import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdPinpad;

import javax.swing.*;
import java.awt.event.*;

public class DialogPinpadConfig extends JDialog {
    private cmdPinpad myPinpad = new cmdPinpad();
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JComboBox cbxPinpadCOMPort;
    private JComboBox cbxPinpadCOMSpeed;
    private JComboBox cbxPinpadType;
    private JComboBox cbxPinpadFunctionPY2;
    private JComboBox cbxPinpadFunctionPY4;
    private JComboBox cbxPinpadServerConnection;

    public DialogPinpadConfig() {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(buttonOK);

        try {

            cbxPinpadCOMPort.setSelectedIndex(myPinpad.getPinpadComPort() - 1);
            cbxPinpadCOMSpeed.setSelectedIndex(myPinpad.getPinpadComBaudRate());
            cbxPinpadType.setSelectedIndex(myPinpad.getPinpadType().ordinal() - 1);
            cbxPinpadServerConnection.setSelectedIndex(myPinpad.getPinpadConnectionType());
            cbxPinpadFunctionPY2.setSelectedIndex(myPinpad.getPinpadPaymentMenu());
            cbxPinpadFunctionPY4.setSelectedIndex(myPinpad.getPinpadLoyaltyPayment());

        } catch (Exception e) {
            MainForm.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }


        buttonOK.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {

                try {
                    myPinpad.setPinpadComPort(cbxPinpadCOMPort.getSelectedIndex() + 1);
                    myPinpad.setPinpadComBaudRate(cbxPinpadCOMSpeed.getSelectedIndex());
                    myPinpad.setPinpadType(cmdPinpad.PinpadType.values()[cbxPinpadType.getSelectedIndex() + 1]);
                    myPinpad.setPinpadConnectionType(cbxPinpadServerConnection.getSelectedIndex());
                    myPinpad.setPinpadPaymentMenu(cbxPinpadFunctionPY2.getSelectedIndex());
                    myPinpad.setPinpadLoyaltyPayment(cbxPinpadFunctionPY4.getSelectedIndex());
                    MainForm.errListModel.add(0, "Pinpad settings saved...");
                } catch (Exception exception) {
                    MainForm.errListModel.add(0, exception.getMessage());
                    exception.printStackTrace();
                }
            }
        });

        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);

    }

    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        DialogPinpadConfig dialog = new DialogPinpadConfig();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }


}
