
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.DailyInfoModel;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdInfo;
import tools.RowHeaderRenderer;

import javax.swing.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.util.List;


public class AdditionalDayInfo extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JProgressBar pb;
    private JScrollPane scrollPanel;
    private JTable table;
    private cmdInfo myInfo = new cmdInfo();

    public AdditionalDayInfo() {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(buttonOK);
        init();
        buttonOK.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onOK();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
    }

    private void init() {

        ListModel lm = new AbstractListModel() {
            public int getSize() {
                return 40;
            }

            public Object getElementAt(int index) {
                return String.valueOf(index + 1);
            }
        };


        DefaultTableModel tableModel = new DefaultTableModel(lm.getSize(), 2);
        boolean[] isGreyRow = new boolean[lm.getSize()];
        new Thread(new Runnable() {
            @Override
            public void run() {
                pb.setValue(0);
                pb.setMaximum(98);
                // do the thing that takes a long time
                int freeRow = 0;
                try {
                    String localCurrency = " " + myInfo.GetCurrNameLocal();
                    String foreignCurrency = " " + myInfo.GetCurrNameForeign();
                    //pb.setValue(i);
                    isGreyRow[freeRow]=true;
                    tableModel.setValueAt("Registration", freeRow++, 0);
                    //Fill Table with values
                    tableModel.setValueAt("The Device Serial Number", freeRow, 0);
                    tableModel.setValueAt(myInfo.GetDeviceSerialNumber(), freeRow++, 1);

                    tableModel.setValueAt("Programmed TAX number", freeRow, 0);
                    tableModel.setValueAt(myInfo.GetTaxNumber(), freeRow++, 1);

                    tableModel.setValueAt("Date of fiscalization", freeRow, 0);
                    tableModel.setValueAt(myInfo.GetActiveTaxRatesDate(), freeRow++, 1);
                    tableModel.setValueAt("Last fiscal record date", freeRow, 0);
                    tableModel.setValueAt(myInfo.GetLastFiscalRecordDate(), freeRow++, 1);

                    isGreyRow[freeRow]=true;
                    tableModel.setValueAt("Current Z period info", freeRow++, 0);
                    //Fiscal receipts by Z period:
                    DailyInfoModel info = myInfo.GetDailyNumAndSumsOfSells();
                    tableModel.setValueAt("Number and total turnover", freeRow, 0);
                    tableModel.setValueAt(info.getNumberOfClients() + "/" + info.getSumOfSells() + localCurrency, freeRow++, 1);

                    //Number and total of VOID items by day
                    info = myInfo.GetDailyNumAndSumsOfVoided();
                    tableModel.setValueAt("Number and amount VOID", freeRow, 0);
                    tableModel.setValueAt(info.getNumberOfCorrections() + "/" + info.getSumOfCorrections() + localCurrency, freeRow++, 1);

                    //Number and total of VOID items by day
                    info = myInfo.GetDailyNumAndSumsOfVoided();
                    tableModel.setValueAt("Number and amount canceled", freeRow, 0);
                    tableModel.setValueAt(info.getNumberOfAnnulled() + "/" + info.getSumOfAnnulled() + localCurrency, freeRow++, 1);
                    //Number and total of discounts by day
                    info = myInfo.GetDailyNumAndSumsOfDiscountsSurcharges();
                    tableModel.setValueAt("Number and amount of discounts", freeRow, 0);
                    tableModel.setValueAt(info.getNumberOfDiscounts() + "/" + info.getSumOfDiscounts() + localCurrency, freeRow++, 1);
                    //Number and total of Surcharges by day
                    tableModel.setValueAt("Number and amount of surcharges", freeRow, 0);
                    tableModel.setValueAt(info.getNumberOfSurcharges() + "/" + info.getSumOfSurcharges() + localCurrency, freeRow++, 1);
                    //Number and total of CashCashInOut
                    info = myInfo.GetDailyCashCashInOut();
                    tableModel.setValueAt("Number and amount of Cash IN", freeRow, 0);
                    tableModel.setValueAt(info.getNumberOfCashIn() + "/" + info.getSumOfCashIn() + localCurrency, freeRow++, 1);
                    tableModel.setValueAt("Number and amount of Cash OUT", freeRow, 0);
                    tableModel.setValueAt(info.getNumberOfCashOut() + "/" + info.getSumOfCashOut() + localCurrency, freeRow++, 1);
                    tableModel.setValueAt("Number and amount of Cash IN", freeRow, 0);
                    tableModel.setValueAt(info.getNumberOfCashInF() + "/" + info.getSumOfCashInF() + foreignCurrency, freeRow++, 1);
                    tableModel.setValueAt("Number and amount of Cash OUT", freeRow, 0);
                    tableModel.setValueAt(info.getNumberOfCashOutF() + "/" + info.getSumOfCashOutF() + foreignCurrency, freeRow++, 1);
                    isGreyRow[freeRow]=true;
                    tableModel.setValueAt("Payments (sell operations)", freeRow++, 0);
                    info = myInfo.GetDailyPayments();
                    List<String> paymentTotals = Arrays.asList(
                            info.getPay1() + localCurrency,
                            info.getPay2() + localCurrency,
                            info.getPay3() + localCurrency,
                            info.getPay4() + localCurrency,
                            info.getPay5() + localCurrency,
                            info.getPay6() + localCurrency,
                            info.getForeignPay() + localCurrency);
                    for (int i = 0; i < 6; i++) {
                        tableModel.setValueAt(myInfo.GetPayName(i), freeRow, 0);
                        tableModel.setValueAt(paymentTotals.get(i) + localCurrency, freeRow++, 1);
                    }
                    isGreyRow[freeRow]=true;
                    tableModel.setValueAt("Payments (storno operations)", freeRow++, 0);

                    info = myInfo.GetDailyPaymentsStornoOperations();
                    paymentTotals = Arrays.asList(
                            info.getPay1() + foreignCurrency,
                            info.getPay2() + foreignCurrency,
                            info.getPay3() + foreignCurrency,
                            info.getPay4() + foreignCurrency,
                            info.getPay5() + foreignCurrency,
                            info.getPay6() + foreignCurrency,
                            info.getForeignPay() + localCurrency);
                    for (int i = 0; i < 6; i++) {
                        tableModel.setValueAt(myInfo.GetPayName(i), freeRow, 0);
                        tableModel.setValueAt(paymentTotals.get(i) + localCurrency, freeRow++, 1);
                    }

                    SwingUtilities.invokeLater(new Runnable() {
                        public void run() {
                            //  pb.setValue(pb.getMaximum());
                        }
                    });

                } catch (Exception e1) {
                    MainForm.errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }).start();
        table = new JTable(tableModel);

        TableColumn column1 = table.getTableHeader().getColumnModel().getColumn(0);
        column1.setHeaderValue("Property");
        TableColumn column2 = table.getTableHeader().getColumnModel().getColumn(1);
        column2.setHeaderValue("Value");
        table.setAutoResizeMode(JTable.AUTO_RESIZE_LAST_COLUMN);
        JList rowHeader = new JList(lm);
        rowHeader.setFixedCellWidth(44);
        rowHeader.setFixedCellHeight(table.getRowHeight());
        rowHeader.setCellRenderer(new RowHeaderRenderer(table));
        scrollPanel.setViewportView(table);
        scrollPanel.setRowHeaderView(rowHeader);
        table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer() {
            //            @Override
//            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
//                MyTableModel model = (MyTableModel) table.getModel();
//                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
//                c.setBackground(model.getRowColour(row));
//                return c;
//            }
            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                final Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if(isGreyRow[row])  c.setBackground(Color.LIGHT_GRAY); //c.setBackground(row % 2 == 0 ? Color.LIGHT_GRAY : Color.WHITE);
                else   c.setBackground(Color.WHITE);
                return c;
            }
        });





    }

    private void onOK() {
        // add your code here
        dispose();
    }

    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        AdditionalDayInfo dialog = new AdditionalDayInfo();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }


}
