import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdConfig;

import javax.swing.*;
import java.awt.event.*;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class DialogSetDataTime extends JDialog {
    private final Timer timer;
    private JPanel contentPane;
    private JButton buttonCancel;
    private JButton btnSynchro;
    private JTextField edDeviceTime;
    private JCheckBox chkAutoUpdate;
    private JTextField edSystemTime;

    public DialogSetDataTime() {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(btnSynchro);


        timer = new Timer(1000, (ActionEvent e) -> {
            DateTimeFormatter myTime = DateTimeFormatter.ofPattern("dd-MM-yy HH:mm:ss");
            LocalDateTime now = LocalDateTime.now();
            edSystemTime.setText(String.valueOf(myTime.format(now)));
            edDeviceTime.setText(getDeviceDataTime());

        });
        timer.setRepeats(true);
        timer.start();

        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        chkAutoUpdate.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (chkAutoUpdate.isSelected()) timer.start();
                else timer.stop();
            }
        });
        btnSynchro.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                int dialogButton = JOptionPane.YES_NO_OPTION;
                int dialogResult = JOptionPane.showConfirmDialog(getParent(), "Changing a device clock with incorrect date/time\n\r" +
                                "may block it fiscal functionality! \n\r" +
                                "Are you sure to set:" + edDeviceTime.getText()+ " ?",
                        "Device Date Time Set", dialogButton);
                if (dialogResult == 0) {

                    try {
                        cmdConfig.DateTime myClock = new cmdConfig.DateTime();
                        myClock.setDateTime(edDeviceTime.getText());
                        btnSynchro.setEnabled(false);
                    } catch (Exception e1) {
                        MainFormAB.errListModel.add(0, e1.getMessage());
                        e1.printStackTrace();
                    }
                }
            }});
    }

    private String getDeviceDataTime() {
        cmdConfig.DateTime myClock = new cmdConfig.DateTime();
        try {
            return myClock.getDateTime();
        } catch (Exception e) {
            MainFormAB.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    private void onOK() {
        // add your code here
        dispose();
    }

    private void onCancel() {
        // add your code here if necessary
        timer.stop();
        dispose();
    }

    public static void main(String[] args) {
        DialogSetDataTime dialog = new DialogSetDataTime();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }
}
