
import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdConfig;
import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdInfo;
import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdReceipt;


import javax.swing.*;
import java.awt.event.*;


public class DialogPinpadDemoAB extends JDialog {
    private JPanel contentPane;

    private JButton buttonCancel;
    private JButton btnSale;

    private JButton btnPay;
    private JButton btnPainpadEndOfDay;
    private JButton btnCloseAll;
    private JComboBox cbxPaymentType;
    private JLabel lbSTL;

    private JProgressBar pbTransaction;
    private JTextField edAmount;

    private JComboBox cbxPinpadReceiptCopies;
    private JComboBox cbxPinpadReceiptInfo;
    private JCheckBox chkPrintAfterPayment;
    private JCheckBox chkPrintAfterClosing;
    private JCheckBox chkPinpadShortReceipt;
    private JButton VOIDButton;
    private JButton btnTestPinpad;
    private JButton btnTestServer;
    private JButton btnPinpadConfig;
    private cmdReceipt.FiscalReceipt fiscalReceipt;
    private cmdReceipt.FiscalReceipt.FiscalSale testSale = new cmdReceipt.FiscalReceipt.FiscalSale();
    private cmdConfig myConfig = new cmdConfig();

    public DialogPinpadDemoAB() {
        setContentPane(contentPane);
        setModal(false);
        getRootPane().setDefaultButton(buttonCancel);

        try {
            //Init
            lbSTL.setText(String.format("%.2f", new cmdReceipt.FiscalReceipt.FiscalTransaction().getNotPaid() / 100.00));
            cbxPaymentType.setSelectedIndex(3);//Debit card
//            cbxPinpadReceiptInfo.setSelectedIndex(myConfig.GetPinpadReceiptInfo());
//            cbxPinpadReceiptCopies.setSelectedIndex(myConfig.GetPinpadReceiptCopies());
//            chkPinpadShortReceipt.setSelected(myConfig.GetPinpadShortRec());
//            lbSTL.setText(String.valueOf(new cmdReceipt.FiscalTransaction().getNotPaid()));
        } catch (Exception e) {
            MainFormAB.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }


        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        btnSale.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                String operatorCode = "1";//Operator number
                String operatorPassword = null;
                if (MainFormAB.myFiscalDevice.isConnectedPrinter())
                    operatorPassword = MainFormAB.myFiscalDevice.getConnectedPrinterV1().getDefaultOpPass();
                else if (MainFormAB.myFiscalDevice.isConnectedECR())
                    operatorPassword = MainFormAB.myFiscalDevice.getConnectedECRV1().getDefaultOpPass();


                String salePoint = "1"; //Number of work place / integer from 1 to 99999 /

                try {
                    fiscalReceipt = new cmdReceipt.FiscalReceipt();
                    if (!fiscalReceipt.isOpen()) { //Open new fiscal receipt
                        //FOR DATECS FP-800 / FP-2000 / FP-650 / SK1-21F / SK1-31F/ FMP-10 / FP-550
                        /**
                         *
                         *    UNP Unique sales number format:
                         * - serial number of the fiscal device
                         * - operator code (four digits or Latin characters)
                         * - sequential sales number (seven digits with leading zeros)
                         *   example: DT000600-0001-0001000
                         *
                         *  Note: DATECS FP-800 / FP-2000 / FP-650 / SK1-21F / SK1-31F/ FMP-10 / FP-550 Only!
                         *
                         *  Before the first sale, the UNP must be set at least once
                         *  if then omitted the parameter device will increment with the number
                         *  of the sale automatically.
                         *
                         */

                        String unp = new cmdInfo().GetDeviceSerialNumber() + "-" +
                                String.format("%04d", Integer.parseInt(operatorCode)) + "-" + // Pad left with trailing zero
                                String.format("%07d", 1 + Integer.valueOf(fiscalReceipt.getLastUNP()));  //Next Document number pad left with trailing zero

                        fiscalReceipt.openFiscalReceipt(operatorCode, operatorPassword, salePoint, unp);    //Internal generated  unp="".
                    }
                    //Registration of items for sale
                    testSale.add(
                            "Прясно мляко",
                            "Краве",
                            "Б", //А, Б, В...
                            "0.01",
                            "",
                            "",
                            cmdReceipt.FiscalReceipt.FiscalSale.CorrectionType.noCorecction,
                            "");


                } catch (Exception e1) {
                    MainFormAB.errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                } finally {
                    calcSTL();
                }

            }
        });

        btnCloseAll.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    closeAll();
                    calcSTL();
                } catch (Exception e1) {
                    MainFormAB.errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
        btnPainpadEndOfDay.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

            }
        });
        btnPay.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                //TOTAL
                pbTransaction.setIndeterminate(true);
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        // do the thing that takes a long time
                        cmdReceipt.TotalResult totalResult = null;
                        try {
                            //testSale.saleTotal(cmdReceipt.PaymentType.values()[cbxPaymentType.getSelectedIndex()], edAmount.getText());
                            totalResult = testSale.saleTotal(
                                    "Тотал:",
                                    "",
                                    getPayMode(cbxPaymentType.getSelectedIndex()), edAmount.getText());

                            if (cbxPaymentType.getSelectedItem().equals("DebitCardPayment('D')"))
                                printAndClose();
                            tryToCloseFiscalReceipt(fiscalReceipt);

                            SwingUtilities.invokeLater(new Runnable() {
                                public void run() {
                                    pbTransaction.setIndeterminate(false);
                                }
                            });
                        } catch (Exception e) {
                            MainFormAB.errListModel.add(0, e.getMessage());
                            e.printStackTrace();
                        } finally {
                            pbTransaction.setIndeterminate(false);
                            calcSTL();
                        }
                    }
                }).start();

            }
        });

        btnPainpadEndOfDay.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    //getConnectedFD().getConnectedModelV2().command55Variant3Version0("5");
                } catch (Exception exception) {
                    exception.printStackTrace();
                    MainFormAB.errListModel.add(0, exception.getMessage());
                }
            }
        });

        VOIDButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

            }
        });

        cbxPinpadReceiptCopies.addItemListener(new ItemListener() {
            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    // myConfig.SetPinpadReceiptCopies(cbxPinpadReceiptCopies.getSelectedIndex());
                } catch (Exception exception) {
                    MainFormAB.errListModel.add(0, exception.getMessage());
                    exception.printStackTrace();
                }
            }
        });

        cbxPinpadReceiptInfo.addItemListener(new ItemListener() {
            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    //  myConfig.SetPinpadReceiptInfo(cbxPinpadReceiptInfo.getSelectedIndex());
                } catch (Exception exception) {
                    MainFormAB.errListModel.add(0, exception.getMessage());
                    exception.printStackTrace();
                }
            }
        });

        chkPinpadShortReceipt.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    //    myConfig.SetPinpadShortRec(chkPinpadShortReceipt.isSelected());
                } catch (Exception exception) {
                    MainFormAB.errListModel.add(0, exception.getMessage());
                    exception.printStackTrace();
                }
            }
        });
        btnTestPinpad.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    //'9'  - Check connection with Pinpad;
                    //if (new cmdService().CheckPinpadConnection())  MainForm.errListModel.add(0, "Pinpad is connected ..");
                } catch (Exception exception) {
                    MainFormAB.errListModel.add(0, exception.getMessage());
                    exception.printStackTrace();
                }
            }
        });
        btnTestServer.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                //'10' - Check connection with server;
                try {
                    // if (new cmdService().CheckPinpadServerConnection()) MainForm.errListModel.add(0, "Bank server is OK !");
                } catch (Exception exception) {
                    MainFormAB.errListModel.add(0, exception.getMessage());
                    exception.printStackTrace();
                }
            }
        });
/*        btnPinpadConfig.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                DialogPinpadConfig dialog = null;
                try {
                    dialog = new DialogPinpadConfig();
                    dialog.setPreferredSize(new Dimension(600, 300));
                    dialog.pack();
                    dialog.setTitle("Pinpad configuration...");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    MainForm.errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });*/
    }

    private void calcSTL() {
        try {
            Double owedSum = new cmdReceipt.FiscalReceipt.FiscalTransaction().getNotPaid() / 100.00;
            edAmount.setText(String.format("%.2f", owedSum));
            lbSTL.setText(String.valueOf(owedSum));
            btnPay.setEnabled(owedSum > 0.00);
        } catch (Exception exception) {
            MainFormAB.errListModel.add(0, exception.getMessage());
            exception.printStackTrace();
        }

    }

    private String getPayMode(int index) {
        return cmdReceipt.FiscalReceipt.FiscalSale.PaidMode.fromOrdinal(index).getId();
    }

    private void printAndClose() throws Exception {

    }

    /**
     * Used when command 53( paying with pinpad ) and command 55 ( option 14 ) returns error
     * along with sum and last digits of card number
     *
     * @param message
     */
    private void voidTransaction(String message) {
        String sQuestion = String.format("Payment has already started.\n\r" +
                message + "\n\r" +//"Pinpad error: Unknown result of the transaction between fiscal device and PinPad";
                "Cancel - VOID Transaction\n\r" +
                "OK - Print receipt\n\r");
        try {
            int dialogResult = JOptionPane.showConfirmDialog(getParent(), sQuestion, "Void transaction", JOptionPane.OK_CANCEL_OPTION);
            if (dialogResult == 0) {
                //     getConnectedFD().getConnectedModelV2().command55Variant3Version1("1");
                printAndClose();
            } else {
//                if (getConnectedFD().getConnectedModelV2().command55Variant3Version1("2").getInt("errorCode") == FiscalErrorCodesV2.OK) {
//                    return;
//                } else voidTransaction("VOID FAILED...");

            }

        } catch (Exception e) {
            MainFormAB.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }


    }


    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        DialogPinpadDemoAB dialog = new DialogPinpadDemoAB();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }


    /**
     * This method attempts to refuse a fiscal or non-fiscal receipt.
     * And if there is a startup payment on the amount and it is not fully paid,
     * it issues a payment message.
     */
    private void closeAll() throws Exception {

        //   cmdReceipt.FiscalReceipt.Storno stornoReceipt = new cmdReceipt.FiscalReceipt.Storno();
        cmdReceipt.FiscalReceipt fiscalReceipt = new cmdReceipt.FiscalReceipt();
        cmdReceipt.FiscalReceipt.NonFiscalReceipt noFiscalReceipt = new cmdReceipt.FiscalReceipt.NonFiscalReceipt();

        if (noFiscalReceipt.isOpen()) {
            noFiscalReceipt.closeNonFiscalReceipt();
            return;
        }

        // if (stornoReceipt.isOpen()) stornoReceipt.cancel();
        //Try to close fiscal receipt of all type: Sale Receipt,Invoice Receipt,Storno of Sale and Storno of Invoice.
        if (fiscalReceipt.isOpen()) tryToCloseFiscalReceipt(fiscalReceipt);
    }

    private void tryToCloseFiscalReceipt(cmdReceipt.FiscalReceipt thisReceipt) throws Exception {

        final Double owedSum = new cmdReceipt.FiscalReceipt.FiscalTransaction().getNotPaid();//owedSum=Amount-Tender
        Double payedSum = new cmdReceipt.FiscalReceipt.FiscalTransaction().getPaid();//Amount that the customer has provided
        int dialogResult = -1;
        //If a TOTAL in the opened receipt has not been set, it will be canceled
        if (payedSum == 0.0) {
            dialogResult = JOptionPane.showConfirmDialog(getParent(), "No payment started on this receipt,\n\n" +
                    "Yes-Pay the whole amount,No-Cancel receipt", "Close receipt?", JOptionPane.YES_NO_OPTION);
            if (dialogResult == 0) {
                payFull();
                closeFiscalRec(thisReceipt);
            }
            if (dialogResult == 1)
                thisReceipt.cancel();
            return;
        }

        //If a TOTAL is set with a partial payment, there is a Amount and Tender is positive.
        //Offer payment of the amount and completion of the sale.
        if (owedSum > 0.0) {
            StringBuilder sQuestion = new StringBuilder();
            sQuestion.append("Payment has already started.\n\r");
            sQuestion.append(String.format("Do you want to pay the owed sum: %2.2f -and close it?\n\r", owedSum / 100.0));
            sQuestion.append("YES-Pay all\n\r");
            sQuestion.append("No-Return\n\r");
            sQuestion.append("Cancel-Cancel fiscal receipt\n\r");

            dialogResult = JOptionPane.showConfirmDialog(getParent(), sQuestion, "Cancel receipt", JOptionPane.YES_NO_CANCEL_OPTION);

            if (dialogResult == JOptionPane.YES_OPTION) {
                payFull();
                closeFiscalRec(thisReceipt);
            } else {
                if (dialogResult == JOptionPane.CANCEL_OPTION) thisReceipt.cancel();
                else if (dialogResult == JOptionPane.NO_OPTION) return;

            }


        } else {
            //If a TOTAL is set with a full payment, there is a Amount-Tender=0.
            //All is OK, completion of the sale!
            closeFiscalRec(thisReceipt);
        }
    }

    private void closeFiscalRec(cmdReceipt.FiscalReceipt thisReceipt) throws Exception {
        //Try to enter new client Invoice Info
        if (thisReceipt.isInvoice())
            tryToEnterClientInfo();
        thisReceipt.closeFiscalReceipt();
    }

    private void tryToEnterClientInfo() throws Exception {
        //Show Dialog to enter client data
        DialogClientInfo dialog = new DialogClientInfo();
        int result = dialog.doModal();
        if (result == dialog.ID_OK) dialog.getClientInfo().saveClientInfo();

    }

    private void payFull() throws Exception {
        new cmdReceipt.FiscalReceipt.FiscalSale().saleTotal(
                "Тотал:",
                "",
                cmdReceipt.FiscalReceipt.FiscalSale.PaidMode.fromOrdinal(0).getId(),
                ""); //We pays a full amount
    }


}
