 import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdConfig;
 import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdInfo;
 import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdService;
 import tools.RowHeaderRenderer;

import javax.swing.*;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import java.awt.*;
import java.awt.event.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


public class AdditionaDayInfo extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JProgressBar pb;
    private JScrollPane scrollPanel;
    private JTable table;
    private cmdInfo myInfo = new cmdInfo();

    public AdditionaDayInfo() {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(buttonOK);
        init();
        buttonOK.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onOK();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
    }

    private void init() {

        ListModel lm = new AbstractListModel() {
            public int getSize() {
                return 40;
            }

            public Object getElementAt(int index) {
                return String.valueOf(index + 1);
            }
        };


        DefaultTableModel tableModel = new DefaultTableModel(lm.getSize(), 2);
        boolean[] isGreyRow = new boolean[lm.getSize()];
        new Thread(new Runnable() {
            @Override
            public void run() {
//                pb.setValue(0);
//                pb.setMaximum(40);
                // do the thing that takes a long time
                int freeRow = 0;
                try {
                    cmdService.VAT myServiceInfo = new cmdService.VAT();
                    myServiceInfo.readVatRates(); // To read Info: Decimal position, Local currency
                    //int decPlace = Integer.valueOf(myServiceInfo.getDecimals());
                    String localCurrency = " " + myServiceInfo.getCurrencyName();
                    //pb.setValue(i);
                    isGreyRow[freeRow] = true;
                    tableModel.setValueAt("Registration", freeRow++, 0);
                    //Fill Table with values
                    tableModel.setValueAt("The Device Serial Number", freeRow, 0);
                    tableModel.setValueAt(myInfo.GetDeviceSerialNumber(), freeRow++, 1);

                    tableModel.setValueAt("Programmed TAX number", freeRow, 0);
                    tableModel.setValueAt(myInfo.GetTaxNumber(), freeRow++, 1);

                    if (myInfo.isConnectedPrinter()) {
                        tableModel.setValueAt("Date of fiscalization", freeRow, 0);
                        tableModel.setValueAt(myInfo.GetDateTimeOfFiscalization(), freeRow++, 1);
                    }

                    DateFormat deviceFormat = null;
                    if (myInfo.isConnectedECR()) deviceFormat = new SimpleDateFormat("ddMMyy");
                    if (myInfo.isConnectedPrinter()) deviceFormat = new SimpleDateFormat("ddMMyyHHmmss");
                    Date deviceDate = deviceFormat.parse(myInfo.GetLastFiscalRecordDate());
                    DateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
                    tableModel.setValueAt("Last fiscal record date", freeRow, 0);
                    tableModel.setValueAt(dateFormat.format(deviceDate), freeRow++, 1);

                    isGreyRow[freeRow] = true;
                    tableModel.setValueAt("Current Z period info", freeRow++, 0);
                    //Fiscal receipts by Z period:
                    cmdInfo.DailyInfoModel info = myInfo.GetDailyNumAndSumsOfSells();
                    tableModel.setValueAt("Number and total turnover", freeRow, 0);
                    tableModel.setValueAt(info.getNumberOfClients() + "/" + info.getSumOfSells() + localCurrency, freeRow++, 1);

                    //Number and total of VOID items by day
                    info = myInfo.GetDailyNumAndSumsOfVoided();
                    tableModel.setValueAt("Number and amount VOID", freeRow, 0);
                    tableModel.setValueAt(info.getNumberOfCorrections() + "/" + info.getSumOfCorrections() + localCurrency, freeRow++, 1);

                    //Number and total of VOID items by day
                    info = myInfo.GetDailyNumAndSumsOfVoided();
                    tableModel.setValueAt("Number and amount canceled", freeRow, 0);
                    tableModel.setValueAt(info.getNumberOfAnnulled() + "/" + info.getSumOfAnnulled() + localCurrency, freeRow++, 1);
                    //Number and total of discounts by day
                    info = myInfo.GetDailyNumAndSumsOfDiscountsSurcharges();
                    tableModel.setValueAt("Number and amount of discounts", freeRow, 0);
                    tableModel.setValueAt(info.getNumberOfDiscounts() + "/" + info.getSumOfDiscounts() + localCurrency, freeRow++, 1);
                    //Number and total of Surcharges by day
                    tableModel.setValueAt("Number and amount of surcharges", freeRow, 0);
                    tableModel.setValueAt(info.getNumberOfSurcharges() + "/" + info.getSumOfSurcharges() + localCurrency, freeRow++, 1);
                    //Number and total of CashCashInOut
                    info = myInfo.GetDailyCashCashInOut();
                    tableModel.setValueAt("Number and amount of Cash IN", freeRow, 0);
                    tableModel.setValueAt(info.getNumberOfCashIn() + "/" + info.getSumOfCashIn() + localCurrency, freeRow++, 1);
                    tableModel.setValueAt("Number and amount of Cash OUT", freeRow, 0);
                    tableModel.setValueAt(info.getNumberOfCashOut() + "/" + info.getSumOfCashOut() + localCurrency, freeRow++, 1);
                    isGreyRow[freeRow] = true;
                    tableModel.setValueAt("Daily Payments by type", freeRow++, 0);
                    info = myInfo.GetDailyPayments();
                    tableModel.setValueAt("Daily Payments Cash", freeRow, 0);
                    tableModel.setValueAt(info.getCash() + localCurrency, freeRow++, 1);
                    tableModel.setValueAt("Daily Payment Credit", freeRow, 0);
                    tableModel.setValueAt(info.getCredit() + localCurrency, freeRow++, 1);

                    tableModel.setValueAt("Daily Payment Cheque", freeRow, 0);//Not supported on DP-05, DP-25, DP-35, WP-50, DP-150
                    tableModel.setValueAt(info.getCheque() + localCurrency, freeRow++, 1);

                    if (myInfo.isConnectedPrinter()) {
                        info = myInfo.GetDailyPaymentsEx();
                        populate_AdditionalPaymentTablePrinter(tableModel, freeRow, info.getAdditionalPaymentEX(), localCurrency);
                    } else {
                        //supported on DP-05, DP-25, DP-35, WP-50, DP-150
                        tableModel.setValueAt(new cmdConfig().GetPayName(1), freeRow, 0);
                        tableModel.setValueAt(info.getPay1() + localCurrency, freeRow++, 1);

                        tableModel.setValueAt(new cmdConfig().GetPayName(2), freeRow, 0);
                        tableModel.setValueAt(info.getPay2() + localCurrency, freeRow++, 1);

                        tableModel.setValueAt(new cmdConfig().GetPayName(3), freeRow, 0);
                        tableModel.setValueAt(info.getPay3() + localCurrency, freeRow++, 1);

                        tableModel.setValueAt(new cmdConfig().GetPayName(4), freeRow, 0);
                        tableModel.setValueAt(info.getPay4() + localCurrency, freeRow++, 1);

                        tableModel.setValueAt(new cmdConfig().GetPayName(5), freeRow, 0);
                        tableModel.setValueAt(info.getPay4() + localCurrency, freeRow++, 1);

                    }

                    SwingUtilities.invokeLater(new Runnable() {
                        public void run() {
                            // pb.setValue(pb.getMaximum());
                        }
                    });

                } catch (Exception e1) {
                    MainFormAB.errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }).start();
        table = new JTable(tableModel);

        TableColumn column1 = table.getTableHeader().getColumnModel().getColumn(0);
        column1.setHeaderValue("Property");
        TableColumn column2 = table.getTableHeader().getColumnModel().getColumn(1);
        column2.setHeaderValue("Value");
        table.setAutoResizeMode(JTable.AUTO_RESIZE_LAST_COLUMN);
        JList rowHeader = new JList(lm);
        rowHeader.setFixedCellWidth(44);
        rowHeader.setFixedCellHeight(table.getRowHeight());
        rowHeader.setCellRenderer(new RowHeaderRenderer(table));
        scrollPanel.setViewportView(table);
        scrollPanel.setRowHeaderView(rowHeader);
        table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer() {

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                final Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (isGreyRow[row])
                    c.setBackground(Color.LIGHT_GRAY); //c.setBackground(row % 2 == 0 ? Color.LIGHT_GRAY : Color.WHITE);
                else c.setBackground(Color.WHITE);
                return c;
            }
        });


    }


    //Used on  FP-800 / FP-2000 / FP-650 / SK1-21F / SK1-31F / FMP-10 / FP-700
    public void populate_AdditionalPaymentTablePrinter(DefaultTableModel tableModel, int row, double[] additionalPaymentEx, String localCurr) throws Exception {
        int numOfPayNames = myInfo.getAdditionalPayNamesCount();
        List<String> paymnetNames = new ArrayList<String>();
        for (int i = 1; i <= numOfPayNames; i++)
            paymnetNames.add(new cmdConfig().GetPayName(i));

        for (int i = 0; i < numOfPayNames; i++) {
            tableModel.setValueAt(paymnetNames.get(i), row, 0);
            tableModel.setValueAt(additionalPaymentEx[i] + localCurr, row++, 1);
        }

    }

    private void onOK() {
        // add your code here
        dispose();
    }

    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        AdditionaDayInfo dialog = new AdditionaDayInfo();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }


}
