import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdConfig;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdInfo;
import tools.cmdEJStructInfo;

import javax.swing.*;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class DialogStructInfoEJ extends JFrame {

    private JPanel contentPane;
    private JButton btnReadEJ;
    private JButton buttonCancel;
    private JTextField edFromDate;
    private JTextField edFromTime;
    private JTextField edToDate;
    private JTextField edToTime;
    private JCheckBox chbxByDocNumber;
    private JTextField edFromNum;
    private JTextField edToNum;
    private JLabel lbFromDate;
    private JLabel lbToDate;
    private JLabel lbFromNum;
    private JLabel lbToNum;
    private JProgressBar progBarDocs;
    private JButton btnExport;
    private JTextArea docPane;
    private JScrollPane edEJMonitor;
    private cmdEJStructInfo myEjStructInfo = new cmdEJStructInfo();
    private cmdInfo myDeviceInfo = new cmdInfo();
    private cmdConfig myConfig = new cmdConfig();
    private File initPath = FileSystemView.getFileSystemView().getHomeDirectory();

    public DialogStructInfoEJ() {

        setContentPane(contentPane);
        StyleContext sc = new StyleContext();

        getRootPane().setDefaultButton(btnReadEJ);
        // Init EJ Search parameters
        try {
            edFromDate.setText(myDeviceInfo.GetActiveTaxRatesDate()); // Indicative start date for the reporting period
            edFromTime.setText("00:00:00");
            edToDate.setText(myDeviceInfo.GetLastFiscalRecordDate());
            edToTime.setText("23:59:59");
            edFromNum.setText("1");
            edToNum.setText(myDeviceInfo.GetGlobalNumberOfReceipts());
        } catch (Exception e) {
            MainForm.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }

        btnReadEJ.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ReadEJ();
            }
        });

        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        chbxByDocNumber.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                boolean byDate = !chbxByDocNumber.isSelected();
                lbFromDate.setEnabled(byDate);
                edFromDate.setEnabled(byDate);
                edFromTime.setEnabled(byDate);
                lbToDate.setEnabled(byDate);
                edToDate.setEnabled(byDate);
                edToTime.setEnabled(byDate);
                lbFromNum.setEnabled(!byDate);
                edFromNum.setEnabled(!byDate);
                lbToNum.setEnabled(!byDate);
                edToNum.setEnabled(!byDate);
            }
        });


        edFromNum.addKeyListener(new KeyAdapter() {
            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                checkInput(edFromNum);
            }
        });

        edToNum.addKeyListener(new KeyAdapter() {
            @Override
            public void keyReleased(KeyEvent e) {
                super.keyReleased(e);
                checkInput(edToNum);
            }
        });

        btnExport.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                String text = docPane.getText();
                JFileChooser saveFile = new JFileChooser(initPath);
                int option = saveFile.showSaveDialog(null);
                saveFile.setDialogTitle("Save the file...");
                if (option == JFileChooser.APPROVE_OPTION) {
                    File file = saveFile.getSelectedFile();
                    initPath = file;
                    if (!file.exists()) {
                        try {
                            BufferedWriter writer = new BufferedWriter(new FileWriter(file.getAbsolutePath() + ".rtf"));
                            writer.write(text);
                            writer.close();
                            MainForm.errListModel.add(0, "Info is saved to:" + file.getName());
                        } catch (IOException ex) {
                            ex.printStackTrace();
                            JOptionPane.showMessageDialog(null, "Failed to save the file");
                        }
                    } else if (file.exists()) {
                        int confirm = JOptionPane.showConfirmDialog(null,
                                "File exists do you want to save anyway?");
                        if (confirm == 0) {
                            try {
                                BufferedWriter writer = new BufferedWriter(new FileWriter(file.getAbsolutePath()));
                                writer.write(text);
                                writer.close();
                            } catch (IOException ex) {
                                ex.printStackTrace();
                                JOptionPane.showMessageDialog(null, "Failed to save the file");
                            }

                        } else if (confirm == 1) {
                            JOptionPane.showMessageDialog(null, "The file was not saved.");

                        }
                    }

                }

                if (option == JFileChooser.CANCEL_OPTION) {

                    saveFile.setVisible(false);

                }


            }
        });
    }


    private void checkInput(JTextField tf) {
        try {
            long number = Long.parseLong(tf.getText());
        } catch (Exception ex) {
            JOptionPane.showMessageDialog(rootPane, "Only Numbers Allowed");
            tf.setSelectionStart(tf.getText().length() - 1);
        }

    }

    private void ReadEJ() {
        progBarDocs.setValue(0);
        progBarDocs.setStringPainted(false);
        docPane.setText("");
        new Thread(new Runnable() {
            @Override
            public void run() {
                // do the thing that takes a long time
                try {
                    String readDocData = null;
                    if (chbxByDocNumber.isSelected()) { //Search EJ by Number of Documents
                        int fromNum = Integer.parseInt(edFromNum.getText());
                        int toNum = Integer.parseInt(edToNum.getText());
                        progBarDocs.setMaximum(toNum - fromNum);
                        if (fromNum > toNum) toNum = fromNum;
                        int p = 0;
                        for (int docNum = fromNum; docNum <= toNum; docNum++) {
                            readDocData = myEjStructInfo.ReadDocumentByNumber(docNum, cmdEJStructInfo.DocTypeToRead.all_types);
                            if (readDocData != null) docPane.append(readDocData);
                            progBarDocs.setValue(p++);
                        }

                    } else { //Search EJ by Data Time of Documents
                        String fromDT = edFromDate.getText() + " " + edFromTime.getText();
                        String toDT = edToDate.getText() + " " + edToTime.getText();
                        int[] docRange = myEjStructInfo.SearchDocumentsInPeriod(fromDT, toDT);
                        progBarDocs.setMaximum(docRange.length);
                        int p = 0;
                        for (int docNum : docRange) {
                            readDocData = myEjStructInfo.ReadDocumentByNumber(docNum, cmdEJStructInfo.DocTypeToRead.all_types);
                            if (readDocData != null) docPane.append(readDocData);
                            progBarDocs.setValue(p++);
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable() {
                        public void run() {
                            progBarDocs.setValue(progBarDocs.getMaximum());
                            btnExport.setEnabled(docPane.getText().length() > 0);
                        }
                    });
                } catch (Exception e) {
                    progBarDocs.setValue(0);
                    e.printStackTrace();
                    MainForm.errListModel.add(0, e.getMessage());
                }
            }
        }).start();
    }


    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public void addColoredText(JTextPane pane, String text, Color color) {
        StyledDocument doc = pane.getStyledDocument();

        Style style = pane.addStyle("Color Style", null);
        StyleConstants.setForeground(style, color);
        try {
            doc.insertString(doc.getLength(), text, style);
        } catch (BadLocationException e) {

            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        DialogStructInfoEJ dialog = new DialogStructInfoEJ();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }


}
