import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdInfo;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdItems;
import com.datecs.util.RegExpr;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import tools.RowHeaderRenderer;
import javax.swing.*;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.List;
import java.util.*;

import static javax.swing.JComponent.WHEN_FOCUSED;


public class DialogItems extends JFrame implements TableModelListener, ActionListener {

    private final DefaultListModel headerList = new DefaultListModel();
    private final JTable table;
    private final String[] priceTypeValues = {"Fixed", "Free", "Max"};
    private final String[] taxRatesValues = {"A", "B", "C", "D", "E", "F", "G", "H"};
    private final List<String> unitNamesList;
    private final JPopupMenu popupMenu;
    private final JMenuItem menuInsertItem = new JMenuItem("Insert New Row");
    private final JMenuItem menuItemRemove = new JMenuItem("Remove Current Row");
    private final JMenuItem menuSaveItems = new JMenuItem("Save Selected Rows");
    private String[] qtySetValues = new String[]{"Add QTY", "Replace QTY"};
    private JPanel contentPane;
    private JButton btnReadRange;
    private JButton buttonCancel;
    private JButton btnReadAll;
    private JButton btnClearTable;
    private JButton saveToDeviceButton;
    private JButton btnDeleteItems;
    private JButton btnImportCSVFile;
    private JButton exportItemsButton;
    private JScrollPane scrPanel;
    private JProgressBar progBar;
    private JButton btnAddItem;
    private JButton btnDelItems;
    private JPanel pChangedItem;
    private JPanel pDeviceItem;
    private JPanel pSavedItem;
    private JButton btnStop;
    protected ItemsTableData m_dataModel;
    CustomTableCellRenderer colorRenderer = new CustomTableCellRenderer();
    protected JLabel m_title;
    private cmdItems myItems = new cmdItems();

    private boolean[] mRunThread = {true}; //Flag to stop running threads
    private String[] headerCSVfile = {"PLU", "Name", "Price", "PriceType", "Qty", "AddQty", "StockGr", "VAT", "Dept",
            "Turnover", "SoldQty", "Bar1", "Bar2", "Bar3", "Bar4", "Unit"};


    public DialogItems() {
        //setUndecorated(true);
        //getRootPane().setWindowDecorationStyle(JRootPane.PLAIN_DIALOG);
        setContentPane(contentPane);
        getRootPane().setDefaultButton(btnReadRange);

        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// Init The Table
        m_dataModel = new ItemsTableData(new Vector());
        table = new JTable(m_dataModel);
//        {
//            public void tableChanged(TableModelEvent e) {
//                super.tableChanged(e);
//                repaint();
//            }
//        };


        table.getModel().addTableModelListener(this);
        table.setAutoCreateColumnsFromModel(true);
        //    0       1        2             3           4      5        6      7       8        9      10       11       12           13         14      15
        // "PLU", "Name", "Price", "Price Type", "Quantity", "Add", "Stock", "VAT", "Dept", "Bar 1", "Bar 2", "Bar 3", "Bar 4", "Turnover", "Sold QTY","Unit"
        //Create and Populate all combo box columns
        JComboBox comboBox1 = new JComboBox();
        comboBox1.setModel(new DefaultComboBoxModel(priceTypeValues));
        setUpColumnComboBox(table.getColumnModel().getColumn(3), comboBox1, "Select Price Type");

        JComboBox comboBox2 = new JComboBox();
        comboBox2.setModel(new DefaultComboBoxModel(taxRatesValues));
        setUpColumnComboBox(table.getColumnModel().getColumn(7), comboBox2, "Select VAT group (letter 'A'...'H'");

        JComboBox comboBox3 = new JComboBox();
        String[] stockGroupValues = new String[new cmdInfo().getMaxStockGroup()];
        for (int i = 0; i < new cmdInfo().getMaxStockGroup(); i++)
            stockGroupValues[i] = String.valueOf(i + 1); //Init Stock group (1...99);
        comboBox3.setModel(new DefaultComboBoxModel(stockGroupValues));
        setUpColumnComboBox(table.getColumnModel().getColumn(6), comboBox3, "Select Stock group (1...99)");

        JComboBox comboBox4 = new JComboBox();
        String[] departmantValues = new String[new cmdInfo().getMaxDepartments() + 1];
        for (int i = 0; i < new cmdInfo().getMaxDepartments() + 1; i++)
            departmantValues[i] = String.valueOf(i); //Department ( 0...99 );
        comboBox4.setModel(new DefaultComboBoxModel(departmantValues));
        setUpColumnComboBox(table.getColumnModel().getColumn(8), comboBox4, "Select Department (0...99)");

        JComboBox comboBox5 = new JComboBox();
        comboBox5.setModel(new DefaultComboBoxModel(qtySetValues));
        setUpColumnComboBox(table.getColumnModel().getColumn(5), comboBox5, "Select to update QTY");


        unitNamesList = initUnitNames();
        JComboBox comboBox6 = new JComboBox();
        comboBox6.setModel(new DefaultComboBoxModel(unitNamesList.toArray()));
        setUpColumnComboBox(table.getColumnModel().getColumn(15), comboBox6, "Select Measurement unit");


        table.setAutoResizeMode(JTable.AUTO_RESIZE_LAST_COLUMN);
        scrPanel.setViewportView(table);

        //Item Color Legend
        pChangedItem.setBackground(Color.PINK);
        pDeviceItem.setBackground(Color.CYAN);
        pSavedItem.setBackground(Color.GREEN);

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////PopUp Menu
        popupMenu = new JPopupMenu();
        popupMenu.add(menuInsertItem);
        popupMenu.add(menuItemRemove);
        popupMenu.add(menuSaveItems);
        menuInsertItem.addActionListener(this);
        menuItemRemove.addActionListener(this);
        menuSaveItems.addActionListener(this);

        // sets the popup menu for the table
        table.setComponentPopupMenu(popupMenu);
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////DEL - Key
        InputMap inputMap = table.getInputMap(WHEN_FOCUSED);
        ActionMap actionMap = table.getActionMap();

        String deleteAction = "delete";
        inputMap.put(KeyStroke.getKeyStroke(KeyEvent.VK_DELETE, 0), deleteAction);
        actionMap.put(deleteAction, new AbstractAction() {
            public void actionPerformed(ActionEvent deleteEvent) {
                int[] selectedRows = table.getSelectedRows();
                int opcion = JOptionPane.showConfirmDialog(null, "Selected items will be deleted from the device !!!\n\r",
                        "Are you sure ?", JOptionPane.YES_NO_OPTION);
                if (opcion == 0) {
                    DeleteSelected(selectedRows);
                } else {
                    // System.out.print("no");
                }

            }
        });
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// On Button
        btnReadAll.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                int programmedItemsCount = 0;
                try {
                    programmedItemsCount = myItems.GetItemsInformation().getTotalCountOfProgrammedItems();
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
                ReadAllItems(programmedItemsCount);

            }
        });

        //Init Table
        btnClearTable.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                ClearTable();
            }
        });


        btnReadRange.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                JTextField f1 = new JTextField();
                JTextField f2 = new JTextField();
                Object[] message = {
                        "From PLU:", f1, "To PLU:", f2
                };
                if (f1.getText().equals("")) {
                    f1.setText("1");
                    f2.setText("100");
                }

                int option = JOptionPane.showConfirmDialog(null, message, "Set Range", JOptionPane.OK_CANCEL_OPTION);
                if (option == JOptionPane.OK_OPTION) {
                    if (f1.getText().matches("^\\d{1,6}$") && f2.getText().matches("^\\d{1,6}$")) {
                        ReadItemsByPLU(Integer.valueOf(f1.getText()),Integer.valueOf(f2.getText()));
                    } else {
                        System.out.println("Use digits 1-100000");
                    }
                } else {
                    //System.out.println(""); Bye !
                }

            }
        });

        btnDeleteItems.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                JTextField f1 = new JTextField();
                JTextField f2 = new JTextField();
                Object[] message = {
                        "From PLU:", f1, "To PLU:", f2
                };
                if (f1.getText().equals("")) {
                    f1.setText("1");
                    f2.setText("100");
                }

                int option = JOptionPane.showConfirmDialog(null, message, "Delete Items...", JOptionPane.OK_CANCEL_OPTION);
                if (option == JOptionPane.OK_OPTION) {
                    if (f1.getText().matches("^\\d{1,6}$") && f2.getText().matches("^\\d{1,6}$")) {
                        DelteItemsInRange(Integer.valueOf(f1.getText()),Integer.valueOf(f2.getText()));
                    } else {
                        System.out.println("Use digits 1-100000");
                    }
                } else {
                    //System.out.println(""); Bye !
                }
            }
        });


        btnAddItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                AddItem();

            }
        });
        btnImportCSVFile.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser jfc = new JFileChooser(FileSystemView.getFileSystemView().getHomeDirectory());
                jfc.setDialogTitle("Select an Items File...");
                jfc.setAcceptAllFileFilterUsed(false);
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Items File (CSV)", "CSV", "txt");
                jfc.addChoosableFileFilter(filter);

                int returnValue = jfc.showOpenDialog(null);
                if (returnValue == JFileChooser.APPROVE_OPTION) {
                    System.out.println(jfc.getSelectedFile().getPath());
                    LoadingCSVFile(jfc.getSelectedFile().getPath());
                }
            }
        });
        exportItemsButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

            }
        });
        saveToDeviceButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

                String message = "All positions in table will be saved in to device, old items will be overwritten!";
                int option = JOptionPane.showConfirmDialog(null, message, "Save Items to Device...", JOptionPane.OK_CANCEL_OPTION);
                if (option == JOptionPane.OK_OPTION) {
                    SaveAllItems();
                } else {
                    //System.out.println(""); Bye !
                }
            }
        });
        exportItemsButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser jfc = new JFileChooser(FileSystemView.getFileSystemView().getHomeDirectory());
                jfc.setDialogTitle("Save Items File...");
                jfc.setAcceptAllFileFilterUsed(false);
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Items File (CSV)", "CSV");
                jfc.addChoosableFileFilter(filter);

                int returnValue = jfc.showSaveDialog(null);
                if (returnValue == JFileChooser.APPROVE_OPTION) {
                    ExportItemsToCSV(jfc.getSelectedFile().getPath() + ".CSV");
                }

            }
        });
        btnStop.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                mRunThread[0] = false;
                InitHeaderColumn();
            }
        });


    }

    private void ExportItemsToCSV(String filePath) {

        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(filePath));

            CSVPrinter csvPrinter = new CSVPrinter(writer, CSVFormat.EXCEL.withDelimiter(';').
                    withHeader(headerCSVfile));
            //"PLU", "Name", "Price", "PriceType", "Qty", "AddQty", "StockGr", "VAT", "Dept","Turnover", "SoldQty", "Bar1", "Bar2", "Bar3", "Bar4", "Unit"
            for (Object obj : m_dataModel.m_vector) {
                cmdItems.ItemModel item = (cmdItems.ItemModel) obj;
                csvPrinter.printRecord(
                        item.getPLU(),
                        item.getName(),
                        item.getPrice(),
                        item.getPriceType(),
                        item.getQuantity(),
                        item.getAddQty(),
                        item.getGroup(),
                        item.getTaxGr(),
                        item.getDep(),
                        item.getTurnover(),
                        item.getSoldQty(),
                        item.getBar1(), item.getBar2(), item.getBar3(), item.getBar4(),
                        item.getUnit());
            }
            csvPrinter.close();

        } catch (IOException ex) {
            ex.printStackTrace();
        }

    }

    private void SaveAllItems() {
        progBar.setValue(0);
        progBar.setMaximum(m_dataModel.getRowCount() - 3);
        progBar.setStringPainted(true);
        mRunThread[0] = true;
        new Thread(new Runnable() {
            @Override
            public void run() {
                // do the thing that takes a long time
                try {
                    int i = 0;
                    for (Object temp : m_dataModel.m_vector) {
                        if (!mRunThread[0]) return;
                        cmdItems.ItemModel itemToSave = (cmdItems.ItemModel) temp;
                        myItems.SetItem(itemToSave);
                        int finalI = i++;
                        SwingUtilities.invokeLater(new Runnable() {
                            public void run() {
                                progBar.setValue(finalI);
                            }
                        });
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    MainForm.errListModel.add(0, e.getMessage());
                }
            }
        }).start();
    }


    /**
     * @param filePath
     */
    private void LoadingCSVFile(final String filePath) {

        progBar.setValue(0);
        progBar.setMaximum(100);
        progBar.setStringPainted(true);
        ClearTable();
        mRunThread[0] = true;
        // Runs outside of the Swing UI thread
        new Thread(new Runnable() {
            public void run() {
                try {
                    Reader in = new FileReader(filePath);
                    CSVParser records = CSVFormat.EXCEL.withDelimiter(';').withHeader(headerCSVfile).parse(in);
                    int i = 0;
                    for (CSVRecord record : records.getRecords()) {
                        if (!mRunThread[0]) return;
                        if (record.get("PLU").equals("PLU")) continue;
                        //PLU,taxGr,dep,group,priceType,price,addQty,quantity,bar1,bar2,bar3,bar4,name,turnover,soldQty,unitName,cmdItems.ItemModel.ItemState state
                        List<String> arrlst = Arrays.asList(taxRatesValues);
                        cmdItems.ItemModel temp = new cmdItems.ItemModel(
                                record.get("PLU"),
                                String.valueOf(arrlst.lastIndexOf(record.get("VAT")) + 1),//Convert value of TaxGr is A,B....to index 1,2...
                                record.get("Dept"),
                                record.get("StockGr"),
                                record.get("PriceType"),
                                record.get("Price"),
                                record.get("AddQty"),
                                record.get("Qty"),
                                record.get("Bar1"),
                                record.get("Bar2"),
                                record.get("Bar3"),
                                record.get("Bar4"),
                                record.get("Name"),
                                record.get("Turnover"),
                                record.get("SoldQty"),
                                record.get("Unit"),
                                cmdItems.ItemModel.ItemState.ITEM_NOT_SAVED
                        );
                        m_dataModel.setItemData(temp);
                        int finalI = i++;

                        SwingUtilities.invokeLater(new Runnable() {
                            public void run() {
                                progBar.setValue(finalI);
                            }
                        });
                    }
                    InitHeaderColumn();
                } catch (Exception e) {
                    MainForm.errListModel.add(0, e.getMessage());
                    e.printStackTrace();
                }
            }
        }).start();

    }

    /**
     * Add item to bottom of table
     */
    private void AddItem() {
        try {
            int newItemID = new cmdItems().GetFirstNotProgrammed(1);
            cmdItems.ItemModel temp = new cmdItems.ItemModel(
                    String.valueOf(newItemID),
                    "2",
                    "1",
                    "1",
                    "1",
                    "0.01",
                    "",
                    "",
                    "", "", "", "",
                    "Item " + String.valueOf(newItemID),
                    "", //Read Only
                    "",  //Read Only
                    "0",
                    cmdItems.ItemModel.ItemState.ITEM_NOT_SAVED);
            m_dataModel.setItemData(temp);
            InitHeaderColumn();
//            table.requestFocus();
//            table.scrollRectToVisible(table.getCellRect(m_dataModel.getRowCount(), 0, true));

        } catch (Exception ex) {
            MainForm.errListModel.add(0, ex.getMessage());
            ex.printStackTrace();
        }
    }

    /**
     * Delete items in table from device
     *
     * @param fromIndex
     * @param toIndex
     */
    public void DelteItemsInRange(int fromIndex, int toIndex) {
        progBar.setValue(0);
        progBar.setMaximum(toIndex-fromIndex);
        progBar.setStringPainted(true);
        m_dataModel.fireTableRowsDeleted(fromIndex, toIndex);
        m_dataModel.fireTableDataChanged();

       new Thread(new Runnable() {
           @Override
           public void run() {
               final int[] i = {0};
               for (int pluCode =fromIndex; pluCode <= toIndex; pluCode++) {
                   if (!mRunThread[0]) {
                       break;
                   }
                   try {
                       if (!myItems.DelItemsInRange(pluCode, 0)) MainForm.errListModel.add(0, pluCode+"-Item not found");
                       else //PLU e iztrito ot ustrojstvoto -> Ako go ima v grida go iztrivame
                       for (int gridPos = 0; gridPos < m_dataModel.getRowCount(); gridPos++)
                       {
                           String tempPlu= String.valueOf(m_dataModel.getValueAt(gridPos,0));
                           if (pluCode ==Integer.valueOf(tempPlu))
                           {// ima li takova PLU v grida
                               m_dataModel.removeRow(gridPos);
                               break;
                           }
                       }
                       m_dataModel.fireTableDataChanged();

                   } catch (Exception e) {
                       e.printStackTrace();
                   }
                   SwingUtilities.invokeLater(new Runnable() {
                       public void run() {
                           progBar.setValue(i[0]++);
                       }
                   });


               }

           }
       }).start();

    }

    /**
     * Delete all selected items in table from device
     *
     */
    public void DeleteSelected(int[] selectedRows) {
        progBar.setValue(0);
        progBar.setMaximum(selectedRows.length);
        progBar.setStringPainted(true);
        new Thread(new Runnable() {
            @Override
            public void run() {
                int i = 0;
                // do the thing that takes a long time
                try {
                    for (int rowNum : selectedRows) {
                        if (!mRunThread[0]) return;
                        int iPLUtoDelete = Integer.parseInt((String) m_dataModel.getValueAt(rowNum - i, 0)); //use i- to correct shift after delete list elements
                        myItems.DelItemsInRange(iPLUtoDelete, 0); //Delete By PLU code
                        m_dataModel.removeRow(rowNum - i);
                        i++;
                        int finalI = i;
                        SwingUtilities.invokeLater(new Runnable() {
                            public void run() {
                                progBar.setValue(finalI);
                            }
                        });
                    }
                    InitHeaderColumn();
                } catch (Exception e) {
                    e.printStackTrace();
                    MainForm.errListModel.add(0, e.getMessage());

                } finally {
                }
            }
        }).start();
        JList rowHeader = new JList(headerList);
        rowHeader.setFixedCellWidth(44);
        rowHeader.setFixedCellHeight(table.getRowHeight());
        rowHeader.setCellRenderer(new RowHeaderRenderer(table));

    }


    /**
     * Read item from device, use this method to read by PLU code
     *
     * @param fromPlu
     * @param toPlu
     */
    private void ReadItemsByPLU(final int fromPlu, final int toPlu) {
        progBar.setValue(0);
        progBar.setMaximum(toPlu - 1);
        progBar.setStringPainted(true);
        final int[] i = {0};
        ClearTable();
        mRunThread[0] = true;
        new Thread(new Runnable() {
            @Override
            public void run() {
                // do the thing that takes a long time
                try {
                    for (int pluCode = fromPlu; pluCode <= toPlu; pluCode++) {
                        if (!mRunThread[0]) return;
                        cmdItems.ItemModel temp = myItems.ReadItem(pluCode);
                        if (temp != null) m_dataModel.setItemData(temp);
                        else
                            MainForm.errListModel.add(0, "Item not found:" + pluCode);
                        SwingUtilities.invokeLater(new Runnable() {
                            public void run() {
                                progBar.setValue(i[0]++);
                            }
                        });
                    }
                    InitHeaderColumn();
                } catch (Exception e) {
                    e.printStackTrace();
                    MainForm.errListModel.add(0, e.getMessage());
                    //return;
                } finally {
                    //progress.dismiss();
                }
            }
        }).start();
    }


    /**
     * Read All Programed Device Items.
     *
     * @param programmedItemsCount
     */
    private void ReadAllItems(int programmedItemsCount) {
        progBar.setValue(0);
        progBar.setMaximum(programmedItemsCount - 2);
        progBar.setStringPainted(true);
        ClearTable();
        mRunThread[0] = true;
        // Runs outside of the Swing UI thread
        new Thread(new Runnable() {
            public void run() {
                try {
                    /// "PLU", "Name", "Price", "Price Type", "Quantity", "Add", "Stock", "VAT", "Dept", "Bar 1", "Bar 2", "Bar 3", "Bar 4", "Turnover", "Sold QTY","Unit"
                    cmdItems.ItemModel firstItemData = myItems.GetFirstFoundProgrammed(1);
                    m_dataModel.setItemData(firstItemData);
                    for (int i = 1; i < programmedItemsCount; i++) {
                        if (!mRunThread[0]) return;
                        // Runs inside of the Swing UI thread
                        m_dataModel.setItemData(myItems.GetNextProgrammed());
                        int finalI = i;
                        SwingUtilities.invokeLater(new Runnable() {
                            public void run() {
                                progBar.setValue(finalI);
                            }
                        });
                    }
                    InitHeaderColumn();
                } catch (Exception e) {
                    MainForm.errListModel.add(0, e.getMessage());
                    e.printStackTrace();
                }
            }
        }).start();
    }


    private void ClearTable() {
        m_dataModel.Clear();
        headerList.clear();
        table.setModel(m_dataModel);
    }

    private void InitHeaderColumn() {
        headerList.removeAllElements();
        for (int i = 0; i < table.getRowCount(); i++)
            headerList.add(i, String.valueOf(i + 1));
        JList rowHeader = new JList(headerList);
        rowHeader.setFixedCellWidth(44);
        rowHeader.setFixedCellHeight(table.getRowHeight());
        //+ table.getRowMargin());
        //+ table.getIntercellSpacing().height);
        rowHeader.setCellRenderer(new RowHeaderRenderer(table));
        scrPanel.setRowHeaderView(rowHeader);
    }

    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        DialogItems dialog = new DialogItems();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }


    public void setUpColumnComboBox(TableColumn col, JComboBox comboBox, String sToolTip) {
        //Set up the editor for the sport cells.
        col.setCellEditor(new DefaultCellEditor(comboBox));

        //Set up tool tips for the sport cells.
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText(sToolTip);
        col.setCellRenderer(renderer);
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////PopUp Menu selected
    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem menu = (JMenuItem) e.getSource();

        if (menu == menuInsertItem) {
            InsertItem();

        } else if (menu == menuItemRemove) {
            m_dataModel.removeRow(table.getSelectedRow());
            InitHeaderColumn();
        } else if (menu == menuSaveItems) {
            int opcion = JOptionPane.showConfirmDialog(null, "Selected items will be saved to the device !!!\n\r",
                    "Are you sure ?", JOptionPane.YES_NO_OPTION);
            if (opcion == 0) {
                int[] selectedRows = table.getSelectedRows();
                SaveSelectedItems(selectedRows);
            } else {
                // System.out.print("no");
            }
        }
    }

    private void InsertItem() {
        int newItemID = 0;
        try {
            newItemID = new cmdItems().GetFirstNotProgrammed(1);
            cmdItems.ItemModel newItem = new cmdItems.ItemModel(
                    String.valueOf(newItemID),
                    "B",
                    "1",
                    "1",
                    "1",
                    "0.01",
                    "",
                    "",
                    "", "", "", "",
                    "Item " + String.valueOf(newItemID),
                    "", //Read Only
                    "",  //Read Only
                    "0",
                    cmdItems.ItemModel.ItemState.ITEM_NOT_SAVED);
            m_dataModel.insertItemData(newItem, table.getSelectedRow() < 0 ? 0 : table.getSelectedRow());
            InitHeaderColumn();
        } catch (Exception ex) {
            MainForm.errListModel.add(0, ex.getMessage());
            ex.printStackTrace();
        }

    }


    private void SaveSelectedItems(int[] selectedRows) {
        progBar.setValue(0);
        progBar.setMaximum(m_dataModel.getRowCount() - 1);
        progBar.setStringPainted(true);
        mRunThread[0] = true;
        new Thread(new Runnable() {
            @Override
            public void run() {
                // do the thing that takes a long time
                try {
                    int i = 0;
                    for (int rowNum : selectedRows) {
                        if (!mRunThread[0]) return;
                        cmdItems.ItemModel itemToSave = (cmdItems.ItemModel) m_dataModel.m_vector.get(rowNum);
                        myItems.SetItem(itemToSave);
                        m_dataModel.fireTableCellUpdated(rowNum, 0);
                        i++;
                        int finalI = i;
                        SwingUtilities.invokeLater(new Runnable() {
                            public void run() {
                                progBar.setValue(finalI);
                            }
                        });
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    MainForm.errListModel.add(0, e.getMessage());
                    //return;
                }
            }
        }).start();
    }

    private void createUIComponents() {
        // TODO: place custom component creation code here
    }


    class ColumnData {
        public String m_title;
        public int m_width;
        public int m_alignment;

        public ColumnData(String title, int width, int alignment) {
            m_title = title;
            m_width = width;
            m_alignment = alignment;
        }
    }

    /**
     * "PLU", "Name", "Price", "Price Type", "Quantity", "Add", "Stock", "VAT", "Dept", "Bar 1", "Bar 2", "Bar 3", "Bar 4", "Turnover", "Sold QTY","Unit"
     */
    class ItemsTableData extends AbstractTableModel {
        final public ColumnData[] m_columns = {
                new ColumnData("PLU", 100, JLabel.LEFT),
                new ColumnData("Name", 460, JLabel.LEFT),
                new ColumnData("Price", 100, JLabel.LEFT),
                new ColumnData("Type", 150, JLabel.RIGHT),
                new ColumnData("Quantity", 100, JLabel.RIGHT),
                new ColumnData("Add", 50, JLabel.RIGHT),
                new ColumnData("Stock", 60, JLabel.RIGHT),
                new ColumnData("VAT", 60, JLabel.RIGHT),
                new ColumnData("Dept", 60, JLabel.RIGHT),
                new ColumnData("Bar 1", 100, JLabel.RIGHT),
                new ColumnData("Bar 2", 100, JLabel.RIGHT),
                new ColumnData("Bar 3", 100, JLabel.RIGHT),
                new ColumnData("Bar 4", 100, JLabel.RIGHT),
                new ColumnData("Turnover", 100, JLabel.RIGHT),
                new ColumnData("Sold QTY", 100, JLabel.RIGHT),
                new ColumnData("Unit", 100, JLabel.RIGHT)
        };

        //protected SimpleDateFormat m_frm;
        private Vector m_vector;

        public ItemsTableData(Vector m_vector) {
            this.m_vector = m_vector;
        }

        public ItemsTableData() {

        }

        public void setItemData(cmdItems.ItemModel itemData) {
            m_vector.addElement(itemData);
            fireTableDataChanged();
        }


        public void insertItemData(cmdItems.ItemModel itemData, int row) {
            this.m_vector.insertElementAt(itemData, row);
            m_dataModel.fireTableDataChanged();
        }

        public void removeRow(int row) {
            if (m_vector.size() > 0) {
                m_vector.removeElementAt(row);
                fireTableRowsDeleted(row, row); //updates the table
            }

        }

        /// "PLU", "Name", "Price", "Price Type", "Quantity", "Add", "Stock", "VAT", "Dept", "Bar 1", "Bar 2", "Bar 3", "Bar 4", "Turnover", "Sold QTY","Unit"
        @Override
        public void setValueAt(Object value, int row, int col) {
            cmdItems.ItemModel itemData = (cmdItems.ItemModel) (m_vector.elementAt(row));
            switch (col) {
                case 0:
                    String sPLU = (String) value;
                    if (sPLU.matches(RegExpr._1_9999999)) itemData.setPLU(sPLU);
                    break;
                case 1:
                    String sName = (String) value;
                    if (sName.matches(RegExpr._UpTo72Symbol))
                        itemData.setName(sName);
                    break;
                case 2:
                    String sPrince = (String) value;
                    if (sPrince.matches(RegExpr._0_00__9999999_99))
                        itemData.setPrice(sPrince);
                    break;
                case 3:
                    String pt = (String) value;
                    if (pt.equals(priceTypeValues[0])) itemData.setPriceType("0");
                    else if (pt.equals(priceTypeValues[1])) itemData.setPriceType("1");
                    else
                        itemData.setPriceType("2");
                    break;
                case 4:
                    String sQuantity = (String) value;
                    if (sQuantity.matches(RegExpr._0_000__999999_999))
                        itemData.setQuantity(sQuantity);
                    break;
                case 5:
                    String addQty = (String) value;
                    itemData.setAddQty(addQty.equals("Add QTY") ? "A" : "");
                    break;
                case 6:
                    itemData.setGroup((String) value);
                    break;
                case 7:
                    List<String> arrlst = Arrays.asList(taxRatesValues);
                    //Convert value of TaxGr is A,B....to index 1,2...
                    itemData.setTaxGr(String.valueOf(arrlst.lastIndexOf((String) value) + 1));
                    break;
                case 8:
                    itemData.setDep((String) value);
                    break;
                case 9:
                    itemData.setBar1((String) value);
                    break;
                case 10:
                    itemData.setBar2((String) value);
                    break;
                case 11:
                    itemData.setBar3((String) value);
                    break;
                case 12:
                    itemData.setBar4((String) value);
                    break;
                case 13:
                    itemData.setTurnover((String) value);
                    break;
                case 14:
                    itemData.setSoldQty((String) value);
                    break;
                case 15:
                    //Convert unit name to index 0,1...
                    itemData.setUnit(String.valueOf(unitNamesList.lastIndexOf((String) value)));
                    break;
            }
            //Is not so smart, the items in row may is not changed
            itemData.setState(cmdItems.ItemModel.ItemState.ITEM_NOT_SAVED);
        }


        @Override
        public int getRowCount() {
            return m_vector == null ? 0 : m_vector.size();
        }

        @Override
        public int getColumnCount() {
            return m_columns.length;
        }

        @Override
        public String getColumnName(int column) {
            return m_columns[column].m_title;
        }

        @Override
        public boolean isCellEditable(int nRow, int nCol) {
            switch (nCol) {
                case 13:
                case 14:
                    return false;
                default:
                    return true;

            }
        }

        /**
         * "PLU", "Name", "Price", "Price Type", "Quantity", "Add", "Stock", "VAT", "Dept", "Bar 1", "Bar 2", "Bar 3", "Bar 4", "Turnover", "Sold QTY","Unit"
         */
        @Override
        public Object getValueAt(int nRow, int nCol) {
            if (nRow < 0 || nRow >= getRowCount()) return "";

            cmdItems.ItemModel rowItemData = (cmdItems.ItemModel) m_vector.elementAt(nRow);
            setRowColor(colorRenderer, rowItemData.getState(), nRow);
            switch (nCol) {
                case 0:
                    return rowItemData.getPLU();
                case 1:
                    return rowItemData.getName();
                case 2:
                    return rowItemData.getPrice();
                case 3:
                    int priceTypeID = Integer.valueOf(rowItemData.getPriceType());
                    return priceTypeValues[priceTypeID];
                case 4:
                    return rowItemData.getQuantity();
                case 5:
                    return rowItemData.getAddQty() == "A" ? qtySetValues[0] : qtySetValues[1];
                case 6:
                    return rowItemData.getGroup();
                case 7:
                    // TaxGr is stored in device by id:  1-taxA,2 - taxB ...
                    return taxRatesValues[Integer.parseInt(rowItemData.getTaxGr()) - 1]; //
                case 8:
                    return rowItemData.getDep();
                case 9:
                    return rowItemData.getBar1();
                case 10:
                    return rowItemData.getBar2();
                case 11:
                    return rowItemData.getBar3();
                case 12:
                    return rowItemData.getBar4();
                case 13:
                    return rowItemData.getTurnover();
                case 14:
                    return rowItemData.getSoldQty();
                case 15:
                    //Convert index of Unit to unit name
                    return unitNamesList.get(Integer.parseInt(rowItemData.getUnit()));

            }
            return "";


        }

        public void Clear() {
            this.m_vector.clear();
            fireTableDataChanged();
        }
    }

    private List<String> initUnitNames() {
        List<String> res = new ArrayList<>();
        try {
            cmdInfo myInfo = new cmdInfo();

            for (int i = 0; i < 20; i++) {
                res.add(myInfo.GetUnitName(i));
            }


        } catch (Exception e) {
            MainForm.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }
        return res;
    }

    public class CustomTableCellRenderer extends DefaultTableCellRenderer {

        private Map<Integer, Color> mapColors;

        public CustomTableCellRenderer() {
            mapColors = new HashMap<Integer, Color>();
        }

        public void setRowColor(int row, Color color) {
            mapColors.put(row, color);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {

            Component cell = super.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, 1);
            Color color = mapColors.get(row);
            if (color != null) {
                cell.setBackground(color);
            } else {
                cell.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            }
            return cell;
        }
    }

    /**
     * Set background of column PLU, depending of Item State
     */
    private void setRowColor(CustomTableCellRenderer renderer, cmdItems.ItemModel.ItemState state, int row) {
        Color color = Color.WHITE;
        switch (state) {
            case ITEM_NOT_SAVED:
                color = Color.PINK; //Color file loaded item in table
                break;
            case ITEM_SAVED:
                color = Color.GREEN;
                break;
            case ITEM_IS_READ:
                color = Color.CYAN;
                break;
        }
        renderer.setRowColor(row, color);
        table.getColumnModel().getColumn(0).setCellRenderer(renderer);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
//        int row = e.getFirstRow();
//        int column = e.getColumn();
//        AbstractTableModel model = (AbstractTableModel) e.getSource();
//        //String columnName = model.getColumnName(column);
//        //Object data = model.getValueAt(row, column);
////        JComboBox dd = null; if (column ==3) {
////            dd = (JComboBox) model.getValueAt(row, column);
////            dd.setSelectedIndex(1);
////        }


    }
}
