import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdService;

import javax.swing.*;
import java.awt.event.*;
import java.util.ArrayList;

public class DialogCommands extends JDialog {
    private final String SCRIPT_FREE_SALE = "48,1[\\t]0000[\\t]1[\\t][\\t]\n" +
            "49,Item1[\\t]2[\\t]0.1[\\t][\\t][\\t][\\t]0[\\t]0[\\t]\n" +
            "53,0[\\t]0.1[\\t]\n" +
            "56";
    private final String SCRIPT_INVOICE_SALE = "48,1[\\t]1[\\t]1[\\t]I[\\t]\n" +
            "49,Item1[\\t]2[\\t]0.1[\\t][\\t][\\t][\\t]0[\\t]0[\\t]\n" +
            "53,0[\\t]0.1[\\t]\n" +
            "57,Datecs[\\t]Soft.Department[\\t]Buyer[\\t]Sofia[\\t]ul.Datecs No4[\\t]0[\\t]000713391[\\t]00000000000001[\\t]\n" +
            "56";


    /*
    *  new cmdReceipt.FiscalReceipt.InvoiceClientInfo(
                                    cmdReceipt.FiscalReceipt.InvoiceClientInfo.TypeTAXN.BULSTAT,
                                    "000713391",
                                    "00000000000001",
                                    "",
                                    "Datecs",
                                    "",
                                    "",
                                    "").saveClientInfo();*/
    private JPanel contentPane;
    private JButton btnExecute;
    private JButton buttonCancel;
    private JTextArea edCommands;
    private JButton btnExecSelected;
    private JButton btnTab;
    private JList lsCommandResult;
    private JRadioButton fiscalSaleRadioButton;
    private JRadioButton fiscalInvoiceRadioButton;
    private JRadioButton stornoRefundSaleRadioButton;
    private JRadioButton stornoRefundInvoiceRadioButton;
    public static DefaultListModel resultListModel = new DefaultListModel();

    public DialogCommands() {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(btnExecute);
        lsCommandResult.setModel(resultListModel);

        edCommands.setText(SCRIPT_FREE_SALE);

        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        btnExecute.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                cmdService myCommand = new cmdService();
                String cmdResult = "";
                ArrayList<CommandData> cmdList = null;

                int i = 0;
                try {
                    resultListModel.clear();
                    cmdList = ScripParser(edCommands.getText());


                    for (i = 0; i < cmdList.size(); i++) {
                        cmdResult = myCommand.customCommand(cmdList.get(i).getCmdIndex(), cmdList.get(i).getCmdData().replace("[\\t]", "\t"));

                        resultListModel.add(0, cmdList.get(i).getCmdIndex() + ": " + cmdResult);
                    }

                } catch (Exception e1) {
                    resultListModel.add(0, cmdList.get(i).getCmdIndex() + ": " + e1.getMessage());
                    e1.printStackTrace();
                }

            }
        });

        btnExecSelected.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                int startSelection = edCommands.getSelectionStart();
                int endSelection = edCommands.getSelectionEnd();
                String selectedText = edCommands.getText().substring(startSelection, endSelection);

                cmdService myCommand = new cmdService();
                String cmdResult = "";
                ArrayList<CommandData> cmdList = null;
                int i = 0;
                try {
                    resultListModel.clear();
                    cmdList = ScripParser(selectedText);
                    for (i = 0; i < cmdList.size(); i++) {
                        cmdResult = myCommand.customCommand(cmdList.get(i).getCmdIndex(), cmdList.get(i).getCmdData().replace("[\\t]", "\t"));
                        resultListModel.add(0, cmdList.get(i).getCmdIndex() + ":" + cmdResult);
                    }
                } catch (Exception e1) {
                    resultListModel.add(0, cmdList.get(i).getCmdIndex() + ": " + e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
        btnTab.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                insertConstantStr("[\\t]", edCommands);
            }
        });
        fiscalSaleRadioButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

            }
        });
        fiscalInvoiceRadioButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                edCommands.setText(SCRIPT_INVOICE_SALE);
            }
        });
    }

    private void insertConstantStr(String insertStr, JTextArea editText) {
        String oriContent = editText.getText().toString();
        int index = editText.getSelectionStart() >= 0 ? editText.getSelectionStart() : 0;
        StringBuilder sBuilder = new StringBuilder(oriContent);
        sBuilder.insert(index, insertStr);
        editText.setText(sBuilder.toString());
        editText.setSelectionStart(index + insertStr.length());
    }

    private void onOK() {
        // add your code here
        dispose();
    }

    private void onCancel() {
        // add your code here if necessary
        dispose();
    }


    private class CommandData {

        private String cmdIndex;
        private String cmdData;

        public String getCmdData() {
            return cmdData;
        }

        public void setCmdData(String cmdData) {
            this.cmdData = cmdData;
        }

        public String getCmdIndex() {
            return cmdIndex;
        }

        public void setCmdIndex(String cmdIndex) {
            this.cmdIndex = cmdIndex;
        }
    }

    private ArrayList<CommandData> ScripParser(String text) {
        ArrayList<CommandData> res = new ArrayList<>();
        try {
            String lines[] = text.split("\\r?\\n");
            for (String line : lines) {
                CommandData oneCmd = new CommandData();
                String[] sLine = line.split(",");

                if (!sLine[0].matches("^\\d{1,3}$"))
                    throw new Exception("Command code not accepted !!!");

                if (sLine.length > 0) oneCmd.setCmdIndex(sLine[0]);
                if (sLine.length > 1) oneCmd.setCmdData(sLine[1]);
                else oneCmd.setCmdData("");

                res.add(oneCmd);
            }
        } catch (Exception e) {
            resultListModel.add(0, e.getMessage());
            e.printStackTrace();
        }

        return res;
    }

    public static void main(String[] args) {
        DialogCommands dialog = new DialogCommands();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }
}
