import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdInfo;
import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdReceipt;
import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdService;

import javax.swing.*;
import java.awt.event.*;
import java.util.ArrayList;


public class DialogCommands extends JDialog {
    private String deviceFM;
    private String docDateTime;
    private String docUNP;
    private String fiscalRefundScriptECR=null;
    private  String fiscalInvoiceFP=null;
    private  String fiscalInvoiceECR=null;
    private String fiscalSaleScriptECR=null;
    private String fiscalSaleScriptFP=null;
    private String deviceSN = null;
    private JPanel contentPane;
    private JButton btnExecute;
    private JButton buttonCancel;
    private JTextArea edCommands;
    private JButton btnExecSelected;
    private JButton btnTab;
    private JList lsCommadResult;
    private JRadioButton fiscalSaleRadioButton;
    private JRadioButton fiscalInvoiceRadioButton;
    private JRadioButton stornoRefundSaleRadioButton;
    private JRadioButton stornoRefundInvoiceRadioButton;
    public static DefaultListModel resultListModel = new DefaultListModel();
    private String fiscalRefundScriptFP;

    public DialogCommands() {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(btnExecute);
        lsCommadResult.setModel(resultListModel);

        try {
            deviceSN = new cmdInfo().GetDeviceSerialNumber();
            //Some sample documents scripts
            fiscalSaleScriptECR = String.format("48,1,1,%s-0001-0000001,1\n49,\tБ0.01\n53,Тотал:\tP0.01\n56\n", deviceSN);
            fiscalSaleScriptFP = String.format(";FISCAL SALE TEST\n48,1,0000,1\n49,[\\t]Б0.01\n53,[\\t]P0.01\n56\n");
            fiscalInvoiceECR = String.format("48,1,1,%s-0001-0000001,1,I\n" +
                    "49,\tБ0.01\n" +
                    "53,Тотал:\tP0.01\n" +
                    "57,000713391\t0\tДатекс\t\n"+
                    "56\n", deviceSN);
            fiscalInvoiceFP = String.format(";FISCAL SALE TEST\n48,1,0000,1,I\n49,[\\t]Б0.01\n53,[\\t]P0.01\n" +
                    "57,000713391\tДатекс\t\n"+
                    "56\n");


            docUNP=new cmdReceipt.FiscalReceipt().getLastUNP();
            docDateTime="DDMMYYHHMM";
            deviceFM=new cmdService().GetFiscalMemoryNumber();
            //Demo of Fiscal Sale Refund
            fiscalRefundScriptECR = String.format("46,1,1,%s-0001-0000001,1,0,%s,%s,%s\n49,\tБ0.01\n53,Тотал:\tP0.01\n56\n", deviceSN,docUNP,docDateTime,deviceFM);
            String unp = new cmdInfo().GetDeviceSerialNumber() + "-0001-" + // Pad opCode left with trailing zero
                    String.format("%07d", Integer.valueOf(docUNP));  //Next Document number pad left with trailing zero
           fiscalRefundScriptFP = String.format(";FISCAL REFUND TEST\n46,1,0000,1,E%s,%s,%s,%s\n49,[\\t]Б0.01\n53,[\\t]P0.01\n56\n",docUNP,unp,docDateTime,deviceFM);
           //Demo of Invoice Sale Refund

        } catch (Exception e) {
            e.printStackTrace();
        }
        //Demo script sells
        if (MainFormAB.myFiscalDevice.isConnectedPrinter()) edCommands.setText(fiscalSaleScriptFP);
        if (MainFormAB.myFiscalDevice.isConnectedECR())edCommands.setText(fiscalSaleScriptECR);
        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        btnExecute.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                cmdService myCommand = new cmdService();
                String cmdResult = "";
                ArrayList<CommandData> cmdList = null;
                int i = 0;
                try {
                    resultListModel.clear();
                    cmdList = ScripParser(edCommands.getText());

                    for (i = 0; i < cmdList.size(); i++) {
                        cmdResult = myCommand.customCommand(cmdList.get(i).getCmdIndex(), cmdList.get(i).getCmdData().replace("[\\t]", "\t"));
                        resultListModel.add(0, cmdList.get(i).getCmdIndex() + ": " + cmdResult);
                    }

                } catch (Exception e1) {
                    resultListModel.add(0, cmdList.get(i).getCmdIndex() + ": " + e1.getMessage());
                    e1.printStackTrace();
                }

            }
        });

        btnExecSelected.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                int startSelection = edCommands.getSelectionStart();
                int endSelection = edCommands.getSelectionEnd();
                String selectedText = edCommands.getText().substring(startSelection, endSelection);

                cmdService myCommand = new cmdService();
                String cmdResult = "";
                ArrayList<CommandData> cmdList = null;
                int i = 0;
                try {
                    resultListModel.clear();
                    cmdList = ScripParser(selectedText);
                    for (i = 0; i < cmdList.size(); i++) {
                        cmdResult = myCommand.customCommand(cmdList.get(i).getCmdIndex(), cmdList.get(i).getCmdData().replace("[\\t]", "\t"));
                        resultListModel.add(0, cmdList.get(i).getCmdIndex() + ":" + cmdResult);
                    }
                } catch (Exception e1) {
                    resultListModel.add(0, cmdList.get(i).getCmdIndex() + ": " + e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });
        btnTab.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                insertConstantStr("[\\t]", edCommands);
            }
        });
        fiscalSaleRadioButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                //Demo script sells
                if (MainFormAB.myFiscalDevice.isConnectedPrinter()) edCommands.setText(fiscalSaleScriptFP);
                if (MainFormAB.myFiscalDevice.isConnectedECR())edCommands.setText(fiscalSaleScriptECR);

            }
        });

        fiscalInvoiceRadioButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                //Demo script Invoice
                if (MainFormAB.myFiscalDevice.isConnectedPrinter()) edCommands.setText(fiscalInvoiceFP);
                if (MainFormAB.myFiscalDevice.isConnectedECR())edCommands.setText(fiscalInvoiceECR);
            }
        });

        stornoRefundSaleRadioButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                //Demo script refund
                if (MainFormAB.myFiscalDevice.isConnectedPrinter()) edCommands.setText(fiscalRefundScriptFP);
                if (MainFormAB.myFiscalDevice.isConnectedECR())edCommands.setText(fiscalRefundScriptECR);
            }
        });
    }

    private void insertConstantStr(String insertStr, JTextArea editText) {
        String oriContent = editText.getText().toString();
        int index = editText.getSelectionStart() >= 0 ? editText.getSelectionStart() : 0;
        StringBuilder sBuilder = new StringBuilder(oriContent);
        sBuilder.insert(index, insertStr);
        editText.setText(sBuilder.toString());
        editText.setSelectionStart(index + insertStr.length());
    }

    private void onOK() {
        // add your code here
        dispose();
    }

    private void onCancel() {
        // add your code here if necessary
        dispose();
    }


    private class CommandData {

        private String cmdIndex;
        private String cmdData;

        public String getCmdData() {
            return cmdData;
        }

        public void setCmdData(String cmdData) {
            this.cmdData = cmdData;
        }

        public String getCmdIndex() {
            return cmdIndex;
        }

        public void setCmdIndex(String cmdIndex) {
            this.cmdIndex = cmdIndex;
        }
    }

    private ArrayList<CommandData> ScripParser(String text) {
        ArrayList<CommandData> res = new ArrayList<>();
        try {
            String lines[] = text.split("\\r?\\n");
            for (String line : lines) {
                if (line.startsWith(";")) continue;
                CommandData oneCmd = new CommandData();
                String[] sLine = line.split(",", 2);

                if (!sLine[0].matches("^\\d{1,3}$"))
                    throw new Exception("Command code not accepted !!!");

                if (sLine.length > 0) oneCmd.setCmdIndex(sLine[0]);
                if (sLine.length > 1) oneCmd.setCmdData(sLine[1]);
                else oneCmd.setCmdData("");

                res.add(oneCmd);
            }
        } catch (Exception e) {
            resultListModel.add(0, e.getMessage());
            e.printStackTrace();
        }

        return res;
    }


    public static void main(String[] args) {
        DialogCommands dialog = new DialogCommands();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }
}
