import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdReceipt;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class DialogClientInfo extends JDialog {
    public static final int ID_OK = 1;
    public static final int ID_CANCEL = 0;
    private int exitCode = ID_CANCEL;
    private JPanel contentPane;
    private JButton btnCancel;
    private JTextField edClientEIK;
    private JTextField edSellerName;
    private JTextField edReceiverName;
    private JTextField edBuyerName;
    private JComboBox cbxTypeTAXN;
    private JTextField edClientAddress1;
    private JTextField edClientAddress2;
    private JTextField edClentTAXnum;
    private JButton btnValidateClientInfo;
    private cmdReceipt.FiscalReceipt.InvoiceClientInfo clientInfo;
    private JTextField edAccountablePerson;
    private JLabel labAccountablePerson;
    private JButton btnOK;


    public cmdReceipt.FiscalReceipt.InvoiceClientInfo getClientInfo() {
        return clientInfo;
    }

    public void setClientInfo(cmdReceipt.FiscalReceipt.InvoiceClientInfo clientInfo) {
        this.clientInfo = clientInfo;
    }

    public int doModal() {
        setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        setPreferredSize(new Dimension(640, 480));
        setTitle("Client Info");
        pack();
        setLocationRelativeTo(getParent());
        setModal(true);
        setVisible(true);
        return exitCode;
    }

    public DialogClientInfo() {
        edAccountablePerson.setEnabled(MainFormAB.myFiscalDevice.isConnectedPrinter());
        labAccountablePerson.setEnabled(MainFormAB.myFiscalDevice.isConnectedPrinter());
        setContentPane(contentPane);
        getRootPane().setDefaultButton(btnOK);

        btnOK.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                exitCode = ID_OK;
                setVisible(false);
            }
        });

        btnCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                exitCode = ID_CANCEL;
                setVisible(false);
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);

        btnValidateClientInfo.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                /**
                 res[0] Validation of EGN, BULSTAT , or  LNCH
                 res[1] Validation of  VATnum
                 res[2] Validation of Seller
                 res[3] Validation of Receiver
                 res[4] Validation of Buyer
                 res[5] Validation of Address1
                 res[6] Validation of Address2
                 */
                clientInfo = new cmdReceipt.FiscalReceipt.InvoiceClientInfo(
                        edClientEIK.getText(),
                        cmdReceipt.FiscalReceipt.InvoiceClientInfo.BulstatType.fromOrdinal(cbxTypeTAXN.getSelectedIndex()),
                        edSellerName.getText(),
                        edReceiverName.getText(),
                        edBuyerName.getText(),
                        edClentTAXnum.getText(),
                        edClientAddress1.getText(),
                        edClientAddress2.getText(),
                        edAccountablePerson.getText());

                boolean res[] = clientInfo.isValid();

                if (!res[0]) edClientEIK.setForeground(Color.red);
                else edClientEIK.setForeground(Color.black);

                if (!res[1]) edSellerName.setForeground(Color.red);
                else edSellerName.setForeground(Color.black);

                if (!res[2]) edReceiverName.setForeground(Color.red);
                else edReceiverName.setForeground(Color.black);

                if (!res[3]) edBuyerName.setForeground(Color.red);
                else edBuyerName.setForeground(Color.black);

                if (!res[4]) edClentTAXnum.setForeground(Color.red);
                else edClentTAXnum.setForeground(Color.black);

                if (!res[5]) edClientAddress1.setForeground(Color.red);
                else edClientAddress1.setForeground(Color.black);
                if (!res[6]) edClientAddress2.setForeground(Color.red);
                else edClientAddress1.setForeground(Color.black);
                boolean isValid = true;
                for (boolean tRes : res) {
                    isValid &= tRes;
                }
                btnOK.setEnabled(isValid);
            }
        });
    }

    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public int showModal(JComponent child, String title) {
        setTitle(title);
        pack();
        setLocationRelativeTo(getParent());
        setVisible(true);
        return exitCode;
    }

    public static void main(String[] args) {
        DialogClientInfo dialog = new DialogClientInfo();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }
}
