import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdReceipt;

import javax.swing.*;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import java.awt.event.*;
import java.text.NumberFormat;

public class DialogCashInOut extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JRadioButton rbtnCashOut;
    private JRadioButton rbtnCashIn;
    private JPanel JB;
    private JFormattedTextField edCashInOut;
    //Formats to format and parse numbers
    private NumberFormat amountDisplayFormat;
    private NumberFormat amountEditFormat;

    public DialogCashInOut() {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(buttonOK);


        try {
          //TODO :  Show Cash

        } catch (Exception e) {
            MainFormAB.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }


        // Create the button group to keep only one selected.
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(rbtnCashOut);
        btnGroup.add(rbtnCashIn);

        //Format the input TextField with the regional settings of the operating system;
        // 0.00...9999999.99
        amountDisplayFormat = NumberFormat.getCurrencyInstance();
        amountDisplayFormat.setMinimumFractionDigits(0);
        amountEditFormat = NumberFormat.getNumberInstance();
        amountEditFormat.setMaximumIntegerDigits(7);
        amountEditFormat.setMaximumFractionDigits(2);
        amountEditFormat.setMinimumFractionDigits(0);

        DefaultFormatterFactory factory = new DefaultFormatterFactory(
                new NumberFormatter(amountDisplayFormat),
                new NumberFormatter(amountDisplayFormat),
                new NumberFormatter(amountEditFormat));

        edCashInOut.setFormatterFactory(factory);
        edCashInOut.setColumns(10);
        edCashInOut.setValue(new Double(0.00));

        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        //
        buttonOK.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isCashOut = rbtnCashOut.isSelected();
                int dialogButton = JOptionPane.YES_NO_OPTION;
                int dialogResult = JOptionPane.showConfirmDialog(getParent(),
                        "Are you sure you want the amount of: " + edCashInOut.getText() +
                                "\n\r" + operationString(!isCashOut),
                        "Confirm Sum", dialogButton);
                if (dialogResult == 0) {
                    Double amount = ((Number) edCashInOut.getValue()).doubleValue();
                    if (isCashOut) amount = -1 * amount;
                    CashInOut(amount);

                } else {
                    //System.out.println("No Option");
                }
            }

            private String operationString(boolean isCashIn) {
                String res;
                if (isCashIn) res = " to be added as an";
                else res = " to be subtracted from";
                return res + " available cash amount in the fiscal device ?";

            }
        });



    }


    private void CashInOut(Double valueOfCurrency) {
        try {
            // cashInSafe Holds result of operation:
            //0-cashSum
            //1-cashIn
            //2-cashOut
            Double[] cashInSafe = new Double[3];

            cashInSafe = new cmdReceipt.FiscalReceipt().cashInCashOut(valueOfCurrency);

            String msg = ("Cash in safe:" + cashInSafe[0] + "\n\r" +
                    " Sum of Cash IN:" + cashInSafe[1] + "\n\r" +
                    " Sum of Cash OUT:" + cashInSafe[2]);

            JOptionPane.showMessageDialog(this,
                    msg,
                    "Cash in safe",
                    JOptionPane.INFORMATION_MESSAGE);

        } catch (Exception e) {
            MainFormAB.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }

    }

    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        DialogCashInOut dialog = new DialogCashInOut();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }


}
