import com.datecs.fiscalprinter.SDK.model.UserLayerV2.ReceiptConverterC;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdInfo;

import javax.swing.*;
import java.awt.event.*;
import java.awt.image.BufferedImage;


public class DialogReceiptToImg extends JDialog {
    private JPanel contentPane;
    private JButton buttonCancel;

    private JTextField edDocNum;
    private JTextField edReceiptImage;
    private JTextField edLogoFile;

    private JScrollPane scrPane;
    private JButton btnExportReceipt;
    private JCheckBox chkUseLogo;
    private JProgressBar prgBarRead;
    private JLabel lbLogo;
    private JLabel lbRecImage;
    private int recNum = 0;


    public DialogReceiptToImg() throws Exception {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(buttonCancel);

        edDocNum.setText(String.valueOf(new cmdInfo().GetNumberOfCurrentOrLastReceipt()));

        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);


        btnExportReceipt.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                prgBarRead.setIndeterminate(true);
                btnExportReceipt.setEnabled(false);
                String fmN = "";
                String SN = "";
                ReceiptConverterC receiptConverter = new ReceiptConverterC();
                try {

                    fmN = new cmdInfo().GetDeviceFMnumber();
                    recNum = Integer.parseInt(edDocNum.getText());
                    receiptConverter.setRegularFontSize(15);   //Default size :15
                    receiptConverter.setBoldTextFontSize(17);   //Default size :17
                    receiptConverter.setTextFont("Courier New");//Default true type: "Courier New"
                    receiptConverter.setOutImageFormat("png");  //Default : "png" use "jpg" for jpeg image format
                    receiptConverter.setQRsize(120);  //Default size for QR code: 120 pix.
                    receiptConverter.setBarcodeHeight(120); //Default Height size for barcode: 120 pix.
                    receiptConverter.setBarcodeWidth(200); //Default Width size for barcode: 300 pix.
                    receiptConverter.setBarcodeFormat(ReceiptConverterC.BCType.CODE128);
                    // Supported barcode type:
                    // EAN8 barcode. Data must contain only 8 digits;
                    // EAN13 barcode. Data must contain only 13 digits;
                    // Code128 barcode. Data must contain symbols with ASCII codes between 32 and 127. Data length is between 3 and 31 symbols;
                    // QR code. Data must contain symbols with ASCII codes between 32 and 127. Data length is between 3 and 279 symbols;
                    // Interleave 2of5 barcode. Data must contain only digits, from 3 to 22 chars;
                    // PDF417 truncated Data must contain symbols with ASCII codes between 32 and 127. Data length is between 3 and 400 symbols;
                    receiptConverter.ConvertEjReceipt(fmN, recNum, (ImageIcon) lbLogo.getIcon(), edReceiptImage.getText() + recNum);

                } catch (Exception exception) {
                    exception.printStackTrace();
                    btnExportReceipt.setEnabled(true);
                    prgBarRead.setIndeterminate(false);
                    MainForm.errListModel.add(0, exception.getMessage());
                }

                String finalFmN = fmN;
                receiptConverter.registerConvertCompletedListener(new ReceiptConverterC.OnConvertCompletedListener() {
                    @Override
                    public void onResultEvent(BufferedImage resultImage, String message) {
                        if (resultImage != null) lbRecImage.setIcon(new ImageIcon(resultImage));
                        if (message != null) MainForm.errListModel.add(0, message);
                      // receiptConverter.ConvertEjReceipt(finalFmN, recNum++, (ImageIcon) lbLogo.getIcon(), edReceiptImage.getText()+recNum);
                        btnExportReceipt.setEnabled(true);
                        prgBarRead.setIndeterminate(false);
                    }
                });
            }
        });
        chkUseLogo.addItemListener(new ItemListener() {
            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == ItemEvent.SELECTED) {
                    lbLogo.setIcon(new ImageIcon(edLogoFile.getText()));
                } else {
                    lbLogo.setIcon(null);
                }
            }
        });
    }


    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) throws Exception {
        DialogReceiptToImg dialog = new DialogReceiptToImg();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }


}
