import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdConfig;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdInfo;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdService;
import tools.RowHeaderRenderer;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import java.awt.event.*;

public class DialogDepartments extends JDialog {
    private JTable table;
    private DefaultTableModel tableModel = null;
    private JPanel contentPane;
    private JButton btnSetDepartments;
    private JButton buttonCancel;
    private JScrollPane scrollPanel;
    private JProgressBar pb;

    public DialogDepartments() {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(btnSetDepartments);

        btnSetDepartments.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (table.isEditing())
                    table.getCellEditor().stopCellEditing();
                tableModel.fireTableDataChanged();
                try {
                    cmdConfig myConfig = new cmdConfig();
                    final int cntDepartment = new cmdService().getMaxDepartments();
                    for (int i = 0; i < cntDepartment; i++) {
                        myConfig.SetDeptName(i, String.valueOf(tableModel.getValueAt(i, 0)));
                        myConfig.SetDeptVAT(i, String.valueOf(tableModel.getValueAt(i, 1)));
                        myConfig.SetDeptPrice(i, String.valueOf(tableModel.getValueAt(i, 2)));
                    }
                    MainForm.errListModel.add(0, "Departments is saved...");
                } catch (Exception e1) {
                    MainForm.errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });

        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        init();
    }

    private void init() {
        final int cntDepartment = new cmdService().getMaxDepartments();
//       String headers[] =new String[cntDepartment];
//       for(int i=1;i<=cntDepartment;i++) headers[i]=String.valueOf(i);
        //Init Table
        ListModel lm = new AbstractListModel() {
            public int getSize() {
                return cntDepartment;
            }

            public Object getElementAt(int index) {
                return String.valueOf(index + 1);
            }
        };
       tableModel = new DefaultTableModel(lm.getSize(), 3);
        //Fill Table with values
        new Thread(new Runnable() {
            @Override
            public void run() {
               pb.setValue(0);
                pb.setMaximum(98);
                // do the thing that takes a long time
                try {
                    for (int i = 0; i < cntDepartment; i++) {
                        pb.setValue(i);
                        tableModel.setValueAt(new cmdInfo().GetDeptName(i), i, 0);
                        tableModel.setValueAt(new cmdInfo().GetDeptVat(i), i, 1);
                        tableModel.setValueAt(new cmdInfo().GetDeptPrice(i), i, 2);
                        SwingUtilities.invokeLater(new Runnable() {
                            public void run() {
                             //  pb.setValue(pb.getMaximum());
                            }
                        });
                    }
                } catch (Exception e1) {
                    MainForm.errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }).start();
        table = new JTable(this.tableModel);
        TableColumn column1 = table.getTableHeader().getColumnModel().getColumn(0);
        column1.setHeaderValue("Name");
        TableColumn column2 = table.getTableHeader().getColumnModel().getColumn(1);
        column2.setHeaderValue("VAT");
        TableColumn column3 = table.getTableHeader().getColumnModel().getColumn(2);
        column3.setHeaderValue("Price");
        table.setAutoResizeMode(JTable.AUTO_RESIZE_LAST_COLUMN);
        JList rowHeader = new JList(lm);
        rowHeader.setFixedCellWidth(44);
        rowHeader.setFixedCellHeight(table.getRowHeight());
        rowHeader.setCellRenderer(new RowHeaderRenderer(table));
        scrollPanel.setViewportView(table);
        scrollPanel.setRowHeaderView(rowHeader);
    }



    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        DialogDepartments dialog = new DialogDepartments();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }


    private void createUIComponents() {
        // TODO: place custom component creation code here
    }
}