import com.datecs.fiscalprinter.SDK.model.UserLayerV2.cmdReceipt;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class DialogClientInfo extends JDialog {
    public static final int ID_OK = 1;
    public static final int ID_CANCEL = 0;
    private int exitCode = ID_CANCEL;
    private JPanel contentPane;
    private JButton btnОК;
    private JButton buttonCancel;
    private JTextField edClientTAXN;
    private JTextField edClientName;
    private JTextField edClientReceiver;
    private JTextField edClientBuyer;
    private JComboBox cbxTypeTAXN;
    private JTextField edClientAddress1;
    private JTextField edClientAddress2;
    private JTextField edVATN;
    private JButton btnValidateClientInfo;

    public cmdReceipt.FiscalReceipt.InvoiceClientInfo getClientInfo() {
        return clientInfo;
    }

    public void setClientInfo(cmdReceipt.FiscalReceipt.InvoiceClientInfo clientInfo) {
        this.clientInfo = clientInfo;
    }

    private cmdReceipt.FiscalReceipt.InvoiceClientInfo clientInfo;


    public int doModal() {
        setPreferredSize(new Dimension(600, 520));
        setTitle("Client Info");
        setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        pack();
        setLocationRelativeTo(getParent());
        setModal(true);
        setVisible(true);
        return exitCode;
    }
    public DialogClientInfo() {
        setContentPane(contentPane);
        getRootPane().setDefaultButton(btnОК);


        btnОК.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                exitCode = ID_OK;
                setVisible(false);
            }
        });

        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                exitCode = ID_CANCEL;
                setVisible(false);
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        btnValidateClientInfo.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                /**
                 res[0] Validation of EGN, BULSTAT , or  LNCH
                 res[1] Validation of  VATnum
                 res[2] Validation of Seller
                 res[3] Validation of Receiver
                 res[4] Validation of Buyer
                 res[5] Validation of Address1
                 res[6] Validation of Address2
                 */

                clientInfo = new cmdReceipt.FiscalReceipt.InvoiceClientInfo(
                        cmdReceipt.FiscalReceipt.InvoiceClientInfo.TypeTAXN.fromOrdinal(cbxTypeTAXN.getSelectedIndex()),
                        edClientTAXN.getText(),
                        edVATN.getText(),
                        edClientName.getText(),
                        edClientReceiver.getText(),
                        edClientBuyer.getText(),
                        edClientAddress1.getText(),
                        edClientAddress2.getText());

                boolean res[] = clientInfo.isValid();
                if (!res[0]) edClientTAXN.setForeground(Color.red);
                else edClientTAXN.setForeground(Color.black);
                if (!res[1]) edVATN.setForeground(Color.red);
                else edVATN.setForeground(Color.black);
                if (!res[2]) edClientName.setForeground(Color.red);
                else edClientName.setForeground(Color.black);
                if (!res[3]) edClientReceiver.setForeground(Color.red);
                else edClientReceiver.setForeground(Color.black);
                if (!res[4]) edClientBuyer.setForeground(Color.red);
                else edClientBuyer.setForeground(Color.black);
                if (!res[5]) edClientAddress1.setForeground(Color.red);
                else edClientAddress1.setForeground(Color.black);
                if (!res[6]) edClientAddress2.setForeground(Color.red);
                else edClientAddress1.setForeground(Color.black);
                boolean isValid = true;
                for (boolean tRes : res) {
                    isValid &= tRes;
                }
                btnОК.setEnabled(isValid);
            }
        });

    }



    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        DialogClientInfo dialog = new DialogClientInfo();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }
}
