import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdInfo;
import tools.RowHeaderRenderer;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import java.awt.*;
import java.awt.event.*;

public class OperatorInformation extends JDialog {
    private JTable table;
    private DefaultTableModel tableModel = null;
    private JPanel contentPane;
    private JButton btnReadOperatorInfo;
    private JButton buttonCancel;
    private JScrollPane scrollPanel;
    private JButton btnSetOperatorName;


    public OperatorInformation() {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(btnReadOperatorInfo);
        btnReadOperatorInfo.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                populataTable();
            }
        });


        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);

        populataTable();
        btnSetOperatorName.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {

                DialogEditOperator dialog = null;
                try {
                    int r = table.getSelectedRow();
                    if (r < 0) return;
                    dialog = new DialogEditOperator(r, String.valueOf(tableModel.getValueAt(r, 0)), String.valueOf(tableModel.getValueAt(r, 1)));
                    dialog.setPreferredSize(new Dimension(320, 240));
                    dialog.pack();
                    dialog.setTitle("Edit Operator Name and Password");
                    dialog.setLocationRelativeTo(null);
                    dialog.setVisible(true);
                } catch (Exception e1) {
                    MainFormAB.errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }
            }
        });

    }

    private void populataTable() {
        Integer operatorsCnt;
        if (MainFormAB.myFiscalDevice.isConnectedECR())
            operatorsCnt = MainFormAB.myFiscalDevice.getConnectedECRV1().getMaxOperators();
        else operatorsCnt = MainFormAB.myFiscalDevice.getConnectedPrinterV1().getMaxOperators();

        String headers[] = new String[operatorsCnt];
        for (int i = 0; i < operatorsCnt; i++) headers[i] = String.valueOf(i + 1);
        //Init Table
        ListModel lm = new AbstractListModel() {
            public int getSize() {
                return headers.length;
            }

            public Object getElementAt(int index) {
                return headers[index];
            }
        };
        tableModel = new DefaultTableModel(lm.getSize(), 7);
        //Fill Table with values
        try {
            for (int i = 0; i < operatorsCnt; i++) {
                cmdInfo.OperatorInfoModel operInfo = new cmdInfo().GetOperatorInfo(i + 1);
                tableModel.setValueAt(operInfo.getOperatorName(), i, 0); //Name
                tableModel.setValueAt((operInfo.getPassword()==null)?"****":operInfo.getPassword().trim(), i, 1);//If no service jumper, use default device password
                tableModel.setValueAt(operInfo.getReceipts(), i, 2);//
                tableModel.setValueAt(operInfo.getnTotal() + "/" + operInfo.getTotal(), i, 3);
                tableModel.setValueAt(operInfo.getnDiscount() + "/" + operInfo.getDiscount(), i, 4);
                tableModel.setValueAt(operInfo.getnSurcharge() + "/" + operInfo.getSurcharge(), i, 5);
                tableModel.setValueAt(operInfo.getnVoid() + "/" + operInfo.getVoid(), i, 6);
            }


        } catch (Exception e1) {
            MainFormAB.errListModel.add(0, e1.getMessage());
            e1.printStackTrace();
        }
        //  MainForm.errListModel.add(0, "...");

        table = new JTable(this.tableModel);
        TableColumn column1 = table.getTableHeader().getColumnModel().getColumn(0);
        column1.setHeaderValue("Name");
        TableColumn column2 = table.getTableHeader().getColumnModel().getColumn(1);
        column2.setHeaderValue("Password");

        TableColumn column3 = table.getTableHeader().getColumnModel().getColumn(2);
        column3.setHeaderValue("Receipts");

        TableColumn column4 = table.getTableHeader().getColumnModel().getColumn(3);
        column4.setHeaderValue("Total");

        TableColumn column5 = table.getTableHeader().getColumnModel().getColumn(4);
        column5.setHeaderValue("Discount");

        TableColumn column6 = table.getTableHeader().getColumnModel().getColumn(5);
        column6.setHeaderValue("Surcharge");

        TableColumn column7 = table.getTableHeader().getColumnModel().getColumn(6);
        column7.setHeaderValue("Void");

        table.setAutoResizeMode(JTable.AUTO_RESIZE_LAST_COLUMN);


        JList rowHeader = new JList(lm);
        rowHeader.setFixedCellWidth(44);
        rowHeader.setFixedCellHeight(table.getRowHeight());
        //+ table.getRowMargin());
        //+ table.getIntercellSpacing().height);
        rowHeader.setCellRenderer(new RowHeaderRenderer(table));
        scrollPanel.setViewportView(table);
        scrollPanel.setRowHeaderView(rowHeader);


    }

    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        DialogHeaderFooter dialog = new DialogHeaderFooter();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }


}