import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdService;

import javax.swing.*;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import java.awt.*;
import java.awt.event.*;


public class DialogVAT extends JDialog implements TableModelListener {
    private final JTable table;
    private final DefaultTableModel initialTable;
    private final cmdService.VAT myVATs = new cmdService.VAT();
    private JPanel contentPane;
    private JButton btnSaveVAT;
    private JButton buttonCancel;
    private JScrollPane scrlPane;
    private JComboBox cbxDecimals;
    private JTextField еdCurrencyName;

    public DialogVAT() {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(btnSaveVAT);


        btnSaveVAT.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (table.isEditing())
                    table.getCellEditor().stopCellEditing();
                initialTable.fireTableDataChanged();

                try {
                    String maskVATsEnabled = "";
                    for (int i = 0; i < 8; i++) {
                        JRadioButton dd = (JRadioButton) initialTable.getValueAt(i, 0);
                        maskVATsEnabled += dd.isSelected() ? "1" : "0";
                    }

                    myVATs.setEnabledMask(maskVATsEnabled);
                    myVATs.setCurrencyName(еdCurrencyName.getText());
                    myVATs.setDecimals(String.valueOf(2 * cbxDecimals.getSelectedIndex())); //Init Decimals !!!

                    myVATs.saveVatRates(
                            String.valueOf(initialTable.getValueAt(0, 1)),//A
                            String.valueOf(initialTable.getValueAt(1, 1)),//B
                            String.valueOf(initialTable.getValueAt(2, 1)),//C
                            String.valueOf(initialTable.getValueAt(3, 1)),//D
                            String.valueOf(initialTable.getValueAt(4, 1)),//E
                            String.valueOf(initialTable.getValueAt(5, 1)),//F
                            String.valueOf(initialTable.getValueAt(6, 1)),//G
                            String.valueOf(initialTable.getValueAt(7, 1)));//H


                } catch (Exception e1) {
                    MainFormAB.errListModel.add(0, e1.getMessage());
                    e1.printStackTrace();
                }

            }
        });

        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);


        try {
            myVATs.readVatRates(); // Call first to init VATs
        } catch (Exception e) {
            MainFormAB.errListModel.add(0, e.getMessage());
            e.printStackTrace();
        }
        cbxDecimals.setSelectedIndex(Integer.valueOf(myVATs.getDecimals()) / 2); //value 0 or 2 - to index 0,1
        еdCurrencyName.setText(myVATs.getCurrencyName());
        initialTable = new DefaultTableModel();
        initialTable.setDataVector(
                new Object[][]{
                        {new JRadioButton("A", myVATs.isEnableTaxA()), myVATs.getTaxA()},
                        {new JRadioButton("B", myVATs.isEnableTaxB()), myVATs.getTaxB()},
                        {new JRadioButton("C", myVATs.isEnableTaxC()), myVATs.getTaxC()},
                        {new JRadioButton("D", myVATs.isEnableTaxD()), myVATs.getTaxD()},
                        {new JRadioButton("E", myVATs.isEnableTaxE()), myVATs.getTaxE()},
                        {new JRadioButton("F", myVATs.isEnableTaxF()), myVATs.getTaxF()},
                        {new JRadioButton("G", myVATs.isEnableTaxG()), myVATs.getTaxG()},
                        {new JRadioButton("H", myVATs.isEnableTaxH()), myVATs.getTaxH()}
                },
                new Object[]{"TAX rates", "TAX Value"});
        table = new JTable(initialTable) {
            public void tableChanged(TableModelEvent e) {
                super.tableChanged(e);
                repaint();
            }
        };

        table.getColumn("TAX rates").setCellRenderer(new RadioButtonRenderer());
        table.getColumn("TAX rates").setCellEditor(new RadioButtonEditor(new JCheckBox()));
        table.getModel().addTableModelListener(this);
        scrlPane.setViewportView(table);

    }

    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        DialogVAT dialog = new DialogVAT();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int row = e.getFirstRow();
        int column = e.getColumn();
        DefaultTableModel model = (DefaultTableModel) e.getSource();
        String columnName = model.getColumnName(column);
        //Object data = model.getValueAt(row, column);
        JRadioButton dd = null;
        if (columnName.equals("TAX rates")) {
            dd = (JRadioButton) model.getValueAt(row, column);
            String val;
            if (dd.isSelected()) val = "0.00";
            else val = "Disabled";
            model.setValueAt(val, row, column + 1);
        }

    }


    class RadioButtonEditor extends DefaultCellEditor
            implements ItemListener {
        private JRadioButton button;

        public RadioButtonEditor(JCheckBox checkBox) {
            super(checkBox);
        }

        public Component getTableCellEditorComponent(JTable table, Object value,
                                                     boolean isSelected, int row, int column) {
            if (value == null) return null;
            button = (JRadioButton) value;
            button.addItemListener(this);
            return (Component) value;
        }

        public Object getCellEditorValue() {
            button.removeItemListener(this);
            return button;
        }

        public void itemStateChanged(ItemEvent e) {
            super.fireEditingStopped();
        }
    }

    class RadioButtonRenderer implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value,
                                                       boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) return null;
            return (Component) value;
        }
    }


}
