
import com.datecs.fiscalprinter.SDK.model.UserLayerV1.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.BufferedImage;

import static java.awt.image.BufferedImage.TYPE_BYTE_BINARY;


public class DialogReceiptToImg extends JDialog {
    private JPanel contentPane;
    private JButton buttonCancel;
    private JTextField edDocNum;
    private JTextField edImageName;
    private JButton btnExportReceiptToImage;
    private JProgressBar prgBarRead;
    private JButton btnDownloadLogo;
    private JLabel lbDeviceLogo;
    private JLabel lbRecImage;
    private JScrollPane scrPane;
    private int MAX_LOGO_H;
    private int MAX_LOGO_W;
    private final cmdConfig printConfig = new cmdConfig();
    private BufferedImage fLogoImg;


    public DialogReceiptToImg() {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(buttonCancel);


        if (printConfig.isConnectedECR()) {
            MAX_LOGO_W = printConfig.getConnectedECRV1().getMaxLogoWidthPixel();
            MAX_LOGO_H = 96;//printConfig.getConnectedECRV1().getMaxLogoHeightPixel();
        }
        if (printConfig.isConnectedPrinter()) {
            MAX_LOGO_W = printConfig.getConnectedPrinterV1().getMaxLogoWidthPixel();
            MAX_LOGO_H = printConfig.getConnectedPrinterV1().getMaxLogoHeightPixel();
        }
        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);

        btnExportReceiptToImage.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiptConverterAB receiptConverter = new ReceiptConverterAB();
                prgBarRead.setIndeterminate(true);
                btnEnable(false);
                receiptConverter.setRegularFontSize(16);   //Default size :15
                receiptConverter.setBoldTextFontSize(17);   //Default size :17
                receiptConverter.setTextFont("Courier New");//Default true type: "Courier New"
                receiptConverter.setOutImageFormat("png");  //Default : "png" use "jpg" for jpeg image format
                receiptConverter.setQRsize(120);  //Default size for fiscal QR code: 120 pix.

                try {
                    String fiscalMemoryNumber = new cmdService().GetFiscalMemoryNumber();
                    if (MainFormAB.getConnectedFD().isConnectedPrinter()) {
                        /**
                         *
                         * Supported barcode encoding:
                         * If the converting receipt contains barcode data,
                         * it will be encoded in one of the supported types
                         *         EAN8,    7 Digit
                         *         EAN13,   13 Digit
                         *         CODE128, 22 to 42 ASCII[32 to 127]
                         *         ITF,     Digits
                         *         PDF417,  up 140 symbols
                         *         QRCODE,  up 140 symbols
                         *         DATAMATRIX up 140 symbols
                         *
                         *       Use  receiptConverter.setBarcodeFormat() to set barcode writer.
                         *
                         *     If receiptConverter.setfPrintBarcodeData(true);
                         *     barcode data symbols is printed below barcode
                         *
                         */
                        receiptConverter.setBarcodeFormat(ReceiptConverterAB.BCType.CODE128);
                        receiptConverter.setBarcodeHeight(90); //Default Height size for barcode: 120 pix.
                        receiptConverter.setBarcodeWidth(200);  //Default Width size for barcode: 300 pix.
                        receiptConverter.setfPrintBarcodeData(true);
                        receiptConverter.ConvertEJReceiptA(fiscalMemoryNumber, edDocNum.getText(), fLogoImg, edImageName.getText());
                    } else
                        receiptConverter.ConvertEJReceiptB(fiscalMemoryNumber, edDocNum.getText(), fLogoImg, edImageName.getText());

                } catch (Exception exception) {
                    exception.printStackTrace();
                    MainFormAB.errListModel.add(0, exception.getMessage());
                }
                receiptConverter.registerConvertCompletedListener(new ReceiptConverterAB.OnConvertCompletedListener() {
                    @Override
                    public void onResultEvent(BufferedImage bufferedImage, String message) {
                        if (bufferedImage != null) lbRecImage.setIcon(new ImageIcon(bufferedImage));
                        if (message != null) MainFormAB.errListModel.add(0, message); //Something went wrong !

                        btnEnable(true);
                        prgBarRead.setIndeterminate(false);
                    }
                });

            }
        });

        btnDownloadLogo.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                readDeviceLogo();
            }
        });
    }

    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        DialogReceiptToImg dialog = new DialogReceiptToImg();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }

    /**
     * Read logo from fiscal device,
     */
    private void readDeviceLogo() {
        prgBarRead.setValue(0);
        prgBarRead.setMaximum(MAX_LOGO_H - 1);
        btnEnable(false);
        new Thread(new Runnable() {
            String logo = "";

            @Override
            public void run() {
                // do the thing that takes a long time
                try {
                    for (int i = 0; i < MAX_LOGO_H; i++) {
                        logo += printConfig.Logo_ReadRow(i);//Read all 348 pixels. 96/2 = 48*8; 48*8=348 pixel
                        int finalI = i;
                        SwingUtilities.invokeLater(new Runnable() {
                            public void run() {
                                prgBarRead.setValue(finalI);
                            }
                        });
                    }
                    fLogoImg = logoToBitmap(logo);
                    lbDeviceLogo.setIcon(new ImageIcon(fLogoImg));
                } catch (Exception e) {
                    MainFormAB.errListModel.add(0, e.getMessage());
                    e.printStackTrace();
                } finally {
                    btnEnable(true);
                }
            }
        }).start();
    }

    /**
     * @param logo
     * @return
     */
    private BufferedImage logoToBitmap(String logo) {
        BufferedImage bitmap = new BufferedImage(MAX_LOGO_W, MAX_LOGO_H, TYPE_BYTE_BINARY);
        try {
            byte[] decoded = hexStringToByteArray(logo); // Obsolete: DatatypeConverter.parseHexBinary(logo);
            for (int y = 0; y < MAX_LOGO_H; y++) {
                for (int x = 0; x < MAX_LOGO_W / 8; x++) {
                    int index = x * 8;
                    boolean[] bwPixel = byteToBoolArr(decoded[y * MAX_LOGO_W / 8 + x]);
                    bitmap.setRGB(index, y, bwPixel[0] ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                    bitmap.setRGB(index + 1, y, bwPixel[1] ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                    bitmap.setRGB(index + 2, y, bwPixel[2] ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                    bitmap.setRGB(index + 3, y, bwPixel[3] ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                    bitmap.setRGB(index + 4, y, bwPixel[4] ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                    bitmap.setRGB(index + 5, y, bwPixel[5] ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                    bitmap.setRGB(index + 6, y, bwPixel[6] ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                    bitmap.setRGB(index + 7, y, bwPixel[7] ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte) ((Character.digit(s.charAt(i), 16) << 4)
                    + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static boolean[] byteToBoolArr(byte b) {
        boolean boolArr[] = new boolean[8];
        for (int i = 0; i < 8; i++) boolArr[i] = (b & (byte) (128 / Math.pow(2, i))) != 0;
        return boolArr;
    }

    private void btnEnable(boolean bEnabled) {
        btnDownloadLogo.setEnabled(bEnabled);
        btnExportReceiptToImage.setEnabled(bEnabled);
    }

}
