
import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdConfig;

import javax.swing.*;
import java.awt.event.*;

public class DialogLANSettings extends JDialog {
    private JPanel contentPane;
    private JButton btnSave;
    private JButton buttonCancel;
    private JTextField edIP;
    private JTextField edMask;
    private JTextField edGtw;
    private JTextField edMAC;
    private JSpinner spPort;
    private JCheckBox chkDHCP;
    private JLabel labIP;
    private JLabel labMask;
    private JLabel labGate;
    private JLabel labPort;
    private JLabel labMac;

    private cmdConfig myConfig = new cmdConfig();

    public DialogLANSettings() {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(btnSave);
        initUI();

        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);

        btnSave.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                final String sIPLAN = edIP.getText();
                final String sMask = edMask.getText();
                final String sPort = spPort.getValue().toString();
                final String sGatewayLAN = edGtw.getText();
                final boolean DHCP = chkDHCP.isSelected();
                final String sMACLAN = edMAC.getText().toString();
                new Thread(new Runnable() {
                    @Override
                    public void run() {
                        // do the thing that takes a long time
                        try {
                            myConfig.SetLANSettings(new cmdConfig.LANSettings(sIPLAN, sMask, sPort, sGatewayLAN, DHCP, sMACLAN));
                        } catch (Exception e) {
                            e.printStackTrace();
                            MainFormAB.errListModel.add(0, e.getMessage());
                        }
                    }
                }).start();
            }
        });
    }

    private void initUI() {
        new Thread(new Runnable() {
            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable() {
                    public void run() {

                        try {
                            cmdConfig.LANSettings LAN = new cmdConfig().GetLANSettings();
                            edIP.setText(LAN.getIPAddr());
                            edMask.setText(LAN.getSubnetMask());
                            edGtw.setText(LAN.getDefGateway());
                            spPort.setValue(Integer.valueOf(LAN.getTCPPort()));
                            chkDHCP.setSelected(LAN.getDHCP());
                            edMAC.setText(LAN.getMACAddr());
                            btnSave.setEnabled(true);
                        } catch (Exception e) {
                            e.printStackTrace();
                            MainFormAB.errListModel.add(0, e.getMessage());
                        }
                    }
                });
            }
        }).start();


    }


    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        DialogLANSettings dialog = new DialogLANSettings();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }
}
