import com.datecs.fiscalprinter.SDK.FiscalDeviceV1;
import com.datecs.fiscalprinter.SDK.FiscalPrinterV1;
import tools.CheckBoxList;

import javax.swing.*;
import java.awt.event.*;

import static com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice.getConnectedECRV1;
import static com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice.getConnectedPrinterV1;
import static java.awt.Color.RED;


public class DialogDeviceStatus extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private CheckBoxList checkBoxList1;

    public DialogDeviceStatus() {
        setContentPane(contentPane);
        setModal(true);
        getRootPane().setDefaultButton(buttonOK);

        buttonOK.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onOK();
            }
        });

        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        });

        // call onCancel() when cross is clicked
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                onCancel();
            }
        });

        // call onCancel() on ESCAPE
        contentPane.registerKeyboardAction(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onCancel();
            }
        }, KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);

        checkBoxList1.setListData(createStatusList());

    }

    private JCheckBox[] createStatusList() {
        String[] deviceStatusDescr_Byte = new String[8];
        boolean[] deviceStatusFlags_Byte = new boolean[8];
        boolean[] isCritical = new boolean[8];
        JCheckBox[] myChckListArr = new JCheckBox[48];
        try {
            int k = 0;
            //statusOfDevice=MainActivity.myFiscalDevice.GetStatus(); //Get the device status with command 74.
            for (int by = 0; by < 6; by++) {
                for (int bit = 0; bit < 8; bit++) {
                    if (MainFormAB.myFiscalDevice.isConnectedPrinter()) {
                        deviceStatusDescr_Byte[bit] = getConnectedPrinterV1().getStatusBitDescription(by, bit);
                        //+" [" + String.valueOf(by) + "," + String.valueOf(bit) + "]";
                        deviceStatusFlags_Byte[bit] = getConnectedPrinterV1().getStatusBitBol(by, bit);

                    }
                    if (MainFormAB.myFiscalDevice.isConnectedECR()) {
                        deviceStatusDescr_Byte[bit] = getConnectedECRV1().getStatusBitDescription(by, bit);
                        //+" [" + String.valueOf(by) + "," + String.valueOf(bit) + "]";
                        deviceStatusFlags_Byte[bit] = getConnectedECRV1().getStatusBitBol(by, bit);

                    }

                    myChckListArr[k++] = new JCheckBox(deviceStatusDescr_Byte[bit] + "[" + by + "," + bit + "]", deviceStatusFlags_Byte[bit]);

                    //Mark all critical status in red
                    if (MainFormAB.myFiscalDevice.isConnectedPrinter())
                        myChckListArr[k-1].setForeground(FiscalPrinterV1.getIsCriticalStatus()[by][bit] ? RED : getForeground());
                    if (MainFormAB.myFiscalDevice.isConnectedECR())
                        myChckListArr[k-1].setForeground(FiscalDeviceV1.getIsStatusCritical(by, bit) ? RED : getForeground());


                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return myChckListArr;
    }

    private void onOK() {
        // add your code here
        dispose();
    }

    private void onCancel() {
        // add your code here if necessary
        dispose();
    }

    public static void main(String[] args) {
        DialogDeviceStatus dialog = new DialogDeviceStatus();
        dialog.pack();
        dialog.setVisible(true);
        System.exit(0);
    }

    private void createUIComponents() {
        // TODO: place custom component creation code here
    }
}
