/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK.model.UserLayerV2;

import com.datecs.fiscalprinter.SDK.FiscalDeviceV2;
import com.datecs.fiscalprinter.SDK.FiscalException;
import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import java.io.IOException;

public class cmdPinpad
extends DatecsFiscalDevice {
    protected static DatecsFiscalDevice connectedFD;

    public void printCopyTransactionDocument(DocTypeToCopy docTypeToCopy, String docNumber) throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        switch (docTypeToCopy) {
            case AC: {
                if (docNumber.matches("^(\\d){1,6}")) break;
                throw new IllegalArgumentException("AC of the transaction(6 digits max);");
            }
            case RRN: {
                if (docNumber.matches("^(\\d){1,12}")) break;
                throw new IllegalArgumentException("RRN of the transaction(12 digits max);");
            }
            case Number: {
                if (docNumber.matches("^(\\d){1,6}")) break;
                throw new IllegalArgumentException("Number of the transaction(6 digits max);");
            }
            default: {
                this.printCopyOfLastTransactionDocument();
                return;
            }
        }
        if (this.isConnectedDeviceV2()) {
            R = connectedFD.getConnectedModelV2().command55Variant2Version0(String.valueOf(docTypeToCopy.ordinal()), docNumber);
        }
    }

    public PurchaseResult makePurchase(Double amount) throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = connectedFD.getConnectedModelV2().command55Variant3Version4(String.format("%.2f", amount));
        }
        PurchaseResult res = new PurchaseResult(R.getInt("errorCode"), R.get("AC"), PurchaseResult.TypeOfCardPayment.values()[1 + R.getInt("CardData", -1)], R.get("CardNumber"), R.get("MIDNumber"), R.get("RRN"), R.get("TIDNumber"), R.get("TransAmount"), R.get("TransDate"), R.get("TransTime"), R.get("TransNumber"), PurchaseResult.TransStatus.values()[R.getInt("TransStatus")], R.get("TransType"), R.get("FulLResponseCode"));
        return res;
    }

    public void endOfDayReport() throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = connectedFD.getConnectedModelV2().command55Variant3Version0("5");
        }
    }

    public void printCopyOfLastTransactionDocument() throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = connectedFD.getConnectedModelV2().command55Variant2Version0();
        }
    }

    public boolean checkPinpadConnection() throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = connectedFD.getConnectedModelV2().command55Variant3Version0("9");
            return R.getInt("errorCode") == 0;
        }
        return false;
    }

    public boolean CheckPinpadServerConnection() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = connectedFD.getConnectedModelV2().command55Variant3Version0("10");
            return R.getInt("errorCode") == 0;
        }
        return false;
    }

    public int getPinpadComPort() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdPinpad.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.PinpadComPort, "");
        }
        cmdPinpad.checkErrorCode(R);
        return R.getInt("VarValue");
    }

    public void setPinpadComPort(int value) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        R = cmdPinpad.getConnectedModelV2().Command255Write(FiscalDeviceV2.cmd255Name.PinpadComPort, "", String.valueOf(value));
        cmdPinpad.checkErrorCode(R);
    }

    public int getPinpadComBaudRate() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdPinpad.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.PinpadComBaudRate, "");
        }
        cmdPinpad.checkErrorCode(R);
        return R.getInt("VarValue");
    }

    public void setPinpadComBaudRate(int value) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        R = cmdPinpad.getConnectedModelV2().Command255Write(FiscalDeviceV2.cmd255Name.PinpadComBaudRate, "", String.valueOf(value));
        cmdPinpad.checkErrorCode(R);
    }

    public PinpadType getPinpadType() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdPinpad.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.PinpadType, "");
        }
        cmdPinpad.checkErrorCode(R);
        return PinpadType.values()[R.getInt("VarValue")];
    }

    public void setPinpadType(PinpadType value) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        R = cmdPinpad.getConnectedModelV2().Command255Write(FiscalDeviceV2.cmd255Name.PinpadType, "", String.valueOf(value.ordinal()));
        cmdPinpad.checkErrorCode(R);
    }

    public int getPinpadConnectionType() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdPinpad.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.PinpadConnectionType, "");
        }
        cmdPinpad.checkErrorCode(R);
        return R.getInt("VarValue");
    }

    public void setPinpadConnectionType(int value) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        R = cmdPinpad.getConnectedModelV2().Command255Write(FiscalDeviceV2.cmd255Name.PinpadConnectionType, "", String.valueOf(value));
        cmdPinpad.checkErrorCode(R);
    }

    public int getPinpadReceiptInfo() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdPinpad.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.PinpadReceiptInfo, "");
        }
        cmdPinpad.checkErrorCode(R);
        return R.getInt("VarValue");
    }

    public void setPinpadReceiptInfo(int value) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        R = cmdPinpad.getConnectedModelV2().Command255Write(FiscalDeviceV2.cmd255Name.PinpadReceiptInfo, "", String.valueOf(value));
        cmdPinpad.checkErrorCode(R);
    }

    public int getPinpadReceiptCopies() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdPinpad.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.PinpadReceiptCopies, "");
        }
        cmdPinpad.checkErrorCode(R);
        return R.getInt("VarValue");
    }

    public void setPinpadReceiptCopies(int value) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        R = cmdPinpad.getConnectedModelV2().Command255Write(FiscalDeviceV2.cmd255Name.PinpadReceiptCopies, "", String.valueOf(value));
        cmdPinpad.checkErrorCode(R);
    }

    public int getPinpadPaymentMenu() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdPinpad.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.PinpadPaymentMenu, "");
        }
        cmdPinpad.checkErrorCode(R);
        return R.getInt("VarValue");
    }

    public void setPinpadPaymentMenu(int value) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        R = cmdPinpad.getConnectedModelV2().Command255Write(FiscalDeviceV2.cmd255Name.PinpadPaymentMenu, "", String.valueOf(value));
        cmdPinpad.checkErrorCode(R);
    }

    public int getPinpadLoyaltyPayment() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdPinpad.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.PinpadLoyaltyPayment, "");
        }
        cmdPinpad.checkErrorCode(R);
        return R.getInt("VarValue");
    }

    public void setPinpadLoyaltyPayment(int value) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        R = cmdPinpad.getConnectedModelV2().Command255Write(FiscalDeviceV2.cmd255Name.PinpadLoyaltyPayment, "", String.valueOf(value));
        cmdPinpad.checkErrorCode(R);
    }

    public boolean getPinpadShortRec() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdPinpad.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.PinpadShortRec, "");
        }
        cmdPinpad.checkErrorCode(R);
        return R.getInt("VarValue") == 1;
    }

    public void setPinpadShortRec(boolean value) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        R = cmdPinpad.getConnectedModelV2().Command255Write(FiscalDeviceV2.cmd255Name.PinpadShortRec, "", value ? "1" : "0");
        cmdPinpad.checkErrorCode(R);
    }

    public void setPinpadDateTime(String dateTime) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdPinpad.getConnectedModelV2().command55Variant4Version0(dateTime);
        }
    }

    public void printTransactionReceipt() throws IOException, FiscalException {
        connectedFD.getConnectedModelV2().command55Variant3Version0("15");
    }

    public void voidTransactionBorica(String PayType, Double Amount, String RRN, String AC) throws IOException, FiscalException {
        if (!PayType.matches("^7|13{1}$")) {
            throw new IllegalArgumentException("Type of payment: 7 - Return with money, 13 - Return with points from loyal");
        }
        String sAmount = String.format("%.2f", Amount);
        if (!RRN.matches("^(\\d){1,12}")) {
            throw new IllegalArgumentException("RRN of the transaction(12 digits max)");
        }
        if (!AC.matches("^(\\d){1,6}")) {
            throw new IllegalArgumentException("AC of the transaction(6 digits max);");
        }
        connectedFD.getConnectedModelV2().command55Variant0Version0(String.valueOf(PayType), sAmount, RRN, AC);
    }

    public void voidTransactionUBB(String PayType, Double Amount, String Number2) throws IOException, FiscalException {
        if (!PayType.matches("^7|13{1}$")) {
            throw new IllegalArgumentException("Type of payment: 7 - Return with money, 13 - Return with points from loyal");
        }
        String sAmount = String.format("%.2f", Amount);
        connectedFD.getConnectedModelV2().command55Variant0Version1(String.valueOf(PayType), sAmount, Number2);
    }

    public void voidTransactionDSK(Double Amount) throws IOException, FiscalException {
        String sAmount = String.format("%.2f", Amount);
        connectedFD.getConnectedModelV2().command55Variant0Version2("16", sAmount);
    }

    public void returnTransaction(boolean Operation) throws IOException, FiscalException {
        connectedFD.getConnectedModelV2().command55Variant3Version1(Operation ? "1" : "2");
    }

    public static class PurchaseResult {
        private int ErrorCode;
        private String AC;
        private TypeOfCardPayment CardData;
        private String CardNumber;
        private String MIDNumber;
        private String RRN;
        private String TIDNumber;
        private String TransAmount;
        private String TransDate;
        private String TransTime;
        private String TransNumber;
        private TransStatus transStatus;
        private String TransType;
        private String FulLResponseCode;

        public int getErrorCode() {
            return this.ErrorCode;
        }

        public void setErrorCode(int errorCode) {
            this.ErrorCode = errorCode;
        }

        public String getAC() {
            return this.AC;
        }

        public void setAC(String AC) {
            this.AC = AC;
        }

        public TypeOfCardPayment getCardData() {
            return this.CardData;
        }

        public void setCardData(TypeOfCardPayment cardData) {
            this.CardData = cardData;
        }

        public String getCardNumber() {
            return this.CardNumber;
        }

        public void setCardNumber(String cardNumber) {
            this.CardNumber = cardNumber;
        }

        public String getMIDNumber() {
            return this.MIDNumber;
        }

        public void setMIDNumber(String MIDNumber) {
            this.MIDNumber = MIDNumber;
        }

        public String getRRN() {
            return this.RRN;
        }

        public void setRRN(String RRN) {
            this.RRN = RRN;
        }

        public String getTIDNumber() {
            return this.TIDNumber;
        }

        public void setTIDNumber(String TIDNumber) {
            this.TIDNumber = TIDNumber;
        }

        public String getTransAmount() {
            return this.TransAmount;
        }

        public void setTransAmount(String transAmount) {
            this.TransAmount = transAmount;
        }

        public String getTransDate() {
            return this.TransDate;
        }

        public void setTransDate(String transDate) {
            this.TransDate = transDate;
        }

        public String getTransTime() {
            return this.TransTime;
        }

        public void setTransTime(String transTime) {
            this.TransTime = transTime;
        }

        public String getTransNumber() {
            return this.TransNumber;
        }

        public void setTransNumber(String transNumber) {
            this.TransNumber = transNumber;
        }

        public TransStatus getTransStatus() {
            return this.transStatus;
        }

        public void setTransStatus(TransStatus transStatus) {
            this.transStatus = transStatus;
        }

        public String getTransType() {
            return this.TransType;
        }

        public void setTransType(String transType) {
            this.TransType = transType;
        }

        public String getFulLResponseCode() {
            return this.FulLResponseCode;
        }

        public void setFulLResponseCode(String fulLResponseCode) {
            this.FulLResponseCode = fulLResponseCode;
        }

        public PurchaseResult(int errorCode, String AC, TypeOfCardPayment cardData, String cardNumber, String MIDNumber, String RRN, String TIDNumber, String transAmount, String transDate, String transTime, String transNumber, TransStatus transStatus, String transType, String fulLResponseCode) {
            this.ErrorCode = errorCode;
            this.AC = AC;
            this.CardData = cardData;
            this.CardNumber = cardNumber;
            this.MIDNumber = MIDNumber;
            this.RRN = RRN;
            this.TIDNumber = TIDNumber;
            this.TransAmount = transAmount;
            this.TransDate = transDate;
            this.TransTime = transTime;
            this.TransNumber = transNumber;
            this.transStatus = transStatus;
            this.TransType = transType;
            this.FulLResponseCode = fulLResponseCode;
        }

        protected static enum TypeOfCardPayment {
            unknown,
            chip,
            contactless,
            magnetic,
            stripe,
            manually;

        }

        protected static enum TransStatus {
            approved,
            declined,
            error;

        }
    }

    public static enum DocTypeToCopy {
        RESERVED,
        RRN,
        AC,
        Number;

    }

    public static enum PinpadType {
        RESERVED,
        BORICA,
        UBB,
        DSK;

    }
}

