/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.util;

import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtils {
    private StringUtils() {
    }

    public static String[] split(String text, char c) {
        StringBuilder data = new StringBuilder();
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == c) {
                result.add(data.toString());
                data = new StringBuilder();
                continue;
            }
            data.append(c);
        }
        if (data.length() != 0) {
            result.add(data.toString());
        }
        return result.toArray(new String[0]);
    }

    public static String centerLine(String data, int lineLength) {
        int len = Math.min(data.length(), lineLength);
        StringBuilder s = new StringBuilder(data.substring(0, len));
        len = (lineLength - len) / 2;
        for (int i = 0; i < len; ++i) {
            s.insert(0, " ");
        }
        return s.toString();
    }

    public static String alignLeft(String data, int lineLength) {
        int len = Math.min(data.length(), lineLength);
        StringBuilder s = new StringBuilder(data.substring(0, len));
        len = lineLength - len;
        for (int i = 0; i < len; ++i) {
            s.append(" ");
        }
        return s.toString();
    }

    public static String alignRight(String data, int lineLength) {
        int len = Math.min(data.length(), lineLength);
        StringBuilder s = new StringBuilder(data.substring(0, len));
        len = lineLength - len;
        for (int i = 0; i < len; ++i) {
            s.insert(0, " ");
        }
        return s.toString();
    }

    public static String appendLeft(String data, int lineLength) {
        int len = lineLength - data.length();
        StringBuilder dataBuilder = new StringBuilder(data);
        for (int i = 0; i < len; ++i) {
            dataBuilder.insert(0, " ");
        }
        data = dataBuilder.toString();
        return data;
    }

    public static String appendRight(String data, int lineLength) {
        int len = lineLength - data.length();
        StringBuilder dataBuilder = new StringBuilder(data);
        for (int i = 0; i < len; ++i) {
            dataBuilder.append(" ");
        }
        data = dataBuilder.toString();
        return data;
    }

    public static String intToStr(int value, int len) {
        StringBuilder result = new StringBuilder(String.valueOf(value));
        if (result.length() > len) {
            result = new StringBuilder(String.copyValueOf(result.toString().toCharArray(), 0, len));
        }
        int count = len - result.length();
        for (int i = 0; i < count; ++i) {
            result.insert(0, "0");
        }
        return result.toString();
    }

    public static String decimalsToStr(int value, int len) {
        StringBuilder result = new StringBuilder(String.valueOf(value));
        int count = len - result.length();
        for (int i = 0; i < count; ++i) {
            result.append("0");
        }
        return result.toString();
    }

    public static String boolToStr(boolean value) {
        if (value) {
            return "1";
        }
        return "0";
    }

    public static String amountToString(long amount) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.getDefault());
        symbols.setDecimalSeparator('.');
        DecimalFormat formatter = new DecimalFormat("0.00", symbols);
        return formatter.format((double)amount / 100.0);
    }

    public static String quantityToString(double value) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.getDefault());
        symbols.setDecimalSeparator('.');
        DecimalFormat formatter = new DecimalFormat("0.000", symbols);
        return formatter.format(value);
    }

    public static String arrayToStr(int[] value) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            result.append(String.valueOf(value[i])).append("\t");
        }
        return result.toString();
    }

    public static int[] strToIntArray(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, "\t");
        int count = tokenizer.countTokens();
        int[] result = new int[count];
        for (int i = 0; i < count; ++i) {
            String token = tokenizer.nextToken();
            result[i] = Integer.parseInt(token);
        }
        return result;
    }

    public static byte[] getBytes(String text, String charsetName) throws UnsupportedEncodingException {
        if (charsetName == "") {
            return text.getBytes();
        }
        return text.getBytes(charsetName);
    }

    public static String stringOfChar(char c, int count) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            result.append(c);
        }
        return result.toString();
    }
}

