/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK.model.UserLayerV1;

import com.datecs.fiscalprinter.SDK.AbstractTransportProtocol;
import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import java.util.HashMap;
import java.util.Map;

public class cmdInfo
extends DatecsFiscalDevice {
    private final double amountFactor = 100.0;

    public void GetModeConnectionWithPC() throws Exception {
        this.checkErrorCode();
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int GetRemainingZReportEntries() throws Exception {
        this.checkErrorCode();
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public byte[] GetStatus(String option) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdInfo.getConnectedECRV1().command74Variant0Version0(option);
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command74Variant0Version0(option);
        }
        this.checkErrorCode();
        String statusStr = R.getString("S0") + R.getString("S1") + R.getString("S2") + R.getString("S3") + R.getString("S4") + R.getString("S5");
        byte[] dataset = new byte[statusStr.length()];
        AbstractTransportProtocol.toAnsi(statusStr, dataset, 0, 1251);
        return dataset;
    }

    public String GetLastFiscalRecordDate() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdInfo.getConnectedECRV1().command64Variant0Version0("0");
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command64Variant0Version0("*0");
        }
        this.checkErrorCode();
        return R.get("ClosureDate");
    }

    public String GetTaxNumber() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdInfo.getConnectedECRV1().command99Variant0Version0();
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command99Variant0Version0();
        }
        this.checkErrorCode();
        return R.get("Name") + R.get("Text");
    }

    public String GetDeviceSerialNumber() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdInfo.getConnectedECRV1().command90Variant0Version0("");
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command90Variant0Version0("");
        }
        this.checkErrorCode();
        return R.get("Ser");
    }

    public int GetErrorCode(boolean clear) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command32Variant0Version0(clear ? "CLEAR" : "");
        }
        return R.getInt("ErrCode");
    }

    public CurrentReceiptInfo GetCurrentReceipt() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdInfo.getConnectedECRV1().command103Variant0Version0();
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command103Variant0Version0();
        }
        this.checkErrorCode();
        return new CurrentReceiptInfo(R.get("TaxA"), R.get("TaxB"), R.get("TaxC"), R.get("TaxD"), R.get("TaxE"), R.get("TaxF"), R.get("TaxG"), R.get("TaxH"), R.get("Inv").equals("1"), R.get("CanVd").equals("1"), R.getInt("InvNum"));
    }

    public DailyInfoModel GetDailyPayments() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        DailyInfoModel res = new DailyInfoModel();
        if (this.isConnectedECR()) {
            R = cmdInfo.getConnectedECRV1().command110Variant0Version0();
            res.setCash(R.getDouble("Cash") / 100.0);
            res.setCredit(R.getDouble("Credit") / 100.0);
            res.setDebit(R.getDouble("Debit") / 100.0);
            res.setPay1(R.getDouble("Pay4") / 100.0);
            res.setPay2(R.getDouble("Pay5") / 100.0);
            res.setPay3(R.getDouble("Pay6") / 100.0);
            res.setClosure(R.getInt("Closure"));
            res.setReceipt(R.getInt("Receipt"));
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command110Variant0Version0();
            res.setCash(R.getDouble("Cash") / 100.0);
            res.setCredit(R.getDouble("Credit") / 100.0);
            res.setDebit(R.getDouble("Debit") / 100.0);
            res.setCheque(R.getDouble("Cheque") / 100.0);
            res.setPay1(R.getDouble("Pay1") / 100.0);
            res.setPay2(R.getDouble("Pay2") / 100.0);
            res.setPay3(R.getDouble("Pay3") / 100.0);
            res.setPay4(R.getDouble("Pay4") / 100.0);
            res.setClosure(R.getInt("Closure"));
            res.setReceipt(R.getInt("Receipt"));
        }
        this.checkErrorCode();
        return res;
    }

    public DailyInfoModel GetDailyPaymentsEx() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        DailyInfoModel res = new DailyInfoModel();
        if (this.isConnectedECR()) {
            R = cmdInfo.getConnectedECRV1().command65Variant3Version0();
            res.setAdditionalPaymentEX(new double[]{R.getDouble("sPY0") / 100.0, R.getDouble("sPY1") / 100.0, R.getDouble("sPY2") / 100.0, R.getDouble("sPY3") / 100.0, R.getDouble("sPY4") / 100.0});
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command110Variant1Version0();
            res.setAdditionalPaymentEX(new double[]{R.getDouble("Pay1") / 100.0, R.getDouble("Pay2") / 100.0, R.getDouble("Pay3") / 100.0, R.getDouble("Pay4") / 100.0, R.getDouble("Pay5") / 100.0, R.getDouble("Pay6") / 100.0, R.getDouble("Pay7") / 100.0, R.getDouble("Pay8") / 100.0, R.getDouble("Pay9") / 100.0, R.getDouble("Pay10") / 100.0, R.getDouble("Pay11") / 100.0});
        }
        this.checkErrorCode();
        return res;
    }

    public DailyInfoModel GetDailyNumAndSumsOfSells() throws Exception {
        DailyInfoModel res = new DailyInfoModel();
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdInfo.getConnectedECRV1().command65Variant1Version0();
            res.setNumberOfClients(R.getInt("qKLN"));
            res.setSumOfSells(R.getDouble("sPROD") / 100.0);
            R = cmdInfo.getConnectedECRV1().command65Variant0Version0("");
            res.setTurnoverByTaxGroup(new double[]{R.getDouble("TaxA") / 100.0, R.getDouble("TaxB") / 100.0, R.getDouble("TaxC") / 100.0, R.getDouble("TaxD") / 100.0, R.getDouble("TaxE") / 100.0, R.getDouble("TaxF") / 100.0, R.getDouble("TaxG") / 100.0, R.getDouble("TaxH") / 100.0});
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command37Variant0Version0();
            res.setNumberOfClients(R.getInt("FiscRec"));
            R = cmdInfo.getConnectedPrinterV1().command37Variant1Version0();
            res.setTurnoverByTaxGroup(new double[]{R.getDouble("S1"), R.getDouble("S2"), R.getDouble("S3"), R.getDouble("S4"), R.getDouble("S5"), R.getDouble("S6"), R.getDouble("S7"), R.getDouble("S8")});
            res.setSumOfSells(R.getDouble("Total"));
        }
        this.checkErrorCode();
        return res;
    }

    public DailyInfoModel GetDailyTurnoverByTaxGroup() throws Exception {
        DailyInfoModel res = new DailyInfoModel();
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdInfo.getConnectedECRV1().command65Variant0Version0("0");
            res.setTurnoverByTaxGroup(new double[]{R.getDouble("TaxA") / 100.0, R.getDouble("TaxB") / 100.0, R.getDouble("TaxC") / 100.0, R.getDouble("TaxD") / 100.0, R.getDouble("TaxE") / 100.0, R.getDouble("TaxF") / 100.0, R.getDouble("TaxG") / 100.0, R.getDouble("TaxH") / 100.0});
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command65Variant0Version0("0");
            res.setTurnoverByTaxGroup(new double[]{R.getDouble("TaxA"), R.getDouble("TaxB"), R.getDouble("TaxC"), R.getDouble("TaxD"), R.getDouble("TaxE"), R.getDouble("TaxF"), R.getDouble("TaxG"), R.getDouble("TaxH")});
        }
        this.checkErrorCode();
        return res;
    }

    public DailyInfoModel GetDailyAccumulatedVATByTaxGroup() throws Exception {
        DailyInfoModel res = new DailyInfoModel();
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdInfo.getConnectedECRV1().command65Variant0Version0("1");
            res.setAccumulatedVATByTaxGroup(new double[]{R.getDouble("TaxA") / 100.0, R.getDouble("TaxB") / 100.0, R.getDouble("TaxC") / 100.0, R.getDouble("TaxD") / 100.0, R.getDouble("TaxE") / 100.0, R.getDouble("TaxF") / 100.0, R.getDouble("TaxG") / 100.0, R.getDouble("TaxH") / 100.0});
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command65Variant0Version0("1");
            res.setAccumulatedVATByTaxGroup(new double[]{R.getDouble("TaxA") / 100.0, R.getDouble("TaxB") / 100.0, R.getDouble("TaxC") / 100.0, R.getDouble("TaxD") / 100.0, R.getDouble("TaxE") / 100.0, R.getDouble("TaxF") / 100.0, R.getDouble("TaxG") / 100.0, R.getDouble("TaxH") / 100.0});
        }
        this.checkErrorCode();
        return res;
    }

    public DailyInfoModel GetDailyStornoTurnoverByTaxGroup() throws Exception {
        DailyInfoModel res = new DailyInfoModel();
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdInfo.getConnectedECRV1().command65Variant5Version0();
            res.setTurnoverByTaxGroup(new double[]{R.getDouble("StrA") / 100.0, R.getDouble("StrB") / 100.0, R.getDouble("StrC") / 100.0, R.getDouble("StrD") / 100.0, R.getDouble("StrE") / 100.0, R.getDouble("StrF") / 100.0, R.getDouble("StrG") / 100.0, R.getDouble("StrH") / 100.0});
        }
        if (this.isConnectedPrinter()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.checkErrorCode();
        return res;
    }

    public DailyInfoModel GetDailyStornoAccumulatedVATByTaxGroup() throws Exception {
        DailyInfoModel res = new DailyInfoModel();
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdInfo.getConnectedECRV1().command65Variant6Version0();
            res.setTurnoverByTaxGroup(new double[]{R.getDouble("VatStrA") / 100.0, R.getDouble("VatStrB") / 100.0, R.getDouble("VatStrC") / 100.0, R.getDouble("VatStrD") / 100.0, R.getDouble("VatStrE") / 100.0, R.getDouble("VatStrF") / 100.0, R.getDouble("VatStrG") / 100.0, R.getDouble("VatStrH") / 100.0});
        }
        if (this.isConnectedPrinter()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.checkErrorCode();
        return res;
    }

    public String GetDateTimeOfFiscalization() throws Exception {
        DailyInfoModel res = new DailyInfoModel();
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command37Variant6Version0();
        }
        return R.get("Date") + " " + R.get("Time");
    }

    public DailyInfoModel GetDailyNumAndSumsOfDiscountsSurcharges() throws Exception {
        DailyInfoModel res = new DailyInfoModel();
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdInfo.getConnectedECRV1().command65Variant1Version0();
            res.setNumberOfDiscounts(R.getInt("qOTS"));
            res.setSumOfDiscounts(R.getDouble("sOTS") / 100.0);
            res.setNumberOfSurcharges(R.getInt("qNDB"));
            res.setSumOfSurcharges(R.getDouble("sNDB") / 100.0);
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command37Variant2Version0();
            res.setNumberOfDiscounts(R.getInt("DiscountN"));
            res.setSumOfDiscounts(R.getDouble("DiscountS"));
            res.setNumberOfSurcharges(R.getInt("MarkUpN"));
            res.setSumOfSurcharges(R.getDouble("MarkUpS"));
        }
        return res;
    }

    public DailyInfoModel GetDailyNumAndSumsOfVoided() throws Exception {
        DailyInfoModel res = new DailyInfoModel();
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdInfo.getConnectedECRV1().command65Variant1Version0();
            res.setNumberOfCorrections(R.getInt("qVD"));
            res.setSumOfCorrections(R.getDouble("sVD") / 100.0);
            res.setNumberOfAnnulled(R.getInt("qZSTR"));
            res.setSumOfAnnulled(R.getDouble("sZSTR") / 100.0);
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command37Variant2Version0();
            res.setNumberOfCorrections(R.getInt("VoidN"));
            res.setSumOfCorrections(R.getDouble("VoidS"));
            res.setNumberOfAnnulled(R.getInt("CancelN"));
            res.setSumOfAnnulled(R.getDouble("CancelS"));
        }
        return res;
    }

    public DailyInfoModel GetDailyCashCashInOut() throws Exception {
        DailyInfoModel res = new DailyInfoModel();
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdInfo.getConnectedECRV1().command65Variant2Version0();
            res.setNumberOfCashIn(R.getInt("qVV"));
            res.setSumOfCashIn(R.getDouble("sVV") / 100.0);
            res.setNumberOfCashOut(R.getInt("qIZ"));
            res.setSumOfCashOut(R.getDouble("sIZ") / 100.0);
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command37Variant3Version0();
            res.setNumberOfCashIn(R.getInt("CashInN"));
            res.setSumOfCashIn(R.getDouble("CashInS"));
            res.setNumberOfCashOut(R.getInt("CashOutN"));
            res.setSumOfCashOut(R.getDouble("CashOutN"));
        }
        return res;
    }

    public OperatorInfoModel GetOperatorInfo(int OperatorIndex) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdInfo.getConnectedECRV1().command112Variant0Version0(String.valueOf(OperatorIndex));
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command112Variant0Version0(String.valueOf(OperatorIndex));
        }
        OperatorInfoModel res = new OperatorInfoModel(OperatorIndex, R.get("Name"), R.get("Password"), R.getInt("Receipts"), Integer.parseInt(R.get("Total").split(";")[0]), Double.valueOf(R.get("Total").split(";")[1]), Integer.parseInt(R.get("Discount").split(";")[0]), Double.valueOf(R.get("Discount").split(";")[1]), Integer.parseInt(R.get("Surcharge").split(";")[0]), Double.valueOf(R.get("Surcharge").split(";")[1]), Integer.parseInt(R.get("Void").split(";")[0]), Double.valueOf(R.get("Void").split(";")[1]));
        this.checkErrorCode();
        return res;
    }

    public String GetOperName(int operIndex) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdInfo.getConnectedECRV1().command112Variant0Version0(String.valueOf(operIndex));
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command112Variant0Version0(String.valueOf(operIndex));
        }
        this.checkErrorCode();
        return R.getString("Name");
    }

    public String GetOperPasw(int operIndex) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdInfo.getConnectedECRV1().command112Variant0Version0(String.valueOf(operIndex));
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command112Variant0Version0(String.valueOf(operIndex));
        }
        this.checkErrorCode();
        return R.getString("Password");
    }

    public Map<String, String> GetOperNamePasw(int operIndex) throws Exception {
        HashMap<String, String> res = new HashMap<String, String>();
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdInfo.getConnectedECRV1().command112Variant0Version0(String.valueOf(operIndex));
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command112Variant0Version0(String.valueOf(operIndex));
        }
        this.checkErrorCode();
        res.put(R.getString("Password"), R.getString("Name"));
        return res;
    }

    public DepartmentData GetDepartmentData(int index) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdInfo.getConnectedECRV1().command88Variant0Version0(String.valueOf(index));
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command88Variant0Version0(String.valueOf(index));
        }
        this.checkErrorCode();
        if (R.get("ExitCode").equals("P")) {
            return new DepartmentData(R.get("TaxGr"), R.get("RecSales"), R.get("RecSum"), R.get("TotSales"), R.get("TotSum"), R.get("Line1"), R.get("Line2"));
        }
        return new DepartmentData("", "", "", "", "", "", "");
    }

    public String GetAPN(int index) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String GetAPNUser(int index) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String GetAPNPass(int index) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void GetSimPin() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void GetSimICCID() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void GetSimIMSI() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void GetSimTelNumber() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String GetLanMAC() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Boolean GetDHCPenable() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getAdditionalPayNamesCount() {
        if (this.isConnectedECR()) {
            return cmdInfo.getConnectedECRV1().MAX_ADDITIONAL_PAYMENTS;
        }
        if (this.isConnectedPrinter()) {
            return cmdInfo.getConnectedPrinterV1().MAX_ADDITIONAL_PAYMENTS;
        }
        return 0;
    }

    public FiscalPeriodInfo GetFiscRecord_ActiveTaxARates(int nRec) throws Exception {
        FiscalPeriodInfo res = new FiscalPeriodInfo();
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command114Variant0Version0(String.valueOf(nRec));
            if (!R.get("ErrorCode").equals("P")) {
                return res;
            }
            res.setDecRec(R.getInt("DecRec"));
            res.setDec(R.getInt("DecimalsCount"));
            res.setEnabled(R.get("VATEnabled"));
            res.setPerX(new double[]{R.getDouble("PercA"), R.getDouble("PercB"), R.getDouble("PercC"), R.getDouble("PercD"), R.getDouble("PercE"), R.getDouble("PercF"), R.getDouble("PercG"), R.getDouble("PercH")});
            return res;
        }
        this.checkErrorCode();
        return null;
    }

    public FiscalPeriodInfo GetFiscRecord_TotalSales(int nRecBegin, int nRecEnd) throws Exception {
        FiscalPeriodInfo res = new FiscalPeriodInfo();
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command114Variant1Version0(String.valueOf(nRecBegin), String.valueOf(nRecEnd));
            if (!R.get("ErrorCode").equals("P")) {
                return res;
            }
            res.setClosure(R.getInt("Closure"));
            res.setReceipts(R.getInt("Receipts"));
            res.setClCnt(R.getInt("ClCnt"));
            res.setTotX(new double[]{R.getDouble("TotA"), R.getDouble("TotB"), R.getDouble("TotC"), R.getDouble("TotD"), R.getDouble("TotE"), R.getDouble("TotF"), R.getDouble("TotG"), R.getDouble("TotH")});
            return res;
        }
        this.checkErrorCode();
        return null;
    }

    public FiscalPeriodInfo GetFiscRecord_NetAmounts(int nRecBegin, int nRecEnd) throws Exception {
        FiscalPeriodInfo res = new FiscalPeriodInfo();
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command114Variant2Version0(String.valueOf(nRecBegin), String.valueOf(nRecEnd));
            if (!R.get("ErrorCode").equals("P")) {
                return res;
            }
            res.setClosure(R.getInt("Closure"));
            res.setReceipts(R.getInt("Receipts"));
            res.setClCnt(R.getInt("ClCnt"));
            res.setNetX(new double[]{R.getDouble("NetA"), R.getDouble("NetB"), R.getDouble("NetC"), R.getDouble("NetD"), R.getDouble("NetE"), R.getDouble("NetF"), R.getDouble("NetG"), R.getDouble("NetH")});
            return res;
        }
        this.checkErrorCode();
        return null;
    }

    public FiscalPeriodInfo GetFiscRecord_VatAssessed(int nRecBegin, int nRecEnd) throws Exception {
        FiscalPeriodInfo res = new FiscalPeriodInfo();
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command114Variant3Version0(String.valueOf(nRecBegin), String.valueOf(nRecEnd));
            if (!R.get("ErrorCode").equals("P")) {
                return res;
            }
            res.setClosure(R.getInt("Closure"));
            res.setReceipts(R.getInt("Receipts"));
            res.setClCnt(R.getInt("ClCnt"));
            res.setTaxX(new double[]{R.getDouble("TaxA"), R.getDouble("TaxB"), R.getDouble("TaxC"), R.getDouble("TaxD"), R.getDouble("TaxE"), R.getDouble("TaxF"), R.getDouble("TaxG"), R.getDouble("TaxH")});
        }
        this.checkErrorCode();
        return res;
    }

    public FiscalPeriodInfo GetFiscRecord_AdditionalInfo(int nRecBegin) throws Exception {
        FiscalPeriodInfo res = new FiscalPeriodInfo();
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command114Variant4Version0(String.valueOf(nRecBegin));
            if (!R.get("ErrorCode").equals("P")) {
                return res;
            }
            res.setClosure(R.getInt("Closure"));
            res.setReceipts(R.getInt("DecRec"));
            res.setReset(R.get("ResetRec"));
            res.setKLEN(R.getInt("KLEN"));
            res.setDT(R.get("DT"));
        }
        this.checkErrorCode();
        return res;
    }

    public FiscalPeriodInfo GetFiscRecord_Adjustments(int nRecBegin, int nRecEnd) throws Exception {
        FiscalPeriodInfo res = new FiscalPeriodInfo();
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command114Variant8Version0(String.valueOf(nRecBegin), String.valueOf(nRecEnd));
            if (!R.get("ErrorCode").equals("P")) {
                return res;
            }
            res.setDiscC(R.getInt("DiscC"));
            res.setDiscS(R.getDouble("DiscS"));
            res.setMkUpC(R.getInt("MkUpC"));
            res.setMkUpS(R.getDouble("MkUpS"));
            res.setVoidC(R.getInt("VoidC"));
            res.setVoidS(R.getDouble("VoidS"));
            res.setCanC(R.getInt("CanC"));
            res.setCanS(R.getDouble("CanS"));
        }
        this.checkErrorCode();
        return res;
    }

    public FiscalPeriodInfo GetFiscRecord_AmountsByPaymentType(int nRecBegin, int nRecEnd) throws Exception {
        FiscalPeriodInfo res = new FiscalPeriodInfo();
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdInfo.getConnectedPrinterV1().command114Variant7Version0(String.valueOf(nRecBegin), String.valueOf(nRecEnd));
            if (!R.get("ErrorCode").equals("P")) {
                return res;
            }
            res.setCashP(R.getDouble("CashP"));
            res.setCardP(R.getDouble("CardP"));
            res.setCredP(R.getDouble("CredP"));
            res.setCheqP(R.getDouble("CheqP"));
            double[] dTemp = new double[11];
            for (int i = 1; i <= this.getAdditionalPayNamesCount(); ++i) {
                dTemp[i - 1] = R.getDouble("APayd" + i);
            }
            res.setAPayd(dTemp);
        }
        this.checkErrorCode();
        return res;
    }

    public static class FiscalPeriodInfo {
        private int Closure;
        private int ClCnt;
        private int VR;
        private int VE;
        private int VT;
        private int SR;
        private int SE;
        private int ST;
        private int DecRec;
        private int Dec;
        private String Enabled;
        private int Receipts;
        private double[] PerX;
        private double[] TotX;
        private double[] NetX;
        private double[] TaxX;
        private String Reset;
        private int KLEN;
        private String DT;
        private double CashP;
        private double CardP;
        private double CredP;
        private double CheqP;
        private double[] APayd;
        private int DiscC;
        private double DiscS;
        private int MkUpC;
        private double MkUpS;
        private int VoidC;
        private double VoidS;
        private int CanC;
        private double CanS;
        private int InC;
        private int Out;
        private double GTotal;
        private double GVAT;

        public double getCanS() {
            return this.CanS;
        }

        public void setCanS(double canS) {
            this.CanS = canS;
        }

        public int getClosure() {
            return this.Closure;
        }

        public void setClosure(int closure) {
            this.Closure = closure;
        }

        public int getClCnt() {
            return this.ClCnt;
        }

        public void setClCnt(int clCnt) {
            this.ClCnt = clCnt;
        }

        public int getVR() {
            return this.VR;
        }

        public void setVR(int VR) {
            this.VR = VR;
        }

        public int getVE() {
            return this.VE;
        }

        public void setVE(int VE) {
            this.VE = VE;
        }

        public int getVT() {
            return this.VT;
        }

        public void setVT(int VT) {
            this.VT = VT;
        }

        public int getSR() {
            return this.SR;
        }

        public void setSR(int SR) {
            this.SR = SR;
        }

        public int getSE() {
            return this.SE;
        }

        public void setSE(int SE) {
            this.SE = SE;
        }

        public int getST() {
            return this.ST;
        }

        public void setST(int ST) {
            this.ST = ST;
        }

        public int getDecRec() {
            return this.DecRec;
        }

        public void setDecRec(int decRec) {
            this.DecRec = decRec;
        }

        public int getDec() {
            return this.Dec;
        }

        public void setDec(int dec) {
            this.Dec = dec;
        }

        public String getEnabled() {
            return this.Enabled;
        }

        public void setEnabled(String enabled) {
            this.Enabled = enabled;
        }

        public int getReceipts() {
            return this.Receipts;
        }

        public void setReceipts(int receipts) {
            this.Receipts = receipts;
        }

        public double[] getPerX() {
            return this.PerX;
        }

        public void setPerX(double[] perX) {
            this.PerX = perX;
        }

        public double[] getTotX() {
            return this.TotX;
        }

        public void setTotX(double[] totX) {
            this.TotX = totX;
        }

        public double[] getNetX() {
            return this.NetX;
        }

        public void setNetX(double[] netX) {
            this.NetX = netX;
        }

        public double[] getTaxX() {
            return this.TaxX;
        }

        public void setTaxX(double[] taxX) {
            this.TaxX = taxX;
        }

        public String getReset() {
            return this.Reset;
        }

        public void setReset(String reset) {
            this.Reset = reset;
        }

        public int getKLEN() {
            return this.KLEN;
        }

        public void setKLEN(int KLEN) {
            this.KLEN = KLEN;
        }

        public String getDT() {
            return this.DT;
        }

        public void setDT(String DT) {
            this.DT = DT;
        }

        public double getCashP() {
            return this.CashP;
        }

        public void setCashP(double cashP) {
            this.CashP = cashP;
        }

        public double getCardP() {
            return this.CardP;
        }

        public void setCardP(double cardP) {
            this.CardP = cardP;
        }

        public double getCredP() {
            return this.CredP;
        }

        public void setCredP(double credP) {
            this.CredP = credP;
        }

        public double getCheqP() {
            return this.CheqP;
        }

        public void setCheqP(double cheqP) {
            this.CheqP = cheqP;
        }

        public double[] getAPayd() {
            return this.APayd;
        }

        public void setAPayd(double[] APayd) {
            this.APayd = APayd;
        }

        public int getDiscC() {
            return this.DiscC;
        }

        public void setDiscC(int discC) {
            this.DiscC = discC;
        }

        public double getDiscS() {
            return this.DiscS;
        }

        public void setDiscS(double discS) {
            this.DiscS = discS;
        }

        public int getMkUpC() {
            return this.MkUpC;
        }

        public void setMkUpC(int mkUpC) {
            this.MkUpC = mkUpC;
        }

        public double getMkUpS() {
            return this.MkUpS;
        }

        public void setMkUpS(double mkUpS) {
            this.MkUpS = mkUpS;
        }

        public int getVoidC() {
            return this.VoidC;
        }

        public void setVoidC(int voidC) {
            this.VoidC = voidC;
        }

        public double getVoidS() {
            return this.VoidS;
        }

        public void setVoidS(double voidS) {
            this.VoidS = voidS;
        }

        public int getCanC() {
            return this.CanC;
        }

        public void setCanC(int canC) {
            this.CanC = canC;
        }

        public int getInC() {
            return this.InC;
        }

        public void setInC(int inC) {
            this.InC = inC;
        }

        public int getOut() {
            return this.Out;
        }

        public void setOut(int out) {
            this.Out = out;
        }

        public double getGTotal() {
            return this.GTotal;
        }

        public void setGTotal(double GTotal) {
            this.GTotal = GTotal;
        }

        public double getGVAT() {
            return this.GVAT;
        }

        public void setGVAT(double GVAT) {
            this.GVAT = GVAT;
        }
    }

    public static class OperatorInfoModel {
        int index;
        String operatorName;
        int Receipts;
        int nTotal;
        double Total;
        int nDiscount;
        String password;
        double Discount;
        int nSurcharge;
        double Surcharge;
        int nVoid;
        double Void;

        public int getnTotal() {
            return this.nTotal;
        }

        public void setnTotal(int nTotal) {
            this.nTotal = nTotal;
        }

        public void setDiscount(double discount) {
            this.Discount = discount;
        }

        public void setSurcharge(double surcharge) {
            this.Surcharge = surcharge;
        }

        public void setVoid(double aVoid) {
            this.Void = aVoid;
        }

        public OperatorInfoModel(int index, String name, String password, int receipts, int nTotal, double total, int nDiscount, double discount, int nSurcharge, Double surcharge, int nVoid, double aVoid) {
            this.index = index;
            this.operatorName = name;
            this.Receipts = receipts;
            this.nTotal = nTotal;
            this.Total = total;
            this.nDiscount = nDiscount;
            this.Discount = discount;
            this.nSurcharge = nSurcharge;
            this.Surcharge = surcharge;
            this.nVoid = nVoid;
            this.Void = aVoid;
            this.password = password;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getOperatorName() {
            return this.operatorName;
        }

        public void setOperatorName(String operatorName) {
            this.operatorName = operatorName;
        }

        public int getReceipts() {
            return this.Receipts;
        }

        public void setReceipts(int receipts) {
            this.Receipts = receipts;
        }

        public double getTotal() {
            return this.Total;
        }

        public void setTotal(double total) {
            this.Total = total;
        }

        public int getnDiscount() {
            return this.nDiscount;
        }

        public void setnDiscount(int nDiscount) {
            this.nDiscount = nDiscount;
        }

        public Double getDiscount() {
            return this.Discount;
        }

        public void setDiscount(Double discount) {
            this.Discount = discount;
        }

        public int getnSurcharge() {
            return this.nSurcharge;
        }

        public void setnSurcharge(int nSurcharge) {
            this.nSurcharge = nSurcharge;
        }

        public Double getSurcharge() {
            return this.Surcharge;
        }

        public void setSurcharge(Double surcharge) {
            this.Surcharge = surcharge;
        }

        public int getnVoid() {
            return this.nVoid;
        }

        public void setnVoid(int nVoid) {
            this.nVoid = nVoid;
        }

        public Double getVoid() {
            return this.Void;
        }

        public void setVoid(Double aVoid) {
            this.Void = aVoid;
        }
    }

    public static class DailyInfoModel
    extends cmdInfo {
        public static final int DAY_INFO_payments = 0;
        public static final int DAY_INFO_sells = 1;
        public static final int DAY_INFO_discounts_surcharges = 2;
        public static final int DAY_INFO_corrections_annulled = 3;
        public static final int DAY_INFO_cash_in_out = 4;
        private int type;
        private int numberOfClients;
        private double sumOfSells;
        private int numberOfSurcharges;
        private double sumOfSurcharges;
        private int numberOfDiscounts;
        private double sumOfDiscounts;
        private int numberOfCorrections;
        private double sumOfCorrections;
        private int numberOfAnnulled;
        private double sumOfAnnulled;
        private int numberOfCashIn;
        private double sumOfCashIn;
        private int numberOfCashOut;
        private double sumOfCashOut;
        private int numberOfCashInF;
        private double sumOfCashInF;
        private int numberOfCashOutF;
        private double sumOfCashOutF;
        private int Closure;
        private int Receipt;
        private double Cash;
        private double Credit;
        private double Debit;
        private double Cheque;
        private double Pay1;
        private double Pay2;
        private double Pay3;
        private double Pay4;
        public double[] additionalPaymentEX = new double[this.getAdditionalPayNamesCount()];
        public double[] turnoverByTaxGroup = new double[8];
        private double[] accumulatedVATrByTaxGroup = new double[8];

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public int getNumberOfClients() {
            return this.numberOfClients;
        }

        public void setNumberOfClients(int numberOfClients) {
            this.numberOfClients = numberOfClients;
        }

        public double getSumOfSells() {
            return this.sumOfSells;
        }

        public void setSumOfSells(double sumOfSells) {
            this.sumOfSells = sumOfSells;
        }

        public int getNumberOfSurcharges() {
            return this.numberOfSurcharges;
        }

        public void setNumberOfSurcharges(int numberOfSurcharges) {
            this.numberOfSurcharges = numberOfSurcharges;
        }

        public double getSumOfSurcharges() {
            return this.sumOfSurcharges;
        }

        public void setSumOfSurcharges(double sumOfSurcharges) {
            this.sumOfSurcharges = sumOfSurcharges;
        }

        public int getNumberOfDiscounts() {
            return this.numberOfDiscounts;
        }

        public void setNumberOfDiscounts(int numberOfDiscounts) {
            this.numberOfDiscounts = numberOfDiscounts;
        }

        public double getSumOfDiscounts() {
            return this.sumOfDiscounts;
        }

        public void setSumOfDiscounts(double sumOfDiscounts) {
            this.sumOfDiscounts = sumOfDiscounts;
        }

        public int getNumberOfCorrections() {
            return this.numberOfCorrections;
        }

        public void setNumberOfCorrections(int numberOfCorrections) {
            this.numberOfCorrections = numberOfCorrections;
        }

        public double getSumOfCorrections() {
            return this.sumOfCorrections;
        }

        public void setSumOfCorrections(double sumOfCorrections) {
            this.sumOfCorrections = sumOfCorrections;
        }

        public int getNumberOfAnnulled() {
            return this.numberOfAnnulled;
        }

        public void setNumberOfAnnulled(int numberOfAnnulled) {
            this.numberOfAnnulled = numberOfAnnulled;
        }

        public double getSumOfAnnulled() {
            return this.sumOfAnnulled;
        }

        public void setSumOfAnnulled(double sumOfAnnulled) {
            this.sumOfAnnulled = sumOfAnnulled;
        }

        public int getNumberOfCashIn() {
            return this.numberOfCashIn;
        }

        public void setNumberOfCashIn(int numberOfCashIn) {
            this.numberOfCashIn = numberOfCashIn;
        }

        public double getSumOfCashIn() {
            return this.sumOfCashIn;
        }

        public void setSumOfCashIn(double sumOfCashIn) {
            this.sumOfCashIn = sumOfCashIn;
        }

        public int getNumberOfCashOut() {
            return this.numberOfCashOut;
        }

        public void setNumberOfCashOut(int numberOfCashOut) {
            this.numberOfCashOut = numberOfCashOut;
        }

        public double getSumOfCashOut() {
            return this.sumOfCashOut;
        }

        public void setSumOfCashOut(double sumOfCashOut) {
            this.sumOfCashOut = sumOfCashOut;
        }

        public int getNumberOfCashInF() {
            return this.numberOfCashInF;
        }

        public void setNumberOfCashInF(int numberOfCashInF) {
            this.numberOfCashInF = numberOfCashInF;
        }

        public double getSumOfCashInF() {
            return this.sumOfCashInF;
        }

        public void setSumOfCashInF(double sumOfCashInF) {
            this.sumOfCashInF = sumOfCashInF;
        }

        public int getNumberOfCashOutF() {
            return this.numberOfCashOutF;
        }

        public void setNumberOfCashOutF(int numberOfCashOutF) {
            this.numberOfCashOutF = numberOfCashOutF;
        }

        public double getSumOfCashOutF() {
            return this.sumOfCashOutF;
        }

        public void setSumOfCashOutF(double sumOfCashOutF) {
            this.sumOfCashOutF = sumOfCashOutF;
        }

        public int getClosure() {
            return this.Closure;
        }

        public void setClosure(int closure) {
            this.Closure = closure;
        }

        public int getReceipt() {
            return this.Receipt;
        }

        public void setReceipt(int receipt) {
            this.Receipt = receipt;
        }

        public double getCash() {
            return this.Cash;
        }

        public void setCash(double cash) {
            this.Cash = cash;
        }

        public double getCredit() {
            return this.Credit;
        }

        public void setCredit(double credit) {
            this.Credit = credit;
        }

        public double getDebit() {
            return this.Debit;
        }

        public void setDebit(double debit) {
            this.Debit = debit;
        }

        public double getCheque() {
            return this.Cheque;
        }

        public void setCheque(double cheque) {
            this.Cheque = cheque;
        }

        public double getPay1() {
            return this.Pay1;
        }

        public void setPay1(double pay1) {
            this.Pay1 = pay1;
        }

        public double getPay2() {
            return this.Pay2;
        }

        public void setPay2(double pay2) {
            this.Pay2 = pay2;
        }

        public double getPay3() {
            return this.Pay3;
        }

        public void setPay3(double pay3) {
            this.Pay3 = pay3;
        }

        public double getPay4() {
            return this.Pay4;
        }

        public void setPay4(double pay4) {
            this.Pay4 = pay4;
        }

        public double[] getAdditionalPaymentEX() {
            return this.additionalPaymentEX;
        }

        public void setAdditionalPaymentEX(double[] additionalPaymentEX) {
            this.additionalPaymentEX = additionalPaymentEX;
        }

        public double[] getTurnoverByTaxGroup() {
            return this.turnoverByTaxGroup;
        }

        public void setTurnoverByTaxGroup(double[] turnoverByTaxGroup) {
            this.turnoverByTaxGroup = turnoverByTaxGroup;
        }

        public void setAccumulatedVATByTaxGroup(double[] accumulatedVATrByTaxGroup) {
            this.accumulatedVATrByTaxGroup = accumulatedVATrByTaxGroup;
        }

        public double[] getAccumulatedVATrByTaxGroup() {
            return this.accumulatedVATrByTaxGroup;
        }
    }

    public static class CurrentReceiptInfo {
        private String TaxA;
        private String TaxB;
        private String TaxC;
        private String TaxD;
        private String TaxE;
        private String TaxF;
        private String TaxG;
        private String TaxH;
        Boolean CanVd;
        Boolean Inv;
        int InvNmb;

        public CurrentReceiptInfo(String TaxA, String TaxB, String TaxC, String TaxD, String TaxE, String TaxF, String TaxG, String TaxH, Boolean CanVd, Boolean Inv, int InvNmb) {
        }
    }

    public static class DepartmentData {
        private String TaxGr = "";
        private String RecSales = "";
        private String RecSum = "";
        private String TotSales = "";
        private String TotSum = "";
        private String Line1 = "";
        private String Line2 = "";

        public DepartmentData(String taxGr, String recSales, String recSum, String totSales, String totSum, String line1, String line2) {
            this.TaxGr = taxGr;
            this.RecSales = recSales;
            this.RecSum = recSum;
            this.TotSales = totSales;
            this.TotSum = totSum;
            this.Line1 = line1;
            this.Line2 = line2;
        }

        public String getTaxGr() {
            return this.TaxGr;
        }

        public void setTaxGr(String taxGr) {
            this.TaxGr = taxGr;
        }

        public String getRecSales() {
            return this.RecSales;
        }

        public void setRecSales(String recSales) {
            this.RecSales = recSales;
        }

        public String getRecSum() {
            return this.RecSum;
        }

        public void setRecSum(String recSum) {
            this.RecSum = recSum;
        }

        public String getTotSales() {
            return this.TotSales;
        }

        public void setTotSales(String totSales) {
            this.TotSales = totSales;
        }

        public String getTotSum() {
            return this.TotSum;
        }

        public void setTotSum(String totSum) {
            this.TotSum = totSum;
        }

        public String getLine1() {
            return this.Line1;
        }

        public void setLine1(String line1) {
            this.Line1 = line1;
        }

        public String getLine2() {
            return this.Line2;
        }

        public void setLine2(String line2) {
            this.Line2 = line2;
        }
    }
}

