/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK.model.UserLayerV1;

import com.datecs.fiscalprinter.SDK.FiscalException;
import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class cmdConfig
extends DatecsFiscalDevice {
    public LANSettings GetLANSettings() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command36Variant1Version0();
        }
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.checkErrorCode();
        return new LANSettings(R.get("IPAddr"), R.get("SubnetMask"), R.get("TCPPort"), R.get("DefGateway"), R.get("DHCP").equals("1"), R.get("MACAddr"));
    }

    public void SetLANSettings(LANSettings lanSettings) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command36Variant0Version0(lanSettings.getIPAddr(), lanSettings.getSubnetMask(), lanSettings.getTCPPort(), lanSettings.getDefGateway(), lanSettings.getDHCP() ? "*1" : "*0", lanSettings.getMACAddr());
        }
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        this.checkErrorCode();
    }

    public boolean SetCodePageDOS856(boolean value) throws Exception {
        String sw;
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command90Variant0Version0("*");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command90Variant0Version0("*");
        }
        if (!(sw = R.get("Sw")).matches("^[0-1]{16}$")) {
            return false;
        }
        char[] chars = sw.toCharArray();
        chars[5] = value ? 49 : 48;
        String newMode = String.valueOf(chars);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command41Variant0Version0(newMode);
        }
        this.checkErrorCode();
        return R.get("Result").equals("P");
    }

    public boolean SetFpComBaudRate(Baudrate value) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command90Variant0Version0("*");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command90Variant0Version0("*");
        }
        String sw = R.get("Sw");
        String oldBPS = sw.substring(5, 8);
        String newBPS = "";
        if (!oldBPS.matches("^[0-1]{3}$")) {
            return false;
        }
        switch (value) {
            case bps1200: {
                newBPS = "000";
                break;
            }
            case bps2400: {
                newBPS = "100";
                break;
            }
            case bps4800: {
                newBPS = "010";
                break;
            }
            case bps9600: {
                newBPS = "110";
                break;
            }
            case bps19200: {
                newBPS = "001";
                break;
            }
            case bps38400: {
                newBPS = "101";
                break;
            }
            case bps57600: {
                newBPS = "011";
                break;
            }
            case bps115200: {
                newBPS = "111";
            }
        }
        newBPS = sw.substring(0, 5) + newBPS + sw.substring(8);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command41Variant0Version0(newBPS);
        }
        this.checkErrorCode();
        return R.get("Result").equals("P");
    }

    public void SetBarcodeHeight(int value) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant1Version0("B", String.valueOf(value * 8));
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant1Version0("B", String.valueOf(value * 8));
        }
        this.checkErrorCode();
    }

    public int GetBarcodeHeight() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant2Version0("B");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant2Version0("B");
        }
        this.checkErrorCode();
        return Integer.valueOf(R.get("ItemValue")) / 8;
    }

    public void SetOperName(int index, String pass, String name) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command102Variant0Version0(String.valueOf(index), pass, name);
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command102Variant0Version0(String.valueOf(index), pass, name);
        }
        this.checkErrorCode();
    }

    public void SetOperPasw(int operIndex, String oldPass, String newPass) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command101Variant0Version0(String.valueOf(operIndex), oldPass, newPass);
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command101Variant0Version0(String.valueOf(operIndex), oldPass, newPass);
        }
        this.checkErrorCode();
    }

    public void setDepartment(String index, String taxGr, String nameL1, String nameL2) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command87Variant0Version0(index, taxGr, nameL1, nameL2);
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command87Variant0Version0(index, taxGr, nameL1, nameL2);
        }
        this.checkErrorCode();
    }

    public String GetPayName(int index) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            String payCode = "N";
            switch (index) {
                case 1: {
                    payCode = "N";
                    break;
                }
                case 2: {
                    payCode = "C";
                    break;
                }
                case 3: {
                    payCode = "D";
                    break;
                }
                case 4: {
                    payCode = "I";
                    break;
                }
                case 5: {
                    payCode = "J";
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            R = cmdConfig.getConnectedECRV1().command85Variant1Version0(payCode);
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command85Variant1Version0(String.valueOf((char)(104 + index)));
        }
        this.checkErrorCode();
        return R.get("Name");
    }

    public void SetPayName(int index, String name) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            String payCode = "N";
            switch (index) {
                case 1: {
                    payCode = "N";
                    break;
                }
                case 2: {
                    payCode = "C";
                    break;
                }
                case 3: {
                    payCode = "D";
                    break;
                }
                case 4: {
                    payCode = "I";
                    break;
                }
                case 5: {
                    payCode = "J";
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            R = cmdConfig.getConnectedECRV1().command85Variant0Version0(payCode, name);
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command85Variant0Version0(String.valueOf(104 + index), name);
        }
        this.checkErrorCode();
    }

    public void Logo_WriteRow(int row, String data) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command115Variant0Version0(String.valueOf(row), data);
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command115Variant0Version0(String.valueOf(row), data);
        }
        this.checkErrorCode();
    }

    public String Logo_ReadRow(int row) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command115Variant1Version0(String.valueOf(row));
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command115Variant1Version0(String.valueOf(row));
        }
        this.checkErrorCode();
        return R.get("RowData");
    }

    public void Logo_SaveToDevice() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command41Variant0Version0("");
        }
        this.checkErrorCode();
    }

    public void SetPrnQuality(int value) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant1Version0("D", String.valueOf(value + 1));
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant1Version0("D", String.valueOf(value + 1));
        }
        this.checkErrorCode();
    }

    public int GetPrnQuality() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant2Version0("D");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant2Version0("D");
        }
        this.checkErrorCode();
        return R.getInt("ItemValue") - 1;
    }

    public void SetLogoPrint(boolean enable, String height) throws Exception {
        String value;
        FiscalResponse R = new FiscalResponse(0);
        String string = value = enable ? "1" : "0";
        if (!height.equals("")) {
            value = value + "," + height;
        }
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant1Version0("L", value);
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant1Version0("L", value);
        }
        this.checkErrorCode();
    }

    public boolean GetLogoPrint() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant2Version0("L");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant2Version0("L");
        }
        this.checkErrorCode();
        return R.get("ItemValue").equals("1");
    }

    public int GetLogoHeight() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant2Version0("L");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant2Version0("L");
        }
        this.checkErrorCode();
        return R.getInt("ItemValueEx");
    }

    public void SetForeignPrint(boolean enable, String ExRate) throws Exception {
        String value;
        FiscalResponse R = new FiscalResponse(0);
        String rate = "";
        if (Double.valueOf(ExRate) > 0.0) {
            rate = "," + ExRate;
        }
        String string = value = enable ? "1" : "0";
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant1Version0("E", value + rate);
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant1Version0("E", value + rate);
        }
        this.checkErrorCode();
    }

    public boolean GetForeignPrint() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant2Version0("E");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant2Version0("E");
        }
        this.checkErrorCode();
        return R.get("ItemValue").equals("1");
    }

    public String GetExchangeRate() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant2Version0("E");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant2Version0("E");
        }
        this.checkErrorCode();
        return R.get("ItemValueEx");
    }

    public void SetReceiptFormat(boolean value) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant1Version0("A", value ? "1" : "0");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant1Version0("A", value ? "1" : "0");
        }
        this.checkErrorCode();
    }

    public boolean GetReceiptFormat() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant2Version0("A");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant2Version0("A");
        }
        this.checkErrorCode();
        return R.get("ItemValue").equals("1");
    }

    public boolean GetPrintVAT() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant2Version0("T");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant2Version0("T");
        }
        this.checkErrorCode();
        return R.get("ItemValue").equals("1");
    }

    public void SetPrintVAT(boolean value) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant1Version0("T", value ? "1" : "0");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant1Version0("T", value ? "1" : "0");
        }
        this.checkErrorCode();
    }

    public int GetFontType() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant2Version0("F");
        }
        this.checkErrorCode();
        return Integer.valueOf(R.get("ItemValue"));
    }

    public void SetFontType(int value) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant1Version0("F", String.valueOf(value));
        }
        this.checkErrorCode();
    }

    public int GetSpaceLines() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant2Version0("R");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant2Version0("R");
        }
        this.checkErrorCode();
        return Integer.valueOf(R.get("ItemValue"));
    }

    public void SetSpaceLines(int value) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant1Version0("R", String.valueOf(value));
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant1Version0("R", String.valueOf(value));
        }
        this.checkErrorCode();
    }

    public boolean GetAutoPaperCutting() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant2Version0("C");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant2Version0("C");
        }
        this.checkErrorCode();
        return R.get("ItemValue").equals("1");
    }

    public void GetAutoPaperCutting(boolean value) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant1Version0("C", value ? "1" : "0");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant1Version0("C", value ? "1" : "0");
        }
        this.checkErrorCode();
    }

    public boolean GetDrawerOpening() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant2Version0("X");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant2Version0("X");
        }
        this.checkErrorCode();
        return R.get("ItemValue").equals("1");
    }

    public void SetDrawerOpening(boolean value) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant1Version0("X", value ? "1" : "0");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant1Version0("X", value ? "1" : "0");
        }
        this.checkErrorCode();
    }

    public boolean GetDepartmentPrint() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant2Version0("X");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant2Version0("X");
        }
        this.checkErrorCode();
        return R.get("ItemValue").equals("1");
    }

    public void SetDepartmentPrint(boolean value) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command43Variant1Version0("N", value ? "1" : "0");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command43Variant1Version0("N", value ? "1" : "0");
        }
        this.checkErrorCode();
    }

    public long SetInvoiceInterval(String startNumber, String endNumber) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command66Variant0Version0(startNumber, endNumber);
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command66Variant0Version0(startNumber, endNumber);
        }
        this.checkErrorCode();
        return Long.valueOf(R.getString("current"));
    }

    public ArrayList<String> GetInvoiceInterval() throws IOException, FiscalException {
        ArrayList<String> res = new ArrayList<String>();
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdConfig.getConnectedECRV1().command66Variant0Version0("", "");
        }
        if (this.isConnectedPrinter()) {
            R = cmdConfig.getConnectedPrinterV1().command66Variant0Version0("", "");
        }
        cmdConfig.checkErrorCode(R);
        res.add(R.getString("start"));
        res.add(R.getString("end"));
        res.add(R.getString("current"));
        return res;
    }

    public static class LANSettings {
        private String IPAddr;
        private String SubnetMask;
        private String TCPPort;
        private String DefGateway;
        private boolean DHCP;
        private String MACAddr;

        public boolean getDHCP() {
            return this.DHCP;
        }

        public void setDHCP(boolean DHCP) {
            this.DHCP = DHCP;
        }

        public LANSettings(String ipAddr, String subnetMask, String tcpPort, String defGateway, boolean dhcp, String macAddr) {
            this.IPAddr = ipAddr;
            this.SubnetMask = subnetMask;
            this.TCPPort = tcpPort;
            this.DefGateway = defGateway;
            this.DHCP = dhcp;
            this.MACAddr = macAddr;
        }

        public String getIPAddr() {
            return this.IPAddr;
        }

        public void setIPAddr(String IPAddr) {
            this.IPAddr = IPAddr;
        }

        public String getSubnetMask() {
            return this.SubnetMask;
        }

        public void setSubnetMask(String subnetMask) {
            this.SubnetMask = subnetMask;
        }

        public String getTCPPort() {
            return this.TCPPort;
        }

        public void setTCPPort(String TCPPort) {
            this.TCPPort = TCPPort;
        }

        public String getDefGateway() {
            return this.DefGateway;
        }

        public void setDefGateway(String defGateway) {
            this.DefGateway = defGateway;
        }

        public String getMACAddr() {
            return this.MACAddr;
        }

        public void setMACAddr(String MACAddr) {
            this.MACAddr = MACAddr;
        }
    }

    public static enum Baudrate {
        bps1200,
        bps2400,
        bps4800,
        bps9600,
        bps19200,
        bps38400,
        bps57600,
        bps115200;

    }

    public static class HeaderFooter
    extends cmdConfig {
        public String getHeaderLines(Integer lineIndex) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                R = cmdConfig.getConnectedECRV1().command43Variant2Version1(String.valueOf(lineIndex));
            }
            if (this.isConnectedPrinter()) {
                R = cmdConfig.getConnectedPrinterV1().command43Variant2Version1(String.valueOf(lineIndex));
            }
            this.checkErrorCode();
            return R.get("LineText");
        }

        public void setHeaderLines(Integer lineIndex, String headerLineText) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                R = cmdConfig.getConnectedECRV1().command43Variant0Version0(lineIndex.toString(), headerLineText);
            }
            if (this.isConnectedPrinter()) {
                R = cmdConfig.getConnectedPrinterV1().command43Variant0Version0(lineIndex.toString(), headerLineText);
            }
            this.checkErrorCode();
        }

        public void clearHeaderLines(Integer lineIndex) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                R = cmdConfig.getConnectedECRV1().command43Variant0Version0(String.valueOf(lineIndex), "");
            }
            if (this.isConnectedPrinter()) {
                R = cmdConfig.getConnectedPrinterV1().command43Variant0Version0(String.valueOf(lineIndex), "");
            }
            this.checkErrorCode();
        }

        public void setFooterLines(Integer lineIndex, String footerLineText) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                R = cmdConfig.getConnectedECRV1().command43Variant0Version0(String.valueOf(6 + lineIndex), footerLineText);
            }
            if (this.isConnectedPrinter()) {
                R = cmdConfig.getConnectedPrinterV1().command43Variant0Version0(String.valueOf(6 + lineIndex), footerLineText);
            }
            this.checkErrorCode();
        }

        public int getHeaderLinesCount() {
            if (this.isConnectedECR()) {
                return cmdConfig.getConnectedECRV1().getMaxHeaderLines();
            }
            if (this.isConnectedPrinter()) {
                return cmdConfig.getConnectedPrinterV1().getMaxHeaderLines();
            }
            return Integer.MAX_VALUE;
        }

        public int getFooterLinesCount() {
            if (this.isConnectedECR()) {
                return cmdConfig.getConnectedECRV1().getMaxFooterLines();
            }
            if (this.isConnectedPrinter()) {
                return cmdConfig.getConnectedPrinterV1().getMaxFooterLines();
            }
            return Integer.MIN_VALUE;
        }

        public String getFooterLines(int lineIndex) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedECR()) {
                R = cmdConfig.getConnectedECRV1().command43Variant2Version0(String.valueOf(6 + lineIndex));
            }
            if (this.isConnectedPrinter()) {
                R = cmdConfig.getConnectedPrinterV1().command43Variant2Version0(String.valueOf(6 + lineIndex));
            }
            this.checkErrorCode();
            return R.get("ItemValue");
        }
    }

    public static class DateTime
    extends cmdConfig {
        public String getDateTime() throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            if (this.isConnectedPrinter()) {
                R = DateTime.getConnectedPrinterV1().command62Variant0Version0();
            }
            if (this.isConnectedECR()) {
                R = cmdConfig.getConnectedECRV1().command62Variant0Version0();
            }
            this.checkErrorCode();
            return R.get("Date") + " " + R.get("Time");
        }

        public String getDate() throws Exception {
            String[] date = this.getDateTime().split(" ");
            return date[0];
        }

        public String getTime() throws Exception {
            String[] time = this.getDateTime().split(" ");
            return time[1];
        }

        public void setDateTime(String date, String time) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            SimpleDateFormat format = new SimpleDateFormat("dd-MM-yy HH:mm:ss");
            Date newDate = format.parse(date + " " + time);
            if (this.isConnectedPrinter()) {
                R = DateTime.getConnectedPrinterV1().command61Variant0Version0(date, time);
            }
            if (this.isConnectedECR()) {
                R = DateTime.getConnectedECRV1().command61Variant0Version0(date, time);
            }
            this.checkErrorCode();
        }

        public void setDateTime(String dateTime) throws Exception {
            FiscalResponse R = new FiscalResponse(0);
            SimpleDateFormat format = new SimpleDateFormat("dd-MM-yy HH:mm:ss");
            Date newDate = format.parse(dateTime);
            if (this.isConnectedPrinter()) {
                R = DateTime.getConnectedPrinterV1().command61Variant1Version0(dateTime);
            }
            if (this.isConnectedECR()) {
                R = DateTime.getConnectedECRV1().command61Variant1Version0(dateTime);
            }
            this.checkErrorCode();
        }
    }
}

