/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK;

import com.datecs.fiscalprinter.SDK.AbstractTransportProtocol;
import com.datecs.fiscalprinter.SDK.FiscalSocket;
import com.datecs.fiscalprinter.SDK.StopWatch;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TransportProtocolV2
extends AbstractTransportProtocol {
    public static final int MAX_PACKET_SIZE = 512;
    public static final int MAX_DATA_SIZE = 488;
    private byte[] mSB = new byte[8];

    public TransportProtocolV2(InputStream in, OutputStream out, int encoding) {
        super(in, out, encoding);
        this.mPackageSequence = 32;
    }

    public TransportProtocolV2(FiscalSocket socket, int encoding) {
        super(socket, encoding);
        this.mPackageSequence = 32;
    }

    public TransportProtocolV2(FiscalSocket socket) {
        super(socket);
        this.mPackageSequence = 32;
    }

    @Override
    public String customCommand(int command, String data) throws IOException {
        ++this.mPackageSequence;
        if (this.mPackageSequence > 127) {
            this.mPackageSequence = 32;
        }
        this.mSocket.clear();
        LOGGER.severe(String.format("> (%d) %s", command, data));
        StopWatch go = new StopWatch();
        this.writePacket(command, data);
        String result = this.readPacket();
        LOGGER.severe(String.format("< (%d) returned in %dms: \"%s\"", command, (int)go.getElapsedTime(), result));
        return result;
    }

    @Override
    protected void writePacket(int command, String data) throws IOException {
        for (int retry = 0; retry < 2; ++retry) {
            int len;
            byte[] buf = new byte[488];
            int offs = 0;
            int crc = 0;
            int n = len = data != null ? data.length() : 0;
            if (len > 488) {
                throw new IllegalArgumentException("Lenght of the packet exceeds the limits!");
            }
            buf[offs++] = 1;
            int alllen = len;
            alllen += 32;
            buf[offs++] = (byte)(((alllen += 10) >> 12 & 0xF) + 48);
            buf[offs++] = (byte)((alllen >> 8 & 0xF) + 48);
            buf[offs++] = (byte)((alllen >> 4 & 0xF) + 48);
            buf[offs++] = (byte)((alllen >> 0 & 0xF) + 48);
            buf[offs++] = (byte)this.mPackageSequence;
            buf[offs++] = (byte)((command >> 12 & 0xF) + 48);
            buf[offs++] = (byte)((command >> 8 & 0xF) + 48);
            buf[offs++] = (byte)((command >> 4 & 0xF) + 48);
            buf[offs++] = (byte)((command >> 0 & 0xF) + 48);
            TransportProtocolV2.toAnsi(data, buf, offs, this.mEncoding);
            offs += len;
            buf[offs++] = 5;
            for (int i = 1; i < offs; ++i) {
                crc += buf[i] & 0xFF;
            }
            buf[offs++] = (byte)((crc >> 12 & 0xF) + 48);
            buf[offs++] = (byte)((crc >> 8 & 0xF) + 48);
            buf[offs++] = (byte)((crc >> 4 & 0xF) + 48);
            buf[offs++] = (byte)((crc >> 0 & 0xF) + 48);
            buf[offs++] = 3;
            this.mSocket.write(buf, 0, offs);
            this.mSocket.flush();
            do {
                this.mSocket.read(buf, 0, 1, 6000);
            } while ((buf[0] & 0xFF) == 22);
            if (buf[0] == 21 || buf[0] != 1) continue;
            return;
        }
        throw new IOException("Invalid data received!");
    }

    @Override
    protected String readPacket() throws IOException {
        int b;
        int l;
        byte[] buf = new byte[488];
        int len = 0;
        int crc = 0;
        for (l = 0; l < 4; ++l) {
            b = this.mSocket.read(6000);
            crc += b;
            len = (len << 4) + b - 48;
        }
        len -= 51;
        b = this.mSocket.read(6000);
        crc += b;
        for (l = 0; l < 4; ++l) {
            b = this.mSocket.read(6000);
            crc += b;
        }
        this.mSocket.read(buf, 0, len, 6000);
        for (int i = 0; i < len; ++i) {
            crc += buf[i] & 0xFF;
        }
        b = this.mSocket.read(6000);
        if (b != 4) {
            throw new IOException("Invalid data received!");
        }
        crc += b;
        this.mSocket.read(this.mSB, 0, this.mSB.length, 6000);
        for (byte by : this.mSB) {
            crc += by & 0xFF;
        }
        b = this.mSocket.read(6000);
        if (b != 5) {
            throw new IOException("Invalid data received!");
        }
        crc += b;
        b = this.mSocket.read(6000);
        crc -= b - 48 << 12;
        b = this.mSocket.read(6000);
        crc -= b - 48 << 8;
        b = this.mSocket.read(6000);
        crc -= b - 48 << 4;
        b = this.mSocket.read(6000);
        if ((crc -= b - 48) != 0) {
            throw new IOException("Invalid CRC!");
        }
        b = this.mSocket.read(6000);
        if (b != 3) {
            throw new IOException("Invalid data received!");
        }
        return TransportProtocolV2.toUnicode(buf, 0, len, this.mEncoding);
    }

    @Override
    public boolean isStatusBitTriggered(int byteIndex, int bitIndex) {
        return (this.mSB[byteIndex] & 1 << bitIndex) > 0;
    }

    @Override
    public byte[] getStatusBytes() {
        return this.mSB;
    }
}

