/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DecimalFormatter {
    private static Map<String, Locale> localeMap;

    public static String formatCurrency(BigDecimal currencyValue, Locale locale) {
        return DecimalFormatter.formatCurrency(currencyValue, locale, false, true);
    }

    private static synchronized Map<String, Locale> getLocaleMap() {
        if (localeMap == null) {
            localeMap = new HashMap<String, Locale>();
            Locale[] locales = NumberFormat.getAvailableLocales();
            for (int i = 0; i < locales.length; ++i) {
                localeMap.put(locales[i].getCountry(), locales[i]);
            }
        }
        return localeMap;
    }

    public static String formatCurrency(BigDecimal currencyValue, Locale locale, boolean includeCurrencySymbol) {
        return DecimalFormatter.formatCurrency(currencyValue, locale, includeCurrencySymbol, true);
    }

    public static String formatCurrency(BigDecimal currencyValue, String countryCode, boolean includeCurrencySymbol) {
        Locale locale = DecimalFormatter.getLocaleMap().get(countryCode);
        return DecimalFormatter.formatCurrency(currencyValue, locale, includeCurrencySymbol, true);
    }

    public static String formatCurrency(BigDecimal currencyValue, Locale locale, boolean includeCurrencySymbol, boolean includeGroupingSeparator) {
        DecimalFormat currencyFormatter = (DecimalFormat)NumberFormat.getCurrencyInstance(locale);
        currencyFormatter.setGroupingUsed(includeGroupingSeparator);
        if (!includeCurrencySymbol) {
            DecimalFormatSymbols symbols = currencyFormatter.getDecimalFormatSymbols();
            symbols.setCurrencySymbol("");
            currencyFormatter.setDecimalFormatSymbols(symbols);
        }
        String formattedValue = currencyFormatter.format(currencyValue.doubleValue()).trim();
        if (currencyValue.signum() == -1 && !includeCurrencySymbol && locale.getISO3Country().equals("ITA")) {
            formattedValue = formattedValue.replace(" ", "");
        }
        if (currencyValue.signum() == -1 && locale.getISO3Country().equals("USA")) {
            formattedValue = "-" + currencyValue.abs();
        }
        return formattedValue;
    }

    public static String formatDecimal(BigDecimal decimalValue, Locale locale) {
        NumberFormat decimalFormatter = NumberFormat.getNumberInstance(locale);
        String formattedValue = decimalFormatter.format(decimalValue.doubleValue());
        return formattedValue;
    }

    public static String formatCurrencyAsTicketReprint(BigDecimal currencyValue, Locale locale) {
        int decimalLocation;
        double mantissa;
        String formattedValue = null;
        formattedValue = locale.getISO3Country().equals("USA") || locale.getISO3Country().equals("CAN") ? DecimalFormatter.formatCurrency(currencyValue, locale, true) : Currency.getInstance(locale).getSymbol(Locale.US) + " " + DecimalFormatter.formatCurrency(currencyValue, locale, false);
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getCurrencyInstance(locale);
        DecimalFormatSymbols symbols = decimalFormat.getDecimalFormatSymbols();
        if (currencyValue.toString().indexOf(symbols.getMonetaryDecimalSeparator()) != -1 && (mantissa = Double.parseDouble(currencyValue.toString().substring(currencyValue.toString().indexOf(symbols.getMonetaryDecimalSeparator())))) == 0.0 && (decimalLocation = formattedValue.lastIndexOf(symbols.getMonetaryDecimalSeparator())) != -1) {
            formattedValue = formattedValue.substring(0, decimalLocation);
        }
        if (locale.getISO3Country().equals("CAN")) {
            formattedValue = formattedValue + " " + locale.getISO3Country();
        }
        return formattedValue;
    }
}

