/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK.model.UserLayerV2;

import com.datecs.fiscalprinter.SDK.FiscalException;
import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import java.io.IOException;
import java.io.Serializable;

public class cmdClients
extends DatecsFiscalDevice {
    public boolean DelAllItems() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdClients.getConnectedModelV2().command140Variant2Version0("A", "");
        }
        cmdClients.checkErrorCode(R);
        return true;
    }

    public void SetItem(ClientInfoModel item) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdClients.getConnectedModelV2().command140Variant1Version0(String.valueOf(item.getFIRM()), item.getName(), String.valueOf(item.getTypeTAXN().ordinal()), item.getEIK(), item.getRecName(), item.getVATN(), item.getAddr1(), item.getAddr2());
            cmdClients.checkErrorCode(R);
        }
        item.setState(ClientInfoModel.ItemState.ITEM_SAVED);
    }

    public boolean DelClientsInRange(int from, int to) throws Exception {
        boolean res = false;
        if (from > to) {
            to = 0;
        }
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdClients.getConnectedModelV2().command140Variant2Version0(String.valueOf(from), from < 1 ? String.valueOf(to) : "");
            res = true;
            cmdClients.checkErrorCode(R);
        }
        return res;
    }

    public ClientInfoModel ReadItemByID(int firmID) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdClients.getConnectedModelV2().command140Variant3Version0(String.valueOf(firmID));
            cmdClients.checkErrorCode(R);
            return new ClientInfoModel(R.getInt("FIRM"), R.get("Name"), R.get("TAXN"), ClientInfoModel.TypeTAXN.fromOrdinal(R.getInt("TypeTAXN")), R.get("RecName"), R.get("VATN"), R.get("Addr1"), R.get("Addr2"), ClientInfoModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public ClientInfoModel GetFirstFoundProgrammed(int startItem) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdClients.getConnectedModelV2().command140Variant4Version0("F", String.valueOf(startItem < 1 ? "" : Integer.valueOf(startItem)));
            cmdClients.checkErrorCode(R);
            return new ClientInfoModel(R.getInt("FIRM"), R.get("Name"), R.get("TAXN"), ClientInfoModel.TypeTAXN.fromOrdinal(R.getInt("TypeTAXN")), R.get("RecName"), R.get("VATN"), R.get("Addr1"), R.get("Addr2"), ClientInfoModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public ClientInfoModel GetLastFoundProgrammed(int startItem) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdClients.getConnectedModelV2().command140Variant4Version0("L", "");
            cmdClients.checkErrorCode(R);
            return new ClientInfoModel(R.getInt("FIRM"), R.get("Name"), R.get("TAXN"), ClientInfoModel.TypeTAXN.fromOrdinal(R.getInt("TypeTAXN")), R.get("RecName"), R.get("VATN"), R.get("Addr1"), R.get("Addr2"), ClientInfoModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public ClientInfoModel GetNextProgrammed() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdClients.getConnectedModelV2().command140Variant4Version0("N", "");
            cmdClients.checkErrorCode(R);
            return new ClientInfoModel(R.getInt("FIRM"), R.get("Name"), R.get("TAXN"), ClientInfoModel.TypeTAXN.fromOrdinal(R.getInt("TypeTAXN")), R.get("RecName"), R.get("VATN"), R.get("Addr1"), R.get("Addr2"), ClientInfoModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public int GetFirstNotProgrammed(int startItem) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdClients.getConnectedModelV2().command140Variant5Version0("X", String.valueOf(startItem < 1 ? "" : Integer.valueOf(startItem)));
            cmdClients.checkErrorCode(R);
            return R.getInt("FIRM");
        }
        return 0;
    }

    public int GetLastNotProgrammed(int startItem) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdClients.getConnectedModelV2().command140Variant5Version0("x", String.valueOf(startItem < 1 ? "" : Integer.valueOf(startItem)));
            cmdClients.checkErrorCode(R);
            return R.getInt("FIRM");
        }
        return 0;
    }

    public ClientsInfo GetItemsInformation() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdClients.getConnectedModelV2().command140Variant0Version0();
            return new ClientsInfo(R.getInt("Total"), R.getInt("Prog"), R.getInt("NameLen"));
        }
        return null;
    }

    public ClientInfoModel findClientByEIK(String EIK) throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdClients.getConnectedModelV2().command140Variant4Version0("T", EIK);
            cmdClients.checkErrorCode(R);
            return new ClientInfoModel(R.getInt("FIRM"), R.get("Name"), R.get("TAXN"), ClientInfoModel.TypeTAXN.fromOrdinal(R.getInt("TypeTAXN")), R.get("RecName"), R.get("VATN"), R.get("Addr1"), R.get("Addr2"), ClientInfoModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public static class ClientInfoModel
    implements Serializable {
        private ItemState state;
        private int FIRM;
        private String Name;
        private String EIK;
        private TypeTAXN typeN;
        private String RecName;
        private String VATN;
        private String Addr1;
        private String Addr2;

        public ItemState getState() {
            return this.state;
        }

        public void setState(ItemState state) {
            this.state = state;
        }

        public ClientInfoModel(int FIRM, String name, String EIK, TypeTAXN typeTAXN, String recName, String VATN, String addr1, String addr2, ItemState itemState) {
            this.FIRM = FIRM;
            this.Name = name;
            this.EIK = EIK;
            this.typeN = typeTAXN;
            this.RecName = recName;
            this.VATN = VATN;
            this.Addr1 = addr1;
            this.Addr2 = addr2;
            this.state = itemState;
        }

        public int getFIRM() {
            return this.FIRM;
        }

        public void setFIRM(int FIRM) {
            this.FIRM = FIRM;
        }

        public String getName() {
            return this.Name;
        }

        public void setName(String name) {
            this.Name = name;
        }

        public String getEIK() {
            return this.EIK;
        }

        public void setTAXN(String TAXN) {
            this.EIK = TAXN;
        }

        public TypeTAXN getTypeTAXN() {
            return this.typeN;
        }

        public void setTypeTAXN(TypeTAXN typeTAXN) {
            this.typeN = typeTAXN;
        }

        public String getRecName() {
            return this.RecName;
        }

        public void setRecName(String recName) {
            this.RecName = recName;
        }

        public String getVATN() {
            return this.VATN;
        }

        public void setVATN(String VATN) {
            this.VATN = VATN;
        }

        public String getAddr1() {
            return this.Addr1;
        }

        public void setAddr1(String addr1) {
            this.Addr1 = addr1;
        }

        public String getAddr2() {
            return this.Addr2;
        }

        public void setAddr2(String addr2) {
            this.Addr2 = addr2;
        }

        public static enum TypeTAXN {
            BULSTAT,
            EGN,
            LNCH,
            SERVICE;

            public static TypeTAXN[] allValues;

            public static TypeTAXN fromOrdinal(int n) {
                return allValues[n];
            }

            static {
                allValues = TypeTAXN.values();
            }
        }

        public static enum ItemState {
            ITEM_IS_READ,
            ITEM_SAVED,
            ITEM_NOT_SAVED;

        }
    }

    public static class ClientsInfo {
        private int TotalCountOfProgrammableClients;
        private int TotalCountOfProgrammedClients;
        private int MaximumLengthOfClientName;

        public ClientsInfo(int totalCountOfProgrammableClients, int totalCountOfProgrammedClients, int maximumLengthOfClientName) {
            this.TotalCountOfProgrammableClients = totalCountOfProgrammableClients;
            this.TotalCountOfProgrammedClients = totalCountOfProgrammedClients;
            this.MaximumLengthOfClientName = maximumLengthOfClientName;
        }

        public int getTotalCountOfProgrammableClients() {
            return this.TotalCountOfProgrammableClients;
        }

        public void setTotalCountOfProgrammableClients(int totalCountOfProgrammableClients) {
            this.TotalCountOfProgrammableClients = totalCountOfProgrammableClients;
        }

        public int getTotalCountOfProgrammedClients() {
            return this.TotalCountOfProgrammedClients;
        }

        public void setTotalCountOfProgrammedClients(int totalCountOfProgrammedClients) {
            this.TotalCountOfProgrammedClients = totalCountOfProgrammedClients;
        }

        public int getMaximumLengthOfClientName() {
            return this.MaximumLengthOfClientName;
        }

        public void setMaximumLengthOfClientName(int maximumLengthOfClientName) {
            this.MaximumLengthOfClientName = maximumLengthOfClientName;
        }
    }
}

