/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK.model.UserLayerV1;

import com.datecs.fiscalprinter.SDK.FiscalException;
import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import java.io.IOException;
import java.io.Serializable;

public class cmdItems
extends DatecsFiscalDevice {
    public void SaveItem(ItemModel itemModel) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedPrinter()) {
            R = cmdItems.getConnectedPrinterV1().command107Variant1Version0(itemModel.taxGr, String.valueOf(itemModel.plu), itemModel.group, itemModel.sPrice, itemModel.replaceQty ? "A" : "", itemModel.quantity, itemModel.name);
        }
        if (this.isConnectedECR()) {
            R = cmdItems.getConnectedECRV1().command107Variant1Version0(itemModel.taxGr, String.valueOf(itemModel.plu), itemModel.group, itemModel.sPrice, itemModel.replaceQty ? "A" : "", itemModel.quantity, itemModel.name);
        }
        this.checkErrorCode();
    }

    public void SaveItem(String plu, String taxGr, String group, String sPrice, String quantity, boolean replaceQty, String name) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedPrinter()) {
            R = cmdItems.getConnectedPrinterV1().command107Variant1Version0(taxGr, plu, group, sPrice, replaceQty ? "A" : "", quantity, name);
        }
        if (this.isConnectedECR()) {
            R = cmdItems.getConnectedECRV1().command107Variant1Version0(taxGr, plu, group, sPrice, replaceQty ? "A" : "", quantity, name);
        }
        this.checkErrorCode();
    }

    public void SetItemQuantity(int itemID, Double quantity) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdItems.getConnectedECRV1().command107Variant2Version0(String.valueOf(itemID), String.valueOf(quantity));
        }
        if (this.isConnectedPrinter()) {
            R = cmdItems.getConnectedPrinterV1().command107Variant2Version0(String.valueOf(itemID), String.valueOf(quantity));
        }
        this.checkErrorCode();
    }

    public void SetItemPrice(int itemID, Double newPrice) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdItems.getConnectedECRV1().command107Variant12Version0(String.valueOf(itemID), String.valueOf(newPrice));
        }
        if (this.isConnectedPrinter()) {
            R = cmdItems.getConnectedPrinterV1().command107Variant12Version0(String.valueOf(itemID), String.valueOf(newPrice));
        }
        this.checkErrorCode();
    }

    public boolean DelItemsInRange(int fromItem, int toItem) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        String sFromItem = String.valueOf(fromItem);
        String sToItem = String.valueOf(toItem);
        if (fromItem >= toItem) {
            sToItem = "";
        }
        if (this.isConnectedECR()) {
            R = cmdItems.getConnectedECRV1().command107Variant3Version0("", sFromItem, sToItem);
        }
        if (this.isConnectedPrinter()) {
            R = cmdItems.getConnectedPrinterV1().command107Variant3Version0("", sFromItem, sToItem);
        }
        return true;
    }

    public boolean DelAllItems() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdItems.getConnectedECRV1().command107Variant3Version0("A", "", "");
        }
        if (this.isConnectedPrinter()) {
            R = cmdItems.getConnectedPrinterV1().command107Variant3Version0("A", "", "");
        }
        this.checkErrorCode();
        return true;
    }

    public ItemModel ReadItem(int itemID) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdItems.getConnectedECRV1().command107Variant4Version0(itemID > 0 ? String.valueOf(itemID) : "1");
        }
        if (this.isConnectedPrinter()) {
            R = cmdItems.getConnectedPrinterV1().command107Variant4Version0(itemID > 0 ? String.valueOf(itemID) : "1");
        }
        this.checkErrorCode();
        if (R.get("Result").equals("P")) {
            return new ItemModel(R.getInt("PLU"), R.get("TaxGr"), R.get("Grp"), R.get("SPrice"), R.get("Avail"), false, R.get("Name"), R.get("Total"), R.get("Sold"), ItemModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public ItemModel GetFirstFoundProgrammed(int startItem) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdItems.getConnectedECRV1().command107Variant5Version0(startItem < 1 ? "" : String.valueOf(startItem));
        }
        if (this.isConnectedPrinter()) {
            R = cmdItems.getConnectedPrinterV1().command107Variant5Version0(startItem < 1 ? "" : String.valueOf(startItem));
        }
        this.checkErrorCode();
        if (R.get("Result").equals("P")) {
            return new ItemModel(R.getInt("PLU"), R.get("TaxGr"), R.get("Grp"), R.get("SPrice"), R.get("Avail"), false, R.get("Name"), R.get("Total"), R.get("Sold"), ItemModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public ItemModel GetLastFoundProgrammed(int lastPLU) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdItems.getConnectedECRV1().command107Variant6Version0(lastPLU < 1 ? "" : String.valueOf(lastPLU));
        }
        if (this.isConnectedPrinter()) {
            R = cmdItems.getConnectedPrinterV1().command107Variant6Version0(lastPLU < 1 ? "" : String.valueOf(lastPLU));
        }
        this.checkErrorCode();
        if (R.get("Result").equals("P")) {
            return new ItemModel(R.getInt("PLU"), R.get("TaxGr"), R.get("Grp"), R.get("SPrice"), R.get("Avail"), false, R.get("Name"), R.get("Total"), R.get("Sold"), ItemModel.ItemState.ITEM_IS_READ);
        }
        return new ItemModel(0, "", "", "", "", false, "", "", "", ItemModel.ItemState.ITEM_NOT_SAVED);
    }

    public ItemModel GetNextProgrammed() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdItems.getConnectedECRV1().command107Variant7Version0();
        }
        if (this.isConnectedPrinter()) {
            R = cmdItems.getConnectedPrinterV1().command107Variant7Version0();
        }
        this.checkErrorCode();
        if (R.get("Result").equals("P")) {
            return new ItemModel(R.getInt("PLU"), R.get("TaxGr"), R.get("Grp"), R.get("SPrice"), R.get("Avail"), false, R.get("Name"), R.get("Total"), R.get("Sold"), ItemModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public ItemModel GetFirstFoundWithSales(int startItem) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdItems.getConnectedECRV1().command107Variant8Version0(startItem > 0 ? String.valueOf(startItem) : "");
        }
        if (this.isConnectedPrinter()) {
            R = cmdItems.getConnectedPrinterV1().command107Variant8Version0(startItem > 0 ? String.valueOf(startItem) : "");
        }
        this.checkErrorCode();
        if (R.get("Result").equals("P")) {
            return new ItemModel(R.getInt("PLU"), R.get("TaxGr"), R.get("Grp"), R.get("SPrice"), R.get("Avail"), false, R.get("Name"), R.get("Total"), R.get("Sold"), ItemModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public ItemModel GetLastFoundWithSales(int startItem) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdItems.getConnectedECRV1().command107Variant9Version0(startItem > 0 ? String.valueOf(startItem) : "");
        }
        if (this.isConnectedPrinter()) {
            R = cmdItems.getConnectedPrinterV1().command107Variant9Version0(startItem > 0 ? String.valueOf(startItem) : "");
        }
        this.checkErrorCode();
        if (R.get("Result").equals("P")) {
            return new ItemModel(R.getInt("PLU"), R.get("TaxGr"), R.get("Grp"), R.get("SPrice"), R.get("Avail"), false, R.get("Name"), R.get("Total"), R.get("Sold"), ItemModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public ItemModel GetNextFoundWithSales() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdItems.getConnectedECRV1().command107Variant10Version0();
        }
        if (this.isConnectedPrinter()) {
            R = cmdItems.getConnectedPrinterV1().command107Variant10Version0();
        }
        this.checkErrorCode();
        if (R.get("Result").equals("P")) {
            return new ItemModel(R.getInt("PLU"), R.get("TaxGr"), R.get("Grp"), R.get("SPrice"), R.get("Avail"), false, R.get("Name"), R.get("Total"), R.get("Sold"), ItemModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public int GetFirstNotProgrammed(int startItem) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdItems.getConnectedECRV1().command107Variant11Version0("X", startItem > 0 ? String.valueOf(startItem) : "");
        }
        if (this.isConnectedPrinter()) {
            R = cmdItems.getConnectedPrinterV1().command107Variant11Version0("X", startItem > 0 ? String.valueOf(startItem) : "");
        }
        this.checkErrorCode();
        return R.getInt("PLU");
    }

    public int GetLastNotProgrammed(int startItem) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedECR()) {
            R = cmdItems.getConnectedECRV1().command107Variant11Version0("x", startItem > 0 ? String.valueOf(startItem) : "");
        }
        if (this.isConnectedPrinter()) {
            R = cmdItems.getConnectedPrinterV1().command107Variant11Version0("x", startItem > 0 ? String.valueOf(startItem) : "");
        }
        this.checkErrorCode();
        return R.getInt("PLU");
    }

    public ItemsInfo GetItemsInformation() throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        ItemsInfo res = new ItemsInfo();
        if (this.isConnectedPrinter()) {
            R = cmdItems.getConnectedPrinterV1().command107Variant0Version0();
            cmdItems.checkErrorCode(R);
            res.setMaximumLengthOfItemName(R.getInt("Len", 0));
            res.setTotalCountOfProgrammableItems(R.getInt("Total", 0));
            res.setTotalCountOfProgrammedItems(R.getInt("Progr", 0));
        } else if (this.isConnectedECR()) {
            R = cmdItems.getConnectedECRV1().command107Variant0Version0();
            cmdItems.checkErrorCode(R);
            res.setMaximumLengthOfItemName(R.getInt("Len", 0));
            res.setTotalCountOfProgrammableItems(R.getInt("Total", 0));
            res.setTotalCountOfProgrammedItems(R.getInt("Progr", 0));
        }
        return res;
    }

    public static class ItemModel
    implements Serializable {
        private int plu;
        private String taxGr;
        private String group;
        private String sPrice;
        private String quantity;
        private String name;
        private String total;
        private String sold;
        boolean replaceQty;
        private ItemState state;

        public ItemState getState() {
            return this.state;
        }

        public void setState(ItemState state) {
            this.state = state;
        }

        public void setReplaceQty(boolean replaceQty) {
            this.replaceQty = replaceQty;
        }

        public boolean isReplaceQty() {
            return this.replaceQty;
        }

        public ItemModel(int plu, String taxGr, String group, String sPrice, String quantity, boolean replaceQty, String name, String total, String sold, ItemState state) {
            this.plu = plu;
            this.taxGr = taxGr;
            this.group = group;
            this.sPrice = sPrice;
            this.quantity = quantity;
            this.replaceQty = replaceQty;
            this.name = name;
            this.total = total;
            this.sold = sold;
            this.state = state;
        }

        public int getPlu() {
            return this.plu;
        }

        public void setPlu(int plu) {
            this.plu = plu;
        }

        public String getTaxGr() {
            return this.taxGr;
        }

        public void setTaxGr(String taxGr) {
            this.taxGr = taxGr;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getsPrice() {
            return this.sPrice;
        }

        public void setsPrice(String sPrice) {
            this.sPrice = sPrice;
        }

        public String getQuantity() {
            return this.quantity;
        }

        public void setQuantity(String quantity) {
            this.quantity = quantity;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTotal() {
            return this.total;
        }

        public String getSold() {
            return this.sold;
        }

        public static enum ItemState {
            ITEM_IS_READ,
            ITEM_SAVED,
            ITEM_NOT_SAVED;

        }
    }

    public static class ItemsInfo {
        private int TotalCountOfProgrammableItems;
        private int TotalCountOfProgrammedItems;
        private int MaximumLengthOfItemName;

        public ItemsInfo(int totalCountOfProgrammableItems, int totalCountOfProgrammedItems, int maximumLengthOfItemName) {
            this.TotalCountOfProgrammableItems = totalCountOfProgrammableItems;
            this.TotalCountOfProgrammedItems = totalCountOfProgrammedItems;
            this.MaximumLengthOfItemName = maximumLengthOfItemName;
        }

        public ItemsInfo() {
        }

        public int getTotalCountOfProgrammableItems() {
            return this.TotalCountOfProgrammableItems;
        }

        public void setTotalCountOfProgrammableItems(int totalCountOfProgrammableItems) {
            this.TotalCountOfProgrammableItems = totalCountOfProgrammableItems;
        }

        public int getTotalCountOfProgrammedItems() {
            return this.TotalCountOfProgrammedItems;
        }

        public void setTotalCountOfProgrammedItems(int totalCountOfProgrammedItems) {
            this.TotalCountOfProgrammedItems = totalCountOfProgrammedItems;
        }

        public int getMaximumLengthOfItemName() {
            return this.MaximumLengthOfItemName;
        }

        public void setMaximumLengthOfItemName(int maximumLengthOfItemName) {
            this.MaximumLengthOfItemName = maximumLengthOfItemName;
        }
    }
}

