/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK.model.UserLayerV2;

import com.datecs.fiscalprinter.SDK.FiscalException;
import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import java.io.IOException;
import java.io.Serializable;

public class cmdItems
extends DatecsFiscalDevice {
    public boolean DelAllItems() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdItems.getConnectedModelV2().command107Variant3Version1();
        }
        cmdItems.checkErrorCode(R);
        return true;
    }

    public void SetItem(String PLU, String taxGr, String dep, String group, String priceType, String price, String addQty, String quantity, String bar1, String bar2, String bar3, String bar4, String name) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        R = cmdItems.getConnectedModelV2().command107Variant1Version0(PLU, taxGr, dep, group, priceType, price, addQty, quantity, bar1, bar2, bar3, bar4, name);
        cmdItems.checkErrorCode(R);
    }

    public void SetItem(ItemModel item) throws Exception {
        if (item.unit.length() == 0) {
            this.SetItem(item.PLU, item.taxGr, item.dep, item.group, item.priceType, item.price, item.addQty, item.quantity, item.bar1, item.bar2, item.bar3, item.bar4, item.name);
        } else {
            this.SetItem(item.PLU, item.taxGr, item.dep, item.group, item.priceType, item.price, item.addQty, item.quantity, item.bar1, item.bar2, item.bar3, item.bar4, item.name, item.unit);
        }
        item.setState(ItemModel.ItemState.ITEM_SAVED);
    }

    private void SetItem(String plu, String taxGr, String dep, String group, String priceType, String price, String addQty, String quantity, String bar1, String bar2, String bar3, String bar4, String name, String unit) throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        R = cmdItems.getConnectedModelV2().command107Variant1Version1(plu, taxGr, dep, group, priceType, price, addQty, quantity, bar1, bar2, bar3, bar4, name, unit);
        cmdItems.checkErrorCode(R);
    }

    public void SetItemQuantity(int itemID, Double quantity) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdItems.getConnectedModelV2().command107Variant2Version0(String.valueOf(itemID), String.valueOf(quantity));
        }
        cmdItems.checkErrorCode(R);
    }

    public boolean DelItemsInRange(int fromItem, int toItem) throws Exception {
        boolean res = false;
        if (fromItem > toItem) {
            toItem = 0;
        }
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdItems.getConnectedModelV2().command107Variant3Version0(String.valueOf(fromItem), fromItem < 1 ? String.valueOf(toItem) : "");
            res = true;
            cmdItems.checkErrorCode(R);
        }
        return res;
    }

    public ItemModel ReadItem(int itemID) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdItems.getConnectedModelV2().command107Variant5Version0("R", String.valueOf(itemID));
            cmdItems.checkErrorCode(R);
            return new ItemModel(R.get("PLU"), R.get("taxGr"), R.get("department"), R.get("stockGroup"), R.get("priceType"), R.get("price"), "", R.get("stockQty"), R.get("bar1"), R.get("bar2"), R.get("bar3"), R.get("bar4"), R.get("itemName"), R.get("turnover"), R.get("soldQty"), R.get("unitIndex"), ItemModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public ItemModel GetFirstFoundProgrammed(int startItem) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdItems.getConnectedModelV2().command107Variant5Version0("F", String.valueOf(startItem < 1 ? "" : Integer.valueOf(startItem)));
            cmdItems.checkErrorCode(R);
            return new ItemModel(R.get("PLU"), R.get("taxGr"), R.get("department"), R.get("stockGroup"), R.get("priceType"), R.get("price"), "", R.get("stockQty"), R.get("bar1"), R.get("bar2"), R.get("bar3"), R.get("bar4"), R.get("itemName"), R.get("turnover"), R.get("soldQty"), R.get("unitIndex"), ItemModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public ItemModel GetLastFoundProgrammed(int startItem) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdItems.getConnectedModelV2().command107Variant5Version0("L", String.valueOf(startItem < 1 ? "" : Integer.valueOf(startItem)));
            cmdItems.checkErrorCode(R);
            return new ItemModel(R.get("PLU"), R.get("taxGr"), R.get("department"), R.get("stockGroup"), R.get("priceType"), R.get("price"), "", R.get("stockQty"), R.get("bar1"), R.get("bar2"), R.get("bar3"), R.get("bar4"), R.get("itemName"), R.get("turnover"), R.get("soldQty"), R.get("unitIndex"), ItemModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public ItemModel GetNextProgrammed() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdItems.getConnectedModelV2().command107Variant6Version0("N");
            cmdItems.checkErrorCode(R);
            return new ItemModel(R.get("PLU"), R.get("taxGr"), R.get("department"), R.get("stockGroup"), R.get("priceType"), R.get("price"), "", R.get("stockQty"), R.get("bar1"), R.get("bar2"), R.get("bar3"), R.get("bar4"), R.get("itemName"), R.get("turnover"), R.get("soldQty"), R.get("unitIndex"), ItemModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public ItemModel GetFirstFoundWithSales(int startItem) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdItems.getConnectedModelV2().command107Variant5Version0("f", startItem < 1 ? "" : String.valueOf(startItem));
            cmdItems.checkErrorCode(R);
            return new ItemModel(R.get("PLU"), R.get("taxGr"), R.get("department"), R.get("stockGroup"), R.get("priceType"), R.get("price"), "", R.get("stockQty"), R.get("bar1"), R.get("bar2"), R.get("bar3"), R.get("bar4"), R.get("itemName"), R.get("turnover"), R.get("soldQty"), R.get("unitIndex"), ItemModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public ItemModel GetLastFoundWithSales(int startItem) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdItems.getConnectedModelV2().command107Variant5Version0("l", startItem < 1 ? "" : String.valueOf(startItem));
            cmdItems.checkErrorCode(R);
            return new ItemModel(R.get("PLU"), R.get("taxGr"), R.get("department"), R.get("stockGroup"), R.get("priceType"), R.get("price"), "", R.get("stockQty"), R.get("bar1"), R.get("bar2"), R.get("bar3"), R.get("bar4"), R.get("itemName"), R.get("turnover"), R.get("soldQty"), R.get("unitIndex"), ItemModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public ItemModel GetNextFoundWithSales() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdItems.getConnectedModelV2().command107Variant6Version0("n");
            cmdItems.checkErrorCode(R);
            return new ItemModel(R.get("PLU"), R.get("taxGr"), R.get("department"), R.get("stockGroup"), R.get("priceType"), R.get("price"), "", R.get("stockQty"), R.get("bar1"), R.get("bar2"), R.get("bar3"), R.get("bar4"), R.get("itemName"), R.get("turnover"), R.get("soldQty"), R.get("unitIndex"), ItemModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public int GetFirstNotProgrammed(int itemID) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdItems.getConnectedModelV2().command107Variant5Version0("X", itemID < 1 ? "" : String.valueOf(itemID));
            cmdItems.checkErrorCode(R);
            return R.getInt("PLU", 0);
        }
        return 0;
    }

    public int GetLastNotProgrammed(int itemID) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdItems.getConnectedModelV2().command107Variant5Version0("x", itemID < 1 ? "" : String.valueOf(itemID));
            cmdItems.checkErrorCode(R);
            return R.getInt("PLU", 0);
        }
        return 0;
    }

    public ItemsInfo GetItemsInformation() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        ItemsInfo res = new ItemsInfo();
        if (this.isConnectedDeviceV2()) {
            R = cmdItems.getConnectedModelV2().command107Variant0Version0();
            cmdItems.checkErrorCode(R);
            res.setMaximumLengthOfItemName(R.getInt("nameLen", 0));
            res.setTotalCountOfProgrammableItems(R.getInt("total", 0));
            res.setTotalCountOfProgrammedItems(R.getInt("prog", 0));
        }
        return res;
    }

    public static class ItemModel
    implements Serializable {
        private String PLU;
        private String taxGr;
        private String dep;
        private String group;
        private String priceType;
        private String price;
        private String addQty;
        private String quantity;
        private String bar1;
        private String bar2;
        private String bar3;
        private String bar4;
        private String name;
        private String turnover;
        private String soldQty;
        private String unit;
        private ItemState state;

        public void setPLU(String PLU) {
            this.PLU = PLU;
        }

        public void setTaxGr(String taxGr) {
            this.taxGr = taxGr;
        }

        public void setDep(String dep) {
            this.dep = dep;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public void setPriceType(String priceType) {
            this.priceType = priceType;
        }

        public void setPrice(String price) {
            this.price = price;
        }

        public void setAddQty(String addQty) {
            this.addQty = addQty;
        }

        public void setQuantity(String quantity) {
            this.quantity = quantity;
        }

        public void setBar1(String bar1) {
            this.bar1 = bar1;
        }

        public void setBar2(String bar2) {
            this.bar2 = bar2;
        }

        public void setBar3(String bar3) {
            this.bar3 = bar3;
        }

        public void setBar4(String bar4) {
            this.bar4 = bar4;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setTurnover(String turnover) {
            this.turnover = turnover;
        }

        public void setSoldQty(String soldQty) {
            this.soldQty = soldQty;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public ItemModel() {
        }

        public ItemModel(String PLU, String taxGr, String dep, String group, String priceType, String price, String addQty, String quantity, String bar1, String bar2, String bar3, String bar4, String name, String turnover, String soldQty, String unitName, ItemState state) {
            this.PLU = PLU;
            this.taxGr = taxGr;
            this.dep = dep;
            this.group = group;
            this.priceType = priceType;
            this.price = price;
            this.addQty = addQty;
            this.quantity = quantity;
            this.bar1 = bar1;
            this.bar2 = bar2;
            this.bar3 = bar3;
            this.bar4 = bar4;
            this.name = name;
            this.turnover = turnover;
            this.soldQty = soldQty;
            this.unit = unitName;
            this.state = state;
        }

        public ItemModel(String PLU, String taxGr, String dep, String group, String priceType, String price, String addQty, String quantity, String bar1, String bar2, String bar3, String bar4, String name, String turnover, String soldQty, ItemState state) {
            this.PLU = PLU;
            this.taxGr = taxGr;
            this.dep = dep;
            this.group = group;
            this.priceType = priceType;
            this.price = price;
            this.addQty = addQty;
            this.quantity = quantity;
            this.bar1 = bar1;
            this.bar2 = bar2;
            this.bar3 = bar3;
            this.bar4 = bar4;
            this.name = name;
            this.turnover = turnover;
            this.soldQty = soldQty;
            this.state = state;
        }

        public ItemModel(String PLU, String taxGr, String group, String price, String quantity, String turnover, String soldQty) {
            this.PLU = PLU;
            this.taxGr = taxGr;
            this.group = group;
            this.price = price;
            this.quantity = quantity;
            this.turnover = turnover;
            this.soldQty = soldQty;
        }

        public ItemState getState() {
            return this.state;
        }

        public void setState(ItemState state) {
            this.state = state;
        }

        public String getPLU() {
            return this.PLU;
        }

        public String getTaxGr() {
            return this.taxGr;
        }

        public String getDep() {
            return this.dep;
        }

        public String getGroup() {
            return this.group;
        }

        public String getPriceType() {
            return this.priceType;
        }

        public String getPrice() {
            return this.price;
        }

        public String getAddQty() {
            return this.addQty;
        }

        public String getQuantity() {
            return this.quantity;
        }

        public String getBar1() {
            return this.bar1;
        }

        public String getBar2() {
            return this.bar2;
        }

        public String getBar3() {
            return this.bar3;
        }

        public String getBar4() {
            return this.bar4;
        }

        public String getName() {
            return this.name;
        }

        public String getTurnover() {
            return this.turnover;
        }

        public String getSoldQty() {
            return this.soldQty;
        }

        public String getUnit() {
            return this.unit;
        }

        public static enum PriceType {
            FIXED_PRICE,
            FREE_PRICE,
            MAX_PRICE;

            private static PriceType[] allValues;

            public static PriceType fromOrdinal(int n) {
                return allValues[n];
            }

            static {
                allValues = PriceType.values();
            }
        }

        public static enum ItemState {
            ITEM_IS_READ,
            ITEM_SAVED,
            ITEM_NOT_SAVED;

        }
    }

    public static class ItemsInfo {
        private int TotalCountOfProgrammableItems;
        private int TotalCountOfProgrammedItems;
        private int MaximumLengthOfItemName;

        public ItemsInfo(int totalCountOfProgrammableItems, int totalCountOfProgrammedItems, int maximumLengthOfItemName) {
            this.TotalCountOfProgrammableItems = totalCountOfProgrammableItems;
            this.TotalCountOfProgrammedItems = totalCountOfProgrammedItems;
            this.MaximumLengthOfItemName = maximumLengthOfItemName;
        }

        public ItemsInfo() {
        }

        public int getTotalCountOfProgrammableItems() {
            return this.TotalCountOfProgrammableItems;
        }

        public void setTotalCountOfProgrammableItems(int totalCountOfProgrammableItems) {
            this.TotalCountOfProgrammableItems = totalCountOfProgrammableItems;
        }

        public int getTotalCountOfProgrammedItems() {
            return this.TotalCountOfProgrammedItems;
        }

        public void setTotalCountOfProgrammedItems(int totalCountOfProgrammedItems) {
            this.TotalCountOfProgrammedItems = totalCountOfProgrammedItems;
        }

        public int getMaximumLengthOfItemName() {
            return this.MaximumLengthOfItemName;
        }

        public void setMaximumLengthOfItemName(int maximumLengthOfItemName) {
            this.MaximumLengthOfItemName = maximumLengthOfItemName;
        }
    }
}

