/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK;

import com.datecs.fiscalprinter.SDK.AbstractTransportProtocol;
import com.datecs.fiscalprinter.SDK.FiscalSocket;
import com.datecs.fiscalprinter.SDK.StopWatch;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TransportProtocolV1
extends AbstractTransportProtocol {
    public static final int MAX_PACKET_SIZE = 224;
    public static final int MAX_DATA_SIZE = 218;
    private byte[] mSB = new byte[6];

    public TransportProtocolV1(InputStream in, OutputStream out, int encoding) {
        super(in, out, encoding);
        this.mPackageSequence = 39;
    }

    public TransportProtocolV1(FiscalSocket socket, int encoding) {
        super(socket, encoding);
        this.mPackageSequence = 39;
    }

    public TransportProtocolV1(FiscalSocket socket) {
        super(socket);
        this.mPackageSequence = 39;
    }

    @Override
    public String customCommand(int command, String data) throws IOException {
        ++this.mPackageSequence;
        if (this.mPackageSequence > 127) {
            this.mPackageSequence = 39;
        }
        this.mSocket.clear();
        LOGGER.severe(String.format("> (%d) %s", command, data));
        StopWatch go = new StopWatch();
        this.writePacket(command, data);
        String result = this.readPacket();
        LOGGER.severe(String.format("< (%d) \"%s\" in %dms", command, result, (int)go.getElapsedTime()));
        return result;
    }

    @Override
    protected void writePacket(int command, String data) throws IOException {
        for (int retry = 0; retry < 2; ++retry) {
            byte[] buf = new byte[218];
            int offs = 0;
            int len = 0;
            int crc = 0;
            int n = len = data != null ? data.length() : 0;
            if (len > 218) {
                throw new IllegalArgumentException("Lenght of the packet exceeds the limits!");
            }
            buf[offs++] = 1;
            buf[offs++] = (byte)(36 + len);
            buf[offs++] = (byte)this.mPackageSequence;
            buf[offs++] = (byte)command;
            TransportProtocolV1.toAnsi(data, buf, offs, this.mEncoding);
            offs += len;
            buf[offs++] = 5;
            for (int i = 1; i < offs; ++i) {
                crc += buf[i] & 0xFF;
            }
            buf[offs++] = (byte)((crc >> 12 & 0xF) + 48);
            buf[offs++] = (byte)((crc >> 8 & 0xF) + 48);
            buf[offs++] = (byte)((crc >> 4 & 0xF) + 48);
            buf[offs++] = (byte)((crc >> 0 & 0xF) + 48);
            buf[offs++] = 3;
            this.mSocket.write(buf, 0, offs);
            this.mSocket.flush();
            do {
                this.read(buf, 0, 1);
            } while ((buf[0] & 0xFF) == 22);
            if (buf[0] == 21) continue;
            if (buf[0] != 1) {
                throw new IOException("W:Invalid data received!");
            }
            return;
        }
        throw new IOException("Invalid packet checksum!");
    }

    @Override
    protected String readPacket() throws IOException {
        byte[] buf = new byte[218];
        int b = this.read();
        int len = b - 43;
        int crc = b;
        b = this.read();
        crc += b;
        b = this.read();
        crc += b;
        this.read(buf, 0, len);
        for (int i = 0; i < len; ++i) {
            crc += buf[i] & 0xFF;
        }
        b = this.read();
        if (b != 4) {
            throw new IOException("R0:Invalid data received!");
        }
        crc += b;
        this.read(this.mSB, 0, this.mSB.length);
        for (byte by : this.mSB) {
            crc += by & 0xFF;
        }
        b = this.read();
        if (b != 5) {
            throw new IOException("R1:Invalid data received!");
        }
        crc += b;
        b = this.read();
        crc -= b - 48 << 12;
        b = this.read();
        crc -= b - 48 << 8;
        b = this.read();
        crc -= b - 48 << 4;
        b = this.read();
        if ((crc -= b - 48) != 0) {
            throw new IOException("Invalid CRC!");
        }
        b = this.read();
        if (b != 3) {
            throw new IOException("R2:Invalid data received!");
        }
        return TransportProtocolV1.toUnicode(buf, 0, len, this.mEncoding);
    }

    @Override
    public boolean isStatusBitTriggered(int byteIndex, int bitIndex) {
        return (this.mSB[byteIndex] & 1 << bitIndex) > 0;
    }

    @Override
    public byte[] getStatusBytes() {
        return this.mSB;
    }
}

