/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.util;

public class EIKValidator {
    private static int[] FIRST_SUM_9DIGIT_WEIGHTS = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
    private static int[] SECOND_SUM_9DIGIT_WEIGHTS = new int[]{3, 4, 5, 6, 7, 8, 9, 10};
    private static int[] FIRST_SUM_13DIGIT_WEIGHTS = new int[]{2, 7, 3, 5};
    private static int[] SECOND_SUM_13DIGIT_WEIGHTS = new int[]{4, 9, 5, 7};

    public static boolean isValid(String eik) {
        if (eik.length() == 9) {
            int[] resDigitis = EIKValidator.checkInput(eik, 9);
            int ninthDigit = EIKValidator.calc9(resDigitis);
            return ninthDigit == resDigitis[8];
        }
        if (eik.length() == 13) {
            int[] resDigitis = EIKValidator.checkInput(eik, 13);
            int thirteenDigit = EIKValidator.calc13(resDigitis);
            return thirteenDigit == resDigitis[12];
        }
        return false;
    }

    private static int calc9(int[] digits) {
        int sum = 0;
        for (int i = 0; i < 8; ++i) {
            sum += digits[i] * FIRST_SUM_9DIGIT_WEIGHTS[i];
        }
        int remainder = sum % 11;
        if (remainder != 10) {
            return remainder;
        }
        int secondSum = 0;
        for (int i = 0; i < 8; ++i) {
            secondSum += digits[i] * SECOND_SUM_9DIGIT_WEIGHTS[i];
        }
        int secondRem = secondSum % 11;
        if (secondRem != 10) {
            return secondRem;
        }
        return 0;
    }

    private static int calc13(int[] digits) {
        int ninthDigit = EIKValidator.calc9(digits);
        if (ninthDigit != digits[8]) {
            throw new IllegalArgumentException("Incorrect 9th digit in EIK-13.");
        }
        int sum = 0;
        int i = 8;
        for (int j = 0; j < 4; ++j) {
            sum += digits[i] * FIRST_SUM_13DIGIT_WEIGHTS[j];
            ++i;
        }
        int remainder = sum % 11;
        if (remainder != 10) {
            return remainder;
        }
        int secondSum = 0;
        int i2 = 8;
        for (int j = 0; j < 4; ++j) {
            secondSum += digits[i2] * SECOND_SUM_13DIGIT_WEIGHTS[j];
            ++i2;
        }
        int secondRem = secondSum % 11;
        if (secondRem != 10) {
            return secondRem;
        }
        return 0;
    }

    private static int[] checkInput(String eik, int eikLength) {
        if (eik != null && eik.length() != eikLength) {
            throw new IllegalArgumentException("Incorrect count of digits in EIK: " + eik.length() + "!= 9 or 13");
        }
        char[] charDigits = eik.toCharArray();
        int[] digits = new int[charDigits.length];
        for (int i = 0; i < digits.length; ++i) {
            if (!Character.isDigit(charDigits[i])) {
                throw new IllegalArgumentException("Incorrect input character. Only digits are allowed.");
            }
            digits[i] = Character.digit(charDigits[i], 10);
        }
        return digits;
    }
}

