/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK.model.UserLayerV2;

import com.datecs.fiscalprinter.SDK.AbstractTransportProtocol;
import com.datecs.fiscalprinter.SDK.FiscalDeviceV2;
import com.datecs.fiscalprinter.SDK.FiscalException;
import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import com.datecs.fiscalprinter.SDK.model.UserLayerV2.DailyInfoModel;
import java.io.IOException;

public class cmdInfo
extends DatecsFiscalDevice {
    public void GetModeConnectionWithPC() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command45Variant0Version0();
        }
        cmdInfo.checkErrorCode(R);
    }

    public String[] GetActiveTaxRates() throws Exception {
        String[] res = new String[8];
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command50Variant0Version0();
            cmdInfo.checkErrorCode(R);
            res[0] = R.get("taxA");
            res[1] = R.get("taxB");
            res[2] = R.get("taxC");
            res[3] = R.get("taxD");
            res[4] = R.get("taxE");
            res[5] = R.get("taxF");
            res[6] = R.get("taxG");
            res[7] = R.get("taxH");
        }
        return res;
    }

    public String GetActiveTaxRatesDate() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command50Variant0Version0();
        }
        cmdInfo.checkErrorCode(R);
        return R.get("entDate");
    }

    public String[] GetLastFiscEntryTurnover() throws Exception {
        String[] res = new String[10];
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command64Variant0Version0("0");
            cmdInfo.checkErrorCode(R);
            res[0] = R.get("nRep");
            res[1] = R.get("sumA");
            res[2] = R.get("sumB");
            res[3] = R.get("sumC");
            res[4] = R.get("sumD");
            res[5] = R.get("sumE");
            res[6] = R.get("sumF");
            res[7] = R.get("sumG");
            res[8] = R.get("sumH");
            res[9] = R.get("date");
        }
        return res;
    }

    public int GetRemainingZReportEntries() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command68Variant0Version0();
        }
        cmdInfo.checkErrorCode(R);
        return R.getInt("ReportsLeft");
    }

    public String PrintDiagnostic() throws Exception {
        return "";
    }

    public byte[] GetStatus() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command74Variant0Version0();
        }
        cmdInfo.checkErrorCode(R);
        String statusStr = R.getString("statusBytes");
        int len = statusStr.length();
        byte[] dataset = new byte[len];
        AbstractTransportProtocol.toAnsi(statusStr, dataset, 0, 1251);
        return dataset;
    }

    public String GetLastFiscalRecordDate() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command64Variant0Version0("1");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("date");
    }

    public String GetTaxNumber() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command99Variant0Version0();
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("tAXnumber");
    }

    public String GetError(int Code) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command99Variant0Version0();
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("errorMessage");
    }

    public CurrentReceiptInfo GetCurrentReceipt() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command103Variant0Version0();
        }
        cmdInfo.checkErrorCode(R);
        return new CurrentReceiptInfo(R.get("sumVATA"), R.get("sumVATB"), R.get("sumVATC"), R.get("sumVATD"), R.get("sumVATE"), R.get("sumVATF"), R.get("sumVATG"), R.get("sumVATH"), R.get("inv").equals("1"), R.getInt("invNmb"));
    }

    public DailyInfoModel GetDailyPayments() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command110Variant0Version0();
        }
        cmdInfo.checkErrorCode(R);
        return new DailyInfoModel(R.get("pay1"), R.get("pay2"), R.get("pay3"), R.get("pay4"), R.get("pay5"), R.get("pay6"), R.get("foreignPay"));
    }

    public DailyInfoModel GetDailyPaymentsStornoOperations() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command110Variant1Version0();
        }
        cmdInfo.checkErrorCode(R);
        return new DailyInfoModel(R.get("pay1"), R.get("pay2"), R.get("pay3"), R.get("pay4"), R.get("pay5"), R.get("pay6"), R.get("foreignPay"));
    }

    public DailyInfoModel GetDailyNumAndSumsOfSells() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command110Variant2Version0();
        }
        cmdInfo.checkErrorCode(R);
        return new DailyInfoModel(R.get("num"), R.get("sum"));
    }

    public DailyInfoModel GetDailyNumAndSumsOfDiscountsSurcharges() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command110Variant3Version0();
        }
        cmdInfo.checkErrorCode(R);
        return new DailyInfoModel(DailyInfoModel.DayInfoType.DiscountsAndSurcharges, R.get("qSur"), R.get("sSur"), R.get("qDis"), R.get("sDis"));
    }

    public DailyInfoModel GetDailyNumAndSumsOfVoided() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command110Variant4Version0();
        }
        cmdInfo.checkErrorCode(R);
        return new DailyInfoModel(DailyInfoModel.DayInfoType.CorrectionsAndAnnulled, R.get("qVoid"), R.get("sVoid"), R.get("qAnul"), R.get("sAnul"));
    }

    public DailyInfoModel GetDailyCashCashInOut() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command110Variant5Version0();
        }
        cmdInfo.checkErrorCode(R);
        return new DailyInfoModel(R.get("qCashIn1"), R.get("sCashIn1"), R.get("qCashOut1"), R.get("sCashOut1"), R.get("qCashIn2"), R.get("sCashIn2"), R.get("qCashOut2"), R.get("sCashOut2"));
    }

    public OperatorInfoModel GetOperatorInfo(int OperatorIndex) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command112Variant0Version0(String.valueOf(OperatorIndex));
        }
        cmdInfo.checkErrorCode(R);
        return new OperatorInfoModel(OperatorIndex, this.GetOperName(OperatorIndex - 1), R.getInt("receipts"), R.getDouble("total"), R.getInt("nDiscount"), R.getDouble("discount"), R.getInt("nSurcharge"), R.getDouble("surcharge"), R.getInt("nVoid"), R.getDouble("void"));
    }

    public int GetFpComBaudRate() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.ComPortBaudRate, "0");
        }
        cmdInfo.checkErrorCode(R);
        return R.getInt("VarValue");
    }

    public boolean GetBthDiscoverability() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.BthDiscoverability, "0");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue").equals("1");
    }

    public boolean GetnZreport() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.nZreport, "0");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue").equals("1");
    }

    public int GetBthPairing() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.BthPairing, "0");
        }
        cmdInfo.checkErrorCode(R);
        return R.getInt("VarValue");
    }

    public int GetBthPinCode() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.BthPinCode, "0");
        }
        cmdInfo.checkErrorCode(R);
        return R.getInt("VarValue");
    }

    public String GetBthVersion() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.BthVersion, "0");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue");
    }

    public String GetBthAddress() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.BthAddress, "0");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue");
    }

    public int GetBarCodeHeight() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.BarCodeHeight, "0");
        }
        cmdInfo.checkErrorCode(R);
        return R.getInt("VarValue");
    }

    public boolean GetBarcodeName() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.BarcodeName, "0");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue").equals("1");
    }

    public boolean GetAutoPaperCutting() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.AutoPaperCutting, "0");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue").equals("1");
    }

    public boolean GetPaperCuttingType() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.PaperCuttingType, "0");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue").equals("1");
    }

    public void GetLinespacing() throws Exception {
    }

    public boolean GetEcrConnectedOperReport() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.EcrConnectedOperReport, "0");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue").equals("1");
    }

    public boolean GetEcrConnectedGroupsReport() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.EcrConnectedGroupsReport, "0");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue").equals("1");
    }

    public boolean GetEcrConnectedDeptReport() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.EcrConnectedDeptReport, "0");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue").equals("1");
    }

    public boolean GetEcrConnectedPluSalesReport() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.EcrPluDailyClearing, "0");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue").equals("1");
    }

    public boolean GetEcrConnectedCashReport() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.EcrConnectedCashReport, "0");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue").equals("1");
    }

    public boolean GetEcrPluDailyClearing() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.EcrPluDailyClearing, "0");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue").equals("1");
    }

    public int GetEcrNumberBarcode() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.EcrNumberBarcode, "0");
        }
        cmdInfo.checkErrorCode(R);
        return Integer.parseInt(R.getString("VarValue"));
    }

    public int GetAutoPowerOff() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.EcrNumberBarcode, "0");
        }
        cmdInfo.checkErrorCode(R);
        return Integer.parseInt(R.getString("VarValue"));
    }

    public String GetCurrNameLocal() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.CurrNameLocal, "0");
            cmdInfo.checkErrorCode(R);
            return R.getString("VarValue");
        }
        return null;
    }

    public String GetCurrNameForeign() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.CurrNameForeign, "0");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue");
    }

    public String GetExchangeRate() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.ExchangeRate, "0");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue");
    }

    public String GetUnitName(int unitIndex) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.Unit_name, String.valueOf(unitIndex));
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue");
    }

    public String GetOperName(int operIndex) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.OperName, String.valueOf(operIndex));
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue");
    }

    public String GetOperPasw(int operIndex) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.OperPasw, String.valueOf(operIndex));
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue");
    }

    public String GetDeptName(int deptIndex) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.Dept_name, String.valueOf(deptIndex));
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue");
    }

    public String GetDeptPrice(int deptIndex) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.Dept_price, String.valueOf(deptIndex));
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue");
    }

    public String GetDeptVat(int deptIndex) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.Dept_vat, String.valueOf(deptIndex));
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue");
    }

    public boolean GetPaymentForbidden(int IndexOfPayment) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.Payment_forbidden, String.valueOf(IndexOfPayment));
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue").equals("1");
    }

    public String GetPayName(int indexOfPayment) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.PayName, String.valueOf(indexOfPayment));
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue");
    }

    public String GetServMessage(int indexOfMessage) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.ServMessage, String.valueOf(indexOfMessage));
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue");
    }

    public String GetServiceDate() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.ServMessage, "");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue");
    }

    public String GetDeviceSerialNumber() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.IDnumber, "");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue");
    }

    public String GetGlobalNumberOfReceipts() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.nBon, "");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue");
    }

    public String GetGlobalNumberOfFiscalReceipts() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.nFBon, "");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue");
    }

    public String GetDeviceFMnumber() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().Command255Read(FiscalDeviceV2.cmd255Name.FMnumber, "");
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("VarValue");
    }

    public String GetDateOfLastZreport() throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command123Variant3Version0();
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("Znumber");
    }

    public String GetNumberOfLastZreport() throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command123Variant3Version0();
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("Znumber");
    }

    public String GetNumberBonFiscal() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command123Variant3Version0();
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("BonFiscal");
    }

    public String GetDateBonFiscal() throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command123Variant3Version0();
        }
        cmdInfo.checkErrorCode(R);
        return R.getString("DateBonFiscal");
    }

    public boolean GetPrintBufferStatus() throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command74Variant0Version1();
        }
        cmdInfo.checkErrorCode(R);
        return R.getBoolean("PrintBufferStatus");
    }

    public int GetNumberOfCurrentOrLastReceipt() throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command74Variant0Version1();
        }
        cmdInfo.checkErrorCode(R);
        return R.getInt("number");
    }

    public QRinfo GetQRInfo() throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command74Variant0Version1();
        }
        cmdInfo.checkErrorCode(R);
        return new QRinfo(R.getDouble("QRamount"), R.getInt("QRnumber"), R.get("QRdatetime"));
    }

    public DailyTaxation GetDailyTurnoverByTaxGroup(boolean isStorno) throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command65Variant0Version0(isStorno ? "2" : "0");
        }
        cmdInfo.checkErrorCode(R);
        return new DailyTaxation(R.getInt("nRep"), R.get("sumA"), R.get("sumB"), R.get("sumC"), R.get("sumD"), R.get("sumE"), R.get("sumF"), R.get("sumG"), R.get("sumH")).setTurnoverOnTAXGr();
    }

    public DailyTaxation GetAmountOnTAXgroup(boolean isStorno) throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedDeviceV2()) {
            R = cmdInfo.getConnectedModelV2().command65Variant0Version0(isStorno ? "3" : "1");
        }
        cmdInfo.checkErrorCode(R);
        return new DailyTaxation(R.getInt("nRep"), R.get("sumA"), R.get("sumB"), R.get("sumC"), R.get("sumD"), R.get("sumE"), R.get("sumF"), R.get("sumG"), R.get("sumH")).setAmountOnTAX();
    }

    public static class QRinfo {
        private double amount;
        private int number;
        private String datetime;

        public QRinfo(double amount, int number, String datetime) {
            this.amount = amount;
            this.number = number;
            this.datetime = datetime;
        }

        public double getAmount() {
            return this.amount;
        }

        public int getNumber() {
            return this.number;
        }

        public String getDatetime() {
            return this.datetime;
        }
    }

    public static class DailyTaxation {
        private boolean isAmountOnTAX;
        private boolean isTurnoverOnTAXGr;
        private int nRep;
        private String SumA;
        private String SumB;
        private String SumC;
        private String SumD;
        private String SumE;
        private String SumF;
        private String SumG;
        private String SumH;

        public DailyTaxation setAmountOnTAX() {
            this.isTurnoverOnTAXGr = false;
            this.isAmountOnTAX = true;
            return this;
        }

        public DailyTaxation setTurnoverOnTAXGr() {
            this.isAmountOnTAX = false;
            this.isTurnoverOnTAXGr = true;
            return this;
        }

        public boolean isAmountOnTAX() {
            return this.isAmountOnTAX;
        }

        public boolean isTurnoverOnTAXGr() {
            return this.isTurnoverOnTAXGr;
        }

        public int getnRep() {
            return this.nRep;
        }

        public String getSumA() {
            return this.SumA;
        }

        public String getSumB() {
            return this.SumB;
        }

        public String getSumC() {
            return this.SumC;
        }

        public String getSumD() {
            return this.SumD;
        }

        public String getSumE() {
            return this.SumE;
        }

        public String getSumF() {
            return this.SumF;
        }

        public String getSumG() {
            return this.SumG;
        }

        public String getSumH() {
            return this.SumH;
        }

        public String getSumX(int taxIndex) {
            switch (taxIndex) {
                case 0: {
                    return this.SumA;
                }
                case 1: {
                    return this.SumB;
                }
                case 2: {
                    return this.SumC;
                }
                case 3: {
                    return this.SumD;
                }
                case 4: {
                    return this.SumE;
                }
                case 5: {
                    return this.SumF;
                }
                case 6: {
                    return this.SumG;
                }
                case 7: {
                    return this.SumH;
                }
            }
            return "";
        }

        public DailyTaxation(int nRep, String sumA, String sumB, String sumC, String sumD, String sumE, String sumF, String sumG, String sumH) {
            this.nRep = nRep;
            this.SumA = sumA;
            this.SumB = sumB;
            this.SumC = sumC;
            this.SumD = sumD;
            this.SumE = sumE;
            this.SumF = sumF;
            this.SumG = sumG;
            this.SumH = sumH;
        }
    }

    public static class OperatorInfoModel {
        int index;
        String operatorName;
        int Receipts;
        double Total;
        int nDiscount;
        Double Discount;
        int nSurcharge;
        Double Surcharge;
        int nVoid;
        Double Void;

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getOperatorName() {
            return this.operatorName;
        }

        public void setOperatorName(String operatorName) {
            this.operatorName = operatorName;
        }

        public OperatorInfoModel(int index, String name, int receipts, double total, int nDiscount, Double discount, int nSurcharge, Double surcharge, int nVoid, Double aVoid) {
            this.index = index;
            this.operatorName = name;
            this.Receipts = receipts;
            this.Total = total;
            this.nDiscount = nDiscount;
            this.Discount = discount;
            this.nSurcharge = nSurcharge;
            this.Surcharge = surcharge;
            this.nVoid = nVoid;
            this.Void = aVoid;
        }

        public int getReceipts() {
            return this.Receipts;
        }

        public void setReceipts(int receipts) {
            this.Receipts = receipts;
        }

        public double getTotal() {
            return this.Total;
        }

        public void setTotal(double total) {
            this.Total = total;
        }

        public int getnDiscount() {
            return this.nDiscount;
        }

        public void setnDiscount(int nDiscount) {
            this.nDiscount = nDiscount;
        }

        public Double getDiscount() {
            return this.Discount;
        }

        public void setDiscount(Double discount) {
            this.Discount = discount;
        }

        public int getnSurcharge() {
            return this.nSurcharge;
        }

        public void setnSurcharge(int nSurcharge) {
            this.nSurcharge = nSurcharge;
        }

        public Double getSurcharge() {
            return this.Surcharge;
        }

        public void setSurcharge(Double surcharge) {
            this.Surcharge = surcharge;
        }

        public int getnVoid() {
            return this.nVoid;
        }

        public void setnVoid(int nVoid) {
            this.nVoid = nVoid;
        }

        public Double getVoid() {
            return this.Void;
        }

        public void setVoid(Double aVoid) {
            this.Void = aVoid;
        }
    }

    public static class CurrentReceiptInfo {
        private String SumVATA;
        private String SumVATB;
        private String SumVATC;
        private String SumVATD;
        private String SumVATE;
        private String SumVATF;
        private String SumVATG;
        private String SumVATH;
        Boolean Inv;
        int InvNmb;

        public CurrentReceiptInfo(String sumVATA, String sumVATB, String sumVATC, String sumVATD, String sumVATE, String sumVATF, String sumVATG, String sumVATH, Boolean inv, int invNmb) {
            this.SumVATA = sumVATA;
            this.SumVATB = sumVATB;
            this.SumVATC = sumVATC;
            this.SumVATD = sumVATD;
            this.SumVATE = sumVATE;
            this.SumVATF = sumVATF;
            this.SumVATG = sumVATG;
            this.SumVATH = sumVATH;
            this.Inv = inv;
            this.InvNmb = invNmb;
        }
    }
}

