/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK.model.UserLayerV1;

import com.datecs.fiscalprinter.SDK.FiscalException;
import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import java.io.IOException;
import java.io.Serializable;

public class cmdClients
extends DatecsFiscalDevice {
    private int clientNum = 0;

    public boolean DelAllItems() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedPrinter()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            R = cmdClients.getConnectedECRV1().command140Variant6Version0();
        }
        cmdClients.checkErrorCode(R);
        return true;
    }

    public void SetItem(ClientInfoModel item) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedPrinter()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            R = cmdClients.getConnectedECRV1().command140Variant0Version0(item.getEIK(), String.valueOf(item.getTypeTAXN().ordinal()), item.getRecName(), item.getName(), item.getVATN(), item.getAddr1(), item.getAddr2());
            cmdClients.checkErrorCode(R);
        }
        item.setState(ClientInfoModel.ItemState.ITEM_SAVED);
    }

    public ClientInfoModel GetFirstFoundProgrammed(int startItem) throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedPrinter()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            R = cmdClients.getConnectedECRV1().command140Variant4Version0();
            if (R.get("EIK").equals("F")) {
                return null;
            }
            return new ClientInfoModel(this.clientNum, R.get("Client"), R.get("EIK"), ClientInfoModel.TypeTAXN.fromOrdinal(R.getInt("EIKType")), R.get("Receiver"), R.get("TaxNo"), R.get("Address_1"), R.get("Address_2"), ClientInfoModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public ClientInfoModel GetNextProgrammed() throws Exception {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedPrinter()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            R = cmdClients.getConnectedECRV1().command140Variant5Version0();
            if (R.get("EIK").equals("F")) {
                return null;
            }
            return new ClientInfoModel(this.clientNum, R.get("Client"), R.get("EIK"), ClientInfoModel.TypeTAXN.fromOrdinal(R.getInt("EIKType")), R.get("Receiver"), R.get("TaxNo"), R.get("Address_1"), R.get("Address_2"), ClientInfoModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public ClientInfoModel findClientByEIK(String EIK) throws IOException, FiscalException {
        FiscalResponse R = new FiscalResponse(0);
        if (this.isConnectedPrinter()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            R = cmdClients.getConnectedECRV1().command140Variant7Version0(EIK);
            return new ClientInfoModel(0, R.get("Client"), R.get("EIK"), ClientInfoModel.TypeTAXN.fromOrdinal(R.getInt("EIKType")), R.get("Receiver"), R.get("TaxNo"), R.get("Address_1"), R.get("Address_2"), ClientInfoModel.ItemState.ITEM_IS_READ);
        }
        return null;
    }

    public boolean DelClientsByEIK(String nEIK) throws Exception {
        if (this.isConnectedPrinter()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            FiscalResponse R = cmdClients.getConnectedECRV1().command140Variant1Version0(nEIK);
            return true;
        }
        return false;
    }

    public void WriteSellerName(String Seller) throws Exception {
        if (this.isConnectedPrinter()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            FiscalResponse fiscalResponse = cmdClients.getConnectedECRV1().command140Variant2Version0(Seller);
        }
    }

    public String ReadSellerName() throws Exception {
        if (this.isConnectedPrinter()) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        if (this.isConnectedECR()) {
            FiscalResponse R = cmdClients.getConnectedECRV1().command140Variant3Version0();
            return R.get("Seller");
        }
        return "";
    }

    public static class ClientInfoModel
    implements Serializable {
        private ItemState state;
        private int FIRM;
        private String Name;
        private String EIK;
        private TypeTAXN typeN;
        private String RecName;
        private String VATN;
        private String Addr1;
        private String Addr2;

        public ItemState getState() {
            return this.state;
        }

        public void setState(ItemState state) {
            this.state = state;
        }

        public ClientInfoModel(int FIRM, String name, String EIK, TypeTAXN typeTAXN, String recName, String VATN, String addr1, String addr2, ItemState itemState) {
            this.FIRM = FIRM;
            this.Name = name;
            this.EIK = EIK;
            this.typeN = typeTAXN;
            this.RecName = recName;
            this.VATN = VATN;
            this.Addr1 = addr1;
            this.Addr2 = addr2;
            this.state = itemState;
        }

        public int getFIRM() {
            return this.FIRM;
        }

        public void setFIRM(int FIRM) {
            this.FIRM = FIRM;
        }

        public String getName() {
            return this.Name;
        }

        public void setName(String name) {
            this.Name = name;
        }

        public String getEIK() {
            return this.EIK;
        }

        public void setTAXN(String TAXN) {
            this.EIK = TAXN;
        }

        public TypeTAXN getTypeTAXN() {
            return this.typeN;
        }

        public void setTypeTAXN(TypeTAXN typeTAXN) {
            this.typeN = typeTAXN;
        }

        public String getRecName() {
            return this.RecName;
        }

        public void setRecName(String recName) {
            this.RecName = recName;
        }

        public String getVATN() {
            return this.VATN;
        }

        public void setVATN(String VATN) {
            this.VATN = VATN;
        }

        public String getAddr1() {
            return this.Addr1;
        }

        public void setAddr1(String addr1) {
            this.Addr1 = addr1;
        }

        public String getAddr2() {
            return this.Addr2;
        }

        public void setAddr2(String addr2) {
            this.Addr2 = addr2;
        }

        public static enum TypeTAXN {
            BULSTAT,
            EGN,
            LNCH,
            SERVICE;

            public static TypeTAXN[] allValues;

            public static TypeTAXN fromOrdinal(int n) {
                return allValues[n];
            }

            static {
                allValues = TypeTAXN.values();
            }
        }

        public static enum ItemState {
            ITEM_IS_READ,
            ITEM_SAVED,
            ITEM_NOT_SAVED;

        }
    }

    public static class ClientsInfo {
        private int TotalCountOfProgrammableClients;
        private int TotalCountOfProgrammedClients;
        private int MaximumLengthOfClientName;

        public ClientsInfo(int totalCountOfProgrammableClients, int totalCountOfProgrammedClients, int maximumLengthOfClientName) {
            this.TotalCountOfProgrammableClients = totalCountOfProgrammableClients;
            this.TotalCountOfProgrammedClients = totalCountOfProgrammedClients;
            this.MaximumLengthOfClientName = maximumLengthOfClientName;
        }

        public int getTotalCountOfProgrammableClients() {
            return this.TotalCountOfProgrammableClients;
        }

        public void setTotalCountOfProgrammableClients(int totalCountOfProgrammableClients) {
            this.TotalCountOfProgrammableClients = totalCountOfProgrammableClients;
        }

        public int getTotalCountOfProgrammedClients() {
            return this.TotalCountOfProgrammedClients;
        }

        public void setTotalCountOfProgrammedClients(int totalCountOfProgrammedClients) {
            this.TotalCountOfProgrammedClients = totalCountOfProgrammedClients;
        }

        public int getMaximumLengthOfClientName() {
            return this.MaximumLengthOfClientName;
        }

        public void setMaximumLengthOfClientName(int maximumLengthOfClientName) {
            this.MaximumLengthOfClientName = maximumLengthOfClientName;
        }
    }
}

