/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK.model.BGR;

import com.datecs.fiscalprinter.SDK.AbstractTransportProtocol;
import com.datecs.fiscalprinter.SDK.FiscalDeviceV1;
import com.datecs.fiscalprinter.SDK.FiscalException;
import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.TransportProtocolV1;
import com.datecs.util.RegExpr;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DP05_BGR
extends FiscalDeviceV1 {
    final int printColumns = 42;
    public final int maxLogoHeightPixel = 336;
    public final int maxLogoWidthPixel = 384;
    public final int minBarcodeHeight_mm = 3;
    public final int maxBarcodeHeight_mm = 30;
    public final Integer MAX_PLU = 2500;
    public final Integer MAX_DEPARTMENT = 9;
    private final Integer MAX_STOCK_GR = 9;
    private final boolean capAutoCutter = false;
    private boolean capFontSupported = false;

    @Override
    protected void INIT(boolean chkInputParams) throws IllegalArgumentException {
        this.setChkInputParams(chkInputParams);
    }

    public DP05_BGR(InputStream in, OutputStream out) throws IllegalArgumentException {
        this(new TransportProtocolV1(in, out, 1251));
    }

    public DP05_BGR(AbstractTransportProtocol protocol) throws IllegalArgumentException {
        super(protocol);
        this.INIT(true);
    }

    @Override
    public FiscalResponse command33Variant0Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(33, InputString);
        FiscalResponse R = new FiscalResponse(1);
        return R;
    }

    @Override
    public FiscalResponse command35Variant0Version0(String text) throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        InputString = InputString + text;
        String OutpS = this.customCommand(35, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command38Variant0Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(38, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(1);
        if (myOutputList.length > 0) {
            R.put("Allreceipt", myOutputList[0]);
        }
        return R;
    }

    @Override
    public FiscalResponse command39Variant0Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(39, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        if (myOutputList.length > 0) {
            R.put("Allreceipt", myOutputList[0]);
        }
        return R;
    }

    @Override
    public FiscalResponse command42Variant0Version0(String text) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !text.matches(RegExpr._UpTo40Symbol)) {
            throw new IllegalArgumentException("Wrong input data.");
        }
        String InputString = "";
        InputString = InputString + text;
        String OutpS = this.customCommand(42, InputString);
        FiscalResponse R = new FiscalResponse(1);
        return R;
    }

    @Override
    public FiscalResponse command42Variant1Version0(String Height, String Text) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!Height.matches(RegExpr._1_3)) {
                throw new IllegalArgumentException("Wrong input data.Height: 1-3");
            }
            if (!Text.matches(RegExpr._UpTo40Symbol)) {
                throw new IllegalArgumentException("Wrong input data.Text:  Up to 40 symbol");
            }
        }
        String InputString = "";
        InputString = InputString + Height + "\t" + Text;
        String OutpS = this.customCommand(42, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command43Variant0Version0(String itemIndex, String itemText) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!itemIndex.matches("^[0-7]$")) {
                throw new IllegalArgumentException("Wrong input data.Line number 0...7");
            }
            if (!itemText.matches(RegExpr._UpTo42Symbol)) {
                throw new IllegalArgumentException("Wrong input data.Text of the line up 42 symbols");
            }
        }
        String InputString = "";
        InputString = InputString + itemIndex;
        InputString = InputString + itemText;
        String OutpS = this.customCommand(43, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command43Variant1Version0(String printOption, String value) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !printOption.matches("^[0-7,A,B,C,D,E,L,N,T,X]")) {
            throw new IllegalArgumentException("Wrong input data.Print option");
        }
        String InputString = "";
        InputString = InputString + printOption;
        if (printOption.equals("B") || printOption.equals("L")) {
            InputString = InputString + ",";
        }
        InputString = InputString + value;
        String OutpS = this.customCommand(43, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command43Variant2Version0(String itemOption) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !itemOption.matches("^[0-7,A,B,C,D,E,F,L,N,Q,R,T,X,W,c,d]|SIM$")) {
            throw new IllegalArgumentException("Wrong input data.Print option");
        }
        String InputString = "I";
        InputString = InputString + itemOption;
        String OutpS = this.customCommand(43, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(1);
        if (myOutputList.length > 0) {
            R.put("ItemValue", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("ItemValueEx", myOutputList[1]);
        }
        return R;
    }

    @Override
    public FiscalResponse command43Variant2Version1(String lineNumber) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !lineNumber.matches("^[0-7]$")) {
            throw new IllegalArgumentException("Wrong input data.Print option");
        }
        String InputString = "I";
        InputString = InputString + lineNumber;
        String OutpS = this.customCommand(43, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("LineText", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command44Variant0Version0(String lines) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !lines.matches(RegExpr._0_99)) {
            throw new IllegalArgumentException("Wrong input data.Lines to feed 0-99");
        }
        String InputString = "";
        InputString = InputString + lines;
        String OutpS = this.customCommand(44, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command46Variant0Version0(String OpCode, String OpPwd, String NSale, String TillNmb, String DocType, String DocNumber, String DocDateTime, String FMNumber, String Invoice, String InvNumber, String Reason) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!OpCode.matches(RegExpr._1_30)) {
                throw new IllegalArgumentException("Wrong input data.Operator number  1...30");
            }
            if (!OpPwd.matches(RegExpr._1to8Digit)) {
                throw new IllegalArgumentException("Wrong input data.Operator password is not ascii string of digits. Length  4...8");
            }
            if (NSale.length() > 0 && !NSale.matches(RegExpr._UNP)) {
                throw new IllegalArgumentException("Wrong input data .Format UNP- DT000600-0001-0001000");
            }
            if (!TillNmb.matches(RegExpr._1_9999999)) {
                throw new IllegalArgumentException("Wrong input data .Number of point of sale (tillNumber) is not  1...9999999");
            }
            if (!DocType.matches(RegExpr._0_2)) {
                throw new IllegalArgumentException("Wrong input data .DocType is not 0,1 or 2");
            }
            if (!DocNumber.matches(RegExpr._0_99999999)) {
                throw new IllegalArgumentException("Wrong input data .DocNum 1 - 9999999");
            }
            if (!DocDateTime.matches(RegExpr._DDMMYYhhmmss)) {
                throw new IllegalArgumentException("Wrong input data .Format DocDateTime DDMMYYhhmmss");
            }
            if (!FMNumber.matches(RegExpr._1to8Digit)) {
                throw new IllegalArgumentException("Wrong input data .FMNumber 8 digits ");
            }
            if (Invoice.length() > 0) {
                if (!Invoice.matches(RegExpr._I)) {
                    throw new IllegalArgumentException("Wrong input data.Invoice is not I");
                }
                if (!InvNumber.matches(RegExpr._1_9999999999)) {
                    throw new IllegalArgumentException("Wrong input data .Invoice number 1 - 9999999999");
                }
            }
            if (Reason.length() > 0 && !Reason.matches(RegExpr._UpTo30Symbol)) {
                throw new IllegalArgumentException("Wrong input data .StornoReason up to 30 symbol");
            }
        }
        String InputString = "";
        InputString = InputString + OpCode + "," + OpPwd + "," + NSale + "," + TillNmb + "," + DocType + "," + DocNumber + "," + DocDateTime + "," + FMNumber;
        if (Invoice.length() > 0) {
            InputString = InputString + "," + Invoice + "," + InvNumber;
        }
        if (Reason.length() > 0) {
            InputString = InputString + "," + Reason;
        }
        String OutpS = this.customCommand(46, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        if (myOutputList.length > 0) {
            R.put("AllReceipt", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("FiscReceipt", myOutputList[1]);
        }
        return R;
    }

    @Override
    public FiscalResponse command47Variant0Version0(String text) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !text.matches(RegExpr._UpTo20Symbol)) {
            throw new IllegalArgumentException("Wrong input data.Text to display ( up to 20 symbols )");
        }
        String InputString = "";
        InputString = InputString + text;
        String OutpS = this.customCommand(47, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public int getMaxLinesToFeed() {
        return this.maxLinesToFeed;
    }

    @Override
    public FiscalResponse command48Variant0Version0(String OpNum, String Password, String TillNum, String NSale) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!OpNum.matches(RegExpr._1_30)) {
                throw new IllegalArgumentException("Wrong input data.Operator number  1...30");
            }
            if (!Password.matches(RegExpr._1to8Digit)) {
                throw new IllegalArgumentException("Wrong input data.Operator password is not ascii string of digits. Length  1...8");
            }
            if (!TillNum.matches(RegExpr._1_99999)) {
                throw new IllegalArgumentException("Wrong input data .Number of point of sale (tillNumber) is not 1...99999");
            }
            if (NSale.length() > 0 && !NSale.matches(RegExpr._UNP)) {
                throw new IllegalArgumentException("Wrong input data.Format UNP- DTxxxxxx-xxxx-xxxxxxx");
            }
        }
        String InputString = "";
        InputString = InputString + OpNum + ",";
        InputString = InputString + Password + ",";
        if (NSale.length() > 0) {
            InputString = InputString + NSale + ",";
        }
        InputString = InputString + TillNum;
        String OutpS = this.customCommand(48, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        if (myOutputList.length > 0) {
            R.put("AllReceipt", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("FiscReceipt", myOutputList[1]);
        }
        return R;
    }

    @Override
    public FiscalResponse command48Variant1Version0(String OpCode, String OpPwd, String TillNmb, String NSale) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!OpCode.matches(RegExpr._1_30)) {
                throw new IllegalArgumentException("Wrong input data.Operator number  1...30");
            }
            if (!OpPwd.matches(RegExpr._1to8Digit)) {
                throw new IllegalArgumentException("Wrong input data.Operator password is not ascii string of digits. Length  1...8");
            }
            if (!TillNmb.matches(RegExpr._1_99999)) {
                throw new IllegalArgumentException("Wrong input data .Number of point of sale (tillNumber) is not  1...99999");
            }
            if (NSale.length() > 0 && !NSale.matches(RegExpr._UNP)) {
                throw new IllegalArgumentException("Wrong input data.Format UNP- DT000600-OP01-0001000");
            }
        }
        String InputString = "";
        InputString = InputString + OpCode + ",";
        InputString = InputString + OpPwd + ",";
        if (NSale.length() > 0) {
            InputString = InputString + NSale + ",";
        }
        InputString = InputString + TillNmb + ",I";
        String OutpS = this.customCommand(48, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        if (myOutputList.length > 0) {
            R.put("AllReceipt", myOutputList[1]);
        }
        if (myOutputList.length > 1) {
            R.put("FiscReceipt", myOutputList[1]);
        }
        return R;
    }

    @Override
    public FiscalResponse command48Variant2Version0() throws IOException, FiscalException {
        String InputString = "";
        String OutpS = this.customCommand(48, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("UNP", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command49Variant0Version0(String L1, String L2, String taxCd, String price, String quan, String perc) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (L1.length() > 0 && !L1.matches(RegExpr._UpTo42Symbol)) {
                throw new IllegalArgumentException("Wrong input data. L1 description is a text up to 42 char.");
            }
            if (L2.length() > 0 && !L2.matches(RegExpr._UpTo42Symbol)) {
                throw new IllegalArgumentException("Wrong input data. L2 description is a text up to 42 char.");
            }
            if (!taxCd.matches(RegExpr._A_H_A_3)) {
                throw new IllegalArgumentException("Wrong input data. TaxCd is not in range [A-H].");
            }
            if (Double.valueOf(price) > this.MAX_PRICE) {
                throw new IllegalArgumentException("Wrong input data.Price is up to 99999999.00.");
            }
            if (quan.length() > 0 && Double.valueOf(quan) > this.MAX_PRICE) {
                throw new IllegalArgumentException("Wrong input data.Quantity is up to 99999999.000.");
            }
            if (perc.length() > 0 && (Double.valueOf(perc) < -100.0 || Double.valueOf(perc) > 100.0)) {
                throw new IllegalArgumentException("Wrong input data.Percent is not in range -100.00 to 100.00");
            }
        }
        String InputString = "";
        if (L1.length() > 0) {
            InputString = InputString + L1;
        }
        if (L2.length() > 0) {
            InputString = InputString + "\n" + L2;
        }
        InputString = InputString + "\t" + taxCd + price;
        if (quan.length() > 0) {
            InputString = InputString + "*" + quan;
        }
        if (perc.length() > 0) {
            InputString = InputString + "," + perc;
        }
        String OutpS = this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command49Variant1Version0(String L1, String L2, String taxCd, String price, String quan, String absSum) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (L1.length() > 0 && !L1.matches(RegExpr._UpTo42Symbol)) {
                throw new IllegalArgumentException("Wrong input data. L1 description is a text up to 22 char.");
            }
            if (L2.length() > 0 && !L2.matches(RegExpr._UpTo42Symbol)) {
                throw new IllegalArgumentException("Wrong input data. L2 description is a text up to 22 char.");
            }
            if (!taxCd.matches(RegExpr._A_H_A_3)) {
                throw new IllegalArgumentException("Wrong input data. TaxCd is not in range [A-H].");
            }
            if (Double.valueOf(price) > this.MAX_PRICE) {
                throw new IllegalArgumentException("Wrong input data.Price is up to 99999999.00.");
            }
            if (quan.length() > 0 && Double.valueOf(quan) > this.MAX_PRICE) {
                throw new IllegalArgumentException("Wrong input data.Quantity is up to 99999999.000.");
            }
            if (absSum.length() > 0 && Double.valueOf(absSum) > this.MAX_PRICE) {
                throw new IllegalArgumentException("Wrong input data.Sum is up to 99999999.00.");
            }
        }
        String InputString = "";
        if (L1.length() > 0) {
            InputString = InputString + L1;
        }
        if (L2.length() > 0) {
            InputString = InputString + "\n" + L2;
        }
        InputString = InputString + "\t" + taxCd + price;
        if (quan.length() > 0) {
            InputString = InputString + "*" + quan;
        }
        if (absSum.length() > 0) {
            InputString = InputString + ";" + absSum;
        }
        String OutpS = this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command49Variant0Version1(String L1, String L2, String Dept, String price, String quan, String perc) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (L1.length() > 0 && !L1.matches(RegExpr._UpTo22Symbol)) {
                throw new IllegalArgumentException("Wrong input data. L1 description is a text up to 22 char.");
            }
            if (L2.length() > 0 && !L2.matches(RegExpr._UpTo22Symbol)) {
                throw new IllegalArgumentException("Wrong input data. L2 description is a text up to 22 char.");
            }
            if (1 > Integer.valueOf(Dept) || Integer.valueOf(Dept) > this.MAX_DEPARTMENT) {
                throw new IllegalArgumentException("Wrong input data. Dept is not in range [1-60].");
            }
            if (Double.valueOf(price) > this.MAX_PRICE) {
                throw new IllegalArgumentException("Wrong input data.Price is up to 99999999.00.");
            }
            if (quan.length() > 0 && Double.valueOf(quan) > this.MAX_PRICE) {
                throw new IllegalArgumentException("Wrong input data.Quantity is up to 99999999.000.");
            }
            if (perc.length() > 0 && (Double.valueOf(perc) < -100.0 || Double.valueOf(perc) > 100.0)) {
                throw new IllegalArgumentException("Wrong input data.Percent is not in range -100.00 to 100.00");
            }
        }
        String InputString = "";
        if (L1.length() > 0) {
            InputString = InputString + L1;
        }
        if (L2.length() > 0) {
            InputString = InputString + "\n" + L2;
        }
        InputString = InputString + "\t" + Dept + "\t" + price;
        if (quan.length() > 0) {
            InputString = InputString + "*" + quan;
        }
        if (perc.length() > 0) {
            InputString = InputString + "," + perc;
        }
        String OutpS = this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command49Variant1Version1(String L1, String L2, String Dept, String price, String quan, String absSum) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (L1.length() > 0 && !L1.matches(RegExpr._UpTo42Symbol)) {
                throw new IllegalArgumentException("Wrong input data. L1 description is a text up to 22 char.");
            }
            if (L2.length() > 0 && !L2.matches(RegExpr._UpTo42Symbol)) {
                throw new IllegalArgumentException("Wrong input data. L2 description is a text up to 22 char.");
            }
            if (1 > Integer.valueOf(Dept) || Integer.valueOf(Dept) > this.MAX_DEPARTMENT) {
                throw new IllegalArgumentException("Wrong input data. Dept is not in range [1-60].");
            }
            if (Double.valueOf(price) > this.MAX_PRICE) {
                throw new IllegalArgumentException("Wrong input data.Price is up to 99999999.00.");
            }
            if (quan.length() > 0 && Double.valueOf(quan) > this.MAX_PRICE) {
                throw new IllegalArgumentException("Wrong input data.Quantity is up to 99999999.000.");
            }
            if (absSum.length() > 0 && Double.valueOf(absSum) > this.MAX_PRICE) {
                throw new IllegalArgumentException("Wrong input data.Sum is up to 99999999.00.");
            }
        }
        String InputString = "";
        if (L1.length() > 0) {
            InputString = InputString + L1;
        }
        if (L2.length() > 0) {
            InputString = InputString + "\n" + L2;
        }
        InputString = InputString + "\t" + Dept + "\t" + price;
        if (quan.length() > 0) {
            InputString = InputString + "*" + quan;
        }
        if (absSum.length() > 0) {
            InputString = InputString + ";" + absSum;
        }
        String OutpS = this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(2);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command50Variant0Version0(String startDate, String endDate) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && startDate.length() > 0) {
            if (!startDate.matches(RegExpr._DDMMYY)) {
                throw new IllegalArgumentException("Wrong input data.Use date format DDMMYY.");
            }
            if (!endDate.matches(RegExpr._DDMMYY)) {
                throw new IllegalArgumentException("Wrong input data.Use date format DDMMYY.");
            }
        }
        String InputString = "";
        if (startDate.length() > 0) {
            InputString = InputString + startDate + "," + endDate;
        }
        String OutpS = this.customCommand(50, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(9);
        if (myOutputList.length > 0) {
            R.put("F_RESULT", myOutputList[0].substring(0, 1));
        }
        if (myOutputList.length > 0) {
            R.put("AA", myOutputList[0].substring(1));
        }
        if (myOutputList.length > 1) {
            R.put("BB", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("CC", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("DD", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("EE", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("FF", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("GG", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("HH", myOutputList[7]);
        }
        if (myOutputList.length > 8) {
            R.put("DDMMYY", myOutputList[8]);
        }
        return R;
    }

    @Override
    public FiscalResponse command51Variant0Version0(String print, String display) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!print.matches(RegExpr._01)) {
                throw new IllegalArgumentException("Wrong input data.Print is not 0 or 1.");
            }
            if (!display.matches(RegExpr._01)) {
                throw new IllegalArgumentException("Wrong input data.Display is not 0 or 1.");
            }
        }
        String InputString = "";
        InputString = InputString + print;
        InputString = InputString + display;
        String OutpS = this.customCommand(51, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(9);
        if (myOutputList.length > 0) {
            R.put("SubTotal", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("TaxA", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("TaxB", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("TaxC", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("TaxD", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("TaxE", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("TaxF", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("TaxG", myOutputList[7]);
        }
        if (myOutputList.length > 8) {
            R.put("TaxH", myOutputList[8]);
        }
        return R;
    }

    @Override
    public FiscalResponse command51Variant1Version0(String print, String display, String perc) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!print.matches(RegExpr._01)) {
                throw new IllegalArgumentException("Wrong input data.Print is not 0 or 1.");
            }
            if (!display.matches(RegExpr._01)) {
                throw new IllegalArgumentException("Wrong input data.Display is not 0 or 1.");
            }
            if (Double.valueOf(perc) < -100.0 || Double.valueOf(perc) > 100.0) {
                throw new IllegalArgumentException("Wrong input data.Percent is not in range -100.00 to 100.00");
            }
        }
        String InputString = "";
        InputString = InputString + print;
        InputString = InputString + display;
        InputString = InputString + ",";
        InputString = InputString + perc;
        String OutpS = this.customCommand(51, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(9);
        if (myOutputList.length > 0) {
            R.put("SubTotal", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("TaxA", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("TaxB", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("TaxC", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("TaxD", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("TaxE", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("TaxF", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("TaxG", myOutputList[7]);
        }
        if (myOutputList.length > 8) {
            R.put("TaxH", myOutputList[8]);
        }
        return R;
    }

    @Override
    public FiscalResponse command51Variant2Version0(String print, String display, String absSum) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!print.matches(RegExpr._01)) {
                throw new IllegalArgumentException("Wrong input data.Print is not 0 or 1.");
            }
            if (!display.matches(RegExpr._01)) {
                throw new IllegalArgumentException("Wrong input data.Display is not 0 or 1.");
            }
            if (Double.valueOf(absSum) > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data.Sum is up to 99999999.00.");
            }
        }
        String InputString = "";
        InputString = InputString + print;
        InputString = InputString + display;
        InputString = InputString + ";";
        InputString = InputString + absSum;
        String OutpS = this.customCommand(51, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(9);
        if (myOutputList.length > 0) {
            R.put("SubTotal", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("TaxA", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("TaxB", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("TaxC", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("TaxD", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("TaxE", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("TaxF", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("TaxG", myOutputList[7]);
        }
        if (myOutputList.length > 8) {
            R.put("TaxH", myOutputList[8]);
        }
        return R;
    }

    @Override
    public FiscalResponse command52Variant0Version0(String L1, String taxCd, String price, String quan, String UN, String perc) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (L1.length() > 0 && !L1.matches(RegExpr._UpTo22Symbol)) {
                throw new IllegalArgumentException("Wrong input data. L1 description is a text up to 22 char.");
            }
            if (!taxCd.matches(RegExpr._A_H_A_3)) {
                throw new IllegalArgumentException("Wrong input data. TaxCd is not in range [A-H].");
            }
            if (Double.valueOf(price) > this.MAX_PRICE) {
                throw new IllegalArgumentException("Wrong input data.Price is up to 99999999.00.");
            }
            if (quan.length() > 0 && Double.valueOf(quan) > this.MAX_PRICE) {
                throw new IllegalArgumentException("Wrong input data.Quantity is up to 99999999.000.");
            }
            if (perc.length() > 0 && (Double.valueOf(perc) < -100.0 || Double.valueOf(perc) > 100.0)) {
                throw new IllegalArgumentException("Wrong input data.Percent is not in range -100.00 to 100.00");
            }
        }
        String InputString = "";
        if (L1.length() > 0) {
            InputString = InputString + L1;
        }
        InputString = InputString + "\t" + taxCd + price;
        if (quan.length() > 0) {
            InputString = InputString + "*" + quan;
        }
        if (UN.length() > 0) {
            InputString = InputString + "#" + UN;
        }
        if (perc.length() > 0) {
            InputString = InputString + "," + perc;
        }
        String OutpS = this.customCommand(52, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command52Variant1Version0(String L1, String taxCd, String price, String quan, String absSum) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (L1.length() > 0 && !L1.matches(RegExpr._UpTo42Symbol)) {
                throw new IllegalArgumentException("Wrong input data. L1 description is a text up to 22 char.");
            }
            if (!taxCd.matches(RegExpr._A_H_A_3)) {
                throw new IllegalArgumentException("Wrong input data. TaxCd is not in range [A-H].");
            }
            if (Double.valueOf(price) > this.MAX_PRICE) {
                throw new IllegalArgumentException("Wrong input data.Price is up to 99999999.00.");
            }
            if (quan.length() > 0 && Double.valueOf(quan) > this.MAX_PRICE) {
                throw new IllegalArgumentException("Wrong input data.Quantity is up to 99999999.000.");
            }
            if (absSum.length() > 0 && Double.valueOf(absSum) > this.MAX_PRICE) {
                throw new IllegalArgumentException("Wrong input data.Sum is up to 99999999.00.");
            }
        }
        String InputString = "";
        if (L1.length() > 0) {
            InputString = InputString + L1;
        }
        InputString = InputString + "\t" + taxCd + price;
        if (quan.length() > 0) {
            InputString = InputString + "*" + quan;
        }
        if (absSum.length() > 0) {
            InputString = InputString + ";" + absSum;
        }
        String OutpS = this.customCommand(52, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command52Variant0Version1(String L1, String Dept, String price, String quan, String perc) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (L1.length() > 0 && !L1.matches(RegExpr._UpTo22Symbol)) {
                throw new IllegalArgumentException("Wrong input data. L1 description is a text up to 22 char.");
            }
            if (1 > Integer.valueOf(Dept) || Integer.valueOf(Dept) > this.MAX_DEPARTMENT) {
                throw new IllegalArgumentException("Wrong input data. Dept is not in range [1-60].");
            }
            if (Double.valueOf(price) > this.MAX_PRICE) {
                throw new IllegalArgumentException("Wrong input data.Price is up to 99999999.00.");
            }
            if (quan.length() > 0 && Double.valueOf(quan) > this.MAX_PRICE) {
                throw new IllegalArgumentException("Wrong input data.Quantity is up to 99999999.000.");
            }
            if (perc.length() > 0 && (Double.valueOf(perc) < -100.0 || Double.valueOf(perc) > 100.0)) {
                throw new IllegalArgumentException("Wrong input data.Percent is not in range -100.00 to 100.00");
            }
        }
        String InputString = "";
        if (L1.length() > 0) {
            InputString = InputString + L1;
        }
        InputString = InputString + "\t" + Dept + price;
        if (quan.length() > 0) {
            InputString = InputString + "*" + quan;
        }
        if (perc.length() > 0) {
            InputString = InputString + "," + perc;
        }
        String OutpS = this.customCommand(52, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command52Variant1Version1(String L1, String Dept, String price, String quan, String absSum) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (L1.length() > 0 && !L1.matches(RegExpr._UpTo42Symbol)) {
                throw new IllegalArgumentException("Wrong input data. L1 description is a text up to 22 char.");
            }
            if (1 > Integer.valueOf(Dept) || Integer.valueOf(Dept) > this.MAX_DEPARTMENT) {
                throw new IllegalArgumentException("Wrong input data. Dept is not in range [1-60].");
            }
            if (Double.valueOf(price) > this.MAX_PRICE) {
                throw new IllegalArgumentException("Wrong input data.Price is up to 99999999.00.");
            }
            if (quan.length() > 0 && Double.valueOf(quan) > this.MAX_PRICE) {
                throw new IllegalArgumentException("Wrong input data.Quantity is up to 99999999.000.");
            }
            if (absSum.length() > 0 && Double.valueOf(absSum) > this.MAX_PRICE) {
                throw new IllegalArgumentException("Wrong input data.Sum is up to 99999999.00.");
            }
        }
        String InputString = "";
        if (L1.length() > 0) {
            InputString = InputString + L1;
        }
        InputString = InputString + "\t" + Dept + price;
        if (quan.length() > 0) {
            InputString = InputString + "*" + quan;
        }
        if (absSum.length() > 0) {
            InputString = InputString + ";" + absSum;
        }
        String OutpS = this.customCommand(52, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command53Variant0Version0(String L1, String L2, String paidMode, String amount) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (L1.length() > 0 && !L1.matches(RegExpr._UpTo36Symbol)) {
                throw new IllegalArgumentException("Wrong input data. L1 description is a text up to 22 char.");
            }
            if (L2.length() > 0 && !L2.matches(RegExpr._UpTo36Symbol)) {
                throw new IllegalArgumentException("Wrong input data. L2 description is a text up to 22 char.");
            }
            if (paidMode.length() > 0 && !paidMode.matches(RegExpr._PaiedModes)) {
                throw new IllegalArgumentException("Wrong input data.PaidMode is wromg.");
            }
            if (amount.length() > 0 && (-9.999999999E9 > Double.valueOf(amount) || Double.valueOf(amount) > 9.999999999E9)) {
                throw new IllegalArgumentException("Wrong input data.Amount is <> 9999999999.00.");
            }
        }
        String InputString = "";
        if (L1.length() > 0) {
            InputString = InputString + L1;
        }
        if (L2.length() > 0) {
            InputString = InputString + "\n" + L2;
        }
        InputString = InputString + "\t";
        if (paidMode.length() > 0) {
            InputString = InputString + paidMode;
        }
        if (amount.length() > 0) {
            InputString = InputString + amount;
        }
        String OutpS = this.customCommand(53, InputString);
        FiscalResponse R = new FiscalResponse(2);
        R.put("PaidCode", OutpS.substring(0, 1));
        R.put("Amount_Out", OutpS.substring(1));
        return R;
    }

    @Override
    public FiscalResponse command54Variant0Version0(String text) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !text.matches(RegExpr._UpTo36Symbol)) {
            throw new IllegalArgumentException("Wrong input data.");
        }
        String InputString = "";
        InputString = InputString + text;
        String OutpS = this.customCommand(54, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command56Variant0Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(56, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        if (myOutputList.length > 0) {
            R.put("Allreceipt", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("FiscReceipt", myOutputList[1]);
        }
        return R;
    }

    @Override
    public FiscalResponse command57Variant0Version0(String Bulstat, String seller, String receiver, String client, String taxNo, String address) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!Bulstat.matches(RegExpr._9_14Symbol)) {
                throw new IllegalArgumentException("Wrong input data.EIK 9-14 symbol.");
            }
            if (seller.length() > 0 && !seller.matches(RegExpr._UpTo36Symbol)) {
                throw new IllegalArgumentException("Wrong input data.Seller up to 36 symbol.");
            }
            if (receiver.length() > 0 && !receiver.matches(RegExpr._UpTo36Symbol)) {
                throw new IllegalArgumentException("Wrong input data.Receiver up to 36 symbol.");
            }
            if (client.length() > 0 && !client.matches(RegExpr._UpTo36Symbol)) {
                throw new IllegalArgumentException("Wrong input data.Client up to 36 symbol.");
            }
            if (taxNo.length() > 0 && !taxNo.matches(RegExpr._10_14Symbol)) {
                throw new IllegalArgumentException("Wrong input data.TaxNo 10-14 symbol.");
            }
        }
        String InputString = "";
        InputString = InputString + Bulstat;
        InputString = InputString + "\t" + seller;
        InputString = InputString + "\t" + receiver;
        InputString = InputString + "\t" + client;
        InputString = InputString + "\t" + taxNo;
        InputString = InputString + "\t" + address;
        String OutpS = this.customCommand(57, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command57Variant1Version0(String typeEIK, String EIK, String seller, String receiver, String client, String taxNo, String address) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!typeEIK.matches(RegExpr._0_3)) {
                throw new IllegalArgumentException("Wrong input data.EIK type 0-3");
            }
            if (!EIK.matches(RegExpr._9_14Symbol)) {
                throw new IllegalArgumentException("Wrong input data.EIK 9-14 symbol.");
            }
            if (seller.length() > 0 && !seller.matches(RegExpr._UpTo36Symbol)) {
                throw new IllegalArgumentException("Wrong input data.Seller up to 36 symbol.");
            }
            if (receiver.length() > 0 && !receiver.matches(RegExpr._UpTo36Symbol)) {
                throw new IllegalArgumentException("Wrong input data.Receiver up to 36 symbol.");
            }
            if (client.length() > 0 && !client.matches(RegExpr._UpTo36Symbol)) {
                throw new IllegalArgumentException("Wrong input data.Client up to 36 symbol.");
            }
            if (taxNo.length() > 0 && !taxNo.matches(RegExpr._10_14Symbol)) {
                throw new IllegalArgumentException("Wrong input data.TaxNo 10-14 symbol.");
            }
        }
        String InputString = "";
        InputString = InputString + EIK + "\t" + typeEIK;
        InputString = InputString + "\t" + seller;
        InputString = InputString + "\t" + receiver;
        InputString = InputString + "\t" + client;
        InputString = InputString + "\t" + taxNo;
        InputString = InputString + "\t" + address;
        String OutpS = this.customCommand(57, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command58Variant0Version0(String display, String plu, String dept, String quan, String perc) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (-1 * this.MAX_PLU > Integer.valueOf(plu) || Integer.valueOf(plu) > this.MAX_PLU) {
                throw new IllegalArgumentException("Wrong input data.PLU 1-999999999");
            }
            if (1 > Integer.valueOf(dept) || Integer.valueOf(dept) > this.MAX_DEPARTMENT) {
                throw new IllegalArgumentException("Wrong input data. Dept is not in range [1-60].");
            }
            if (quan.length() > 0 && Double.valueOf(quan) > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data.Quantity is up to 99999999.000.");
            }
            if (perc.length() > 0 && (Double.valueOf(perc) < -100.0 || Double.valueOf(perc) > 100.0)) {
                throw new IllegalArgumentException("Wrong input data.Percent is not in range -100.00 to 100.00");
            }
        }
        String InputString = "";
        if (display.equals("D")) {
            InputString = "D";
        }
        InputString = InputString + plu;
        if (dept.length() > 0) {
            InputString = InputString + "\t" + dept + "\t";
        }
        if (quan.length() > 0) {
            InputString = InputString + "*" + quan;
        }
        if (perc.length() > 0) {
            InputString = InputString + "," + perc;
        }
        String OutpS = this.customCommand(58, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command58Variant0Version1(String D, String plu, String dept, String quan, String abs) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (-1 * this.MAX_PLU > Integer.valueOf(plu) || Integer.valueOf(plu) > this.MAX_PLU) {
                throw new IllegalArgumentException("Wrong input data.PLU 1-999999999");
            }
            if (1 > Integer.valueOf(dept) || Integer.valueOf(dept) > this.MAX_DEPARTMENT) {
                throw new IllegalArgumentException("Wrong input data. Dept is not in range [1-60].");
            }
            if (quan.length() > 0 && Double.valueOf(quan) > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data.Quantity is up to 99999999.000.");
            }
            if (abs.length() > 0 && (this.MAX_PRICE < Double.valueOf(abs) || Double.valueOf(abs) > this.MAX_PRICE)) {
                throw new IllegalArgumentException("Wrong input data. Abs is up to +/-99999999.00.");
            }
        }
        String InputString = "";
        if (D.equals("D")) {
            InputString = "D";
        }
        InputString = InputString + plu;
        if (dept.length() > 0) {
            InputString = InputString + "\t" + dept + "\t";
        }
        if (quan.length() > 0) {
            InputString = InputString + "*" + quan;
        }
        if (abs.length() > 0) {
            InputString = InputString + ";" + abs;
        }
        String OutpS = this.customCommand(58, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command60Variant0Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(60, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command61Variant0Version0(String date, String time) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!date.matches(RegExpr._DD_MM_YY)) {
                throw new IllegalArgumentException("Wrong input data.Date format DD-MM-YY.");
            }
            if (!time.matches(RegExpr._HH_MM_SS)) {
                throw new IllegalArgumentException("Wrong input data.Time format HH:MM[:SS].");
            }
        }
        String InputString = "";
        InputString = InputString + date;
        InputString = InputString + " ";
        InputString = InputString + time;
        String OutpS = this.customCommand(61, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command61Variant1Version0(String dateTime) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !dateTime.matches(RegExpr._DD_MM_YY_HH_MM_SS)) {
            throw new IllegalArgumentException("Wrong input data.Date format DD-MM-YY HH:MM[:SS].");
        }
        String InputString = dateTime;
        String OutpS = this.customCommand(61, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command62Variant0Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(62, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{" "});
        FiscalResponse R = new FiscalResponse(2);
        if (myOutputList.length > 0) {
            R.put("Date", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("Time", myOutputList[1]);
        }
        return R;
    }

    @Override
    public FiscalResponse command63Variant0Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(63, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command64Variant0Version0(String Option) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !Option.matches(RegExpr._x01)) {
            throw new IllegalArgumentException("Wrong input data. Option (0,1)");
        }
        String InputString = Option;
        String OutpS = this.customCommand(64, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(11);
        if (myOutputList.length > 0) {
            R.put("ErrCode", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("Closure", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("TaxA", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("TaxB", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("TaxC", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("TaxD", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("TaxE", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("TaxF", myOutputList[7]);
        }
        if (myOutputList.length > 8) {
            R.put("TaxG", myOutputList[8]);
        }
        if (myOutputList.length > 9) {
            R.put("TaxH", myOutputList[9]);
        }
        if (myOutputList.length > 10) {
            R.put("ClosureDate", myOutputList[10]);
        }
        return R;
    }

    @Override
    public FiscalResponse command65Variant0Version0(String option) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !option.matches(RegExpr._x01)) {
            throw new IllegalArgumentException("Wrong input data. Option [0-1].");
        }
        String InputString = "";
        InputString = InputString + option;
        String OutpS = this.customCommand(65, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(8);
        if (myOutputList.length > 0) {
            R.put("TaxA", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("TaxB", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("TaxC", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("TaxD", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("TaxE", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("TaxF", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("TaxG", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("TaxH", myOutputList[7]);
        }
        return R;
    }

    @Override
    public FiscalResponse command65Variant1Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        InputString = InputString + "2";
        String OutpS = this.customCommand(65, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(10);
        R.put("qKLN", myOutputList[0]);
        R.put("sPROD", myOutputList[1]);
        R.put("sNDB", myOutputList[2]);
        R.put("qNDB", myOutputList[3]);
        R.put("sOTS", myOutputList[4]);
        R.put("qOTS", myOutputList[5]);
        R.put("sVD", myOutputList[6]);
        R.put("qVD", myOutputList[7]);
        R.put("sZSTR", myOutputList[8]);
        R.put("qZSTR", myOutputList[9]);
        return R;
    }

    @Override
    public FiscalResponse command65Variant2Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        InputString = InputString + "3";
        String OutpS = this.customCommand(65, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(10);
        R.put("sPYForeign", myOutputList[0]);
        R.put("sPYLocal", myOutputList[1]);
        R.put("sVV", myOutputList[2]);
        R.put("qVV", myOutputList[3]);
        R.put("sIZ", myOutputList[4]);
        R.put("qIZ", myOutputList[5]);
        R.put("sVValt", myOutputList[6]);
        R.put("qVValt", myOutputList[7]);
        R.put("sIZalt", myOutputList[8]);
        R.put("qIZalt", myOutputList[9]);
        return R;
    }

    @Override
    public FiscalResponse command65Variant3Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        InputString = InputString + "4";
        String OutpS = this.customCommand(65, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(6);
        R.put("sPY0", myOutputList[0]);
        R.put("sPY1", myOutputList[1]);
        R.put("sPY2", myOutputList[2]);
        R.put("sPY3", myOutputList[3]);
        R.put("sPY4", myOutputList[4]);
        R.put("sPY5", myOutputList[5]);
        return R;
    }

    @Override
    public FiscalResponse command65Variant5Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        InputString = InputString + "5";
        String OutpS = this.customCommand(65, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(8);
        R.put("StrA", myOutputList[0]);
        R.put("StrB", myOutputList[1]);
        R.put("StrC", myOutputList[2]);
        R.put("StrD", myOutputList[3]);
        R.put("StrE", myOutputList[4]);
        R.put("StrF", myOutputList[5]);
        R.put("StrG", myOutputList[6]);
        R.put("StrH", myOutputList[7]);
        return R;
    }

    @Override
    public FiscalResponse command65Variant6Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        InputString = InputString + "6";
        String OutpS = this.customCommand(65, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(8);
        R.put("VatStrA", myOutputList[0]);
        R.put("VatStrB", myOutputList[1]);
        R.put("VatStrC", myOutputList[2]);
        R.put("VatStrD", myOutputList[3]);
        R.put("VatStrE", myOutputList[4]);
        R.put("VatStrF", myOutputList[5]);
        R.put("VatStrG", myOutputList[6]);
        R.put("VatStrH", myOutputList[7]);
        return R;
    }

    @Override
    public FiscalResponse command65Variant7Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        InputString = InputString + "7";
        String OutpS = this.customCommand(65, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(8);
        R.put("sPY0Str", myOutputList[0]);
        R.put("sPY1Str", myOutputList[1]);
        R.put("sPY2Str", myOutputList[2]);
        R.put("sPY3Str", myOutputList[3]);
        R.put("sPY4Str", myOutputList[4]);
        R.put("sPY5Str", myOutputList[5]);
        R.put("sPYForeignStr", myOutputList[6]);
        R.put("sPYLocalStr", myOutputList[7]);
        return R;
    }

    @Override
    public FiscalResponse command66Variant0Version0(String start, String end) throws IOException, FiscalException, IllegalArgumentException {
        if (start.length() > 0 && this.isChkInputParams()) {
            if (!start.matches(RegExpr._10digit)) {
                throw new IllegalArgumentException("Wrong input data. Start up to 10 digits");
            }
            if (!end.matches(RegExpr._10digit)) {
                throw new IllegalArgumentException("Wrong input data. End up to 10 digits");
            }
        }
        String InputString = "";
        if (start.length() > 0) {
            InputString = InputString + start + "," + end;
        }
        String OutpS = this.customCommand(66, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(3);
        if (myOutputList.length > 0) {
            R.put("start", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("end", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("current", myOutputList[2]);
        }
        return R;
    }

    @Override
    public FiscalResponse command68Variant0Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(68, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(1);
        if (myOutputList.length > 0) {
            R.put("Free", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("Total", myOutputList[1]);
        }
        return R;
    }

    @Override
    public FiscalResponse command69Variant0Version0(String reportType) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !reportType.matches(RegExpr._0_2)) {
            throw new IllegalArgumentException("Wrong input data.ReportType 0,2");
        }
        String InputString = "";
        InputString = InputString + reportType;
        String OutpS = this.customCommand(69, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(10);
        if (myOutputList.length > 0) {
            R.put("Closure", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("FM_Total", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("totA", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("totB", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("totC", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("totD", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("totE", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("totF", myOutputList[7]);
        }
        if (myOutputList.length > 8) {
            R.put("totG", myOutputList[8]);
        }
        if (myOutputList.length > 9) {
            R.put("totH", myOutputList[9]);
        }
        return R;
    }

    @Override
    public FiscalResponse command70Variant0Version0(String amount) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !amount.matches(RegExpr._10d_2d)) {
            throw new IllegalArgumentException("Wrong input data.Amount");
        }
        String InputString = "";
        InputString = InputString + amount;
        String OutpS = this.customCommand(70, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(4);
        if (myOutputList.length > 0) {
            R.put("ExitCode", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("CashSum", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("ServIn", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("ServOut", myOutputList[3]);
        }
        return R;
    }

    @Override
    public FiscalResponse command71Variant0Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(71, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command73Variant0Version0(String SHA1, String SkipZ, String Start, String End) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!Start.matches(RegExpr._4d)) {
                throw new IllegalArgumentException("Wrong input data.Start");
            }
            if (!End.matches(RegExpr._4d)) {
                throw new IllegalArgumentException("Wrong input data.Start");
            }
        }
        String InputString = SHA1 + SkipZ + Start + "," + End;
        String OutpS = this.customCommand(73, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command74Variant0Version0(String option) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !option.matches(RegExpr._WX)) {
            throw new IllegalArgumentException("Wrong input data.Option W,X");
        }
        String InputString = option;
        String OutpS = this.customCommand(74, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(6);
        if (myOutputList.length > 0) {
            R.put("S0", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("S1", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("S2", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("S4", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("S4", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("S5", myOutputList[5]);
        }
        return R;
    }

    @Override
    public FiscalResponse command74Variant1Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "L";
        String OutpS = this.customCommand(74, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("Nlines", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command74Variant2Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "P";
        String OutpS = this.customCommand(74, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(5);
        if (myOutputList.length > 0) {
            R.put("Len", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("Docs", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Cuts", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("PwOns", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("MdRst", myOutputList[4]);
        }
        return R;
    }

    @Override
    public FiscalResponse command74Variant3Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "R";
        String OutpS = this.customCommand(74, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(6);
        if (myOutputList.length > 0) {
            R.put("Lastprintdoc", myOutputList[0].substring(0, 1));
        }
        if (myOutputList.length > 1) {
            R.put("Nlastsentdoc", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Dtlastsentdoc", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("Minlastsuccesssent", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("Nfirstnotsentdoc", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("Dtfirstnotsentdoc", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("Minfirstnotsuccesssent", myOutputList[6]);
        }
        return R;
    }

    @Override
    public FiscalResponse command75Variant0Version0(String Restore) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !Restore.matches(RegExpr._01)) {
            throw new IllegalArgumentException("Wrong input data.Restore 0-1");
        }
        String InputString = "";
        String OutpS = this.customCommand(75, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(4);
        if (myOutputList.length > 0) {
            R.put("Open", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("Items", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Amount", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("Tender", myOutputList[3]);
        }
        return R;
    }

    @Override
    public FiscalResponse command76Variant0Version0(String option) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !option.matches(RegExpr._T)) {
            throw new IllegalArgumentException("Wrong input data.Option T.");
        }
        String InputString = "";
        if (!option.equals("")) {
            InputString = InputString + "T";
        }
        String OutpS = this.customCommand(76, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(4);
        if (myOutputList.length > 0) {
            R.put("Open", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("Items", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Amount", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("Tender", myOutputList[3]);
        }
        return R;
    }

    @Override
    public FiscalResponse command79Variant0Version0(String start, String end) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!start.matches(RegExpr._DDMMYY)) {
                throw new IllegalArgumentException("Wrong input data.Start date DDMMYY.");
            }
            if (end.length() > 0 && !end.matches(RegExpr._DDMMYY)) {
                throw new IllegalArgumentException("Wrong input data.End date DDMMYY.");
            }
        }
        String InputString = start;
        if (end.length() > 0) {
            InputString = InputString + "," + end;
        }
        String OutpS = this.customCommand(79, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command80Variant0Version0(String hz, String mSec) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && hz.length() > 0) {
            if (Integer.valueOf(hz) < 100 || Integer.valueOf(hz) > 5000) {
                throw new IllegalArgumentException("Wrong input data. Sound Freq.100-50000Hz");
            }
            if (Integer.valueOf(mSec) < 50 || Integer.valueOf(hz) > 2000) {
                throw new IllegalArgumentException("Wrong input data. Sound Duration 50-20000mSec");
            }
        }
        String InputString = "";
        if (hz.length() > 0) {
            InputString = hz + "," + mSec;
        }
        String OutpS = this.customCommand(80, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command83Variant0Version0(String multiplier, String decimals, String currency, String enabledT, String taxA, String taxB, String taxC, String taxD, String taxE, String taxF, String taxG, String taxH) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!multiplier.matches(RegExpr._01)) {
                throw new IllegalArgumentException("Wrong input data.Multiplier 0-3");
            }
            if (!decimals.matches(RegExpr._0_2)) {
                throw new IllegalArgumentException("Wrong input data.Decimals 0-2");
            }
            if (!currency.matches(RegExpr._UpTo3Symbol)) {
                throw new IllegalArgumentException("Wrong input data.Currency up to 3 symbol.");
            }
            if (!enabledT.matches(RegExpr._mask8byte)) {
                throw new IllegalArgumentException("Wrong input data.EnabledT 8 byte string of 0-1");
            }
        }
        String InputString = "";
        InputString = InputString + multiplier + ",";
        InputString = InputString + decimals + ",";
        InputString = InputString + currency + ",";
        InputString = InputString + enabledT + ",";
        InputString = InputString + taxA + ",";
        InputString = InputString + taxB + ",";
        InputString = InputString + taxC + ",";
        InputString = InputString + taxD + ",";
        InputString = InputString + taxE + ",";
        InputString = InputString + taxF + ",";
        InputString = InputString + taxG + ",";
        InputString = InputString + taxH;
        String OutpS = this.customCommand(83, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command83Variant1Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(83, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(12);
        if (myOutputList.length > 0) {
            R.put("Multiplier", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("Decimals", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Currency_name", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("EnabledT", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("TaxA", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("TaxB", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("TaxC", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("TaxD", myOutputList[7]);
        }
        if (myOutputList.length > 8) {
            R.put("TaxE", myOutputList[8]);
        }
        if (myOutputList.length > 9) {
            R.put("TaxF", myOutputList[9]);
        }
        if (myOutputList.length > 10) {
            R.put("TaxG", myOutputList[10]);
        }
        if (myOutputList.length > 11) {
            R.put("TaxH", myOutputList[11]);
        }
        return R;
    }

    @Override
    public FiscalResponse command84Variant0Version0(String bcType, String bcData, String sPrintBCdata) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            switch (bcType) {
                case "1": {
                    if (bcData.matches("^\\d{7}$")) break;
                    throw new IllegalArgumentException("Wrong input data.Barcode Data EAN8-7 digit.");
                }
                case "2": {
                    if (bcData.matches("^\\d{12}$")) break;
                    throw new IllegalArgumentException("Wrong input data.Barcode Data EAN13-12 digit.");
                }
                case "3": {
                    if (bcData.matches("^.{1,30}$")) break;
                    throw new IllegalArgumentException("Wrong input data.Barcode Data Code128 - up to 30 symbol.");
                }
                default: {
                    throw new IllegalArgumentException("Wrong input data.Barcode Type.");
                }
            }
        }
        String InputString = bcType + sPrintBCdata + bcData;
        String OutpS = this.customCommand(84, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command85Variant0Version0(String option, String name) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!option.matches(RegExpr._ADD_PAY1)) {
                throw new IllegalArgumentException("Wrong input data.Option N,C,D,E,J");
            }
            if (!name.matches(RegExpr._UpTo10Symbol)) {
                throw new IllegalArgumentException("Wrong input data.Name up to 10 symbol");
            }
        }
        String InputString = "";
        InputString = InputString + option + ",";
        InputString = InputString + name;
        String OutpS = this.customCommand(85, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command85Variant1Version0(String option) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !option.matches(RegExpr._ADD_PAY1)) {
            throw new IllegalArgumentException("Wrong input data.Option ");
        }
        String InputString = "";
        InputString = InputString + option;
        String OutpS = this.customCommand(85, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(1);
        if (myOutputList.length > 0) {
            R.put("Name", myOutputList[0]);
        }
        return R;
    }

    @Override
    public FiscalResponse command86Variant0Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(86, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("DT", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command86Variant1Version0(String Option, String Number2) throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        if (Option.length() > 0) {
            InputString = InputString + Option;
        }
        if (Number2.length() > 0) {
            InputString = InputString + "," + Number2;
        }
        String OutpS = this.customCommand(86, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(6);
        R.put("DT", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command87Variant0Version0(String dept, String taxGr, String line1, String line2) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (Integer.valueOf(dept) < 1 || Integer.valueOf(dept) > this.MAX_DEPARTMENT) {
                throw new IllegalArgumentException("Wrong input data.Department number");
            }
            if (!taxGr.matches(RegExpr._A_H_A_3)) {
                throw new IllegalArgumentException("Wrong input data.Tax group");
            }
            if (!line1.matches(RegExpr._UpTo28Symbol)) {
                throw new IllegalArgumentException("Wrong input data.Line1 text up 28 symbol");
            }
            if (line2.length() > 0 && !line1.matches(RegExpr._UpTo34Symbol)) {
                throw new IllegalArgumentException("Wrong input data.Line2 text up 34 symbol");
            }
        }
        String InputString = dept + "," + taxGr + "," + line1;
        if (line2.length() > 0) {
            InputString = InputString + "\n" + line2;
        }
        String OutpS = this.customCommand(87, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command88Variant0Version0(String dept) throws IOException, FiscalException, IllegalArgumentException {
        if (Integer.valueOf(dept) < 1 || Integer.valueOf(dept) > this.MAX_DEPARTMENT) {
            throw new IllegalArgumentException("Wrong input data.Department number 1-" + String.valueOf(this.MAX_DEPARTMENT));
        }
        String InputString = "";
        InputString = InputString + dept;
        String OutpS = this.customCommand(88, InputString);
        String[] myOutputList = OutpS.split(",", 6);
        FiscalResponse R = new FiscalResponse(7);
        if (myOutputList.length > 0) {
            R.put("ExitCode", String.valueOf(myOutputList[0].charAt(0)));
        }
        if (R.get("ExitCode").equals("P")) {
            if (myOutputList.length > 0) {
                R.put("TaxGr", String.valueOf(myOutputList[0].charAt(1)));
            }
            if (myOutputList.length > 1) {
                R.put("RecSales", myOutputList[1]);
            }
            if (myOutputList.length > 2) {
                R.put("RecSum", myOutputList[2]);
            }
            if (myOutputList.length > 3) {
                R.put("TotSales", myOutputList[3]);
            }
            if (myOutputList.length > 4) {
                R.put("TotSum", myOutputList[4]);
            }
            if (myOutputList.length > 5) {
                String[] lines = DP05_BGR.split(myOutputList[5], new String[]{"\n"});
                if (lines.length > 0) {
                    R.put("Line1", lines[0]);
                }
                if (lines.length > 1) {
                    R.put("Line2", lines[1]);
                }
            }
        }
        return R;
    }

    @Override
    public FiscalResponse command89Variant0Version0(String testType) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !testType.matches(RegExpr._T)) {
            throw new IllegalArgumentException("Wrong input data.Test T ");
        }
        String InputString = "";
        InputString = InputString + testType;
        String OutpS = this.customCommand(89, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        if (myOutputList.length > 0) {
            R.put("Result", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("Free", myOutputList[1]);
        }
        return R;
    }

    @Override
    public FiscalResponse command90Variant0Version0(String option) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !option.matches(RegExpr._x01)) {
            throw new IllegalArgumentException("Wrong input data.option *,1");
        }
        String InputString = "";
        InputString = InputString + option;
        String OutpS = this.customCommand(90, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{" ", ","});
        FiscalResponse R = new FiscalResponse(8);
        if (myOutputList.length > 0) {
            R.put("Name", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("FwRevCountry", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("FwDate", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("FwTime", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("Chk", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("Sw", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("Ser", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("FM", myOutputList[7]);
        }
        return R;
    }

    @Override
    public FiscalResponse command92Variant0Version0(String type) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !type.matches(RegExpr._1_4)) {
            throw new IllegalArgumentException("Wrong input data.Type 1-4");
        }
        String InputString = "";
        InputString = InputString + type;
        String OutpS = this.customCommand(92, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command92Variant1Version0(String type) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !type.matches("^[0-3]{0,3}$")) {
            throw new IllegalArgumentException("Wrong input data.Type 0-3");
        }
        String InputString = "W" + type;
        String OutpS = this.customCommand(92, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command93Variant1Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(85, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(4);
        if (myOutputList.length > 0) {
            R.put("CntD", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("SumD", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("CntM", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("SumM", myOutputList[3]);
        }
        return R;
    }

    @Override
    public FiscalResponse command94Variant0Version0(String SHA1, String SkipZ, String startDate, String endDate) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!startDate.matches(RegExpr._DDMMYY)) {
                throw new IllegalArgumentException("Wrong input data.Start date DDMMYY.");
            }
            if (!endDate.matches(RegExpr._DDMMYY)) {
                throw new IllegalArgumentException("Wrong input data.End date DDMMYY.");
            }
        }
        String InputString = SHA1 + SkipZ;
        InputString = InputString + startDate + ",";
        InputString = InputString + endDate;
        String OutpS = this.customCommand(94, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command94Variant1Version0(String SHA1, String SkipZ, String startDate) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            switch (startDate.length()) {
                case 4: {
                    if (startDate.matches(RegExpr._MMYY)) break;
                    throw new IllegalArgumentException("Wrong input data.Start date MMYY.");
                }
                case 2: {
                    if (startDate.matches(RegExpr._YY)) break;
                    throw new IllegalArgumentException("Wrong input data.Start date MMYY.");
                }
                default: {
                    throw new IllegalArgumentException("Wrong input data.Start date");
                }
            }
        }
        String InputString = SHA1 + SkipZ;
        InputString = InputString + startDate;
        String OutpS = this.customCommand(94, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command95Variant0Version0(String first, String last) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && first.length() > 0) {
            if (!first.matches(RegExpr._1_99999)) {
                throw new IllegalArgumentException("Wrong input data.First block number up to 99999.");
            }
            if (!first.matches(RegExpr._1_99999)) {
                throw new IllegalArgumentException("Wrong input data.Last block number up to 99999.");
            }
        }
        String InputString = "";
        InputString = InputString + first + "," + last;
        String OutpS = this.customCommand(95, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command97Variant0Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(97, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(8);
        if (myOutputList.length > 0) {
            R.put("TaxA", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("TaxB", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("TaxC", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("TaxD", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("TaxE", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("TaxF", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("TaxG", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("TaxH", myOutputList[7]);
        }
        return R;
    }

    @Override
    public FiscalResponse command98Variant0Version0(String text, String name) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !text.matches(RegExpr._UpTo14Symbol)) {
            throw new IllegalArgumentException("Wrong input data.First up to 99999.");
        }
        String InputString = text;
        if (name.length() > 0) {
            InputString = InputString + "," + name;
        }
        String OutpS = this.customCommand(98, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command99Variant0Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(99, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        if (myOutputList.length > 0) {
            R.put("Text", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("Name", myOutputList[1]);
        }
        return R;
    }

    @Override
    public FiscalResponse command100Variant0Version0(String text) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !text.matches(RegExpr._UpTo40Symbol)) {
            throw new IllegalArgumentException("Wrong input data.Text up 40 symbol.");
        }
        String InputString = "";
        InputString = InputString + text;
        String OutpS = this.customCommand(100, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command101Variant0Version0(String operatorCode, String oldPassword, String newPassword) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!operatorCode.matches(RegExpr._1_30)) {
                throw new IllegalArgumentException("Wrong input data.OperatorCode 1 - 30\"");
            }
            if (!oldPassword.matches(RegExpr._1to8Digit)) {
                throw new IllegalArgumentException("Wrong input data.Password up 8 digits.");
            }
            if (!newPassword.matches(RegExpr._1to8Digit)) {
                throw new IllegalArgumentException("Wrong input data.Password up 8 digits.");
            }
        }
        String InputString = "";
        InputString = InputString + operatorCode + ",";
        InputString = InputString + oldPassword + ",";
        InputString = InputString + newPassword;
        String OutpS = this.customCommand(101, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command102Variant0Version0(String operatorCode, String operatorPass, String operatorName) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!operatorCode.matches(RegExpr._1_30)) {
                throw new IllegalArgumentException("Wrong input data.OperatorCode 1 - 30");
            }
            if (!operatorPass.matches(RegExpr._1to8Digit)) {
                throw new IllegalArgumentException("Wrong input data.Password up 8 digits.");
            }
            if (!operatorName.matches(RegExpr._UpTo24Symbol)) {
                throw new IllegalArgumentException("Wrong input data.Name up 24 symbol.");
            }
        }
        String InputString = "";
        InputString = InputString + operatorCode + ",";
        InputString = InputString + operatorPass + ",";
        InputString = InputString + operatorName;
        String OutpS = this.customCommand(102, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command103Variant0Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(103, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(12);
        if (myOutputList.length > 0) {
            R.put("CanVd", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("TaxA", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("TaxB", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("TaxC", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("TaxD", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("TaxE", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("TaxF", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("TaxG", myOutputList[7]);
        }
        if (myOutputList.length > 8) {
            R.put("TaxH", myOutputList[8]);
        }
        if (myOutputList.length > 9) {
            R.put("Inv", myOutputList[9]);
        }
        if (myOutputList.length > 10) {
            R.put("InvNum", myOutputList[10]);
        }
        if (myOutputList.length > 11) {
            R.put("Type", myOutputList[11]);
        }
        return R;
    }

    @Override
    public FiscalResponse command105Variant0Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(105, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command106Variant0Version0(String mSec) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && (Integer.valueOf(mSec) < 5 || Integer.valueOf(mSec) > 100)) {
            throw new IllegalArgumentException("Wrong input data.Pulse 5-100 mS.");
        }
        String InputString = "";
        InputString = InputString + mSec;
        String OutpS = this.customCommand(106, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command107Variant0Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        InputString = InputString + "I";
        String OutpS = this.customCommand(107, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(3);
        if (myOutputList.length > 0) {
            R.put("Total", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("Progr", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Len", myOutputList[2]);
        }
        return R;
    }

    @Override
    public FiscalResponse command107Variant1Version0(String taxGr, String PLU, String group, String price, String replaceQty, String quantity, String name) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!taxGr.matches(RegExpr._A_H_A_3)) {
                throw new IllegalArgumentException("Wrong input data.Tax group");
            }
            if (!PLU.matches(RegExpr._1_999999999)) {
                throw new IllegalArgumentException("Wrong input data.PLU code 1-999999999");
            }
            if (!group.matches(RegExpr._01_09)) {
                throw new IllegalArgumentException("Wrong input data.Stock group 1-9");
            }
            if (!price.matches(RegExpr._0_00__9999999_99)) {
                throw new IllegalArgumentException("Wrong input data.Price 0.00 to 9999999.99");
            }
            if (!quantity.matches(RegExpr._0_000__999999_999)) {
                throw new IllegalArgumentException("Wrong input data.Quantity is up to 99999999.000.");
            }
            if (!replaceQty.matches(RegExpr._A)) {
                throw new IllegalArgumentException("Wrong input data.Add Quantity-A.");
            }
            if (!name.matches(RegExpr._UpTo36Symbol)) {
                throw new IllegalArgumentException("Wrong input data.Name up to 36 symbol.");
            }
        }
        String InputString = "";
        InputString = InputString + "P" + taxGr + PLU + "," + group + "," + price + ",";
        if (replaceQty.length() > 0) {
            InputString = InputString + "A";
        }
        InputString = InputString + quantity + "," + name;
        String OutpS = this.customCommand(107, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command107Variant2Version0(String PLU, String quantity) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!PLU.matches(RegExpr._1_999999999)) {
                throw new IllegalArgumentException("Wrong input data.PLU code 1-999999999");
            }
            if (!quantity.matches(RegExpr._0_000__999999_999)) {
                throw new IllegalArgumentException("Wrong input data.Quantity is up to 99999999.000.");
            }
        }
        String InputString = "";
        InputString = InputString + "A" + PLU + "," + quantity;
        String OutpS = this.customCommand(107, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command107Variant3Version0(String option, String PLU, String toPLU) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (option.length() > 0 && !option.matches("^[A]$")) {
                throw new IllegalArgumentException("Wrong input data.Option - A");
            }
            if (PLU.length() > 0 && !PLU.matches(RegExpr._1_999999999)) {
                throw new IllegalArgumentException("Wrong input data.PLU code 1-999999999");
            }
            if (toPLU.length() > 0 && !toPLU.matches(RegExpr._1_999999999)) {
                throw new IllegalArgumentException("Wrong input data.PLU code 1-999999999");
            }
        }
        String InputString = "";
        InputString = InputString + "D";
        if (option.length() > 0) {
            InputString = InputString + option;
        } else {
            InputString = InputString + PLU;
            if (toPLU.length() > 0) {
                InputString = InputString + "," + toPLU;
            }
        }
        String OutpS = this.customCommand(107, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command107Variant4Version0(String PLU) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !PLU.matches(RegExpr._1_999999999)) {
            throw new IllegalArgumentException("Wrong input data.PLU code 1-999999999");
        }
        String InputString = "";
        InputString = InputString + "R";
        InputString = InputString + PLU;
        String OutpS = this.customCommand(107, InputString);
        String[] myOutputList = OutpS.split(",", 8);
        FiscalResponse R = new FiscalResponse(8);
        if (myOutputList.length > 0) {
            R.put("Result", myOutputList[0].substring(0, 1));
        }
        if (myOutputList.length > 0) {
            R.put("PLU", myOutputList[0].substring(1));
        }
        if (myOutputList.length > 1) {
            R.put("TaxGr", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Grp", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("SPrice", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("Total", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("Sold", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("Avail", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("Name", myOutputList[7]);
        }
        return R;
    }

    @Override
    public FiscalResponse command107Variant5Version0(String startPLU) throws IOException, FiscalException, IllegalArgumentException {
        if (startPLU.length() > 0 && this.isChkInputParams() && !startPLU.matches(RegExpr._1_999999999)) {
            throw new IllegalArgumentException("Wrong input data.PLU code 1-999999999");
        }
        String InputString = "F";
        InputString = InputString + startPLU;
        String OutpS = this.customCommand(107, InputString);
        String[] myOutputList = OutpS.split(",", 8);
        FiscalResponse R = new FiscalResponse(8);
        if (myOutputList.length > 0) {
            R.put("Result", myOutputList[0].substring(0, 1));
        }
        if (myOutputList.length > 0) {
            R.put("PLU", myOutputList[0].substring(1));
        }
        if (myOutputList.length > 1) {
            R.put("TaxGr", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Grp", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("SPrice", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("Total", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("Sold", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("Avail", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("Name", myOutputList[7]);
        }
        return R;
    }

    @Override
    public FiscalResponse command107Variant6Version0(String lastPLU) throws IOException, FiscalException, IllegalArgumentException {
        if (lastPLU.length() > 0 && this.isChkInputParams() && !lastPLU.matches(RegExpr._1_999999999)) {
            throw new IllegalArgumentException("Wrong input data.PLU code 1-999999999");
        }
        String InputString = "";
        InputString = InputString + "L";
        InputString = InputString + lastPLU;
        String OutpS = this.customCommand(107, InputString);
        String[] myOutputList = OutpS.split(",", 8);
        FiscalResponse R = new FiscalResponse(8);
        if (myOutputList.length > 0) {
            R.put("Result", myOutputList[0].substring(0, 1));
        }
        if (myOutputList.length > 0) {
            R.put("PLU", myOutputList[0].substring(1));
        }
        if (myOutputList.length > 1) {
            R.put("TaxGr", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Grp", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("SPrice", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("Total", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("Sold", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("Avail", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("Name", myOutputList[7]);
        }
        return R;
    }

    @Override
    public FiscalResponse command107Variant7Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        InputString = InputString + "N";
        String OutpS = this.customCommand(107, InputString);
        String[] myOutputList = OutpS.split(",", 8);
        FiscalResponse R = new FiscalResponse(8);
        if (myOutputList.length > 0) {
            R.put("Result", myOutputList[0].substring(0, 1));
        }
        if (myOutputList.length > 0) {
            R.put("PLU", myOutputList[0].substring(1));
        }
        if (myOutputList.length > 1) {
            R.put("TaxGr", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Grp", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("SPrice", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("Total", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("Sold", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("Avail", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("Name", myOutputList[7]);
        }
        return R;
    }

    @Override
    public FiscalResponse command107Variant8Version0(String startPLU) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && startPLU.length() > 0 && !startPLU.matches(RegExpr._1_999999999)) {
            throw new IllegalArgumentException("Wrong input data.PLU code 1-999999999");
        }
        String InputString = "";
        InputString = InputString + startPLU;
        String OutpS = this.customCommand(107, InputString);
        String[] myOutputList = OutpS.split(",", 8);
        FiscalResponse R = new FiscalResponse(8);
        if (myOutputList.length > 0) {
            R.put("Result", myOutputList[0].substring(0, 1));
        }
        if (myOutputList.length > 0) {
            R.put("PLU", myOutputList[0].substring(1));
        }
        if (myOutputList.length > 1) {
            R.put("TaxGr", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Grp", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("SPrice", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("Total", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("Sold", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("Avail", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("Name", myOutputList[7]);
        }
        return R;
    }

    @Override
    public FiscalResponse command107Variant9Version0(String startPLU) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && startPLU.length() > 0 && !startPLU.matches(RegExpr._1_999999999)) {
            throw new IllegalArgumentException("Wrong input data.PLU code 1-999999999");
        }
        String InputString = "";
        InputString = InputString + "l";
        InputString = InputString + startPLU;
        String OutpS = this.customCommand(107, InputString);
        String[] myOutputList = OutpS.split(",", 8);
        FiscalResponse R = new FiscalResponse(8);
        if (myOutputList.length > 0) {
            R.put("Result", myOutputList[0].substring(0, 1));
        }
        if (myOutputList.length > 0) {
            R.put("PLU", myOutputList[0].substring(1));
        }
        if (myOutputList.length > 1) {
            R.put("TaxGr", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Grp", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("SPrice", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("Total", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("Sold", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("Avail", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("Name", myOutputList[7]);
        }
        return R;
    }

    @Override
    public FiscalResponse command107Variant10Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        InputString = InputString + "n";
        String OutpS = this.customCommand(107, InputString);
        String[] myOutputList = OutpS.split(",", 8);
        FiscalResponse R = new FiscalResponse(8);
        if (myOutputList.length > 0) {
            R.put("Result", myOutputList[0].substring(0, 1));
        }
        if (myOutputList.length > 0) {
            R.put("PLU", myOutputList[0].substring(1));
        }
        if (myOutputList.length > 1) {
            R.put("TaxGr", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Grp", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("SPrice", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("Total", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("Sold", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("Avail", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("Name", myOutputList[7]);
        }
        return R;
    }

    @Override
    public FiscalResponse command107Variant11Version0(String option, String startPLU) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && startPLU.length() > 0 && !startPLU.matches(RegExpr._1_999999999)) {
            throw new IllegalArgumentException("Wrong input data.PLU code 1-999999999");
        }
        String InputString = "";
        InputString = InputString + option;
        if (startPLU.length() > 0) {
            InputString = InputString + startPLU;
        }
        String OutpS = this.customCommand(107, InputString);
        FiscalResponse R = new FiscalResponse(1);
        if (OutpS.length() > 0) {
            R.put("Result", OutpS.substring(0, 1));
        }
        if (OutpS.length() > 1) {
            R.put("PLU", OutpS.substring(1));
        }
        return R;
    }

    @Override
    public FiscalResponse command107Variant12Version0(String PLU, String price) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!PLU.matches(RegExpr._1_999999999)) {
                throw new IllegalArgumentException("Wrong input data.PLU code 1-999999999");
            }
            if (!price.matches(RegExpr._0_00__9999999_99)) {
                throw new IllegalArgumentException("Wrong input data.Price 0.00 to 9999999.99");
            }
        }
        String InputString = "C";
        InputString = InputString + PLU + ",";
        InputString = InputString + price;
        String OutpS = this.customCommand(107, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command108Variant0Version0(String option) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !option.matches(RegExpr._0_2)) {
            throw new IllegalArgumentException("Wrong input data.ReportType 0,2,0N,2N");
        }
        String InputString = "";
        InputString = InputString + option;
        String OutpS = this.customCommand(108, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(10);
        if (myOutputList.length > 0) {
            R.put("Closure", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("FM_Total", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("totA", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("totB", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("totC", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("totD", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("totE", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("totF", myOutputList[7]);
        }
        if (myOutputList.length > 8) {
            R.put("totG", myOutputList[8]);
        }
        if (myOutputList.length > 9) {
            R.put("totH", myOutputList[9]);
        }
        return R;
    }

    @Override
    public FiscalResponse command109Variant0Version0(String count) throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        if (this.isChkInputParams() && !count.matches(RegExpr._1)) {
            throw new IllegalArgumentException("Wrong input data.Count 1.");
        }
        String OutpS = this.customCommand(109, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command110Variant0Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(110, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(10);
        if (myOutputList.length > 0) {
            R.put("Cash", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("Credit", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Debit", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("Pay4", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("Pay5", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("Pay6", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("Rsrv1", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("Rsrv2", myOutputList[7]);
        }
        if (myOutputList.length > 8) {
            R.put("Closure", myOutputList[8]);
        }
        if (myOutputList.length > 9) {
            R.put("Receipt", myOutputList[9]);
        }
        return R;
    }

    @Override
    public FiscalResponse command111Variant0Version0(String reportType, String firstPLU, String lastPLU, String group) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!reportType.matches(RegExpr._S_P)) {
                throw new IllegalArgumentException("Wrong input data.Option S or P");
            }
            if (firstPLU.length() > 0) {
                if (!firstPLU.matches(RegExpr._1_999999999)) {
                    throw new IllegalArgumentException("Wrong input data.PLU code 1-999999999");
                }
                if (!lastPLU.matches(RegExpr._1_999999999)) {
                    throw new IllegalArgumentException("Wrong input data.PLU code 1-999999999");
                }
            }
            if (group.length() > 0 && !group.matches(RegExpr._01_09)) {
                throw new IllegalArgumentException("Wrong input data.Stock group 1-9");
            }
        }
        String InputString = "";
        InputString = InputString + reportType;
        if (firstPLU.length() > 0) {
            InputString = InputString + firstPLU;
        }
        if (lastPLU.length() > 0) {
            InputString = InputString + "," + lastPLU;
        }
        if (group.length() > 0) {
            InputString = InputString + "," + group;
        }
        String OutpS = this.customCommand(111, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("ErrorCode", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command112Variant0Version0(String operator) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !operator.matches(RegExpr._1_30)) {
            throw new IllegalArgumentException("Wrong input data.Operator number  1...30");
        }
        String InputString = "";
        InputString = InputString + operator;
        String OutpS = this.customCommand(112, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(7);
        if (myOutputList.length > 0) {
            R.put("Receipts", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("Total", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Discount", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("Surcharge", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("Void", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("Name", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("Password", myOutputList[6]);
        }
        return R;
    }

    @Override
    public FiscalResponse command112Variant1Version0(String operator) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !operator.matches(RegExpr._1_30)) {
            throw new IllegalArgumentException("Wrong input data.Operator number  1...30");
        }
        String InputString = "";
        InputString = InputString + operator + ",1";
        String OutpS = this.customCommand(112, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(8);
        if (myOutputList.length > 1) {
            R.put("STRReceipts", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("STRTotal", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("STRReturn", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("STRError", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("STRTaxbase", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("Name", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("Password", myOutputList[7]);
        }
        return R;
    }

    @Override
    public FiscalResponse command113Variant0Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(113, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("DocNum", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command114Variant0Version0(String Rec1) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !Rec1.matches(RegExpr._1_99999)) {
            throw new IllegalArgumentException("Wrong input data.closure1 up to 99999.");
        }
        String InputString = Rec1 + ",0";
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(13);
        R.put("ErrorCode", myOutputList[0]);
        if (myOutputList.length > 1) {
            R.put("DecRec", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("DecimalsCount", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("VATEnabled", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("PercA", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("PercB", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("PercC", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("PercD", myOutputList[7]);
        }
        if (myOutputList.length > 8) {
            R.put("PercE", myOutputList[8]);
        }
        if (myOutputList.length > 9) {
            R.put("PercF", myOutputList[9]);
        }
        if (myOutputList.length > 10) {
            R.put("PercG", myOutputList[10]);
        }
        if (myOutputList.length > 12) {
            R.put("PercH", myOutputList[11]);
        }
        if (myOutputList.length > 12) {
            R.put("DT", myOutputList[12]);
        }
        return R;
    }

    @Override
    public FiscalResponse command114Variant1Version0(String closure1, String closure2) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!closure1.matches(RegExpr._1_99999)) {
                throw new IllegalArgumentException("Wrong input data.Closure number up to 99999.");
            }
            if (closure2.length() > 0 && !closure2.matches(RegExpr._1_99999)) {
                throw new IllegalArgumentException("Wrong input data.Closure number up to 99999.");
            }
        }
        String InputString = "";
        InputString = InputString + closure1 + ",1";
        if (closure2.length() > 0) {
            InputString = InputString + "," + closure2;
        }
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(11);
        R.put("ErrorCode", myOutputList[0]);
        if (myOutputList.length > 1) {
            R.put("Closure", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Receipts", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("TotA", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("TotB", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("TotC", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("TotD", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("TotE", myOutputList[7]);
        }
        if (myOutputList.length > 8) {
            R.put("TotF", myOutputList[8]);
        }
        if (myOutputList.length > 9) {
            R.put("TotG", myOutputList[9]);
        }
        if (myOutputList.length > 10) {
            R.put("TotH", myOutputList[10]);
        }
        return R;
    }

    @Override
    public FiscalResponse command114Variant2Version0(String closure1, String closure2) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!closure1.matches(RegExpr._1_99999)) {
                throw new IllegalArgumentException("Wrong input data.Closure number up to 99999.");
            }
            if (closure2.length() > 0 && !closure2.matches(RegExpr._1_99999)) {
                throw new IllegalArgumentException("Wrong input data.Closure number up to 99999.");
            }
        }
        String InputString = closure1 + ",2";
        if (closure2.length() > 0) {
            InputString = InputString + "," + closure2;
        }
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(11);
        R.put("ErrorCode", myOutputList[0]);
        R.put("Closure", myOutputList[1]);
        R.put("Receipts", myOutputList[2]);
        R.put("NetA", myOutputList[3]);
        R.put("NetB", myOutputList[4]);
        R.put("NetC", myOutputList[5]);
        R.put("NetD", myOutputList[6]);
        R.put("NetE", myOutputList[7]);
        R.put("NetF", myOutputList[8]);
        R.put("NetG", myOutputList[9]);
        R.put("NetH", myOutputList[10]);
        return R;
    }

    @Override
    public FiscalResponse command114Variant3Version0(String closure1, String closure2) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!closure1.matches(RegExpr._1_99999)) {
                throw new IllegalArgumentException("Wrong input data.Closure number up to 99999.");
            }
            if (closure2.length() > 0 && !closure2.matches(RegExpr._1_99999)) {
                throw new IllegalArgumentException("Wrong input data.Closure number up to 99999.");
            }
        }
        String InputString = closure1 + ",3";
        if (closure2.length() > 0) {
            InputString = InputString + "," + closure2;
        }
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(11);
        if (myOutputList.length > 0) {
            R.put("ErrorCode", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("Closure", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Receipts", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("TaxA", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("TaxB", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("TaxC", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("TaxD", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("TaxE", myOutputList[7]);
        }
        if (myOutputList.length > 8) {
            R.put("TaxF", myOutputList[8]);
        }
        if (myOutputList.length > 9) {
            R.put("TaxG", myOutputList[9]);
        }
        if (myOutputList.length > 10) {
            R.put("TaxH", myOutputList[10]);
        }
        return R;
    }

    @Override
    public FiscalResponse command114Variant4Version0(String closure1) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !closure1.matches(RegExpr._1_99999)) {
            throw new IllegalArgumentException("Wrong input data.Closure number up to 99999.");
        }
        String InputString = closure1 + ",4";
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(11);
        if (myOutputList.length > 0) {
            R.put("ErrorCode", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("Closure", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("DecRec", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("ResetRec", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("KLEN", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("DT", myOutputList[5]);
        }
        return R;
    }

    @Override
    public FiscalResponse command114Variant5Version0(String closure1) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !closure1.matches(RegExpr._1_99999)) {
            throw new IllegalArgumentException("Wrong input data.Closure1 up to 99999.");
        }
        String InputString = closure1 + ",5";
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(12);
        if (myOutputList.length > 0) {
            R.put("ErrorCode", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("DecimalsCount", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("VATEnabled", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("PercA", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("PercB", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("PercC", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("PercD", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("PercE", myOutputList[7]);
        }
        if (myOutputList.length > 8) {
            R.put("PercF", myOutputList[8]);
        }
        if (myOutputList.length > 9) {
            R.put("PercG", myOutputList[9]);
        }
        if (myOutputList.length > 10) {
            R.put("PercH", myOutputList[10]);
        }
        if (myOutputList.length > 11) {
            R.put("DT", myOutputList[11]);
        }
        return R;
    }

    @Override
    public FiscalResponse command114Variant6Version0(String closure1) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !closure1.matches(RegExpr._1_99999)) {
            throw new IllegalArgumentException("Wrong input data.Closure number up to 99999.");
        }
        String InputString = closure1 + ",6";
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        R.put("ErrorCode", myOutputList[0]);
        R.put("DT", myOutputList[1]);
        return R;
    }

    @Override
    public FiscalResponse command114Variant7Version0(String closure1, String closure2) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!closure1.matches(RegExpr._1_99999)) {
                throw new IllegalArgumentException("Wrong input data.Closure number up to 99999.");
            }
            if (closure2.length() > 0 && !closure2.matches(RegExpr._1_99999)) {
                throw new IllegalArgumentException("Wrong input data.Closure number up to 99999.");
            }
        }
        String InputString = closure1 + ",7";
        if (closure2.length() > 0) {
            InputString = InputString + "," + closure2;
        }
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(11);
        if (myOutputList.length > 0) {
            R.put("ErrorCode", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("CashP", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("CardP", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("CredP", myOutputList[3]);
        }
        if (myOutputList.length > 5) {
            for (int i = 1; i < 12; ++i) {
                if (myOutputList.length <= 4 + i) continue;
                R.put("APayd" + String.valueOf(i), myOutputList[3 + i]);
            }
        }
        return R;
    }

    @Override
    public FiscalResponse command114Variant8Version0(String closure1, String closure2) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!closure1.matches(RegExpr._1_99999)) {
                throw new IllegalArgumentException("Wrong input data.Closure number up to 99999.");
            }
            if (closure2.length() > 0 && !closure2.matches(RegExpr._1_99999)) {
                throw new IllegalArgumentException("Wrong input data.Closure number up to 99999.");
            }
        }
        String InputString = closure1 + ",8";
        if (closure2.length() > 0) {
            InputString = InputString + "," + closure2;
        }
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(9);
        if (myOutputList.length > 0) {
            R.put("ErrorCode", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("DiscC", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("DiscS", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("MkUpC", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("MkUpS", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("VoidC", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("VoidS", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("CanC", myOutputList[7]);
        }
        if (myOutputList.length > 8) {
            R.put("CanS", myOutputList[8]);
        }
        return R;
    }

    @Override
    public FiscalResponse command114Variant9Version0(String closure1, String closure2) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!closure1.matches(RegExpr._1_99999)) {
                throw new IllegalArgumentException("Wrong input data.Closure number up to 99999.");
            }
            if (closure2.length() > 0 && !closure2.matches(RegExpr._1_99999)) {
                throw new IllegalArgumentException("Wrong input data.Closure number up to 99999.");
            }
        }
        String InputString = closure1 + ",9";
        if (closure2.length() > 0) {
            InputString = InputString + "," + closure2;
        }
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(5);
        if (myOutputList.length > 0) {
            R.put("ErrorCode", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("InC", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("InS", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("OutC", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("OutS", myOutputList[4]);
        }
        return R;
    }

    @Override
    public FiscalResponse command114Variant10Version0(String closure1) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && !closure1.matches(RegExpr._1_99999)) {
            throw new IllegalArgumentException("Wrong input data.Closure number up to 99999.");
        }
        String InputString = closure1 + ",10";
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(5);
        if (myOutputList.length > 0) {
            R.put("ErrorCode", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("GTotal", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("GVAT", myOutputList[2]);
        }
        return R;
    }

    @Override
    public FiscalResponse command115Variant0Version0(String rowNum, String data) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (Integer.valueOf(rowNum) < 0 || Integer.valueOf(rowNum) > 144) {
                throw new IllegalArgumentException("Wrong input data.RowNum 0 to 144");
            }
            if (data.length() > 384) {
                throw new IllegalArgumentException("Wrong input data.Data up " + String.valueOf(384));
            }
        }
        String InputString = "";
        InputString = InputString + rowNum;
        InputString = InputString + ",";
        InputString = InputString + data;
        String OutpS = this.customCommand(115, InputString);
        FiscalResponse R = new FiscalResponse(0);
        R.put("Result", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command115Variant1Version0(String rowNum) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams() && Integer.valueOf(rowNum) > 384) {
            throw new IllegalArgumentException("Wrong input data.RowNum max:" + String.valueOf(384));
        }
        String InputString = "";
        InputString = InputString + "R";
        InputString = InputString + rowNum;
        String OutpS = this.customCommand(115, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("RowData", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command117Variant0Version0(String Reset) throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        if (Reset.length() > 0) {
            InputString = InputString + "0";
        }
        String OutpS = this.customCommand(117, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(10);
        if (myOutputList.length > 0) {
            R.put("Closure", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("FM_Total", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("totA", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("totB", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("totC", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("totD", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("totE", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("totF", myOutputList[7]);
        }
        if (myOutputList.length > 8) {
            R.put("totG", myOutputList[8]);
        }
        if (myOutputList.length > 9) {
            R.put("totH", myOutputList[9]);
        }
        return R;
    }

    @Override
    public FiscalResponse command118Variant0Version0(String Reset) throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "";
        if (Reset.length() > 0) {
            InputString = InputString + "0";
        }
        String OutpS = this.customCommand(118, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(10);
        if (myOutputList.length > 0) {
            R.put("Closure", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("FM_Total", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("totA", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("totB", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("totC", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("totD", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("totE", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("totF", myOutputList[7]);
        }
        if (myOutputList.length > 8) {
            R.put("totG", myOutputList[8]);
        }
        if (myOutputList.length > 9) {
            R.put("totH", myOutputList[9]);
        }
        return R;
    }

    @Override
    public FiscalResponse command119Variant0Version0(String Flg, String DT1, String DT2) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!Flg.matches(RegExpr._A)) {
                throw new IllegalArgumentException("Wrong input data.Flag.");
            }
            if (DT1.length() < 7) {
                if (!DT1.matches(RegExpr._DDMMYY)) {
                    throw new IllegalArgumentException("Wrong input data.Invalid Date format-DDMMYY.");
                }
            } else if (!DT1.matches(RegExpr._DDMMYYhhmmss)) {
                throw new IllegalArgumentException("Wrong input data.Invalid Date-Time format-DDMMYY[hhmmss].");
            }
            if (DT2.length() < 7) {
                if (!DT2.matches(RegExpr._DDMMYY)) {
                    throw new IllegalArgumentException("Wrong input data.Invalid Date format-DDMMYY.");
                }
            } else if (!DT2.matches(RegExpr._DDMMYYhhmmss)) {
                throw new IllegalArgumentException("Wrong input data.Invalid Date-Time format-DDMMYY[hhmmss].");
            }
        }
        String InputString = "R," + Flg + DT1 + "," + DT2;
        String OutpS = this.customCommand(119, InputString);
        String[] myOutputList = OutpS.split(",", 2);
        FiscalResponse R = new FiscalResponse(2);
        if (myOutputList.length > 0) {
            R.put("F_RESULT", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("Text", myOutputList[1]);
        }
        return R;
    }

    @Override
    public FiscalResponse command119Variant1Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "N";
        String OutpS = this.customCommand(119, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        if (myOutputList.length > 0) {
            R.put("F_RESULT", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("Text", myOutputList[1]);
        }
        return R;
    }

    @Override
    public FiscalResponse command124Variant0Version0(String DocType, String BegDate, String EndDate) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!DocType.matches(RegExpr._0_9)) {
                throw new IllegalArgumentException("Wrong input data.DocType 0-9");
            }
            if (BegDate.length() < 7) {
                if (!BegDate.matches(RegExpr._DDMMYY)) {
                    throw new IllegalArgumentException("Wrong input data.Invalid Date format-DDMMYY.");
                }
            } else if (!BegDate.matches(RegExpr._DDMMYYhhmmss)) {
                throw new IllegalArgumentException("Wrong input data.Invalid Date-Time format-DDMMYY[hhmmss].");
            }
            if (EndDate.length() < 7) {
                if (!EndDate.matches(RegExpr._DDMMYY)) {
                    throw new IllegalArgumentException("Wrong input data.Invalid Date format-DDMMYY.");
                }
            } else if (!EndDate.matches(RegExpr._DDMMYYhhmmss)) {
                throw new IllegalArgumentException("Wrong input data.Invalid Date-Time format-DDMMYY[hhmmss].");
            }
        }
        String InputString = "D," + DocType + "," + BegDate + "," + EndDate;
        String OutpS = this.customCommand(124, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(3);
        if (myOutputList.length > 0) {
            R.put("ErrCode", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("FirstDoc", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("LastDoc", myOutputList[2]);
        }
        return R;
    }

    @Override
    public FiscalResponse command124Variant1Version0(String DocType, String BegZ, String EndZ) throws IOException, FiscalException, IllegalArgumentException {
        if (this.isChkInputParams()) {
            if (!DocType.matches(RegExpr._0_9)) {
                throw new IllegalArgumentException("Wrong input data.DocType 0-9");
            }
            if (Integer.valueOf(BegZ) > 1825) {
                throw new IllegalArgumentException("Wrong input data.Max BegZ = 1825.");
            }
            if (Integer.valueOf(EndZ) > 1825) {
                throw new IllegalArgumentException("Wrong input data.Max EndZ = 1825.");
            }
        }
        String InputString = "Z," + DocType + "," + BegZ + "," + EndZ;
        String OutpS = this.customCommand(124, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(3);
        if (myOutputList.length > 0) {
            R.put("ErrCode", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("FirstDoc", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("LastDoc", myOutputList[2]);
        }
        return R;
    }

    @Override
    public FiscalResponse command124Variant2Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "I";
        String OutpS = this.customCommand(124, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(13);
        if (myOutputList.length > 0) {
            R.put("ErrCode", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("isValid", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("isCurrent", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("IDnumber", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("Number", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("DateTime", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("Serial", myOutputList[6]);
        }
        if (myOutputList.length > 7) {
            R.put("fromZ", myOutputList[7]);
        }
        if (myOutputList.length > 8) {
            R.put("toZ", myOutputList[8]);
        }
        if (myOutputList.length > 9) {
            R.put("fromDoc", myOutputList[9]);
        }
        if (myOutputList.length > 10) {
            R.put("toDoc", myOutputList[10]);
        }
        if (myOutputList.length > 11) {
            R.put("Size", myOutputList[11]);
        }
        if (myOutputList.length > 12) {
            R.put("Used", myOutputList[12]);
        }
        return R;
    }

    @Override
    public FiscalResponse command125Variant0Version0(String DocNum, String RecType) throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "0," + DocNum + "," + RecType;
        String OutpS = this.customCommand(125, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(5);
        if (myOutputList.length > 0) {
            R.put("ErrCode", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("DocNumber", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Date", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("Type", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("Znumber", myOutputList[4]);
        }
        return R;
    }

    @Override
    public FiscalResponse command125Variant1Version0() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "1";
        String OutpS = this.customCommand(125, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        if (myOutputList.length > 0) {
            R.put("ErrCode", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("Text", myOutputList[1]);
        }
        return R;
    }

    @Override
    public FiscalResponse command125Variant1Version2() throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "2";
        String OutpS = this.customCommand(125, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        if (myOutputList.length > 0) {
            R.put("ErrCode", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("Data", myOutputList[1]);
        }
        return R;
    }

    @Override
    public Integer getMAX_PLU() {
        return this.MAX_PLU;
    }

    @Override
    public Integer getMAX_DEPARTMENT() {
        return this.MAX_DEPARTMENT;
    }

    @Override
    public Integer getMaxStockGroup() {
        return this.MAX_STOCK_GR;
    }

    @Override
    public int getMaxDepartments() {
        return this.MAX_DEPARTMENT;
    }

    @Override
    public FiscalResponse command125Variant2Version0(String DocNum, String RecType) throws IOException, FiscalException, IllegalArgumentException {
        String InputString = "3," + DocNum + "," + RecType;
        String OutpS = this.customCommand(125, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(5);
        if (myOutputList.length > 0) {
            R.put("ErrCode", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("DocNumber", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Date", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("Type", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("Znumber", myOutputList[4]);
        }
        return R;
    }

    @Override
    public FiscalResponse command140Variant0Version0(String EIK, String EIKType, String Receiver, String Client, String TaxNo, String Address_1, String Address_2) throws IOException, FiscalException {
        String InputString = "+" + EIK + "\t" + EIKType + "\t" + Receiver + "\t" + Client + "\t" + TaxNo + "\t" + Address_1 + "\t" + Address_2 + "\t";
        String OutpS = this.customCommand(140, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("ErrCode", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command140Variant1Version0(String EIK) throws IOException, FiscalException {
        String InputString = "-" + EIK;
        String OutpS = this.customCommand(140, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("ErrCode", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command140Variant2Version0(String Seller) throws IOException, FiscalException {
        String InputString = "^" + Seller;
        String OutpS = this.customCommand(140, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("ErrCode", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command140Variant3Version0() throws IOException, FiscalException {
        String InputString = "$";
        String OutpS = this.customCommand(140, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("Seller", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command140Variant4Version0() throws IOException, FiscalException {
        String InputString = "~";
        String OutpS = this.customCommand(140, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{"\t"});
        FiscalResponse R = new FiscalResponse(1);
        if (myOutputList.length > 0) {
            R.put("EIK", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("EIKType", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Receiver", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("Client", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("TaxNo", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("Address_1", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("Address_2", myOutputList[6]);
        }
        return R;
    }

    @Override
    public FiscalResponse command140Variant5Version0() throws IOException, FiscalException {
        String InputString = "@";
        String OutpS = this.customCommand(140, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{"\t"});
        FiscalResponse R = new FiscalResponse(1);
        if (myOutputList.length > 0) {
            R.put("EIK", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("EIKType", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Receiver", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("Client", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("TaxNo", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("Address_1", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("Address_2", myOutputList[6]);
        }
        return R;
    }

    @Override
    public FiscalResponse command140Variant6Version0() throws IOException, FiscalException {
        String InputString = "!";
        String OutpS = this.customCommand(140, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("ErrCode", OutpS);
        return R;
    }

    @Override
    public FiscalResponse command140Variant7Version0(String EIK) throws IOException, FiscalException {
        String InputString = "#" + EIK;
        String OutpS = this.customCommand(140, InputString);
        String[] myOutputList = DP05_BGR.split(OutpS, new String[]{"\t"});
        FiscalResponse R = new FiscalResponse(1);
        if (myOutputList.length > 0) {
            R.put("EIK", myOutputList[0]);
        }
        if (myOutputList.length > 1) {
            R.put("EIKType", myOutputList[1]);
        }
        if (myOutputList.length > 2) {
            R.put("Receiver", myOutputList[2]);
        }
        if (myOutputList.length > 3) {
            R.put("Client", myOutputList[3]);
        }
        if (myOutputList.length > 4) {
            R.put("TaxNo", myOutputList[4]);
        }
        if (myOutputList.length > 5) {
            R.put("Address_1", myOutputList[5]);
        }
        if (myOutputList.length > 6) {
            R.put("Address_2", myOutputList[6]);
        }
        return R;
    }

    @Override
    public int getMaxLogoHeightPixel() {
        return 336;
    }

    @Override
    public int getMaxLogoWidthPixel() {
        return 384;
    }

    @Override
    public int getLogoROW_NUM() {
        return 336;
    }

    @Override
    public boolean getCapFontSupported() {
        return this.capFontSupported;
    }

    @Override
    public boolean getCapAutoCutter() {
        return false;
    }

    @Override
    public int getPrintColumns() {
        return 42;
    }

    @Override
    public int getMaxBarcodeHeight_mm() {
        return 30;
    }

    @Override
    public int getMinBarcodeHeight_mm() {
        return 3;
    }
}

