/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK;

import com.datecs.fiscalprinter.SDK.AbstractTransportProtocol;
import com.datecs.fiscalprinter.SDK.FiscalDeviceInfo;
import com.datecs.fiscalprinter.SDK.FiscalException;
import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class FiscalDeviceV1 {
    protected final int maxFooterLines = 2;
    protected final int maxHeaderLines = 6;
    protected final Double MAX_PRICE = 9.9999999E7;
    protected final int maxNonFiscalText = 40;
    protected final int maxFiscalText = 36;
    protected final int maxTextHeaderFooter = 42;
    protected final Integer maxLinesToFeed = 99;
    protected final int maxDisplayText = 20;
    protected final Integer maxOperators = 30;
    protected final String defaultOpCode = "1";
    protected final String defaultOpPass = "1";
    protected final String defaultTillNumber = "1";
    public int MAX_ADDITIONAL_PAYMENTS = 5;
    private boolean capAutoCutter;
    static final Logger LOGGER = Logger.getLogger(FiscalDeviceV1.class.getName());
    private static boolean[][] isStatusCritical = new boolean[6][8];
    public static AbstractTransportProtocol transport;
    protected Map<String, Object> parameters;
    protected int build;
    private String msgSeparator = "\n\r";
    private boolean chkInputParams;

    public static boolean getIsStatusCritical(int statusByte, int statusBit) {
        return isStatusCritical[statusByte][statusBit];
    }

    public static void setCriticalStatuses(boolean[][] statusCritical) {
        isStatusCritical = statusCritical;
    }

    public void setMsgSeparator(String msgSeparator) {
        this.msgSeparator = msgSeparator;
    }

    public final String customCommand(int cmd, String data) throws FiscalException, UnsupportedOperationException, IOException {
        String result = transport.customCommand(cmd, data);
        if (cmd != 74) {
            this.CHECK_STATUS();
        }
        return result;
    }

    public final synchronized void close() {
        transport.close();
    }

    public FiscalDeviceV1(InputStream input, OutputStream output, int encoding) {
        this.parameters = new HashMap<String, Object>();
    }

    public FiscalDeviceV1(InputStream input, OutputStream output) {
        this(input, output, 1251);
    }

    public FiscalDeviceV1(AbstractTransportProtocol protocol) {
        transport = protocol;
        this.parameters = new HashMap<String, Object>();
    }

    public String getStatusBitDescription(int byteIndex, int bitIndex) {
        String tmpResult = "";
        if (DatecsFiscalDevice.getCountryCode() == 128) {
            block0 : switch (byteIndex) {
                case 0: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 1.";
                            break block0;
                        }
                        case 6: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 0.";
                            break block0;
                        }
                        case 5: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd - \ufffd\ufffd\ufffd\ufffd \ufffd OR \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd, \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd#\ufffd.";
                            break block0;
                        }
                        case 4: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 0.";
                            break block0;
                        }
                        case 3: {
                            tmpResult = "\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd.";
                            break block0;
                        }
                        case 2: {
                            tmpResult = "\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd.";
                            break block0;
                        }
                        case 1: {
                            tmpResult = "#\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd";
                            break block0;
                        }
                        case 0: {
                            tmpResult = "#\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd.";
                        }
                    }
                    break;
                }
                case 1: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 1.";
                            break block0;
                        }
                        case 6: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd";
                            break block0;
                        }
                        case 5: {
                            tmpResult = "\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd.";
                            break block0;
                        }
                        case 4: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 0.";
                            break block0;
                        }
                        case 3: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 0.";
                            break block0;
                        }
                        case 2: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 0.";
                            break block0;
                        }
                        case 1: {
                            tmpResult = "#\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd.";
                            break block0;
                        }
                        case 0: {
                            tmpResult = "\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd.";
                        }
                    }
                    break;
                }
                case 2: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 1.";
                            break block0;
                        }
                        case 6: {
                            tmpResult = "\ufffd\ufffd \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd.";
                            break block0;
                        }
                        case 5: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd.";
                            break block0;
                        }
                        case 4: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd (\ufffd\ufffd-\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd 10 MB \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd).";
                            break block0;
                        }
                        case 3: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd.";
                            break block0;
                        }
                        case 2: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd (\ufffd\ufffd-\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd 1 MB \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd).";
                            break block0;
                        }
                        case 1: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 0.";
                            break block0;
                        }
                        case 0: {
                            tmpResult = "#\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd.";
                        }
                    }
                    break;
                }
                case 3: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 1.";
                            break block0;
                        }
                        case 6: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 0.";
                            break block0;
                        }
                        case 5: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 0.";
                            break block0;
                        }
                        case 4: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 0.";
                            break block0;
                        }
                        case 3: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 0.";
                            break block0;
                        }
                        case 2: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 0.";
                            break block0;
                        }
                        case 1: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 0.";
                            break block0;
                        }
                        case 0: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 0.";
                        }
                    }
                    break;
                }
                case 4: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 1";
                            break block0;
                        }
                        case 6: {
                            tmpResult = "\ufffd\ufffd \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd.";
                            break block0;
                        }
                        case 5: {
                            tmpResult = "OR \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd, \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd*\ufffd \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd 4 \ufffd 5.";
                            break block0;
                        }
                        case 4: {
                            tmpResult = "*\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd.";
                            break block0;
                        }
                        case 3: {
                            tmpResult = "\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd \ufffd\ufffd-\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd 50 \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd \ufffd\ufffd.";
                            break block0;
                        }
                        case 2: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd.";
                            break block0;
                        }
                        case 1: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd.";
                            break block0;
                        }
                        case 0: {
                            tmpResult = "*\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd.";
                        }
                    }
                    break;
                }
                case 5: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 1.";
                            break block0;
                        }
                        case 6: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 0.";
                            break block0;
                        }
                        case 5: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 0.";
                            break block0;
                        }
                        case 4: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd \ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd.";
                            break block0;
                        }
                        case 3: {
                            tmpResult = "\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd.";
                            break block0;
                        }
                        case 2: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 0.";
                            break block0;
                        }
                        case 1: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd.";
                            break block0;
                        }
                        case 0: {
                            tmpResult = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd 0.";
                        }
                    }
                    break;
                }
                default: {
                    tmpResult = "";
                    break;
                }
            }
        } else {
            switch (byteIndex) {
                case 0: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "For internal use  1.";
                            break;
                        }
                        case 6: {
                            tmpResult = "For internal use  0.";
                            break;
                        }
                        case 5: {
                            tmpResult = "General error - this is OR of all errors marked with #.";
                            break;
                        }
                        case 4: {
                            tmpResult = "For internal use  0.";
                            break;
                        }
                        case 3: {
                            tmpResult = "No client display connected.";
                            break;
                        }
                        case 2: {
                            tmpResult = "The real time clock is not synchronized.";
                            break;
                        }
                        case 1: {
                            tmpResult = "# Command code is invalid.";
                            break;
                        }
                        case 0: {
                            tmpResult = "# Syntax error.";
                        }
                    }
                    break;
                }
                case 1: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "For internal use  1.";
                            break;
                        }
                        case 6: {
                            tmpResult = "The built-in tax terminal does not responding.";
                            break;
                        }
                        case 5: {
                            tmpResult = "There are unsent documents for more than the set alert time.";
                            break;
                        }
                        case 4: {
                            tmpResult = "For internal use  0.";
                            break;
                        }
                        case 3: {
                            tmpResult = "For internal use  0.";
                            break;
                        }
                        case 2: {
                            tmpResult = "For internal use  0.";
                            break;
                        }
                        case 1: {
                            tmpResult = "# Command is not permitted";
                            break;
                        }
                        case 0: {
                            tmpResult = "# Overflow during command execution.";
                        }
                    }
                    break;
                }
                case 2: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "For internal use  1.";
                            break;
                        }
                        case 6: {
                            tmpResult = "Not used";
                            break;
                        }
                        case 5: {
                            tmpResult = "Nonfiscal receipt is open.";
                            break;
                        }
                        case 4: {
                            tmpResult = "EJ nearly full.";
                            break;
                        }
                        case 3: {
                            tmpResult = "Fiscal receipt is Open.";
                            break;
                        }
                        case 2: {
                            tmpResult = "EJ full.";
                            break;
                        }
                        case 1: {
                            tmpResult = "For internal use  0.";
                            break;
                        }
                        case 0: {
                            tmpResult = "#End of paper.";
                        }
                    }
                    break;
                }
                case 3: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "For internal use  1";
                            break;
                        }
                        case 6: {
                            tmpResult = "For internal use  0.";
                            break;
                        }
                        case 5: {
                            tmpResult = "For internal use  0.";
                            break;
                        }
                        case 4: {
                            tmpResult = "For internal use  0.";
                            break;
                        }
                        case 3: {
                            tmpResult = "For internal use  0.";
                            break;
                        }
                        case 2: {
                            tmpResult = "For internal use  0.";
                            break;
                        }
                        case 1: {
                            tmpResult = "For internal use  0.";
                            break;
                        }
                        case 0: {
                            tmpResult = "For internal use  0.";
                        }
                    }
                    break;
                }
                case 4: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "For internal use  1.";
                            break;
                        }
                        case 6: {
                            tmpResult = "Not used";
                            break;
                        }
                        case 5: {
                            tmpResult = "OR of all errors marked with * by bytes 4 and 5.";
                            break;
                        }
                        case 4: {
                            tmpResult = "* Fiscal memory is full.";
                            break;
                        }
                        case 3: {
                            tmpResult = "There is space for less then 50 reports in Fiscal memory.";
                            break;
                        }
                        case 2: {
                            tmpResult = "Serial number and number of FM is  set.";
                            break;
                        }
                        case 1: {
                            tmpResult = "EIK on BULSTAT has been  set.";
                            break;
                        }
                        case 0: {
                            tmpResult = "* Error accessing data in the FM.";
                        }
                    }
                    break;
                }
                case 5: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "For internal use  1.";
                            break;
                        }
                        case 6: {
                            tmpResult = "For internal use  0.";
                            break;
                        }
                        case 5: {
                            tmpResult = "For internal use  0.";
                            break;
                        }
                        case 4: {
                            tmpResult = "VAT rates are set at least once.";
                            break;
                        }
                        case 3: {
                            tmpResult = "The printer is in fiscal mode.";
                            break;
                        }
                        case 2: {
                            tmpResult = "For internal use  0.";
                            break;
                        }
                        case 1: {
                            tmpResult = "Fiscal memory is formatted.";
                            break;
                        }
                        case 0: {
                            tmpResult = "For internal use  0.";
                        }
                    }
                    break;
                }
                default: {
                    tmpResult = "";
                }
            }
        }
        return tmpResult;
    }

    private boolean GetBit(byte thebyte, int position) {
        return 1 == (thebyte >> position & 1);
    }

    protected void CHECK_STATUS() throws FiscalException {
        String statusMessage = "";
        byte[] statusBytes = this.getLastStatus();
        if (!this.GetBit(statusBytes[0], 7) && isStatusCritical[0][7]) {
            statusMessage = statusMessage + this.getStatusBitDescription(0, 7) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 6) && isStatusCritical[0][6]) {
            statusMessage = statusMessage + this.getStatusBitDescription(0, 6) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 5) && isStatusCritical[0][5]) {
            statusMessage = statusMessage + this.getStatusBitDescription(0, 5) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 4) && isStatusCritical[0][4]) {
            statusMessage = statusMessage + this.getStatusBitDescription(0, 4) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 3) && isStatusCritical[0][3]) {
            statusMessage = statusMessage + this.getStatusBitDescription(0, 3) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 2) && isStatusCritical[0][2]) {
            statusMessage = statusMessage + this.getStatusBitDescription(0, 2) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 1) && isStatusCritical[0][1]) {
            statusMessage = statusMessage + this.getStatusBitDescription(0, 1) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 0) && isStatusCritical[0][0]) {
            statusMessage = statusMessage + this.getStatusBitDescription(0, 0) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[1], 7) && isStatusCritical[1][7]) {
            statusMessage = statusMessage + this.getStatusBitDescription(1, 7) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 6) && isStatusCritical[1][6]) {
            statusMessage = statusMessage + this.getStatusBitDescription(1, 6) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 5) && isStatusCritical[1][5]) {
            statusMessage = statusMessage + this.getStatusBitDescription(1, 5) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 4) && isStatusCritical[1][4]) {
            statusMessage = statusMessage + this.getStatusBitDescription(1, 4) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 3) && isStatusCritical[1][3]) {
            statusMessage = statusMessage + this.getStatusBitDescription(1, 3) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 2) && isStatusCritical[1][2]) {
            statusMessage = statusMessage + this.getStatusBitDescription(1, 2) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 1) && isStatusCritical[1][1]) {
            statusMessage = statusMessage + this.getStatusBitDescription(1, 1) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 0) && isStatusCritical[1][0]) {
            statusMessage = statusMessage + this.getStatusBitDescription(1, 0) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[2], 7) && isStatusCritical[2][7]) {
            statusMessage = statusMessage + this.getStatusBitDescription(2, 7) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 6) && isStatusCritical[2][6]) {
            statusMessage = statusMessage + this.getStatusBitDescription(2, 6) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 5) && isStatusCritical[2][5]) {
            statusMessage = statusMessage + this.getStatusBitDescription(2, 5) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 4) && isStatusCritical[2][4]) {
            statusMessage = statusMessage + this.getStatusBitDescription(2, 4) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 3) && isStatusCritical[2][3]) {
            statusMessage = statusMessage + this.getStatusBitDescription(2, 3) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 2) && isStatusCritical[2][2]) {
            statusMessage = statusMessage + this.getStatusBitDescription(2, 2) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 1) && isStatusCritical[2][1]) {
            statusMessage = statusMessage + this.getStatusBitDescription(2, 1) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 0) && isStatusCritical[2][0]) {
            statusMessage = statusMessage + this.getStatusBitDescription(2, 0) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[3], 7) && isStatusCritical[3][7]) {
            statusMessage = statusMessage + this.getStatusBitDescription(3, 7) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 6) && isStatusCritical[3][6]) {
            statusMessage = statusMessage + this.getStatusBitDescription(3, 6) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 5) && isStatusCritical[3][5]) {
            statusMessage = statusMessage + this.getStatusBitDescription(3, 5) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 4) && isStatusCritical[3][4]) {
            statusMessage = statusMessage + this.getStatusBitDescription(3, 4) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 3) && isStatusCritical[3][3]) {
            statusMessage = statusMessage + this.getStatusBitDescription(3, 3) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 2) && isStatusCritical[3][2]) {
            statusMessage = statusMessage + this.getStatusBitDescription(3, 2) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 1) && isStatusCritical[3][1]) {
            statusMessage = statusMessage + this.getStatusBitDescription(3, 1) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 0) && isStatusCritical[3][0]) {
            statusMessage = statusMessage + this.getStatusBitDescription(3, 0) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[4], 7) && isStatusCritical[4][7]) {
            statusMessage = statusMessage + this.getStatusBitDescription(4, 7) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[4], 6) && isStatusCritical[4][6]) {
            statusMessage = statusMessage + this.getStatusBitDescription(4, 6) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[4], 5) && isStatusCritical[4][5]) {
            statusMessage = statusMessage + this.getStatusBitDescription(4, 5) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[4], 4) && isStatusCritical[4][4]) {
            statusMessage = statusMessage + this.getStatusBitDescription(4, 4) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[4], 3) && isStatusCritical[4][3]) {
            statusMessage = statusMessage + this.getStatusBitDescription(4, 3) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[4], 2) && isStatusCritical[4][2]) {
            statusMessage = statusMessage + this.getStatusBitDescription(4, 2) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[4], 1) && isStatusCritical[4][1]) {
            statusMessage = statusMessage + this.getStatusBitDescription(4, 1) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[4], 0) && isStatusCritical[4][0]) {
            statusMessage = statusMessage + this.getStatusBitDescription(4, 0) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[5], 7) && isStatusCritical[5][7]) {
            statusMessage = statusMessage + this.getStatusBitDescription(5, 7) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[5], 6) && isStatusCritical[5][6]) {
            statusMessage = statusMessage + this.getStatusBitDescription(5, 6) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[5], 5) && isStatusCritical[5][5]) {
            statusMessage = statusMessage + this.getStatusBitDescription(5, 5) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[5], 4) && isStatusCritical[5][4]) {
            statusMessage = statusMessage + this.getStatusBitDescription(5, 4) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[5], 3) && isStatusCritical[5][3]) {
            statusMessage = statusMessage + this.getStatusBitDescription(5, 3) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[5], 2) && isStatusCritical[5][2]) {
            statusMessage = statusMessage + this.getStatusBitDescription(5, 2) + this.msgSeparator;
        }
        if (!this.GetBit(statusBytes[5], 1) && isStatusCritical[5][1]) {
            statusMessage = statusMessage + this.getStatusBitDescription(5, 1) + this.msgSeparator;
        }
        if (this.GetBit(statusBytes[5], 0) && isStatusCritical[5][0]) {
            statusMessage = statusMessage + this.getStatusBitDescription(5, 0) + this.msgSeparator;
        }
        if (statusMessage.length() > 0) {
            throw new FiscalException(statusMessage);
        }
    }

    private static void setupLogger() {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new Formatter(){
            private final DateFormat df = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");

            @Override
            public String format(LogRecord record) {
                StringBuilder builder = new StringBuilder(1000);
                builder.append(this.df.format(new Date(record.getMillis()))).append(" - ");
                builder.append(this.formatMessage(record));
                builder.append("\n");
                return builder.toString();
            }

            @Override
            public String getHead(Handler h) {
                return super.getHead(h);
            }

            @Override
            public String getTail(Handler h) {
                return super.getTail(h);
            }
        });
        LOGGER.setUseParentHandlers(false);
        LOGGER.addHandler(handler);
        LOGGER.setLevel(Level.OFF);
    }

    public static void setDebugLevel(Level level) {
        LOGGER.setLevel(level);
    }

    public FiscalDeviceInfo getInfo() {
        return new FiscalDeviceInfo();
    }

    protected String getParam(Object key) {
        return String.valueOf(this.parameters.get(key));
    }

    protected String getParam(Object key, String defaultValue) {
        return this.isNullOrEmpty(this.getParam(key)) ? defaultValue : this.getParam(key);
    }

    protected boolean isNullOrEmpty(String value) {
        return value == null || "".equals(value) || "null".contentEquals(value);
    }

    protected String get(String value, String defaultValue) {
        return this.isNullOrEmpty(value) ? defaultValue : value;
    }

    protected String get(String prefix, String key, String suffix) {
        return (!"".equals(this.get(key, "")) ? prefix : "") + this.get(key, "") + (!"".equals(this.get(key, "")) ? suffix : "");
    }

    protected String get(String prefix, String key, String suffix, String defaultValue) {
        return (!"".equals(this.get(key, defaultValue)) ? prefix : "") + this.get(key, defaultValue) + (!"".equals(this.get(key, defaultValue)) ? suffix : "");
    }

    protected String get(String prefixSep, String prefix, String key, String suffix, String suffixSep, String defaultValue) {
        return prefixSep + this.get(prefix, key, suffix, defaultValue) + suffixSep;
    }

    protected static String[] split(String input, String[] delimiters) {
        char[] inputBuffer = input.toCharArray();
        char[][] delimiterBuffers = new char[delimiters.length][];
        for (int i = 0; i < delimiterBuffers.length; ++i) {
            delimiterBuffers[i] = delimiters[i].toCharArray();
        }
        int numberOfDelimiters = 0;
        for (int i = 0; i < inputBuffer.length; ++i) {
            for (int j = 0; j < delimiterBuffers.length; ++j) {
                if (i + delimiterBuffers[j].length > inputBuffer.length) continue;
                boolean match = true;
                for (int k = 0; k < delimiterBuffers[j].length; ++k) {
                    if (delimiterBuffers[j][k] == inputBuffer[i + k]) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                ++numberOfDelimiters;
                i += delimiterBuffers[j].length - 1;
            }
        }
        String[] stringBuffer = new String[numberOfDelimiters + 1];
        if (stringBuffer.length == 1) {
            stringBuffer[0] = input;
        } else {
            int bufferIndex = 0;
            int startIndex = 0;
            for (int i = 0; i < inputBuffer.length; ++i) {
                for (int j = 0; j < delimiterBuffers.length; ++j) {
                    if (i + delimiterBuffers[j].length > inputBuffer.length) continue;
                    boolean match = true;
                    for (int k = 0; k < delimiterBuffers[j].length; ++k) {
                        if (delimiterBuffers[j][k] == inputBuffer[i + k]) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    stringBuffer[bufferIndex++] = new String(inputBuffer, startIndex, i - startIndex);
                    startIndex = i + delimiterBuffers[j].length;
                    i += delimiterBuffers[j].length - 1;
                }
            }
            stringBuffer[bufferIndex] = new String(inputBuffer, startIndex, inputBuffer.length - startIndex);
        }
        return stringBuffer;
    }

    protected abstract void INIT(boolean var1) throws IOException, FiscalException, IllegalArgumentException;

    public void setChkInputParams(boolean toValue) {
        this.chkInputParams = toValue;
    }

    public boolean isChkInputParams() {
        return this.chkInputParams;
    }

    public boolean notInt(String value) {
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return true;
        }
        return false;
    }

    public boolean notDbl(String value) {
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return true;
        }
        return false;
    }

    public int toInt(String value) {
        return Integer.parseInt(value);
    }

    public double toDouble(String value) {
        return Double.parseDouble(value);
    }

    protected String formatNumber(double n, int digits) {
        StringBuffer sb = new StringBuffer();
        if (digits > 0) {
            String nstr;
            sb.append((int)n);
            sb.append('.');
            n -= (double)((int)n);
            for (int i = 0; i < digits; ++i) {
                n *= 10.0;
            }
            if (n * 10.0 % 10.0 >= 5.0) {
                n += 1.0;
            }
            if ((nstr = Integer.toString((int)n)).length() < digits) {
                for (int i = 0; i < digits - nstr.length(); ++i) {
                    sb.append('0');
                }
            }
            sb.append(nstr);
        } else {
            if (n * 10.0 % 10.0 >= 5.0) {
                n += 1.0;
            }
            sb.append((int)n);
        }
        return sb.toString();
    }

    public byte[] getLastStatus() {
        return transport.getStatusBytes();
    }

    public byte[] queryStatus() throws IOException, FiscalException {
        this.customCommand(74, null);
        return transport.getStatusBytes();
    }

    public boolean getStatusBitBol(int byteIndex, int bitIndex) {
        return transport.isStatusBitTriggered(byteIndex, bitIndex);
    }

    protected String padRight(String str, int size, char padChar) {
        StringBuffer padded = new StringBuffer(str);
        while (padded.length() < size) {
            padded.append(padChar);
        }
        return padded.toString();
    }

    public abstract FiscalResponse command33Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command35Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command38Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command39Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command42Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command42Variant1Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command43Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command43Variant1Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command43Variant2Version1(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command43Variant2Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command44Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command46Variant0Version0(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command47Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract int getMaxLinesToFeed();

    public abstract FiscalResponse command48Variant0Version0(String var1, String var2, String var3, String var4) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command48Variant1Version0(String var1, String var2, String var3, String var4) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command48Variant2Version0() throws IOException, FiscalException;

    public abstract FiscalResponse command49Variant0Version0(String var1, String var2, String var3, String var4, String var5, String var6) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command49Variant1Version0(String var1, String var2, String var3, String var4, String var5, String var6) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command49Variant0Version1(String var1, String var2, String var3, String var4, String var5, String var6) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command49Variant1Version1(String var1, String var2, String var3, String var4, String var5, String var6) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command50Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command51Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command51Variant1Version0(String var1, String var2, String var3) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command51Variant2Version0(String var1, String var2, String var3) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command52Variant0Version0(String var1, String var2, String var3, String var4, String var5, String var6) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command52Variant1Version0(String var1, String var2, String var3, String var4, String var5) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command52Variant0Version1(String var1, String var2, String var3, String var4, String var5) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command52Variant1Version1(String var1, String var2, String var3, String var4, String var5) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command53Variant0Version0(String var1, String var2, String var3, String var4) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command54Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command56Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command57Variant0Version0(String var1, String var2, String var3, String var4, String var5, String var6) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command57Variant1Version0(String var1, String var2, String var3, String var4, String var5, String var6, String var7) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command58Variant0Version0(String var1, String var2, String var3, String var4, String var5) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command58Variant0Version1(String var1, String var2, String var3, String var4, String var5) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command60Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command61Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command61Variant1Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command62Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command63Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command64Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command65Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command65Variant1Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command65Variant2Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command65Variant3Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command65Variant5Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command65Variant6Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command65Variant7Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command66Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command68Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command69Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command70Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command71Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command73Variant0Version0(String var1, String var2, String var3, String var4) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command74Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command74Variant1Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command74Variant2Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command74Variant3Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command75Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command76Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command79Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command80Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command83Variant0Version0(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command83Variant1Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command84Variant0Version0(String var1, String var2, String var3) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command85Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command85Variant1Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command86Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command86Variant1Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command87Variant0Version0(String var1, String var2, String var3, String var4) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command88Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command89Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command90Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command92Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command92Variant1Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command93Variant1Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command94Variant0Version0(String var1, String var2, String var3, String var4) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command94Variant1Version0(String var1, String var2, String var3) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command95Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command97Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command98Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command99Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command100Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command101Variant0Version0(String var1, String var2, String var3) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command102Variant0Version0(String var1, String var2, String var3) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command103Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command105Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command106Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant1Version0(String var1, String var2, String var3, String var4, String var5, String var6, String var7) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant2Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant3Version0(String var1, String var2, String var3) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant4Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant5Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant6Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant7Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant8Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant9Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant10Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant11Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant12Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command108Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command109Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command110Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command111Variant0Version0(String var1, String var2, String var3, String var4) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command112Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command112Variant1Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command113Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant1Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant2Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant3Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant4Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant5Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant6Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant7Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant8Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant9Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant10Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command115Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command115Variant1Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command117Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command118Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command119Variant0Version0(String var1, String var2, String var3) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command119Variant1Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command124Variant0Version0(String var1, String var2, String var3) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command124Variant1Version0(String var1, String var2, String var3) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command124Variant2Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command125Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command125Variant1Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command125Variant1Version2() throws IOException, FiscalException, IllegalArgumentException;

    public abstract Integer getMAX_PLU();

    public Double getMAX_PRICE() {
        return this.MAX_PRICE;
    }

    public abstract Integer getMAX_DEPARTMENT();

    public abstract Integer getMaxStockGroup();

    public int getMaxNonFiscalText() {
        return 40;
    }

    public int getMaxTextHeaderFooter() {
        return 42;
    }

    public int getMaxDisplayText() {
        return 20;
    }

    public Integer getMaxOperators() {
        return this.maxOperators;
    }

    public String getDefaultOpCode() {
        return "1";
    }

    public String getDefaultOpPass() {
        return "1";
    }

    public String getDefaultTillNumber() {
        return "1";
    }

    public boolean isCapAutoCutter() {
        return this.capAutoCutter;
    }

    public int getMaxHeaderLines() {
        return 6;
    }

    public int getMaxFooterLines() {
        return 2;
    }

    public int getMaxFiscalText() {
        return 36;
    }

    public abstract int getMaxDepartments();

    public abstract int getPrintColumns();

    public abstract int getMaxBarcodeHeight_mm();

    public abstract FiscalResponse command125Variant2Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command140Variant0Version0(String var1, String var2, String var3, String var4, String var5, String var6, String var7) throws IOException, FiscalException;

    public abstract FiscalResponse command140Variant1Version0(String var1) throws IOException, FiscalException;

    public abstract FiscalResponse command140Variant2Version0(String var1) throws IOException, FiscalException;

    public abstract FiscalResponse command140Variant3Version0() throws IOException, FiscalException;

    public abstract FiscalResponse command140Variant4Version0() throws IOException, FiscalException;

    public abstract FiscalResponse command140Variant5Version0() throws IOException, FiscalException;

    public abstract FiscalResponse command140Variant6Version0() throws IOException, FiscalException;

    public abstract FiscalResponse command140Variant7Version0(String var1) throws IOException, FiscalException;

    public abstract int getMaxLogoHeightPixel();

    public abstract int getMaxLogoWidthPixel();

    public abstract int getLogoROW_NUM();

    public abstract boolean getCapFontSupported();

    public abstract boolean getCapAutoCutter();

    public abstract int getMinBarcodeHeight_mm();

    static {
        FiscalDeviceV1.setupLogger();
    }
}

