/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK;

import com.datecs.fiscalprinter.SDK.AbstractTransportProtocol;
import com.datecs.fiscalprinter.SDK.FiscalDeviceInfo;
import com.datecs.fiscalprinter.SDK.FiscalException;
import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.model.DatecsFiscalDevice;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class FiscalPrinterV1 {
    protected final int maxFooterLines = 2;
    protected final int maxHeaderLines = 6;
    protected final Double MAX_PRICE = 9.9999999E7;
    protected final Integer MAX_DEPARTMENT = 1200;
    protected final Integer MAX_PLU = 3000;
    protected final Integer MAX_STOCK_GR = 99;
    protected final Integer maxLinesToFeed = 99;
    protected final int maxDisplayText = 20;
    protected final Integer maxOperators = 16;
    protected final String defaultOpCode = "1";
    protected final String defaultOpPass = "0000";
    protected final String defaultTillNumber = "1";
    public int MAX_ADDITIONAL_PAYMENTS = 11;
    private static boolean[][] isCriticalStatus = new boolean[6][8];
    private boolean throwErrorMessage = false;
    private static String msgSeparator = "\n\r";
    static final Logger LOGGER = Logger.getLogger(FiscalPrinterV1.class.getName());
    public static AbstractTransportProtocol transport;
    protected Map<String, Object> parameters;
    protected int build;
    private boolean chkInputParams;
    private boolean autoCutInputParams;

    public boolean[][] getCriticalStatuses() {
        return isCriticalStatus;
    }

    public static void setCriticalStatuses(boolean[][] statusCritical) {
        isCriticalStatus = statusCritical;
    }

    public void setMsgSeparator(String msgSeparator) {
        FiscalPrinterV1.msgSeparator = msgSeparator;
    }

    public void setThrowErrorMessage(boolean throwErrorMessage) {
        this.throwErrorMessage = throwErrorMessage;
    }

    public final String customCommand(int cmd, String data) throws FiscalException, UnsupportedOperationException, IOException {
        String result = transport.customCommand(cmd, data);
        if (cmd != 74) {
            this.CHECK_STATUS(result);
        }
        return result;
    }

    public final synchronized void close() {
        transport.close();
    }

    public FiscalPrinterV1(AbstractTransportProtocol protocol) {
        transport = protocol;
        this.parameters = new HashMap<String, Object>();
    }

    private static void setupLogger() {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new Formatter(){
            private final DateFormat df = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");

            @Override
            public String format(LogRecord record) {
                StringBuilder builder = new StringBuilder(1000);
                builder.append(this.df.format(new Date(record.getMillis()))).append(" - ");
                builder.append(this.formatMessage(record));
                builder.append("\n");
                return builder.toString();
            }

            @Override
            public String getHead(Handler h) {
                return super.getHead(h);
            }

            @Override
            public String getTail(Handler h) {
                return super.getTail(h);
            }
        });
        LOGGER.setUseParentHandlers(false);
        LOGGER.addHandler(handler);
        LOGGER.setLevel(Level.OFF);
    }

    public String getStatusBitDescription(int byteIndex, int bitIndex) {
        String tmpResult = "";
        if (DatecsFiscalDevice.getCountryCode() == 128) {
            block0 : switch (byteIndex) {
                case 0: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "?????????? ? ?????? ? 1.";
                            break block0;
                        }
                        case 6: {
                            tmpResult = "??????? ? ??????? ?? ????????.";
                            break block0;
                        }
                        case 5: {
                            tmpResult = "???? ?????? - ???? ? OR ?? ?????? ??????, ????????? ? ?#?.";
                            break block0;
                        }
                        case 4: {
                            tmpResult = "#?????????? ?? ?????????? ?????????? ??? ????????????.";
                            break block0;
                        }
                        case 3: {
                            tmpResult = "?? ? ??????? ????????? ???????.";
                            break block0;
                        }
                        case 2: {
                            tmpResult = "?????????? ?? ? ?????????.";
                            break block0;
                        }
                        case 1: {
                            tmpResult = "#????? ?? ?????????? ??????? ? ?????????";
                            break block0;
                        }
                        case 0: {
                            tmpResult = "#?????????? ????? ???? ???????????? ??????.";
                        }
                    }
                    break;
                }
                case 1: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "?????????? ? ?????? ? 1.";
                            break block0;
                        }
                        case 6: {
                            tmpResult = "?????????? ??????? ???????? ?? ????????";
                            break block0;
                        }
                        case 5: {
                            tmpResult = "??????? ? ???????? ??? ?? ????? ?? ???????? ?? 90 ??????? ?????.";
                            break block0;
                        }
                        case 4: {
                            tmpResult = "??????? ?????? ???.";
                            break block0;
                        }
                        case 3: {
                            tmpResult = "#????? ??????? (?????????? ?? ?????? ????? ? ? ????????? RESET).";
                            break block0;
                        }
                        case 2: {
                            tmpResult = "#????????? ? ?????????? ?? ???????????? ?????.";
                            break block0;
                        }
                        case 1: {
                            tmpResult = "#???????????? ?? ????????? ?? ? ????????? ? ??????? ???????? ?????.";
                            break block0;
                        }
                        case 0: {
                            tmpResult = "??? ?????????? ?? ????????? ?? ? ???????? ?????????? ?? ????? ?????? ?? ??????.";
                        }
                    }
                    break;
                }
                case 2: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "?????????? ? ?????? ? 1.";
                            break block0;
                        }
                        case 6: {
                            tmpResult = "????? ?????? ???? ?? ???? (???????? ?? ???? ?????????? ??????).";
                            break block0;
                        }
                        case 5: {
                            tmpResult = "??????? ? ???????? ???.";
                            break block0;
                        }
                        case 4: {
                            tmpResult = "?????? ???? ?? ???? (??-????? ?? 10 MB ?? ???? ????????).";
                            break block0;
                        }
                        case 3: {
                            tmpResult = "??????? ? ???????? ???.";
                            break block0;
                        }
                        case 2: {
                            tmpResult = "???? ?? ???? (??-????? ?? 1 MB ?? ???? ????????).";
                            break block0;
                        }
                        case 1: {
                            tmpResult = "???????? ? ????? ??????.";
                            break block0;
                        }
                        case 0: {
                            tmpResult = "#???????? ? ????????.";
                        }
                    }
                    break;
                }
                case 3: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "?????????? ? ?????? ? 1.";
                            break block0;
                        }
                        case 6: {
                            tmpResult = "????????? ?? Sw7.";
                            break block0;
                        }
                        case 5: {
                            tmpResult = "????????? ?? Sw6.";
                            break block0;
                        }
                        case 4: {
                            tmpResult = "????????? ?? Sw5.";
                            break block0;
                        }
                        case 3: {
                            tmpResult = "????????? ?? Sw4.";
                            break block0;
                        }
                        case 2: {
                            tmpResult = "????????? ?? Sw3.";
                            break block0;
                        }
                        case 1: {
                            tmpResult = "????????? ?? Sw2.";
                            break block0;
                        }
                        case 0: {
                            tmpResult = "????????? ?? Sw1.";
                        }
                    }
                    break;
                }
                case 4: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "?????????? ? ?????? ? 1";
                            break block0;
                        }
                        case 6: {
                            tmpResult = "?????????? ????? ? ????????";
                            break block0;
                        }
                        case 5: {
                            tmpResult = "OR ?? ?????? ??????, ????????? ? ?*? ?? ??????? 4 ? 5.";
                            break block0;
                        }
                        case 4: {
                            tmpResult = "*?????????? ????? ? ?????.";
                            break block0;
                        }
                        case 3: {
                            tmpResult = "??? ????? ?? ??-????? ?? 50 ?????? ??? ??.";
                            break block0;
                        }
                        case 2: {
                            tmpResult = "???????? ?? ???????????? ????? ?? ???????? ? ????? ?? ?????????? ?????.";
                            break block0;
                        }
                        case 1: {
                            tmpResult = "??????? ? ??? ?? ???????.";
                            break block0;
                        }
                        case 0: {
                            tmpResult = "*??? ?????? ??? ????? ??? ?????????? ?????.";
                        }
                    }
                    break;
                }
                case 5: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "?????????? ? ?????? ? 1.";
                            break block0;
                        }
                        case 6: {
                            tmpResult = "?? ?? ?????????.";
                            break block0;
                        }
                        case 5: {
                            tmpResult = "?????? ??? ?????? ?? ?????????? ?????";
                            break block0;
                        }
                        case 4: {
                            tmpResult = "???????? ?? ???? ?????? ????????? ??????.";
                            break block0;
                        }
                        case 3: {
                            tmpResult = "????????? ? ??? ???????? ?????.";
                            break block0;
                        }
                        case 2: {
                            tmpResult = "*?????????? ????? ??? ?????????? ????? ?? ? ???????.";
                            break block0;
                        }
                        case 1: {
                            tmpResult = "?????????? ????? ? ???????????.";
                            break block0;
                        }
                        case 0: {
                            tmpResult = "*?????????? ????? ? ?????????? ? ????? READONLY (?????????).";
                        }
                    }
                    break;
                }
                default: {
                    tmpResult = "";
                    break;
                }
            }
        } else {
            switch (byteIndex) {
                case 0: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "For internal use  1.";
                            break;
                        }
                        case 6: {
                            tmpResult = "Cover is Open.";
                            break;
                        }
                        case 5: {
                            tmpResult = "General error - this is OR of all errors marked with #.";
                            break;
                        }
                        case 4: {
                            tmpResult = "# Failure in printing mechanism.";
                            break;
                        }
                        case 3: {
                            tmpResult = "No client display connected.";
                            break;
                        }
                        case 2: {
                            tmpResult = "The real time clock is not synchronized.";
                            break;
                        }
                        case 1: {
                            tmpResult = "# Command code is invalid.";
                            break;
                        }
                        case 0: {
                            tmpResult = "# Syntax error.";
                        }
                    }
                    break;
                }
                case 1: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "For internal use  1.";
                            break;
                        }
                        case 6: {
                            tmpResult = "The built-in tax terminal does not responding.";
                            break;
                        }
                        case 5: {
                            tmpResult = "An office receipt has been opened to print 90-degree text.";
                            break;
                        }
                        case 4: {
                            tmpResult = "Storno receipt is  Open.";
                            break;
                        }
                        case 3: {
                            tmpResult = "# Low battery (Real time clock RESET).";
                            break;
                        }
                        case 2: {
                            tmpResult = "# RAM reset is performed.";
                            break;
                        }
                        case 1: {
                            tmpResult = "# Command is not permitted";
                            break;
                        }
                        case 0: {
                            tmpResult = "# Overflow during command execution.";
                        }
                    }
                    break;
                }
                case 2: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "For internal use  1.";
                            break;
                        }
                        case 6: {
                            tmpResult = "EJ nearly full.(only few receipt allowed)";
                            break;
                        }
                        case 5: {
                            tmpResult = "Nonfiscal receipt is open.";
                            break;
                        }
                        case 4: {
                            tmpResult = "EJ nearly full.";
                            break;
                        }
                        case 3: {
                            tmpResult = "Fiscal receipt is Open.";
                            break;
                        }
                        case 2: {
                            tmpResult = "EJ full.";
                            break;
                        }
                        case 1: {
                            tmpResult = "Near paper end.";
                            break;
                        }
                        case 0: {
                            tmpResult = "#End of paper.";
                        }
                    }
                    break;
                }
                case 3: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "For internal use  1";
                            break;
                        }
                        case 6: {
                            tmpResult = "Sw7.";
                            break;
                        }
                        case 5: {
                            tmpResult = "Sw6.";
                            break;
                        }
                        case 4: {
                            tmpResult = "Sw5.";
                            break;
                        }
                        case 3: {
                            tmpResult = "Sw4.";
                            break;
                        }
                        case 2: {
                            tmpResult = "Sw3.";
                            break;
                        }
                        case 1: {
                            tmpResult = "Sw2.";
                            break;
                        }
                        case 0: {
                            tmpResult = "Sw1.";
                        }
                    }
                    break;
                }
                case 4: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "For internal use  1.";
                            break;
                        }
                        case 6: {
                            tmpResult = "The printer is overheated.";
                            break;
                        }
                        case 5: {
                            tmpResult = "OR of all errors marked with * by bytes 4 and 5.";
                            break;
                        }
                        case 4: {
                            tmpResult = "* Fiscal memory is full.";
                            break;
                        }
                        case 3: {
                            tmpResult = "There is space for less then 50 reports in Fiscal memory.";
                            break;
                        }
                        case 2: {
                            tmpResult = "Serial number and number of FM is set.";
                            break;
                        }
                        case 1: {
                            tmpResult = "EIK on BULSTAT has been set.";
                            break;
                        }
                        case 0: {
                            tmpResult = "* Error accessing data in the FM.";
                        }
                    }
                    break;
                }
                case 5: {
                    switch (bitIndex) {
                        case 7: {
                            tmpResult = "For internal use  1.";
                            break;
                        }
                        case 6: {
                            tmpResult = "For internal use  0.";
                            break;
                        }
                        case 5: {
                            tmpResult = "Error reading fiscal memory.";
                            break;
                        }
                        case 4: {
                            tmpResult = "VAT rates are set at least once.";
                            break;
                        }
                        case 3: {
                            tmpResult = "The printer is in fiscal mode.";
                            break;
                        }
                        case 2: {
                            tmpResult = "* The last record in fiscal memory failed.";
                            break;
                        }
                        case 1: {
                            tmpResult = "Fiscal memory is formatted.";
                            break;
                        }
                        case 0: {
                            tmpResult = "* Fiscal memory is set in READONLY(locked) mode.";
                        }
                    }
                    break;
                }
                default: {
                    tmpResult = "";
                }
            }
        }
        return tmpResult;
    }

    private boolean GetBit(byte thebyte, int position) {
        return 1 == (thebyte >> position & 1);
    }

    protected void CHECK_STATUS(String result) throws FiscalException {
        String statusMessage = "";
        byte[] statusBytes = this.getLastStatus();
        if (!this.GetBit(statusBytes[0], 7) && isCriticalStatus[0][7]) {
            statusMessage = statusMessage + this.getStatusBitDescription(0, 7) + msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 6) && isCriticalStatus[0][6]) {
            statusMessage = statusMessage + this.getStatusBitDescription(0, 6) + msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 5) && isCriticalStatus[0][5]) {
            statusMessage = statusMessage + this.getStatusBitDescription(0, 5) + msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 4) && isCriticalStatus[0][4]) {
            statusMessage = statusMessage + this.getStatusBitDescription(0, 4) + msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 3) && isCriticalStatus[0][3]) {
            statusMessage = statusMessage + this.getStatusBitDescription(0, 3) + msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 2) && isCriticalStatus[0][2]) {
            statusMessage = statusMessage + this.getStatusBitDescription(0, 2) + msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 1) && isCriticalStatus[0][1]) {
            statusMessage = statusMessage + this.getStatusBitDescription(0, 1) + msgSeparator;
        }
        if (this.GetBit(statusBytes[0], 0) && isCriticalStatus[0][0]) {
            statusMessage = statusMessage + this.getStatusBitDescription(0, 0) + msgSeparator;
        }
        if (!this.GetBit(statusBytes[1], 7) && isCriticalStatus[1][7]) {
            statusMessage = statusMessage + this.getStatusBitDescription(1, 7) + msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 6) && isCriticalStatus[1][6]) {
            statusMessage = statusMessage + this.getStatusBitDescription(1, 6) + msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 5) && isCriticalStatus[1][5]) {
            statusMessage = statusMessage + this.getStatusBitDescription(1, 5) + msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 4) && isCriticalStatus[1][4]) {
            statusMessage = statusMessage + this.getStatusBitDescription(1, 4) + msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 3) && isCriticalStatus[1][3]) {
            statusMessage = statusMessage + this.getStatusBitDescription(1, 3) + msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 2) && isCriticalStatus[1][2]) {
            statusMessage = statusMessage + this.getStatusBitDescription(1, 2) + msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 1) && isCriticalStatus[1][1]) {
            statusMessage = statusMessage + this.getStatusBitDescription(1, 1) + msgSeparator;
        }
        if (this.GetBit(statusBytes[1], 0) && isCriticalStatus[1][0]) {
            statusMessage = statusMessage + this.getStatusBitDescription(1, 0) + msgSeparator;
        }
        if (!this.GetBit(statusBytes[2], 7) && isCriticalStatus[2][7]) {
            statusMessage = statusMessage + this.getStatusBitDescription(2, 7) + msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 6) && isCriticalStatus[2][6]) {
            statusMessage = statusMessage + this.getStatusBitDescription(2, 6) + msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 5) && isCriticalStatus[2][5]) {
            statusMessage = statusMessage + this.getStatusBitDescription(2, 5) + msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 4) && isCriticalStatus[2][4]) {
            statusMessage = statusMessage + this.getStatusBitDescription(2, 4) + msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 3) && isCriticalStatus[2][3]) {
            statusMessage = statusMessage + this.getStatusBitDescription(2, 3) + msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 2) && isCriticalStatus[2][2]) {
            statusMessage = statusMessage + this.getStatusBitDescription(2, 2) + msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 1) && isCriticalStatus[2][1]) {
            statusMessage = statusMessage + this.getStatusBitDescription(2, 1) + msgSeparator;
        }
        if (this.GetBit(statusBytes[2], 0) && isCriticalStatus[2][0]) {
            statusMessage = statusMessage + this.getStatusBitDescription(2, 0) + msgSeparator;
        }
        if (!this.GetBit(statusBytes[3], 7) && isCriticalStatus[3][7]) {
            statusMessage = statusMessage + this.getStatusBitDescription(3, 7) + msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 6) && isCriticalStatus[3][6]) {
            statusMessage = statusMessage + this.getStatusBitDescription(3, 6) + msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 5) && isCriticalStatus[3][5]) {
            statusMessage = statusMessage + this.getStatusBitDescription(3, 5) + msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 4) && isCriticalStatus[3][4]) {
            statusMessage = statusMessage + this.getStatusBitDescription(3, 4) + msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 3) && isCriticalStatus[3][3]) {
            statusMessage = statusMessage + this.getStatusBitDescription(3, 3) + msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 2) && isCriticalStatus[3][2]) {
            statusMessage = statusMessage + this.getStatusBitDescription(3, 2) + msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 1) && isCriticalStatus[3][1]) {
            statusMessage = statusMessage + this.getStatusBitDescription(3, 1) + msgSeparator;
        }
        if (this.GetBit(statusBytes[3], 0) && isCriticalStatus[3][0]) {
            statusMessage = statusMessage + this.getStatusBitDescription(3, 0) + msgSeparator;
        }
        if (!this.GetBit(statusBytes[4], 7) && isCriticalStatus[4][7]) {
            statusMessage = statusMessage + this.getStatusBitDescription(4, 7) + msgSeparator;
        }
        if (this.GetBit(statusBytes[4], 6) && isCriticalStatus[4][6]) {
            statusMessage = statusMessage + this.getStatusBitDescription(4, 4) + msgSeparator;
        }
        if (this.GetBit(statusBytes[4], 5) && isCriticalStatus[4][5]) {
            statusMessage = statusMessage + this.getStatusBitDescription(4, 5) + msgSeparator;
        }
        if (this.GetBit(statusBytes[4], 4) && isCriticalStatus[4][4]) {
            statusMessage = statusMessage + this.getStatusBitDescription(4, 4) + msgSeparator;
        }
        if (this.GetBit(statusBytes[4], 3) && isCriticalStatus[4][3]) {
            statusMessage = statusMessage + this.getStatusBitDescription(4, 3) + msgSeparator;
        }
        if (!this.GetBit(statusBytes[4], 2) && isCriticalStatus[4][2]) {
            statusMessage = statusMessage + this.getStatusBitDescription(4, 2) + msgSeparator;
        }
        if (!this.GetBit(statusBytes[4], 1) && isCriticalStatus[4][1]) {
            statusMessage = statusMessage + this.getStatusBitDescription(4, 1) + msgSeparator;
        }
        if (this.GetBit(statusBytes[4], 0) && isCriticalStatus[4][0]) {
            statusMessage = statusMessage + this.getStatusBitDescription(4, 0) + msgSeparator;
        }
        if (!this.GetBit(statusBytes[5], 7) && isCriticalStatus[5][7]) {
            statusMessage = statusMessage + this.getStatusBitDescription(5, 7) + msgSeparator;
        }
        if (this.GetBit(statusBytes[5], 6) && isCriticalStatus[5][6]) {
            statusMessage = statusMessage + this.getStatusBitDescription(5, 6) + msgSeparator;
        }
        if (this.GetBit(statusBytes[5], 5) && isCriticalStatus[5][5]) {
            statusMessage = statusMessage + this.getStatusBitDescription(5, 5) + msgSeparator;
        }
        if (!this.GetBit(statusBytes[5], 4) && isCriticalStatus[5][4]) {
            statusMessage = statusMessage + this.getStatusBitDescription(5, 4) + msgSeparator;
        }
        if (!this.GetBit(statusBytes[5], 3) && isCriticalStatus[5][3]) {
            statusMessage = statusMessage + this.getStatusBitDescription(5, 3) + msgSeparator;
        }
        if (this.GetBit(statusBytes[5], 2) && isCriticalStatus[5][2]) {
            statusMessage = statusMessage + this.getStatusBitDescription(5, 2) + msgSeparator;
        }
        if (!this.GetBit(statusBytes[5], 1) && isCriticalStatus[5][1]) {
            statusMessage = statusMessage + this.getStatusBitDescription(5, 1) + msgSeparator;
        }
        if (this.GetBit(statusBytes[5], 0) && isCriticalStatus[5][0]) {
            statusMessage = statusMessage + this.getStatusBitDescription(5, 0) + msgSeparator;
        }
        if (this.throwErrorMessage && (result.startsWith("@") || result.startsWith("@", 1))) {
            statusMessage = statusMessage + msgSeparator + result;
        }
        if (statusMessage.length() > 0) {
            throw new FiscalException(statusMessage);
        }
    }

    public static void setDebugLevel(Level level) {
        LOGGER.setLevel(level);
    }

    public FiscalDeviceInfo getInfo() {
        return new FiscalDeviceInfo();
    }

    protected String getParam(Object key) {
        return String.valueOf(this.parameters.get(key));
    }

    protected String getParam(Object key, String defaultValue) {
        return this.isNullOrEmpty(this.getParam(key)) ? defaultValue : this.getParam(key);
    }

    protected boolean isNullOrEmpty(String value) {
        return value == null || "".equals(value) || "null".contentEquals(value);
    }

    protected String get(String value, String defaultValue) {
        return this.isNullOrEmpty(value) ? defaultValue : value;
    }

    protected String get(String prefix, String key, String suffix) {
        return (!"".equals(this.get(key, "")) ? prefix : "") + this.get(key, "") + (!"".equals(this.get(key, "")) ? suffix : "");
    }

    protected String get(String prefix, String key, String suffix, String defaultValue) {
        return (!"".equals(this.get(key, defaultValue)) ? prefix : "") + this.get(key, defaultValue) + (!"".equals(this.get(key, defaultValue)) ? suffix : "");
    }

    protected String get(String prefixSep, String prefix, String key, String suffix, String suffixSep, String defaultValue) {
        return prefixSep + this.get(prefix, key, suffix, defaultValue) + suffixSep;
    }

    protected static String[] split(String input, String[] delimiters) {
        char[] inputBuffer = input.toCharArray();
        char[][] delimiterBuffers = new char[delimiters.length][];
        for (int i = 0; i < delimiterBuffers.length; ++i) {
            delimiterBuffers[i] = delimiters[i].toCharArray();
        }
        int numberOfDelimiters = 0;
        for (int i = 0; i < inputBuffer.length; ++i) {
            for (int j = 0; j < delimiterBuffers.length; ++j) {
                if (i + delimiterBuffers[j].length > inputBuffer.length) continue;
                boolean match = true;
                for (int k = 0; k < delimiterBuffers[j].length; ++k) {
                    if (delimiterBuffers[j][k] == inputBuffer[i + k]) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                ++numberOfDelimiters;
                i += delimiterBuffers[j].length - 1;
            }
        }
        String[] stringBuffer = new String[numberOfDelimiters + 1];
        if (stringBuffer.length == 1) {
            stringBuffer[0] = input;
        } else {
            int bufferIndex = 0;
            int startIndex = 0;
            for (int i = 0; i < inputBuffer.length; ++i) {
                for (int j = 0; j < delimiterBuffers.length; ++j) {
                    if (i + delimiterBuffers[j].length > inputBuffer.length) continue;
                    boolean match = true;
                    for (int k = 0; k < delimiterBuffers[j].length; ++k) {
                        if (delimiterBuffers[j][k] == inputBuffer[i + k]) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    stringBuffer[bufferIndex++] = new String(inputBuffer, startIndex, i - startIndex);
                    startIndex = i + delimiterBuffers[j].length;
                    i += delimiterBuffers[j].length - 1;
                }
            }
            stringBuffer[bufferIndex] = new String(inputBuffer, startIndex, inputBuffer.length - startIndex);
        }
        return stringBuffer;
    }

    protected abstract void INIT(boolean var1, boolean var2) throws IOException, FiscalException, IllegalArgumentException;

    public void setChkInputParams(boolean toValue) {
        this.chkInputParams = toValue;
    }

    public boolean isChkInputParams() {
        return this.chkInputParams;
    }

    public void setAutoCutInputParams(boolean toValue) {
        this.autoCutInputParams = toValue;
    }

    public abstract FiscalResponse command48Variant2Version1() throws IOException, FiscalException;

    public abstract boolean isPaperCuttingDevice();

    public abstract FiscalResponse command119Variant11Version1() throws IOException, FiscalException, IllegalArgumentException;

    public abstract int getMaxLogoHeightPixel();

    public abstract int getMaxLogoWidthPixel();

    public abstract int getMaxBarcodeHeight_mm();

    public abstract int getMinBarcodeHeight_mm();

    public abstract int getLogoROW_NUM();

    public abstract boolean getcapFontSupported();

    public boolean getCapAutoCutter() {
        return this.autoCutInputParams;
    }

    public boolean notInt(String value) {
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return true;
        }
        return false;
    }

    public boolean notDbl(String value) {
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return true;
        }
        return false;
    }

    public int toInt(String value) {
        return Integer.parseInt(value);
    }

    public double toDouble(String value) {
        return Double.parseDouble(value);
    }

    protected String formatNumber(double n, int digits) {
        StringBuffer sb = new StringBuffer();
        if (digits > 0) {
            String nstr;
            sb.append((int)n);
            sb.append('.');
            n -= (double)((int)n);
            for (int i = 0; i < digits; ++i) {
                n *= 10.0;
            }
            if (n * 10.0 % 10.0 >= 5.0) {
                n += 1.0;
            }
            if ((nstr = Integer.toString((int)n)).length() < digits) {
                for (int i = 0; i < digits - nstr.length(); ++i) {
                    sb.append('0');
                }
            }
            sb.append(nstr);
        } else {
            if (n * 10.0 % 10.0 >= 5.0) {
                n += 1.0;
            }
            sb.append((int)n);
        }
        return sb.toString();
    }

    public byte[] getLastStatus() {
        return transport.getStatusBytes();
    }

    public byte[] queryStatus() throws IOException, FiscalException {
        this.customCommand(74, null);
        return transport.getStatusBytes();
    }

    public boolean getStatusBitBol(int byteIndex, int bitIndex) {
        return transport.isStatusBitTriggered(byteIndex, bitIndex);
    }

    protected String padRight(String str, int size, char padChar) {
        StringBuffer padded = new StringBuffer(str);
        while (padded.length() < size) {
            padded.append(padChar);
        }
        return padded.toString();
    }

    public abstract FiscalResponse command32Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command33Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command35Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command36Variant0Version0(String var1, String var2, String var3, String var4, String var5, String var6) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command36Variant1Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command37Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command37Variant1Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command37Variant2Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command37Variant3Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command37Variant4Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command37Variant5Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command37Variant6Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command37Variant7Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command38Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command39Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command41Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command42Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command42Variant1Version0(String var1, String var2, String var3) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command43Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command43Variant1Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command43Variant2Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command43Variant2Version1(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command44Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command45Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command46Variant0Version0(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command47Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract int getMaxLinesToFeed();

    public abstract FiscalResponse command48Variant0Version0(String var1, String var2, String var3, String var4) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command48Variant1Version0(String var1, String var2, String var3, String var4) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command48Variant2Version2() throws IOException, FiscalException;

    public abstract FiscalResponse command49Variant0Version0(String var1, String var2, String var3, String var4, String var5, String var6, String var7) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command49Variant1Version0(String var1, String var2, String var3, String var4, String var5, String var6, String var7) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command49Variant0Version1(String var1, String var2, String var3, String var4, String var5, String var6, String var7) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command49Variant1Version1(String var1, String var2, String var3, String var4, String var5, String var6, String var7) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command50Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command51Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command51Variant1Version0(String var1, String var2, String var3) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command51Variant2Version0(String var1, String var2, String var3) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command52Variant0Version0(String var1, String var2, String var3, String var4, String var5, String var6) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command52Variant1Version0(String var1, String var2, String var3, String var4, String var5, String var6) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command52Variant0Version1(String var1, String var2, String var3, String var4, String var5, String var6) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command52Variant1Version1(String var1, String var2, String var3, String var4, String var5, String var6) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command53Variant0Version0(String var1, String var2, String var3, String var4) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command54Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command54Variant1Version0(String var1, String var2, String var3) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command56Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command57Variant0Version0(String var1, String var2, String var3, String var4, String var5, String var6) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command57Variant1Version0(String var1, String var2, String var3, String var4, String var5, String var6, String var7) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command57Variant2Version0(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command58Variant0Version0(String var1, String var2, String var3, String var4, String var5, String var6) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command58Variant0Version1(String var1, String var2, String var3, String var4, String var5, String var6) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command60Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command61Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command61Variant1Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command62Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command63Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command64Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command65Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command66Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command68Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command69Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command70Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command71Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command73Variant0Version0(String var1, String var2, String var3, String var4) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command74Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command74Variant1Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command74Variant2Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command74Variant3Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command75Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command76Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command79Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command80Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command80Variant1Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command81Variant1Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command83Variant0Version0(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10, String var11, String var12) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command83Variant1Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command84Variant0Version0(String var1, String var2, String var3, String var4, String var5) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command85Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command85Variant1Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command86Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command86Variant1Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command87Variant0Version0(String var1, String var2, String var3, String var4) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command88Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command90Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command92Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command92Variant1Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command93Variant1Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command94Variant0Version0(String var1, String var2, String var3, String var4) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command94Variant1Version0(String var1, String var2, String var3) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command95Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command97Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command99Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command100Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command101Variant0Version0(String var1, String var2, String var3) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command102Variant0Version0(String var1, String var2, String var3) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command103Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command105Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command106Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant1Version0(String var1, String var2, String var3, String var4, String var5, String var6, String var7) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant2Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant3Version0(String var1, String var2, String var3) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant4Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant5Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant6Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant7Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant8Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant9Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant10Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant11Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command107Variant12Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command108Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command109Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command110Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command110Variant1Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command111Variant0Version0(String var1, String var2, String var3, String var4) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command112Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command113Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant1Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant2Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant3Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant4Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant5Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant6Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant7Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant8Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant9Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command114Variant10Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command115Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command115Variant1Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command117Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command118Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command119Variant0Version0(String var1, String var2, String var3) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command119Variant1Version0(String var1, String var2, String var3, String var4) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command119Variant2Version0(String var1, String var2, String var3) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command119Variant3Version0(String var1, String var2, String var3, String var4) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command119Variant4Version0(String var1, String var2, String var3, String var4) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command119Variant5Version0(String var1, String var2, String var3, String var4, String var5) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command119Variant6Version1() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command119Variant7Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command119Variant8Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command119Variant9Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command48Variant2Version0() throws IOException, FiscalException;

    public static boolean[][] getIsCriticalStatus() {
        return isCriticalStatus;
    }

    public boolean isThrowErrorMessage() {
        return this.throwErrorMessage;
    }

    public static String getMsgSeparator() {
        return msgSeparator;
    }

    public boolean isAutoCutInputParams() {
        return this.autoCutInputParams;
    }

    public int getMaxFooterLines() {
        return 2;
    }

    public abstract FiscalResponse command119Variant10Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command119Variant10Version1() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command119Variant11Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command148Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command149Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command151Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command152Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command153Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command154Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command155Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command156Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command157Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command158Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command159Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command160Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command161Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command162Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command163Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command164Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command165Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command166Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command167Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command168Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command169Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command172Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command173Variant0Version0() throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command174Variant0Version0(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command175Variant0Version0(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public abstract FiscalResponse command175Variant0Version1(String var1) throws IOException, FiscalException, IllegalArgumentException;

    public int getMaxHeaderLines() {
        return 6;
    }

    public Integer getMAX_PLU() {
        return this.MAX_PLU;
    }

    public Double getMAX_PRICE() {
        return this.MAX_PRICE;
    }

    public Integer getMAX_DEPARTMENT() {
        return this.MAX_DEPARTMENT;
    }

    public int getMaxStockGroup() {
        return this.MAX_STOCK_GR;
    }

    public int getMaxDisplayText() {
        return 20;
    }

    public Integer getMaxOperators() {
        return this.maxOperators;
    }

    public String getDefaultOpCode() {
        return "1";
    }

    public String getDefaultOpPass() {
        return "0000";
    }

    public String getDefaultTillNumber() {
        return "1";
    }

    public abstract int getPrintColumns();

    public abstract int getMaxNonFiscalText();

    public abstract FiscalResponse command114Variant1Version1(String var1, String var2) throws IOException, FiscalException, IllegalArgumentException;

    static {
        FiscalPrinterV1.setupLogger();
    }
}

