/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK.model;

import com.datecs.fiscalprinter.SDK.FiscalDeviceV1;
import com.datecs.fiscalprinter.SDK.FiscalDeviceV2;
import com.datecs.fiscalprinter.SDK.FiscalException;
import com.datecs.fiscalprinter.SDK.FiscalExceptionV1;
import com.datecs.fiscalprinter.SDK.FiscalPrinterV1;
import com.datecs.fiscalprinter.SDK.FiscalResponse;
import com.datecs.fiscalprinter.SDK.model.UserLayerV1.cmdInfo;

public class DatecsFiscalDevice {
    static boolean checkLastErroor = false;
    private static int countryCode;
    private static FiscalDeviceV1 connectedModelV1;
    private static FiscalPrinterV1 connectedPrinterV1;
    private static FiscalDeviceV2 connectedModelV2;

    public static boolean isCheckLastError() {
        return checkLastErroor;
    }

    public void setCheckLastError(boolean checkLastErro) {
        checkLastErroor = checkLastErro;
    }

    public static int getCountryCode() {
        return countryCode;
    }

    public static void setCountryCode(int countryCode) {
        DatecsFiscalDevice.countryCode = countryCode;
    }

    public DatecsFiscalDevice() {
    }

    public static FiscalDeviceV1 getConnectedECRV1() {
        return connectedModelV1;
    }

    public static FiscalPrinterV1 getConnectedPrinterV1() {
        return connectedPrinterV1;
    }

    public static FiscalDeviceV2 getConnectedModelV2() {
        return connectedModelV2;
    }

    public void setConnectedModel(FiscalDeviceV1 connectedModel) {
        connectedModelV1 = connectedModel;
    }

    public void setConnectedModel(FiscalPrinterV1 connectedFP) {
        connectedPrinterV1 = connectedFP;
    }

    public void setConnectedModel(FiscalDeviceV2 connectedFP) {
        connectedModelV2 = connectedFP;
    }

    public DatecsFiscalDevice(int countryCode) {
        DatecsFiscalDevice.countryCode = countryCode;
    }

    public void close() {
        if (connectedModelV1 != null) {
            connectedModelV1.close();
            connectedModelV1 = null;
        }
        if (connectedPrinterV1 != null) {
            connectedPrinterV1.close();
            connectedPrinterV1 = null;
        }
        if (connectedModelV2 != null) {
            connectedModelV2.close();
            connectedModelV2 = null;
        }
    }

    protected void checkErrorCode() throws Exception {
        int errorCode;
        if (this.isConnectedPrinter() && checkLastErroor && (errorCode = new cmdInfo().GetErrorCode(true)) != 0) {
            throw new FiscalExceptionV1(errorCode, countryCode);
        }
    }

    public static void checkErrorCode(FiscalResponse commandResult) throws FiscalException {
    }

    public boolean isConnectedPrinter() {
        return connectedPrinterV1 != null;
    }

    public boolean isConnectedECR() {
        return connectedModelV1 != null;
    }

    public boolean isConnectedDeviceV2() {
        return connectedModelV2 != null;
    }

    public int getMaxStockGroup() {
        if (this.isConnectedDeviceV2()) {
            return connectedModelV2.getMaxStockGroup();
        }
        if (this.isConnectedECR()) {
            return connectedModelV1.getMaxStockGroup();
        }
        if (this.isConnectedPrinter()) {
            return connectedPrinterV1.getMaxStockGroup();
        }
        return 0;
    }

    public int getMaxDepartments() {
        if (this.isConnectedDeviceV2()) {
            return connectedModelV2.getMAX_DEPARTMENT();
        }
        if (this.isConnectedECR()) {
            return connectedModelV1.getMAX_DEPARTMENT();
        }
        if (this.isConnectedPrinter()) {
            return connectedPrinterV1.getMAX_DEPARTMENT();
        }
        return 0;
    }

    public boolean isPaperCuttingDevice() {
        if (this.isConnectedDeviceV2()) {
            return connectedModelV2.getCapAutoCutter();
        }
        if (this.isConnectedECR()) {
            return connectedModelV1.getCapAutoCutter();
        }
        if (this.isConnectedPrinter()) {
            return connectedPrinterV1.getCapAutoCutter();
        }
        return false;
    }

    public boolean isFontSupported() {
        if (this.isConnectedDeviceV2()) {
            return connectedModelV2.getcapFontSupported();
        }
        if (this.isConnectedECR()) {
            return connectedModelV1.getCapFontSupported();
        }
        if (this.isConnectedPrinter()) {
            return connectedPrinterV1.getcapFontSupported();
        }
        return false;
    }

    public boolean isEditItemQTY() {
        if (this.isConnectedDeviceV2()) {
            return true;
        }
        if (this.isConnectedECR()) {
            return false;
        }
        return this.isConnectedPrinter();
    }

    public boolean isEditItemPrice() {
        if (this.isConnectedDeviceV2()) {
            return true;
        }
        if (this.isConnectedECR()) {
            return false;
        }
        return this.isConnectedPrinter();
    }

    static {
        connectedModelV1 = null;
        connectedPrinterV1 = null;
        connectedModelV2 = null;
    }
}

