/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class Logger {
    private final String className;
    private static boolean enabled = false;
    private static BufferedWriter writer = null;

    private Logger(String className) {
        this.className = className;
    }

    public void deleteFile() throws Exception {
        this.closeFile();
        File file = new File(this.getFileName());
        if (file.exists()) {
            file.delete();
        }
    }

    public void closeFile() throws Exception {
        if (writer != null) {
            writer.close();
        }
        writer = null;
    }

    public static synchronized Logger getLogger(Class c) {
        return Logger.getLogger(c.getName());
    }

    public static synchronized Logger getLogger(String className) {
        return new Logger(className);
    }

    public synchronized void fatal(String text, Throwable e) {
        this.error(text + e.getMessage());
    }

    public synchronized void error(String text, Throwable e) {
        this.error(text + e.getMessage());
    }

    public synchronized void error(Throwable e) {
        this.error(e.getMessage());
    }

    public synchronized void error(String text) {
        this.write("ERROR", text);
    }

    public synchronized void debug(String text) {
        this.write("DEBUG", text);
    }

    public void setEnabled(boolean value) {
        enabled = value;
    }

    public String getFileName() {
        return "javapos.log";
    }

    public synchronized void write(String prefix, String text) {
        if (!enabled) {
            return;
        }
        try {
            if (writer == null) {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.getFileName()), "UTF8"));
            }
            Date date = Calendar.getInstance().getTime();
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");
            String line = sdf.format(date) + " " + prefix + " " + this.className + " - " + text;
            writer.write(line);
            writer.newLine();
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

