/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.util;

public class EGNValidator {
    private static int[] weights = new int[]{2, 4, 8, 5, 10, 9, 7, 3, 6};
    private String egn = null;

    public EGNValidator(String egn) {
        this.egn = egn;
    }

    public String getEgn() {
        return this.egn;
    }

    public void setEgn(String egn) {
        this.egn = egn;
    }

    public boolean isValid() {
        int year = -1;
        int month = -1;
        int day = -1;
        int num = -1;
        int checkSum = 0;
        if (this.egn.length() != 10) {
            System.out.println("Expected length of 10, actual:" + this.egn.length());
            return false;
        }
        try {
            Long.parseLong(this.egn);
        }
        catch (NumberFormatException ex) {
            System.out.println("EGN should contain only numbers!");
            return false;
        }
        year = Integer.parseInt(this.egn.substring(0, 2));
        System.out.println("year: " + year);
        if (year < 0 || year > 99) {
            System.out.println("Expected year between 00..99,  actual:" + year);
            return false;
        }
        month = Integer.parseInt(this.egn.substring(2, 4));
        System.out.println("month before adjustment: " + month);
        if (month > 20 && month < 40) {
            month -= 20;
        } else if (month > 40) {
            month -= 40;
        }
        System.out.println("month: " + month);
        if (month < 1 || month > 12) {
            System.out.println("Month should be between 1..12,  actual:" + month);
            return false;
        }
        day = Integer.parseInt(this.egn.substring(4, 6));
        System.out.println("day: " + day);
        if (day < 1 || day > 31) {
            return false;
        }
        num = Integer.parseInt(this.egn.substring(6, 9));
        System.out.println("number of birth: " + num);
        for (int i = 0; i < this.egn.length() - 1; ++i) {
            checkSum += (this.egn.charAt(i) - 48) * weights[i];
        }
        System.out.println("Checksum: " + (checkSum %= 11));
        if (checkSum != this.egn.charAt(9) - 48) {
            System.out.println("Checksum not correct expected " + (this.egn.charAt(9) - 48) + " actual " + checkSum);
            return false;
        }
        System.out.println("EGN is valid!");
        return true;
    }
}

