/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.SDK;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class FiscalSocket {
    private static final Logger LOGGER = Logger.getLogger(FiscalSocket.class.getName());
    private final InputStream in;
    private final OutputStream out;
    private final List<Byte> queue;
    private IOException ex = null;
    private Listener listener;

    private static void setupLogger() {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new Formatter(){
            private final DateFormat df = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");

            @Override
            public String format(LogRecord record) {
                StringBuilder builder = new StringBuilder(1000);
                builder.append(this.df.format(new Date(record.getMillis()))).append(" - ");
                builder.append(this.formatMessage(record));
                builder.append("\n");
                return builder.toString();
            }

            @Override
            public String getHead(Handler h) {
                return super.getHead(h);
            }

            @Override
            public String getTail(Handler h) {
                return super.getTail(h);
            }
        });
        LOGGER.setUseParentHandlers(false);
        LOGGER.addHandler(handler);
        LOGGER.setLevel(Level.OFF);
    }

    public static void setDebugLevel(Level level) {
        LOGGER.setLevel(level);
    }

    public void close() {
        this.ex = new IOException("Closed by user");
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String byteArrayToHexString(byte[] data, int offset, int length) {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] buf = new char[length * 3];
        int offs = 0;
        for (int i = 0; i < length; ++i) {
            buf[offs++] = hex[data[offset + i] >> 4 & 0xF];
            buf[offs++] = hex[data[offset + i] >> 0 & 0xF];
            buf[offs++] = 32;
        }
        return new String(buf, 0, offs);
    }

    public FiscalSocket(final InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.queue = new LinkedList<Byte>();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                byte[] buffer = new byte[1024];
                try {
                    while (FiscalSocket.this.ex == null) {
                        int readed = in.read(buffer);
                        if (readed == 0) {
                            try {
                                Thread.sleep(10L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                        }
                        if (readed < 0) {
                            throw new IOException("The end of the stream has been reached");
                        }
                        if (readed <= 0) continue;
                        LOGGER.severe("receive(" + readed + "): " + FiscalSocket.byteArrayToHexString(buffer, 0, readed));
                        List list = FiscalSocket.this.queue;
                        synchronized (list) {
                            for (int el = 0; el < readed; ++el) {
                                FiscalSocket.this.queue.add(buffer[el]);
                            }
                            FiscalSocket.this.queue.notify();
                        }
                    }
                    return;
                }
                catch (IOException ioe) {
                    FiscalSocket.this.ex = ioe;
                    return;
                }
                finally {
                    Listener l = FiscalSocket.this.listener;
                    if (l != null) {
                        l.onDisconnect(FiscalSocket.this.ex);
                    }
                }
            }
        }).start();
    }

    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        LOGGER.severe("send(" + len + "): " + FiscalSocket.byteArrayToHexString(b, off, len));
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        List<Byte> list = this.queue;
        synchronized (list) {
            this.queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(int timeout) throws IOException {
        List<Byte> list = this.queue;
        synchronized (list) {
            if (this.queue.isEmpty()) {
                try {
                    this.queue.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.queue.isEmpty()) {
                    throw new IOException("Timeout");
                }
            }
            return this.queue.remove(0) & 0xFF;
        }
    }

    public byte[] read(int bytes, int timeout) throws IOException {
        byte[] buf = new byte[bytes];
        for (int i = 0; i < bytes; ++i) {
            buf[i] = (byte)this.read(timeout);
        }
        return buf;
    }

    public void read(byte[] buf, int offset, int len, int timeout) throws IOException {
        for (int i = 0; i < len; ++i) {
            buf[offset + i] = (byte)this.read(timeout);
        }
    }

    static {
        FiscalSocket.setupLogger();
    }

    public static interface Listener {
        public void onDisconnect(Exception var1);
    }
}

