/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter.rou;

import com.datecs.fiscalprinter.FPBase;
import com.datecs.fiscalprinter.FiscalPrinterException;
import com.datecs.fiscalprinter.FiscalResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DP25ROU
extends FPBase {
    private int deviceType;
    private int modelType;
    private int countryCode;
    private int deviceDealerCode;
    private int MajorVersion;
    private int BuildNumber;
    private String deviceName;
    private String serialNumber;
    private String defaultOpCode;
    private String defaultOpPass;
    private String defaultTillNumber;

    public int getDeviceType() {
        return this.deviceType;
    }

    public int getModelType() {
        return this.modelType;
    }

    public int getCountryCode() {
        return this.countryCode;
    }

    public int getDealerCode() {
        return this.deviceDealerCode;
    }

    public int getMajorVersion() {
        return this.MajorVersion;
    }

    public int getBuildNumber() {
        return this.BuildNumber;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    private void setModelRestrictions() {
        switch (this.modelType) {
            case 100001: {
                this.defaultOpCode = "1";
                this.defaultOpPass = "1";
                this.defaultTillNumber = "1";
                break;
            }
            case 200001: {
                this.defaultOpCode = "1";
                this.defaultOpPass = "0000";
                this.defaultTillNumber = "1";
            }
        }
    }

    @Override
    protected void CHECK_STATUS() throws FiscalPrinterException {
        if ((this.mSB[0] & 0x20) > 0) {
            throw new FiscalPrinterException("General error OR of all errors marked with \u2018#\u2019", this.mSB);
        }
        if ((this.mSB[0] & 4) > 0) {
            throw new FiscalPrinterException("Printer clock is not set", this.mSB);
        }
        if ((this.mSB[0] & 2) > 0) {
            throw new FiscalPrinterException("Code of incoming command is invalid", this.mSB);
        }
        if ((this.mSB[0] & 1) > 0) {
            throw new FiscalPrinterException("Incoming data has syntax error", this.mSB);
        }
        if ((this.mSB[1] & 4) > 0) {
            throw new FiscalPrinterException("# Electronic journal end (95% full)", this.mSB);
        }
        if ((this.mSB[1] & 2) > 0) {
            throw new FiscalPrinterException("If command cannot be performed in the current fiscal mode", this.mSB);
        }
        if ((this.mSB[1] & 1) > 0) {
            throw new FiscalPrinterException("If during command some of the fields for the sums overflow.", this.mSB);
        }
        if ((this.mSB[2] & 1) > 0) {
            throw new FiscalPrinterException("# Out of paper", this.mSB);
        }
        if ((this.mSB[4] & 0x20) > 0) {
            throw new FiscalPrinterException("OR of all mistakes marked by \u2018*\u2019 from bytes 4 and 5", this.mSB);
        }
        if ((this.mSB[4] & 0x10) > 0) {
            throw new FiscalPrinterException("* Fiscal memory is full", this.mSB);
        }
        if ((this.mSB[4] & 1) > 0) {
            throw new FiscalPrinterException("* Fiscal memory write error", this.mSB);
        }
    }

    private FiscalResponse detectDevice() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String OutpS = "";
        FiscalResponse R = new FiscalResponse(8);
        try {
            OutpS = this.customCommand(90, "1");
        }
        catch (FiscalPrinterException F) {
            byte[] bArr = F.getStatusBytes();
            if ((bArr[0] & 2) <= 0 && (bArr[0] & 1) <= 0) {
                throw F;
            }
        }
        catch (IOException E) {
            this.close();
            throw E;
        }
        String[] myOutputList = this.split(OutpS, new String[]{",", " "});
        try {
            R.put("printerName", myOutputList[0]);
            R.put("firmwareRevision", myOutputList[1]);
            R.put("firmwareDate", myOutputList[2]);
            R.put("firmwareTime", myOutputList[3]);
            R.put("checkSum", myOutputList[4]);
            R.put("softwareSwitches", myOutputList[5]);
            R.put("serialNumber", myOutputList[6]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.modelType = -1;
        this.deviceType = -1;
        this.countryCode = -1;
        this.deviceName = R.get("printerName");
        this.deviceDealerCode = -1;
        this.MajorVersion = -1;
        this.BuildNumber = -1;
        this.serialNumber = R.get("serialNumber");
        if (this.deviceName.contains("FMP")) {
            this.modelType = 200001;
            this.deviceType = 2;
        }
        if (this.deviceName.contains("DP")) {
            this.modelType = 100001;
            this.deviceType = 1;
        }
        return R;
    }

    @Override
    public void INIT(boolean ChekInputParams, boolean AutoCutInputParams) throws IOException, FiscalPrinterException, IllegalArgumentException {
        this.setAutoCutInputParams(AutoCutInputParams);
        this.setChkInputParams(ChekInputParams);
        this.setLanguageIndex(0);
        this.setAutoCutInputParams(AutoCutInputParams);
        this.setChkInputParams(ChekInputParams);
        this.setLanguageIndex(0);
        this.detectDevice();
        if (this.modelType > 0) {
            this.setModelRestrictions();
        }
    }

    public String getStatusBitEnStr(int byteIndex, int bitIndex) {
        String tmpResult = "";
        switch (byteIndex) {
            case 0: {
                switch (bitIndex) {
                    case 7: {
                        tmpResult = "Reserved \u2013 always 1";
                        break;
                    }
                    case 6: {
                        tmpResult = "Reserved \u2013 always 0";
                        break;
                    }
                    case 5: {
                        tmpResult = "General error - OR of all errors marked with \u2018#\u2019";
                        break;
                    }
                    case 4: {
                        tmpResult = "Reserved \u2013 always 0";
                        break;
                    }
                    case 3: {
                        tmpResult = "Not connected a customer display";
                        break;
                    }
                    case 2: {
                        tmpResult = "Reserved \u2013 always 0";
                        break;
                    }
                    case 1: {
                        tmpResult = "# Invalid command code";
                        break;
                    }
                    case 0: {
                        tmpResult = "# Incoming data has syntax error";
                    }
                }
                break;
            }
            case 1: {
                switch (bitIndex) {
                    case 7: {
                        tmpResult = "Reserved \u2013 always 0";
                        break;
                    }
                    case 6: {
                        tmpResult = "Reserved - always 0";
                        break;
                    }
                    case 5: {
                        tmpResult = "Reserved \u2013 always 0";
                        break;
                    }
                    case 4: {
                        tmpResult = "Reserved \u2013 always 0";
                        break;
                    }
                    case 3: {
                        tmpResult = "Reserved \u2013 always 0";
                        break;
                    }
                    case 2: {
                        tmpResult = "# Electronic journal end (95% full)";
                        break;
                    }
                    case 1: {
                        tmpResult = "# Command cannot be performed in the current fiscal mode";
                        break;
                    }
                    case 0: {
                        tmpResult = "If during command some of the fields for the sums overflow.";
                    }
                }
                break;
            }
            case 2: {
                switch (bitIndex) {
                    case 7: {
                        tmpResult = "Reserved \u2013 always 1";
                        break;
                    }
                    case 6: {
                        tmpResult = "Not used";
                        break;
                    }
                    case 5: {
                        tmpResult = "A non-fiscal receipt is opened";
                        break;
                    }
                    case 4: {
                        tmpResult = "Reserved - always 0";
                        break;
                    }
                    case 3: {
                        tmpResult = "A fiscal receipt is opened";
                        break;
                    }
                    case 2: {
                        tmpResult = "Reserved - always 0";
                        break;
                    }
                    case 1: {
                        tmpResult = "Reserved \u2013 always 0";
                        break;
                    }
                    case 0: {
                        tmpResult = "# Out of paper";
                    }
                }
                break;
            }
            case 3: {
                switch (bitIndex) {
                    case 7: {
                        tmpResult = "Reserved \u2013 always 1";
                        break;
                    }
                    case 6: {
                        tmpResult = "Reserved \u2013 always 0";
                        break;
                    }
                    case 5: {
                        tmpResult = "Reserved \u2013 always 0";
                        break;
                    }
                    case 4: {
                        tmpResult = "Reserved \u2013 always 0";
                        break;
                    }
                    case 3: {
                        tmpResult = "Reserved \u2013 always 0";
                        break;
                    }
                    case 2: {
                        tmpResult = "Reserved \u2013 always 0";
                        break;
                    }
                    case 1: {
                        tmpResult = "Reserved \u2013 always 0";
                        break;
                    }
                    case 0: {
                        tmpResult = "Reserved \u2013 always 0";
                    }
                }
                break;
            }
            case 4: {
                switch (bitIndex) {
                    case 7: {
                        tmpResult = "Reserved";
                        break;
                    }
                    case 6: {
                        tmpResult = "Not used";
                        break;
                    }
                    case 5: {
                        tmpResult = "OR of all mistakes marked by *";
                        break;
                    }
                    case 4: {
                        tmpResult = "* Fiscal memory is full";
                        break;
                    }
                    case 3: {
                        tmpResult = "Less than 50 records can be stored in the fiscal memory";
                        break;
                    }
                    case 2: {
                        tmpResult = "Serial number and fiscal memory number - programmed";
                        break;
                    }
                    case 1: {
                        tmpResult = "VAT registration number - programmed";
                        break;
                    }
                    case 0: {
                        tmpResult = "* Fiscal memory write error";
                    }
                }
                break;
            }
            case 5: {
                switch (bitIndex) {
                    case 7: {
                        tmpResult = "Reserved";
                        break;
                    }
                    case 6: {
                        tmpResult = "Not used";
                        break;
                    }
                    case 5: {
                        tmpResult = "Reserved";
                        break;
                    }
                    case 4: {
                        tmpResult = "Tax rates have been entered at least once";
                        break;
                    }
                    case 3: {
                        tmpResult = "The cash register is in a fiscal mode";
                        break;
                    }
                    case 2: {
                        tmpResult = "Reserved";
                        break;
                    }
                    case 1: {
                        tmpResult = "The fiscal memory is formatted";
                        break;
                    }
                    case 0: {
                        tmpResult = "Reserved";
                    }
                }
                break;
            }
            default: {
                tmpResult = "";
            }
        }
        return tmpResult;
    }

    public DP25ROU(InputStream in, OutputStream out) throws IOException, FiscalPrinterException, IllegalArgumentException {
        super(in, out, 1252);
        try {
            this.INIT(false, true);
        }
        catch (IOException E) {
            this.close();
            throw E;
        }
    }

    public FiscalResponse openFiscalCheck(String operatorCode, String operatorPassword, String tillNumber) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (operatorCode == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (operatorCode.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            int tmpInt = this.toInt(operatorCode);
            if (tmpInt > 16) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10511)");
            }
            tmpInt = this.toInt(operatorCode);
            if (tmpInt < 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10512)");
            }
            if (operatorPassword == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (operatorPassword.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpInt = this.toInt(operatorPassword);
            if (tmpInt > 99999999) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10511)");
            }
            if (tillNumber == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (tillNumber.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpInt = this.toInt(tillNumber);
            if (tmpInt > 99999) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10511)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + operatorCode;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + operatorPassword;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + tillNumber;
        String OutpS = this.customCommand(48, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        R.put("allReceiptNumber", myOutputList[0]);
        R.put("fiscalReceiptNumber", myOutputList[1]);
        return R;
    }

    public FiscalResponse openFiscalCheckWithDefaultValues() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        InputString = String.valueOf(InputString) + this.defaultOpCode;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + this.defaultOpPass;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + this.defaultTillNumber;
        String OutpS = this.customCommand(48, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        R.put("allReceiptNumber", myOutputList[0]);
        R.put("fiscalReceiptNumber", myOutputList[1]);
        return R;
    }

    public FiscalResponse totalInCash() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        InputString = String.valueOf(InputString);
        String OutpS = this.customCommand(53, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        R.put("paidCode", myOutputList[0].substring(0, 1));
        R.put("amountOut", myOutputList[0].substring(1));
        return R;
    }

    public FiscalResponse closeFiscalCheck() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(56, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        R.put("allReceipt", myOutputList[0]);
        R.put("fiscalReceipt", myOutputList[1]);
        return R;
    }

    public boolean checkAndResolve() throws IOException, FiscalPrinterException, IllegalArgumentException {
        boolean tmpResult = false;
        String InputString = "";
        InputString = String.valueOf(InputString) + "T";
        String OutpS = this.customCommand(76, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(4);
        R.put("FT_Opened", myOutputList[0]);
        R.put("Sales_Num", myOutputList[1]);
        R.put("Amount", myOutputList[2]);
        R.put("Tender", myOutputList[3]);
        boolean fBON_OPENED = false;
        boolean sBON_OPENED = false;
        boolean tryToResolve = false;
        int tmpInt = this.toInt(R.get("FT_Opened"));
        if (tmpInt == 1) {
            tryToResolve = true;
            switch (this.modelType) {
                case 100001: {
                    fBON_OPENED = this.getStatusBitBol(2, 3);
                    sBON_OPENED = this.getStatusBitBol(2, 5);
                    break;
                }
                case 200001: {
                    fBON_OPENED = this.getStatusBitBol(2, 3);
                    sBON_OPENED = this.getStatusBitBol(2, 5);
                    break;
                }
                default: {
                    fBON_OPENED = this.getStatusBitBol(2, 3);
                    sBON_OPENED = this.getStatusBitBol(2, 5);
                }
            }
        }
        if (tryToResolve) {
            if (fBON_OPENED) {
                try {
                    this.command60Variant0Version0();
                    tmpResult = true;
                }
                catch (FiscalPrinterException F) {
                    this.command53Variant1Version0();
                    this.command56Variant0Version0();
                    tmpResult = true;
                }
            }
            if (sBON_OPENED) {
                try {
                    this.command39Variant0Version0();
                    tmpResult = true;
                }
                catch (FiscalPrinterException fiscalPrinterException) {
                    // empty catch block
                }
            }
        }
        return tmpResult;
    }

    public FiscalResponse command33Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        this.customCommand(33, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command35Variant0Version0(String inputText) throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        InputString = String.valueOf(InputString) + inputText;
        this.customCommand(35, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command38Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(38, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("Allreceipt", OutpS);
        return R;
    }

    public FiscalResponse command39Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(39, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("AllReceipt\t", OutpS);
        return R;
    }

    public FiscalResponse command42Variant0Version0(String inputText) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (inputText == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (inputText.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (inputText.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (inputText.length() > 30 ? String.valueOf(InputString) + inputText.substring(0, 30) : String.valueOf(InputString) + inputText) : String.valueOf(InputString) + inputText;
        this.customCommand(42, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command43Variant0Version0(String itemIndex, String dataValue) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (itemIndex == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemIndex.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + itemIndex;
        InputString = String.valueOf(InputString) + dataValue;
        this.customCommand(43, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command44Variant0Version0(String targetLines) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (targetLines == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (targetLines.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            int tmpInt = this.toInt(targetLines);
            if (tmpInt > 99) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10511)");
            }
            tmpInt = this.toInt(targetLines);
            if (tmpInt < 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10512)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + targetLines;
        this.customCommand(44, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command47Variant0Version0(String inputText) throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        InputString = String.valueOf(InputString) + inputText;
        this.customCommand(47, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command48Variant0Version0(String operatorCode, String operatorPassword, String tillNumber) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (operatorCode == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (operatorCode.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            int tmpInt = this.toInt(operatorCode);
            if (tmpInt > 16) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10511)");
            }
            tmpInt = this.toInt(operatorCode);
            if (tmpInt < 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10512)");
            }
            if (operatorPassword == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (operatorPassword.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpInt = this.toInt(operatorPassword);
            if (tmpInt > 99999999) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10511)");
            }
            if (tillNumber == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (tillNumber.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpInt = this.toInt(tillNumber);
            if (tmpInt > 99999) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10511)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + operatorCode;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + operatorPassword;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + tillNumber;
        String OutpS = this.customCommand(48, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        R.put("allReceiptNumber", myOutputList[0]);
        R.put("fiscalReceiptNumber", myOutputList[1]);
        return R;
    }

    public FiscalResponse command49Variant0Version0(String taxGroup, String itemPrice) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant0Version2(String taxGroup, String itemPrice, String itemQuantity) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            if (itemQuantity == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemQuantity.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpDbl = this.toDouble(itemQuantity);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10508)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        InputString = String.valueOf(InputString) + "*";
        InputString = String.valueOf(InputString) + itemQuantity;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant0Version4(String textRow2, String taxGroup, String itemPrice) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow2 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + "\n";
        InputString = this.getAutoCutInputParams() ? (textRow2.length() > 30 ? String.valueOf(InputString) + textRow2.substring(0, 30) : String.valueOf(InputString) + textRow2) : String.valueOf(InputString) + textRow2;
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant0Version6(String textRow2, String taxGroup, String itemPrice, String itemQuantity) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow2 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            if (itemQuantity == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemQuantity.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpDbl = this.toDouble(itemQuantity);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10508)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + "\n";
        InputString = this.getAutoCutInputParams() ? (textRow2.length() > 30 ? String.valueOf(InputString) + textRow2.substring(0, 30) : String.valueOf(InputString) + textRow2) : String.valueOf(InputString) + textRow2;
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        InputString = String.valueOf(InputString) + "*";
        InputString = String.valueOf(InputString) + itemQuantity;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant0Version8(String textRow1, String taxGroup, String itemPrice) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow1 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (textRow1.length() > 30 ? String.valueOf(InputString) + textRow1.substring(0, 30) : String.valueOf(InputString) + textRow1) : String.valueOf(InputString) + textRow1;
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant0Version10(String textRow1, String taxGroup, String itemPrice, String itemQuantity) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow1 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            if (itemQuantity == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemQuantity.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpDbl = this.toDouble(itemQuantity);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10508)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (textRow1.length() > 30 ? String.valueOf(InputString) + textRow1.substring(0, 30) : String.valueOf(InputString) + textRow1) : String.valueOf(InputString) + textRow1;
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        InputString = String.valueOf(InputString) + "*";
        InputString = String.valueOf(InputString) + itemQuantity;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant0Version12(String textRow1, String textRow2, String taxGroup, String itemPrice) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow1 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (textRow2 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (textRow1.length() > 30 ? String.valueOf(InputString) + textRow1.substring(0, 30) : String.valueOf(InputString) + textRow1) : String.valueOf(InputString) + textRow1;
        InputString = String.valueOf(InputString) + "\n";
        InputString = this.getAutoCutInputParams() ? (textRow2.length() > 30 ? String.valueOf(InputString) + textRow2.substring(0, 30) : String.valueOf(InputString) + textRow2) : String.valueOf(InputString) + textRow2;
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant0Version14(String textRow1, String textRow2, String taxGroup, String itemPrice, String itemQuantity) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow1 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (textRow2 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            if (itemQuantity == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemQuantity.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpDbl = this.toDouble(itemQuantity);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10508)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (textRow1.length() > 30 ? String.valueOf(InputString) + textRow1.substring(0, 30) : String.valueOf(InputString) + textRow1) : String.valueOf(InputString) + textRow1;
        InputString = String.valueOf(InputString) + "\n";
        InputString = this.getAutoCutInputParams() ? (textRow2.length() > 30 ? String.valueOf(InputString) + textRow2.substring(0, 30) : String.valueOf(InputString) + textRow2) : String.valueOf(InputString) + textRow2;
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        InputString = String.valueOf(InputString) + "*";
        InputString = String.valueOf(InputString) + itemQuantity;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant1Version0(String taxGroup, String itemPrice, String sellWithAbsoluteSumDiscount) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            if (sellWithAbsoluteSumDiscount == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (sellWithAbsoluteSumDiscount.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        InputString = String.valueOf(InputString) + ";";
        InputString = String.valueOf(InputString) + sellWithAbsoluteSumDiscount;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant1Version2(String taxGroup, String itemPrice, String itemQuantity, String sellWithAbsoluteSumDiscount) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            if (itemQuantity == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemQuantity.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpDbl = this.toDouble(itemQuantity);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10508)");
            }
            if (sellWithAbsoluteSumDiscount == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (sellWithAbsoluteSumDiscount.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        InputString = String.valueOf(InputString) + "*";
        InputString = String.valueOf(InputString) + itemQuantity;
        InputString = String.valueOf(InputString) + ";";
        InputString = String.valueOf(InputString) + sellWithAbsoluteSumDiscount;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant1Version4(String textRow2, String taxGroup, String itemPrice, String sellWithAbsoluteSumDiscount) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow2 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            if (sellWithAbsoluteSumDiscount == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (sellWithAbsoluteSumDiscount.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + "\n";
        InputString = this.getAutoCutInputParams() ? (textRow2.length() > 30 ? String.valueOf(InputString) + textRow2.substring(0, 30) : String.valueOf(InputString) + textRow2) : String.valueOf(InputString) + textRow2;
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        InputString = String.valueOf(InputString) + ";";
        InputString = String.valueOf(InputString) + sellWithAbsoluteSumDiscount;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant1Version6(String textRow2, String taxGroup, String itemPrice, String itemQuantity, String sellWithAbsoluteSumDiscount) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow2 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            if (itemQuantity == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemQuantity.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpDbl = this.toDouble(itemQuantity);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10508)");
            }
            if (sellWithAbsoluteSumDiscount == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (sellWithAbsoluteSumDiscount.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + "\n";
        InputString = this.getAutoCutInputParams() ? (textRow2.length() > 30 ? String.valueOf(InputString) + textRow2.substring(0, 30) : String.valueOf(InputString) + textRow2) : String.valueOf(InputString) + textRow2;
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        InputString = String.valueOf(InputString) + "*";
        InputString = String.valueOf(InputString) + itemQuantity;
        InputString = String.valueOf(InputString) + ";";
        InputString = String.valueOf(InputString) + sellWithAbsoluteSumDiscount;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant1Version8(String textRow1, String taxGroup, String itemPrice, String sellWithAbsoluteSumDiscount) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow1 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            if (sellWithAbsoluteSumDiscount == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (sellWithAbsoluteSumDiscount.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (textRow1.length() > 30 ? String.valueOf(InputString) + textRow1.substring(0, 30) : String.valueOf(InputString) + textRow1) : String.valueOf(InputString) + textRow1;
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        InputString = String.valueOf(InputString) + ";";
        InputString = String.valueOf(InputString) + sellWithAbsoluteSumDiscount;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant1Version10(String textRow1, String taxGroup, String itemPrice, String itemQuantity, String sellWithAbsoluteSumDiscount) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow1 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            if (itemQuantity == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemQuantity.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpDbl = this.toDouble(itemQuantity);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10508)");
            }
            if (sellWithAbsoluteSumDiscount == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (sellWithAbsoluteSumDiscount.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (textRow1.length() > 30 ? String.valueOf(InputString) + textRow1.substring(0, 30) : String.valueOf(InputString) + textRow1) : String.valueOf(InputString) + textRow1;
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        InputString = String.valueOf(InputString) + "*";
        InputString = String.valueOf(InputString) + itemQuantity;
        InputString = String.valueOf(InputString) + ";";
        InputString = String.valueOf(InputString) + sellWithAbsoluteSumDiscount;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant1Version12(String textRow1, String textRow2, String taxGroup, String itemPrice, String sellWithAbsoluteSumDiscount) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow1 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (textRow2 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            if (sellWithAbsoluteSumDiscount == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (sellWithAbsoluteSumDiscount.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (textRow1.length() > 30 ? String.valueOf(InputString) + textRow1.substring(0, 30) : String.valueOf(InputString) + textRow1) : String.valueOf(InputString) + textRow1;
        InputString = String.valueOf(InputString) + "\n";
        InputString = this.getAutoCutInputParams() ? (textRow2.length() > 30 ? String.valueOf(InputString) + textRow2.substring(0, 30) : String.valueOf(InputString) + textRow2) : String.valueOf(InputString) + textRow2;
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        InputString = String.valueOf(InputString) + ";";
        InputString = String.valueOf(InputString) + sellWithAbsoluteSumDiscount;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant1Version14(String textRow1, String textRow2, String taxGroup, String itemPrice, String itemQuantity, String sellWithAbsoluteSumDiscount) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow1 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (textRow2 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            if (itemQuantity == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemQuantity.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpDbl = this.toDouble(itemQuantity);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10508)");
            }
            if (sellWithAbsoluteSumDiscount == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (sellWithAbsoluteSumDiscount.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (textRow1.length() > 30 ? String.valueOf(InputString) + textRow1.substring(0, 30) : String.valueOf(InputString) + textRow1) : String.valueOf(InputString) + textRow1;
        InputString = String.valueOf(InputString) + "\n";
        InputString = this.getAutoCutInputParams() ? (textRow2.length() > 30 ? String.valueOf(InputString) + textRow2.substring(0, 30) : String.valueOf(InputString) + textRow2) : String.valueOf(InputString) + textRow2;
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        InputString = String.valueOf(InputString) + "*";
        InputString = String.valueOf(InputString) + itemQuantity;
        InputString = String.valueOf(InputString) + ";";
        InputString = String.valueOf(InputString) + sellWithAbsoluteSumDiscount;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant2Version0(String taxGroup, String itemPrice, String sellWithPercentDiscount) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            if (sellWithPercentDiscount == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (sellWithPercentDiscount.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpDbl = this.toDouble(sellWithPercentDiscount);
            if (tmpDbl > 99.0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            tmpDbl = this.toDouble(sellWithPercentDiscount);
            if (tmpDbl < -99.0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10507)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + sellWithPercentDiscount;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant2Version2(String taxGroup, String itemPrice, String itemQuantity, String sellWithPercentDiscount) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            if (itemQuantity == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemQuantity.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpDbl = this.toDouble(itemQuantity);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10508)");
            }
            if (sellWithPercentDiscount == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (sellWithPercentDiscount.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpDbl = this.toDouble(sellWithPercentDiscount);
            if (tmpDbl > 99.0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            tmpDbl = this.toDouble(sellWithPercentDiscount);
            if (tmpDbl < -99.0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10507)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        InputString = String.valueOf(InputString) + "*";
        InputString = String.valueOf(InputString) + itemQuantity;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + sellWithPercentDiscount;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant2Version4(String textRow2, String taxGroup, String itemPrice, String sellWithPercentDiscount) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow2 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            if (sellWithPercentDiscount == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (sellWithPercentDiscount.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpDbl = this.toDouble(sellWithPercentDiscount);
            if (tmpDbl > 99.0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            tmpDbl = this.toDouble(sellWithPercentDiscount);
            if (tmpDbl < -99.0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10507)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + "\n";
        InputString = this.getAutoCutInputParams() ? (textRow2.length() > 30 ? String.valueOf(InputString) + textRow2.substring(0, 30) : String.valueOf(InputString) + textRow2) : String.valueOf(InputString) + textRow2;
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + sellWithPercentDiscount;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant2Version6(String textRow2, String taxGroup, String itemPrice, String itemQuantity, String sellWithPercentDiscount) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow2 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            if (itemQuantity == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemQuantity.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpDbl = this.toDouble(itemQuantity);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10508)");
            }
            if (sellWithPercentDiscount == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (sellWithPercentDiscount.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpDbl = this.toDouble(sellWithPercentDiscount);
            if (tmpDbl > 99.0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            tmpDbl = this.toDouble(sellWithPercentDiscount);
            if (tmpDbl < -99.0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10507)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + "\n";
        InputString = this.getAutoCutInputParams() ? (textRow2.length() > 30 ? String.valueOf(InputString) + textRow2.substring(0, 30) : String.valueOf(InputString) + textRow2) : String.valueOf(InputString) + textRow2;
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        InputString = String.valueOf(InputString) + "*";
        InputString = String.valueOf(InputString) + itemQuantity;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + sellWithPercentDiscount;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant2Version8(String textRow1, String taxGroup, String itemPrice, String sellWithPercentDiscount) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow1 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            if (sellWithPercentDiscount == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (sellWithPercentDiscount.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpDbl = this.toDouble(sellWithPercentDiscount);
            if (tmpDbl > 99.0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            tmpDbl = this.toDouble(sellWithPercentDiscount);
            if (tmpDbl < -99.0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10507)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (textRow1.length() > 30 ? String.valueOf(InputString) + textRow1.substring(0, 30) : String.valueOf(InputString) + textRow1) : String.valueOf(InputString) + textRow1;
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + sellWithPercentDiscount;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant2Version10(String textRow1, String taxGroup, String itemPrice, String itemQuantity, String sellWithPercentDiscount) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow1 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            if (itemQuantity == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemQuantity.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpDbl = this.toDouble(itemQuantity);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10508)");
            }
            if (sellWithPercentDiscount == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (sellWithPercentDiscount.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpDbl = this.toDouble(sellWithPercentDiscount);
            if (tmpDbl > 99.0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            tmpDbl = this.toDouble(sellWithPercentDiscount);
            if (tmpDbl < -99.0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10507)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (textRow1.length() > 30 ? String.valueOf(InputString) + textRow1.substring(0, 30) : String.valueOf(InputString) + textRow1) : String.valueOf(InputString) + textRow1;
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        InputString = String.valueOf(InputString) + "*";
        InputString = String.valueOf(InputString) + itemQuantity;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + sellWithPercentDiscount;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant2Version12(String textRow1, String textRow2, String taxGroup, String itemPrice, String sellWithPercentDiscount) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow1 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (textRow2 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            if (sellWithPercentDiscount == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (sellWithPercentDiscount.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpDbl = this.toDouble(sellWithPercentDiscount);
            if (tmpDbl > 99.0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            tmpDbl = this.toDouble(sellWithPercentDiscount);
            if (tmpDbl < -99.0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10507)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (textRow1.length() > 30 ? String.valueOf(InputString) + textRow1.substring(0, 30) : String.valueOf(InputString) + textRow1) : String.valueOf(InputString) + textRow1;
        InputString = String.valueOf(InputString) + "\n";
        InputString = this.getAutoCutInputParams() ? (textRow2.length() > 30 ? String.valueOf(InputString) + textRow2.substring(0, 30) : String.valueOf(InputString) + textRow2) : String.valueOf(InputString) + textRow2;
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + sellWithPercentDiscount;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command49Variant2Version14(String textRow1, String textRow2, String taxGroup, String itemPrice, String itemQuantity, String sellWithPercentDiscount) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow1 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow1.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (textRow2 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (textRow2.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (taxGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (taxGroup.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (itemPrice == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemPrice.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(itemPrice);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            if (itemQuantity == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemQuantity.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpDbl = this.toDouble(itemQuantity);
            if (tmpDbl > 9.9999999E7) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10508)");
            }
            if (sellWithPercentDiscount == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (sellWithPercentDiscount.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpDbl = this.toDouble(sellWithPercentDiscount);
            if (tmpDbl > 99.0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            tmpDbl = this.toDouble(sellWithPercentDiscount);
            if (tmpDbl < -99.0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10507)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (textRow1.length() > 30 ? String.valueOf(InputString) + textRow1.substring(0, 30) : String.valueOf(InputString) + textRow1) : String.valueOf(InputString) + textRow1;
        InputString = String.valueOf(InputString) + "\n";
        InputString = this.getAutoCutInputParams() ? (textRow2.length() > 30 ? String.valueOf(InputString) + textRow2.substring(0, 30) : String.valueOf(InputString) + textRow2) : String.valueOf(InputString) + textRow2;
        InputString = String.valueOf(InputString) + "\t";
        InputString = this.getAutoCutInputParams() ? (taxGroup.length() > 1 ? String.valueOf(InputString) + taxGroup.substring(0, 1) : String.valueOf(InputString) + taxGroup) : String.valueOf(InputString) + taxGroup;
        InputString = String.valueOf(InputString) + itemPrice;
        InputString = String.valueOf(InputString) + "*";
        InputString = String.valueOf(InputString) + itemQuantity;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + sellWithPercentDiscount;
        this.customCommand(49, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command50Variant0Version0(String StartDate, String EndDate) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (StartDate == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (StartDate.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (StartDate.length() > 6) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (EndDate == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (EndDate.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (EndDate.length() > 6) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (StartDate.length() > 6 ? String.valueOf(InputString) + StartDate.substring(0, 6) : String.valueOf(InputString) + StartDate) : String.valueOf(InputString) + StartDate;
        InputString = String.valueOf(InputString) + ",";
        InputString = this.getAutoCutInputParams() ? (EndDate.length() > 6 ? String.valueOf(InputString) + EndDate.substring(0, 6) : String.valueOf(InputString) + EndDate) : String.valueOf(InputString) + EndDate;
        String OutpS = this.customCommand(50, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(6);
        R.put("F_RESULT", myOutputList[0].substring(0, 1));
        R.put("AA", myOutputList[0].substring(1));
        R.put("BB", myOutputList[1].substring(0));
        R.put("CC", myOutputList[2].substring(0));
        R.put("DD", myOutputList[3].substring(0));
        R.put("DDMMYY", myOutputList[4].substring(0));
        return R;
    }

    public FiscalResponse command51Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        InputString = String.valueOf(InputString) + 1;
        InputString = String.valueOf(InputString) + 1;
        String OutpS = this.customCommand(51, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(8);
        R.put("subTotal", myOutputList[0]);
        R.put("taxGroupA", myOutputList[1]);
        R.put("taxGroupB", myOutputList[2]);
        R.put("taxGroupC", myOutputList[3]);
        R.put("taxGroupD", myOutputList[4]);
        R.put("taxGroupE", myOutputList[5]);
        R.put("taxGroupF", myOutputList[6]);
        R.put("taxGroupG", myOutputList[7]);
        return R;
    }

    public FiscalResponse command51Variant0Version1(String subtotalWithPercentDiscount) throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        switch (this.modelType) {
            case 100001: {
                InputString = String.valueOf(InputString) + 1;
                InputString = String.valueOf(InputString) + 1;
                break;
            }
            case 200001: {
                InputString = String.valueOf(InputString) + 1;
            }
        }
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + subtotalWithPercentDiscount;
        String OutpS = this.customCommand(51, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(7);
        R.put("subTotal", myOutputList[0]);
        R.put("taxGroupA", myOutputList[1]);
        R.put("taxGroupB", myOutputList[2]);
        R.put("taxGroupC", myOutputList[3]);
        R.put("taxGroupD", myOutputList[4]);
        R.put("taxGroupE", myOutputList[5]);
        R.put("specialTax", myOutputList[6]);
        return R;
    }

    public FiscalResponse command51Variant0Version2(String subtotalWithAbsoluteSumDiscount) throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        InputString = String.valueOf(InputString) + 1;
        InputString = String.valueOf(InputString) + 1;
        InputString = String.valueOf(InputString) + ";";
        InputString = String.valueOf(InputString) + subtotalWithAbsoluteSumDiscount;
        String OutpS = this.customCommand(51, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(7);
        R.put("subTotal", myOutputList[0]);
        R.put("taxGroupA", myOutputList[1]);
        R.put("taxGroupB", myOutputList[2]);
        R.put("taxGroupC", myOutputList[3]);
        R.put("taxGroupD", myOutputList[4]);
        R.put("taxGroupE", myOutputList[5]);
        R.put("specialTax", myOutputList[6]);
        return R;
    }

    public FiscalResponse command53Variant0Version0(String paidMode, String amountIn) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (paidMode == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (paidMode.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            boolean tmpBol = false;
            String[] myList = new String[]{"P", "N", "C", "D", "I", "J", "K"};
            int i = 0;
            while (i < myList.length) {
                if (myList[i].equals(paidMode)) {
                    tmpBol = true;
                    break;
                }
                ++i;
            }
            if (!tmpBol) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10504)");
            }
            if (amountIn == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (amountIn.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(amountIn);
            if (tmpDbl > 9.99999999E8) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            tmpDbl = this.toDouble(amountIn);
            if (tmpDbl < 0.0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10507)");
            }
            if (this.notDbl(amountIn)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10505)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + "\t";
        InputString = String.valueOf(InputString) + paidMode;
        InputString = String.valueOf(InputString) + "+";
        InputString = String.valueOf(InputString) + amountIn;
        String OutpS = this.customCommand(53, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        R.put("paidCode", myOutputList[0].substring(0, 1));
        R.put("amountOut", myOutputList[0].substring(1));
        return R;
    }

    public FiscalResponse command53Variant0Version1(String textRow2, String paidMode, String amountIn) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow2.length() > 32) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (paidMode == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (paidMode.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            boolean tmpBol = false;
            String[] myList = new String[]{"P", "N", "C", "D", "I", "J", "K"};
            int i = 0;
            while (i < myList.length) {
                if (myList[i].equals(paidMode)) {
                    tmpBol = true;
                    break;
                }
                ++i;
            }
            if (!tmpBol) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10504)");
            }
            if (amountIn == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (amountIn.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(amountIn);
            if (tmpDbl > 9.99999999E8) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            tmpDbl = this.toDouble(amountIn);
            if (tmpDbl < 0.0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10507)");
            }
            if (this.notDbl(amountIn)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10505)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + "\n";
        InputString = this.getAutoCutInputParams() ? (textRow2.length() > 32 ? String.valueOf(InputString) + textRow2.substring(0, 32) : String.valueOf(InputString) + textRow2) : String.valueOf(InputString) + textRow2;
        InputString = String.valueOf(InputString) + "\t";
        InputString = String.valueOf(InputString) + paidMode;
        InputString = String.valueOf(InputString) + "+";
        InputString = String.valueOf(InputString) + amountIn;
        String OutpS = this.customCommand(53, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        R.put("paidCode", myOutputList[0].substring(0, 1));
        R.put("amountOut", myOutputList[0].substring(1));
        return R;
    }

    public FiscalResponse command53Variant0Version2(String textRow1, String paidMode, String amountIn) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow1.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (paidMode == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (paidMode.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            boolean tmpBol = false;
            String[] myList = new String[]{"P", "N", "C", "D", "I", "J", "K"};
            int i = 0;
            while (i < myList.length) {
                if (myList[i].equals(paidMode)) {
                    tmpBol = true;
                    break;
                }
                ++i;
            }
            if (!tmpBol) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10504)");
            }
            if (amountIn == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (amountIn.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            double tmpDbl = this.toDouble(amountIn);
            if (tmpDbl > 9.99999999E8) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
            tmpDbl = this.toDouble(amountIn);
            if (tmpDbl < 0.0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10507)");
            }
            if (this.notDbl(amountIn)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10505)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (textRow1.length() > 30 ? String.valueOf(InputString) + textRow1.substring(0, 30) : String.valueOf(InputString) + textRow1) : String.valueOf(InputString) + textRow1;
        InputString = String.valueOf(InputString) + "\t";
        InputString = String.valueOf(InputString) + paidMode;
        InputString = String.valueOf(InputString) + "+";
        InputString = String.valueOf(InputString) + amountIn;
        String OutpS = this.customCommand(53, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        R.put("paidCode", myOutputList[0].substring(0, 1));
        R.put("amountOut", myOutputList[0].substring(1));
        return R;
    }

    public FiscalResponse command53Variant0Version4(String textRow1, String textRow2, String paidMode, String amountIn) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow1.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (textRow2.length() > 32) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (paidMode == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (paidMode.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            boolean tmpBol = false;
            String[] myList = new String[]{"P", "N", "C", "D", "I", "J", "K"};
            int i = 0;
            while (i < myList.length) {
                if (myList[i].equals(paidMode)) {
                    tmpBol = true;
                    break;
                }
                ++i;
            }
            if (!tmpBol) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10504)");
            }
            if (amountIn == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (amountIn.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notDbl(amountIn)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10505)");
            }
            double tmpDbl = this.toDouble(amountIn);
            if (tmpDbl < 0.0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10507)");
            }
            tmpDbl = this.toDouble(amountIn);
            if (tmpDbl > 9.99999999E8) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10506)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (textRow1.length() > 30 ? String.valueOf(InputString) + textRow1.substring(0, 30) : String.valueOf(InputString) + textRow1) : String.valueOf(InputString) + textRow1;
        InputString = String.valueOf(InputString) + "\n";
        InputString = this.getAutoCutInputParams() ? (textRow2.length() > 32 ? String.valueOf(InputString) + textRow2.substring(0, 32) : String.valueOf(InputString) + textRow2) : String.valueOf(InputString) + textRow2;
        InputString = String.valueOf(InputString) + "\t";
        InputString = String.valueOf(InputString) + paidMode;
        InputString = String.valueOf(InputString) + "+";
        InputString = String.valueOf(InputString) + amountIn;
        String OutpS = this.customCommand(53, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        R.put("paidCode", myOutputList[0].substring(0, 1));
        R.put("amountOut", myOutputList[0].substring(1));
        return R;
    }

    public FiscalResponse command53Variant1Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        InputString = String.valueOf(InputString) + "\t";
        String OutpS = this.customCommand(53, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        R.put("paidCode", myOutputList[0].substring(0, 1));
        R.put("amountOut", myOutputList[0].substring(1));
        return R;
    }

    public FiscalResponse command53Variant1Version1(String textRow2) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams() && textRow2.length() > 32) {
            throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + "\n";
        InputString = this.getAutoCutInputParams() ? (textRow2.length() > 32 ? String.valueOf(InputString) + textRow2.substring(0, 32) : String.valueOf(InputString) + textRow2) : String.valueOf(InputString) + textRow2;
        InputString = String.valueOf(InputString) + "\t";
        String OutpS = this.customCommand(53, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        R.put("paidCode", myOutputList[0].substring(0, 1));
        R.put("amountOut", myOutputList[0].substring(1));
        return R;
    }

    public FiscalResponse command53Variant1Version2(String textRow1) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams() && textRow1.length() > 30) {
            throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (textRow1.length() > 30 ? String.valueOf(InputString) + textRow1.substring(0, 30) : String.valueOf(InputString) + textRow1) : String.valueOf(InputString) + textRow1;
        InputString = String.valueOf(InputString) + "\t";
        String OutpS = this.customCommand(53, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        R.put("paidCode", myOutputList[0].substring(0, 1));
        R.put("amountOut", myOutputList[0].substring(1));
        return R;
    }

    public FiscalResponse command53Variant1Version3(String textRow1, String textRow2) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (textRow1.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (textRow2.length() > 32) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (textRow1.length() > 30 ? String.valueOf(InputString) + textRow1.substring(0, 30) : String.valueOf(InputString) + textRow1) : String.valueOf(InputString) + textRow1;
        InputString = String.valueOf(InputString) + "\n";
        InputString = this.getAutoCutInputParams() ? (textRow2.length() > 32 ? String.valueOf(InputString) + textRow2.substring(0, 32) : String.valueOf(InputString) + textRow2) : String.valueOf(InputString) + textRow2;
        InputString = String.valueOf(InputString) + "\t";
        String OutpS = this.customCommand(53, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        R.put("paidCode", myOutputList[0].substring(0, 1));
        R.put("amountOut", myOutputList[0].substring(1));
        return R;
    }

    public FiscalResponse command54Variant0Version0(String inputText) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (inputText == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (inputText.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (inputText.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (inputText.length() > 30 ? String.valueOf(InputString) + inputText.substring(0, 30) : String.valueOf(InputString) + inputText) : String.valueOf(InputString) + inputText;
        this.customCommand(54, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command56Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(56, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        R.put("allReceipt", myOutputList[0]);
        R.put("fiscalReceipt", myOutputList[1]);
        return R;
    }

    public FiscalResponse command60Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        this.customCommand(60, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command61Variant0Version0(String targetDate, String targetTime) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (targetDate == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (targetDate.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (targetDate.length() > 8) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (targetTime == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (targetTime.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (targetTime.length() > 8) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (targetDate.length() > 8 ? String.valueOf(InputString) + targetDate.substring(0, 8) : String.valueOf(InputString) + targetDate) : String.valueOf(InputString) + targetDate;
        InputString = String.valueOf(InputString) + " ";
        InputString = this.getAutoCutInputParams() ? (targetTime.length() > 8 ? String.valueOf(InputString) + targetTime.substring(0, 8) : String.valueOf(InputString) + targetTime) : String.valueOf(InputString) + targetTime;
        this.customCommand(61, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command62Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(62, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("outputText", OutpS);
        return R;
    }

    public FiscalResponse command63Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        this.customCommand(63, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command64Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(64, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(10);
        R.put("errorCode", myOutputList[0].substring(0, 1));
        R.put("receiptCount", myOutputList[0].substring(1));
        R.put("totalSumInTaxGroupA", myOutputList[1].substring(0));
        R.put("totalSumInTaxGroupB", myOutputList[2].substring(0));
        R.put("totalSumInTaxGroupC", myOutputList[1].substring(0));
        R.put("totalSumInTaxGroupD", myOutputList[2].substring(0));
        R.put("totalSumInTaxGroupE", myOutputList[3].substring(0));
        R.put("totalSumInTaxGroupF", myOutputList[0].substring(0));
        R.put("totalSumInTaxGroupG", myOutputList[0].substring(0));
        R.put("fiscalRecordDate", myOutputList[9].substring(0));
        R.put("fiscalRecordDate", myOutputList[9].substring(0));
        return R;
    }

    public FiscalResponse command65Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(65, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(7);
        R.put("totalSumInTaxGroupA", myOutputList[0]);
        R.put("totalSumInTaxGroupB", myOutputList[1]);
        R.put("totalSumInTaxGroupC", myOutputList[2]);
        R.put("totalSumInTaxGroupD", myOutputList[3]);
        R.put("totalSumInTaxGroupE", myOutputList[4]);
        R.put("totalSumInTaxGroupF", myOutputList[5]);
        R.put("totalSumInTaxGroupG", myOutputList[6]);
        return R;
    }

    public FiscalResponse command68Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(68, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("logicalFiscalRecordsCount", OutpS);
        return R;
    }

    public FiscalResponse command69Variant0Version0(String reportTypeOption) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (reportTypeOption == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (reportTypeOption.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + reportTypeOption;
        String OutpS = this.customCommand(69, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(9);
        R.put("fiscalRecordNumber", myOutputList[0]);
        R.put("totalSumForTheDay", myOutputList[1]);
        R.put("totalSumInTaxGroupA", myOutputList[2]);
        R.put("totalSumInTaxGroupB", myOutputList[3]);
        R.put("totalSumInTaxGroupC", myOutputList[4]);
        R.put("totalSumInTaxGroupD", myOutputList[5]);
        R.put("totalSumInTaxGroupE", myOutputList[6]);
        R.put("totalSumInTaxGroupF", myOutputList[7]);
        if (myOutputList.length >= 9) {
            R.put("totalSumInTaxGroupG", myOutputList[8]);
        }
        return R;
    }

    public FiscalResponse command70Variant0Version0(String amountInOut) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams() && this.notDbl(amountInOut)) {
            throw new IllegalArgumentException("Wrong input data. Error number(-10505)");
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + amountInOut;
        String OutpS = this.customCommand(70, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(4);
        R.put("exitCode", myOutputList[0]);
        R.put("sumInCashRegister", myOutputList[1]);
        R.put("totalForAllInputs", myOutputList[2]);
        R.put("totalForOutputs", myOutputList[3]);
        return R;
    }

    public FiscalResponse command70Variant0Version1() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(70, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(4);
        R.put("exitCode", myOutputList[0]);
        R.put("sumInCashRegister", myOutputList[1]);
        R.put("totalForAllInputs", myOutputList[2]);
        R.put("totalForOutputs", myOutputList[3]);
        return R;
    }

    public FiscalResponse command71Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        this.customCommand(71, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command73Variant0Version0(String startRecordNumber, String endRecordNumber) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (startRecordNumber == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (startRecordNumber.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(startRecordNumber)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
            if (endRecordNumber == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (endRecordNumber.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(endRecordNumber)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + startRecordNumber;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + endRecordNumber;
        this.customCommand(73, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command74Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        InputString = String.valueOf(InputString) + "W";
        String OutpS = this.customCommand(74, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(6);
        R.put("statusByte0", myOutputList[0]);
        R.put("statusByte1", myOutputList[1]);
        R.put("statusByte2", myOutputList[2]);
        R.put("statusByte3", myOutputList[3]);
        R.put("statusByte4", myOutputList[4]);
        R.put("statusByte5", myOutputList[5]);
        return R;
    }

    public FiscalResponse command74Variant1Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        InputString = String.valueOf(InputString) + "X";
        String OutpS = this.customCommand(74, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(6);
        R.put("statusByte0", myOutputList[0]);
        R.put("statusByte1", myOutputList[1]);
        R.put("statusByte2", myOutputList[2]);
        R.put("statusByte3", myOutputList[3]);
        R.put("statusByte4", myOutputList[4]);
        R.put("statusByte5", myOutputList[5]);
        return R;
    }

    public FiscalResponse command76Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        InputString = String.valueOf(InputString) + "T";
        String OutpS = this.customCommand(76, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(4);
        R.put("receiptIsOpened", myOutputList[0]);
        R.put("countOfRegisteredSales", myOutputList[1]);
        R.put("lastFiscalReceiptAmount", myOutputList[2]);
        R.put("lastFiscalReceiptTender", myOutputList[3]);
        return R;
    }

    public FiscalResponse command79Variant0Version0(String startDate, String endDate) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (startDate == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (startDate.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (startDate.length() > 6) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (endDate == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (endDate.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (endDate.length() > 6) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (startDate.length() > 6 ? String.valueOf(InputString) + startDate.substring(0, 6) : String.valueOf(InputString) + startDate) : String.valueOf(InputString) + startDate;
        InputString = String.valueOf(InputString) + ",";
        InputString = this.getAutoCutInputParams() ? (endDate.length() > 6 ? String.valueOf(InputString) + endDate.substring(0, 6) : String.valueOf(InputString) + endDate) : String.valueOf(InputString) + endDate;
        this.customCommand(79, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command80Variant0Version0(String soundData) throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        InputString = String.valueOf(InputString) + soundData;
        this.customCommand(80, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command83Variant0Version0(String inputMultiplier, String inputDecimals, String inputCurrency, String inputEnabledTaxesArray, String inputTaxGroupA, String inputTaxGroupB, String inputTaxGroupC, String inputTaxGroupD, String inputTaxGroupE, String inputTaxGroupF, String inputTaxGroupG) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (inputMultiplier == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (inputMultiplier.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            int tmpInt = this.toInt(inputMultiplier);
            if (tmpInt < 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10512)");
            }
            tmpInt = this.toInt(inputMultiplier);
            if (tmpInt > 3) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10511)");
            }
            if (inputDecimals == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (inputDecimals.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            boolean tmpBol = false;
            String[] myList = new String[]{"0"};
            int i = 0;
            while (i < myList.length) {
                if (myList[i].equals(inputDecimals)) {
                    tmpBol = true;
                    break;
                }
                ++i;
            }
            if (!tmpBol) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10504)");
            }
            if (inputCurrency == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (inputCurrency.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (inputCurrency.length() > 6) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (inputEnabledTaxesArray == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (inputEnabledTaxesArray.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (inputEnabledTaxesArray.length() > 8) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (inputTaxGroupA == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (inputTaxGroupA.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notDbl(inputTaxGroupA)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10505)");
            }
            if (inputTaxGroupB == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (inputTaxGroupB.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notDbl(inputTaxGroupB)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10505)");
            }
            if (inputTaxGroupC == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (inputTaxGroupC.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notDbl(inputTaxGroupC)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10505)");
            }
            if (inputTaxGroupD == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (inputTaxGroupD.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notDbl(inputTaxGroupD)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10505)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + inputMultiplier;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + inputDecimals;
        InputString = String.valueOf(InputString) + ",";
        InputString = this.getAutoCutInputParams() ? (inputCurrency.length() > 6 ? String.valueOf(InputString) + inputCurrency.substring(0, 6) : String.valueOf(InputString) + inputCurrency) : String.valueOf(InputString) + inputCurrency;
        InputString = String.valueOf(InputString) + ",";
        InputString = this.getAutoCutInputParams() ? (inputEnabledTaxesArray.length() > 8 ? String.valueOf(InputString) + inputEnabledTaxesArray.substring(0, 8) : String.valueOf(InputString) + inputEnabledTaxesArray) : String.valueOf(InputString) + inputEnabledTaxesArray;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + inputTaxGroupA;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + inputTaxGroupB;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + inputTaxGroupC;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + inputTaxGroupD;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + inputTaxGroupE;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + inputTaxGroupF;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + inputTaxGroupG;
        String OutpS = this.customCommand(83, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(11);
        R.put("outputMultiplier", myOutputList[0]);
        R.put("outputDecimals", myOutputList[1]);
        R.put("outputCurrency", myOutputList[2]);
        R.put("outputEnabledTaxesArray", myOutputList[3]);
        R.put("outputTaxA", myOutputList[4]);
        R.put("outputTaxB", myOutputList[5]);
        R.put("outputTaxC", myOutputList[6]);
        R.put("outputTaxD", myOutputList[7]);
        R.put("outputTaxGroupE", myOutputList[8]);
        R.put("outputTaxGroupF", myOutputList[9]);
        R.put("outputTaxGroupG", myOutputList[10]);
        return R;
    }

    public FiscalResponse command83Variant1Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(83, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(11);
        R.put("outputMultiplier", myOutputList[0]);
        R.put("outputDecimals", myOutputList[1]);
        R.put("outputCurrency", myOutputList[2]);
        R.put("outputEnabledTaxesArray", myOutputList[3]);
        R.put("outputTaxA", myOutputList[4]);
        R.put("outputTaxB", myOutputList[5]);
        R.put("outputTaxC", myOutputList[6]);
        R.put("outputTaxD", myOutputList[7]);
        R.put("outputTaxGroupE", myOutputList[8]);
        R.put("outputTaxGroupF", myOutputList[9]);
        R.put("outputTaxGroupG", myOutputList[10]);
        return R;
    }

    public FiscalResponse command85Variant0Version0(String additionalPaymentTypeOption, String inputAdditionalPaymentName) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (additionalPaymentTypeOption == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (additionalPaymentTypeOption.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (additionalPaymentTypeOption.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            boolean tmpBol = false;
            String[] myList = new String[]{"I", "J", "K"};
            int i = 0;
            while (i < myList.length) {
                if (myList[i].equals(additionalPaymentTypeOption)) {
                    tmpBol = true;
                    break;
                }
                ++i;
            }
            if (!tmpBol) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10504)");
            }
            if (inputAdditionalPaymentName == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (inputAdditionalPaymentName.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (inputAdditionalPaymentName.length() > 24) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (additionalPaymentTypeOption.length() > 1 ? String.valueOf(InputString) + additionalPaymentTypeOption.substring(0, 1) : String.valueOf(InputString) + additionalPaymentTypeOption) : String.valueOf(InputString) + additionalPaymentTypeOption;
        InputString = String.valueOf(InputString) + ",";
        InputString = this.getAutoCutInputParams() ? (inputAdditionalPaymentName.length() > 24 ? String.valueOf(InputString) + inputAdditionalPaymentName.substring(0, 24) : String.valueOf(InputString) + inputAdditionalPaymentName) : String.valueOf(InputString) + inputAdditionalPaymentName;
        String OutpS = this.customCommand(85, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(1);
        R.put("outputText", myOutputList[0].substring(0, 1));
        return R;
    }

    public FiscalResponse command85Variant0Version1(String additionalPaymentTypeOption) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (additionalPaymentTypeOption == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (additionalPaymentTypeOption.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (additionalPaymentTypeOption.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            boolean tmpBol = false;
            String[] myList = new String[]{"I", "J", "K"};
            int i = 0;
            while (i < myList.length) {
                if (myList[i].equals(additionalPaymentTypeOption)) {
                    tmpBol = true;
                    break;
                }
                ++i;
            }
            if (!tmpBol) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10504)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (additionalPaymentTypeOption.length() > 1 ? String.valueOf(InputString) + additionalPaymentTypeOption.substring(0, 1) : String.valueOf(InputString) + additionalPaymentTypeOption) : String.valueOf(InputString) + additionalPaymentTypeOption;
        String OutpS = this.customCommand(85, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("outputAdditionalPaymentName", OutpS);
        return R;
    }

    public FiscalResponse command86Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(86, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("lastFiscalMemoryDate", OutpS);
        return R;
    }

    public FiscalResponse command90Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        InputString = String.valueOf(InputString) + "1";
        String OutpS = this.customCommand(90, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{",", " "});
        FiscalResponse R = new FiscalResponse(7);
        R.put("printerName", myOutputList[0]);
        R.put("firmwareRevision", myOutputList[1]);
        R.put("firmwareDate", myOutputList[2]);
        R.put("firmwareTime", myOutputList[3]);
        R.put("checkSum", myOutputList[4]);
        R.put("softwareSwitches", myOutputList[5]);
        R.put("serialNumber", myOutputList[6]);
        return R;
    }

    public FiscalResponse command92Variant0Version0(String lineType) throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        InputString = String.valueOf(InputString) + lineType;
        this.customCommand(92, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command94Variant0Version0(String startDate, String endDate) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (startDate == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (startDate.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (startDate.length() > 6) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (endDate == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (endDate.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (endDate.length() > 6) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (startDate.length() > 6 ? String.valueOf(InputString) + startDate.substring(0, 6) : String.valueOf(InputString) + startDate) : String.valueOf(InputString) + startDate;
        InputString = String.valueOf(InputString) + ",";
        InputString = this.getAutoCutInputParams() ? (endDate.length() > 6 ? String.valueOf(InputString) + endDate.substring(0, 6) : String.valueOf(InputString) + endDate) : String.valueOf(InputString) + endDate;
        this.customCommand(94, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command95Variant0Version0(String startFiscalRecordNumber, String endFiscalRecordNumber) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (startFiscalRecordNumber == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (startFiscalRecordNumber.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(startFiscalRecordNumber)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
            if (endFiscalRecordNumber == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (endFiscalRecordNumber.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(endFiscalRecordNumber)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + startFiscalRecordNumber;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + endFiscalRecordNumber;
        this.customCommand(95, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command97Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(97, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(7);
        R.put("taxGroupA", myOutputList[0]);
        R.put("taxGroupB", myOutputList[1]);
        R.put("taxGroupC", myOutputList[2]);
        R.put("taxGroupD", myOutputList[3]);
        R.put("taxGroupE", myOutputList[4]);
        R.put("taxGroupF", myOutputList[5]);
        R.put("taxGroupG", myOutputList[6]);
        return R;
    }

    public FiscalResponse command99Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(99, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("vatNumber", OutpS);
        return R;
    }

    public FiscalResponse command100Variant0Version0(String inputText) throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        InputString = String.valueOf(InputString) + inputText;
        this.customCommand(100, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command101Variant0Version0(String operatorCode, String oldOperatorPassword, String newOperatorPassword) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (operatorCode == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (operatorCode.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            int tmpInt = this.toInt(operatorCode);
            if (tmpInt > 16) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10511)");
            }
            tmpInt = this.toInt(operatorCode);
            if (tmpInt < 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10512)");
            }
            if (oldOperatorPassword == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (oldOperatorPassword.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (oldOperatorPassword.length() > 8) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (oldOperatorPassword.length() < 4) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10503)");
            }
            if (newOperatorPassword == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (newOperatorPassword.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (newOperatorPassword.length() > 8) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (newOperatorPassword.length() < 4) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10503)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + operatorCode;
        InputString = String.valueOf(InputString) + ",";
        InputString = this.getAutoCutInputParams() ? (oldOperatorPassword.length() > 8 ? String.valueOf(InputString) + oldOperatorPassword.substring(0, 8) : String.valueOf(InputString) + oldOperatorPassword) : String.valueOf(InputString) + oldOperatorPassword;
        InputString = String.valueOf(InputString) + ",";
        InputString = this.getAutoCutInputParams() ? (newOperatorPassword.length() > 8 ? String.valueOf(InputString) + newOperatorPassword.substring(0, 8) : String.valueOf(InputString) + newOperatorPassword) : String.valueOf(InputString) + newOperatorPassword;
        this.customCommand(101, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command102Variant0Version0(String operatorCode, String operatorPassword, String operatorName) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (operatorCode == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (operatorCode.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            int tmpInt = this.toInt(operatorCode);
            if (tmpInt > 16) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10511)");
            }
            tmpInt = this.toInt(operatorCode);
            if (tmpInt < 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10512)");
            }
            if (operatorPassword == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (operatorPassword.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (operatorPassword.length() > 8) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            if (operatorPassword.length() < 4) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10503)");
            }
            if (operatorName == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (operatorName.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (operatorName.length() > 30) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + operatorCode;
        InputString = String.valueOf(InputString) + ",";
        InputString = this.getAutoCutInputParams() ? (operatorPassword.length() > 8 ? String.valueOf(InputString) + operatorPassword.substring(0, 8) : String.valueOf(InputString) + operatorPassword) : String.valueOf(InputString) + operatorPassword;
        InputString = String.valueOf(InputString) + ",";
        InputString = this.getAutoCutInputParams() ? (operatorName.length() > 30 ? String.valueOf(InputString) + operatorName.substring(0, 30) : String.valueOf(InputString) + operatorName) : String.valueOf(InputString) + operatorName;
        this.customCommand(102, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command103Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(103, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(10);
        R.put("saleVoidIsPossible", myOutputList[0]);
        R.put("taxGroupA", myOutputList[1]);
        R.put("taxGroupB", myOutputList[2]);
        R.put("taxGroupC", myOutputList[3]);
        R.put("taxGroupD", myOutputList[4]);
        R.put("taxGroupE", myOutputList[5]);
        R.put("taxGroupF", myOutputList[6]);
        R.put("taxGroupG", myOutputList[7]);
        R.put("Inv", myOutputList[8]);
        R.put("InvNmb", myOutputList[9]);
        return R;
    }

    public FiscalResponse command105Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        this.customCommand(105, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command106Variant0Version0(String mSec) throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        InputString = String.valueOf(InputString) + mSec;
        this.customCommand(106, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command108Variant0Version0(String reportTypeOption) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (reportTypeOption == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (reportTypeOption.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + reportTypeOption;
        String OutpS = this.customCommand(108, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(9);
        R.put("fiscalRecordNumber", myOutputList[0]);
        R.put("totalSumForTheDay", myOutputList[1]);
        R.put("totalSumInTaxGroupA", myOutputList[2]);
        R.put("totalSumInTaxGroupB", myOutputList[3]);
        R.put("totalSumInTaxGroupC", myOutputList[4]);
        R.put("totalSumInTaxGroupD", myOutputList[5]);
        R.put("totalSumInTaxGroupE", myOutputList[6]);
        R.put("totalSumInTaxGroupF", myOutputList[7]);
        R.put("totalSumInTaxGroupG", myOutputList[8]);
        return R;
    }

    public FiscalResponse command109Variant0Version0(String receiptCount) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (receiptCount == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (receiptCount.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(receiptCount)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + receiptCount;
        this.customCommand(109, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command110Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(110, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(10);
        R.put("paidInCash", myOutputList[0]);
        R.put("paidWithCreditCart", myOutputList[1]);
        R.put("paidWithDebitCard", myOutputList[2]);
        R.put("paidWithCheque", myOutputList[3]);
        R.put("paidInAdditionalPaymentType1", myOutputList[4]);
        R.put("paidInAdditionalPaymentType2", myOutputList[5]);
        R.put("paidInAdditionalPaymentType3", myOutputList[6]);
        R.put("paidInAdditionalPaymentType4", myOutputList[7]);
        R.put("currentFiscalRecordNumber", myOutputList[8]);
        R.put("nextFiscalReceiptNumber", myOutputList[9]);
        return R;
    }

    public FiscalResponse command111Variant0Version0(String printOption, String startItemNumber, String endItemNumber) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (printOption == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (printOption.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (printOption.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            boolean tmpBol = false;
            String[] myList = new String[]{"S"};
            int i = 0;
            while (i < myList.length) {
                if (myList[i].equals(printOption)) {
                    tmpBol = true;
                    break;
                }
                ++i;
            }
            if (!tmpBol) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10504)");
            }
            if (startItemNumber == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (startItemNumber.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(startItemNumber)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
            int tmpInt = this.toInt(startItemNumber);
            if (tmpInt < 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10512)");
            }
            if (endItemNumber == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (endItemNumber.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(endItemNumber)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
            tmpInt = this.toInt(endItemNumber);
            if (tmpInt > 999999999) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10511)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (printOption.length() > 1 ? String.valueOf(InputString) + printOption.substring(0, 1) : String.valueOf(InputString) + printOption) : String.valueOf(InputString) + printOption;
        InputString = String.valueOf(InputString) + startItemNumber;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + endItemNumber;
        String OutpS = this.customCommand(111, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("errorCode", OutpS);
        return R;
    }

    public FiscalResponse command111Variant1Version0(String Option, String StartNum, String EndNum, String itemGroup) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (Option == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (Option.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (Option.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            boolean tmpBol = false;
            String[] myList = new String[]{"S"};
            int i = 0;
            while (i < myList.length) {
                if (myList[i].equals(Option)) {
                    tmpBol = true;
                    break;
                }
                ++i;
            }
            if (!tmpBol) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10504)");
            }
            if (StartNum == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (StartNum.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(StartNum)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
            int tmpInt = this.toInt(StartNum);
            if (tmpInt < 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10512)");
            }
            if (EndNum == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (EndNum.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(EndNum)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
            tmpInt = this.toInt(EndNum);
            if (tmpInt > 999999999) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10511)");
            }
            if (itemGroup == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (itemGroup.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            tmpInt = this.toInt(itemGroup);
            if (tmpInt > 99) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10511)");
            }
            tmpInt = this.toInt(itemGroup);
            if (tmpInt < 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10512)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (Option.length() > 1 ? String.valueOf(InputString) + Option.substring(0, 1) : String.valueOf(InputString) + Option) : String.valueOf(InputString) + Option;
        InputString = String.valueOf(InputString) + StartNum;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + EndNum;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + itemGroup;
        String OutpS = this.customCommand(111, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("errorCode", OutpS);
        return R;
    }

    public FiscalResponse command111Variant2Version0(String printOption) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (printOption == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (printOption.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (printOption.length() > 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10502)");
            }
            boolean tmpBol = false;
            String[] myList = new String[]{"S"};
            int i = 0;
            while (i < myList.length) {
                if (myList[i].equals(printOption)) {
                    tmpBol = true;
                    break;
                }
                ++i;
            }
            if (!tmpBol) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10504)");
            }
        }
        String InputString = "";
        InputString = this.getAutoCutInputParams() ? (printOption.length() > 1 ? String.valueOf(InputString) + printOption.substring(0, 1) : String.valueOf(InputString) + printOption) : String.valueOf(InputString) + printOption;
        String OutpS = this.customCommand(111, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("errorCode", OutpS);
        return R;
    }

    public FiscalResponse command112Variant0Version0(String operatorCode) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (operatorCode == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (operatorCode.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(operatorCode)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
            int tmpInt = this.toInt(operatorCode);
            if (tmpInt > 16) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10511)");
            }
            tmpInt = this.toInt(operatorCode);
            if (tmpInt < 1) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10512)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + operatorCode;
        String OutpS = this.customCommand(112, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{",", ";"});
        FiscalResponse R = new FiscalResponse(11);
        R.put("receiptCountForOperator", myOutputList[0]);
        R.put("registeredSalesCountForOperator", myOutputList[1]);
        R.put("totalAccumulatedSum", myOutputList[2]);
        R.put("discountCountForOperator", myOutputList[3]);
        R.put("totalDiscounts", myOutputList[4]);
        R.put("surchargeCountForOperator", myOutputList[5]);
        R.put("totalSurcharges", myOutputList[6]);
        R.put("voidCountForOperator", myOutputList[7]);
        R.put("totalVoidSum", myOutputList[8]);
        R.put("operatorName", myOutputList[9]);
        R.put("operatorPassword", myOutputList[10]);
        return R;
    }

    public FiscalResponse command113Variant0Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        String OutpS = this.customCommand(113, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("lastDocumentNumber", OutpS);
        return R;
    }

    public FiscalResponse command114Variant0Version0(String fiscalRecordNumber) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (fiscalRecordNumber == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (fiscalRecordNumber.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(fiscalRecordNumber)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + fiscalRecordNumber;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + "0";
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(9);
        R.put("errorCode", myOutputList[0]);
        R.put("lastTaxRatesRecordNumber", myOutputList[1]);
        R.put("decimalsCount", myOutputList[2]);
        R.put("enabledTaxArray", myOutputList[3]);
        R.put("taxPercentRateA", myOutputList[4]);
        R.put("taxPercentRateB", myOutputList[5]);
        R.put("taxPercentRateC", myOutputList[6]);
        R.put("taxPercentRateD", myOutputList[7]);
        R.put("dateAndTime", myOutputList[8]);
        return R;
    }

    public FiscalResponse command114Variant1Version0(String fiscalRecordNumber) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (fiscalRecordNumber == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (fiscalRecordNumber.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(fiscalRecordNumber)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + fiscalRecordNumber;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + "1";
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(9);
        R.put("errorCode", myOutputList[0]);
        R.put("outputFiscalRecordNumber", myOutputList[1]);
        R.put("fiscalReceiptsCount", myOutputList[2]);
        R.put("totalTurnoverInTaxGroupA", myOutputList[3]);
        R.put("totalTurnoverInTaxGroupB", myOutputList[4]);
        R.put("totalTurnoverInTaxGroupC", myOutputList[5]);
        R.put("totalTurnoverInTaxGroupD", myOutputList[6]);
        R.put("totalTurnoverInTaxGroupE", myOutputList[7]);
        R.put("specialTax", myOutputList[8]);
        return R;
    }

    public FiscalResponse command114Variant1Version1(String fiscalRecordNumber1, String fiscalRecordNumber2) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (fiscalRecordNumber1 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (fiscalRecordNumber1.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(fiscalRecordNumber1)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
            if (fiscalRecordNumber2 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (fiscalRecordNumber2.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(fiscalRecordNumber2)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + fiscalRecordNumber1;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + "1";
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + fiscalRecordNumber2;
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(9);
        R.put("errorCode", myOutputList[0]);
        R.put("outputFiscalRecordNumber", myOutputList[1]);
        R.put("fiscalReceiptsCount", myOutputList[2]);
        R.put("totalTurnoverInTaxGroupA", myOutputList[3]);
        R.put("totalTurnoverInTaxGroupB", myOutputList[4]);
        R.put("totalTurnoverInTaxGroupC", myOutputList[5]);
        R.put("totalTurnoverInTaxGroupD", myOutputList[6]);
        R.put("totalTurnoverInTaxGroupE", myOutputList[7]);
        R.put("specialTax", myOutputList[8]);
        return R;
    }

    public FiscalResponse command114Variant2Version0(String fiscalRecordNumber) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (fiscalRecordNumber == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (fiscalRecordNumber.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(fiscalRecordNumber)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + fiscalRecordNumber;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + "2";
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(9);
        R.put("errorCode", myOutputList[0]);
        R.put("outputFiscalRecordNumber", myOutputList[1]);
        R.put("fiscalReceiptsCount", myOutputList[2]);
        R.put("netAmountInTaxGroupA", myOutputList[3]);
        R.put("netAmountInTaxGroupB", myOutputList[4]);
        R.put("netAmountInTaxGroupC", myOutputList[5]);
        R.put("netAmountInTaxGroupD", myOutputList[6]);
        R.put("netAmountInTaxGroupE", myOutputList[7]);
        R.put("specialTax", myOutputList[8]);
        return R;
    }

    public FiscalResponse command114Variant2Version1(String fiscalRecordNumber1, String fiscalRecordNumber2) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (fiscalRecordNumber1 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (fiscalRecordNumber1.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(fiscalRecordNumber1)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
            if (fiscalRecordNumber2 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (fiscalRecordNumber2.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(fiscalRecordNumber2)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + fiscalRecordNumber1;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + "2";
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + fiscalRecordNumber2;
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(9);
        R.put("errorCode", myOutputList[0]);
        R.put("outputFiscalRecordNumber", myOutputList[1]);
        R.put("fiscalReceiptsCount", myOutputList[2]);
        R.put("netAmountInTaxGroupA", myOutputList[3]);
        R.put("netAmountInTaxGroupB", myOutputList[4]);
        R.put("netAmountInTaxGroupC", myOutputList[5]);
        R.put("netAmountInTaxGroupD", myOutputList[6]);
        R.put("netAmountInTaxGroupE", myOutputList[7]);
        R.put("specialTax", myOutputList[8]);
        return R;
    }

    public FiscalResponse command114Variant3Version0(String fiscalRecordNumber) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (fiscalRecordNumber == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (fiscalRecordNumber.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(fiscalRecordNumber)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + fiscalRecordNumber;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + "3";
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(7);
        R.put("errorCode", myOutputList[0]);
        R.put("outputFiscalRecordNumber", myOutputList[1]);
        R.put("fiscalReceiptsCount", myOutputList[2]);
        R.put("vatSumInTaxGroupA", myOutputList[3]);
        R.put("vatSumInTaxGroupB", myOutputList[4]);
        R.put("vatSumInTaxGroupC", myOutputList[5]);
        R.put("vatSumInTaxGroupD", myOutputList[6]);
        return R;
    }

    public FiscalResponse command114Variant3Version1(String fiscalRecordNumber1, String fiscalRecordNumber2) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (fiscalRecordNumber1 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (fiscalRecordNumber1.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(fiscalRecordNumber1)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
            if (fiscalRecordNumber2 == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (fiscalRecordNumber2.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(fiscalRecordNumber2)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + fiscalRecordNumber1;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + "3";
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + fiscalRecordNumber2;
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(7);
        R.put("errorCode", myOutputList[0]);
        R.put("outputFiscalRecordNumber", myOutputList[1]);
        R.put("fiscalReceiptsCount", myOutputList[2]);
        R.put("vatSumInTaxGroupA", myOutputList[3]);
        R.put("vatSumInTaxGroupB", myOutputList[4]);
        R.put("vatSumInTaxGroupC", myOutputList[5]);
        R.put("vatSumInTaxGroupD", myOutputList[6]);
        return R;
    }

    public FiscalResponse command114Variant4Version0(String fiscalRecordNumber) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (fiscalRecordNumber == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (fiscalRecordNumber.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(fiscalRecordNumber)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + fiscalRecordNumber;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + "4";
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(6);
        R.put("errorCode", myOutputList[0]);
        R.put("outputFiscalRecordNumber", myOutputList[1]);
        R.put("lastTaxRatesRecordNumber", myOutputList[2]);
        R.put("lastResetRecordNumber", myOutputList[3]);
        R.put("lastElectronicJournalNumber", myOutputList[4]);
        R.put("dateAndTime", myOutputList[5]);
        return R;
    }

    public FiscalResponse command114Variant5Version0(String fiscalRecordNumber) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (fiscalRecordNumber == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (fiscalRecordNumber.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(fiscalRecordNumber)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + fiscalRecordNumber;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + "5";
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(8);
        R.put("errorCode", myOutputList[0]);
        R.put("decimalsCount", myOutputList[1]);
        R.put("enabledTaxArray", myOutputList[2]);
        R.put("taxPercentRateA", myOutputList[3]);
        R.put("taxPercentRateB", myOutputList[4]);
        R.put("taxPercentRateC", myOutputList[5]);
        R.put("taxPercentRateD", myOutputList[6]);
        R.put("dateAndTime", myOutputList[7]);
        return R;
    }

    public FiscalResponse command114Variant6Version0(String fiscalRecordNumber) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (fiscalRecordNumber == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (fiscalRecordNumber.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (this.notInt(fiscalRecordNumber)) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10510)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + fiscalRecordNumber;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + "6";
        String OutpS = this.customCommand(114, InputString);
        String[] myOutputList = this.split(OutpS, new String[]{","});
        FiscalResponse R = new FiscalResponse(2);
        R.put("errorCode", myOutputList[0]);
        R.put("dateAndTime", myOutputList[1]);
        return R;
    }

    public FiscalResponse command115Variant0Version0(String rowNumber, String rowData) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (rowNumber == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (rowNumber.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            int tmpInt = this.toInt(rowNumber);
            if (tmpInt > 95) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10511)");
            }
            tmpInt = this.toInt(rowNumber);
            if (tmpInt < 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10512)");
            }
            if (rowData == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (rowData.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + rowNumber;
        InputString = String.valueOf(InputString) + ",";
        InputString = String.valueOf(InputString) + rowData;
        this.customCommand(115, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command115Variant1Version0(String rowNumber) throws IOException, FiscalPrinterException, IllegalArgumentException {
        if (this.getChkInputParams()) {
            if (rowNumber == null) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            if (rowNumber.length() == 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10500)");
            }
            int tmpInt = this.toInt(rowNumber);
            if (tmpInt > 95) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10511)");
            }
            tmpInt = this.toInt(rowNumber);
            if (tmpInt < 0) {
                throw new IllegalArgumentException("Wrong input data. Error number(-10512)");
            }
        }
        String InputString = "";
        InputString = String.valueOf(InputString) + "R";
        InputString = String.valueOf(InputString) + rowNumber;
        String OutpS = this.customCommand(115, InputString);
        FiscalResponse R = new FiscalResponse(1);
        R.put("rowData", OutpS);
        return R;
    }

    public FiscalResponse command122Variant2Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        InputString = String.valueOf(InputString) + "PS";
        this.customCommand(122, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command122Variant2Version1() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        InputString = String.valueOf(InputString) + "PL";
        this.customCommand(122, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command122Variant3Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        InputString = String.valueOf(InputString) + "CS";
        this.customCommand(122, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command122Variant3Version1() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        InputString = String.valueOf(InputString) + "CL";
        this.customCommand(122, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }

    public FiscalResponse command122Variant4Version0() throws IOException, FiscalPrinterException, IllegalArgumentException {
        String InputString = "";
        InputString = String.valueOf(InputString) + "E";
        this.customCommand(122, InputString);
        FiscalResponse R = new FiscalResponse(0);
        return R;
    }
}

