/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter;

public class FiscalResponse {
    private int capacity = 0;
    private String[] keys;
    private String[] values;

    public FiscalResponse(int maxElements) {
        this.keys = new String[maxElements];
        this.values = new String[maxElements];
    }

    public String get(String key) {
        int i = 0;
        while (i < this.capacity) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public boolean put(String key, String value) {
        if (this.capacity == this.keys.length) {
            return false;
        }
        int i = 0;
        while (i < this.capacity) {
            if (this.keys[i].equals(key)) {
                this.keys[i] = key;
                this.values[i] = value;
                return true;
            }
            ++i;
        }
        this.keys[this.capacity] = key;
        this.values[this.capacity] = value;
        ++this.capacity;
        return true;
    }

    public int count() {
        return this.capacity;
    }

    public String[] getKeys() {
        if (this.capacity > 0) {
            String[] c = new String[this.capacity];
            System.arraycopy(this.keys, 0, c, 0, this.capacity);
            return c;
        }
        return null;
    }

    public String[] getValues() {
        if (this.capacity > 0) {
            String[] c = new String[this.capacity];
            System.arraycopy(this.values, 0, c, 0, this.capacity);
            return c;
        }
        return null;
    }

    public boolean contains(String key) {
        return this.get(key) != null;
    }
}

