/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.fiscalprinter;

import com.datecs.fiscalprinter.FiscalPrinterException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public abstract class FPBase {
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int MAX_RETRIES = 3;
    private static final int MAX_PACKET_SIZE = 224;
    private static final int MAX_DATA_SIZE = 218;
    public static final int ENCODING_1251 = 1251;
    public static final int ENCODING_1252 = 1252;
    private boolean chkInputParams;
    private boolean autoCutInputParams;
    private int languageIndex;
    private InputStream mIn;
    private OutputStream mOut;
    private int mEncoding;
    private int mPacketSeq;
    private FifoBuffer mRecvQueue;
    private boolean mActive;
    private static final int[] cp_1251 = new int[]{1026, 128, 1027, 129, 8218, 130, 1107, 131, 8222, 132, 8230, 133, 8224, 134, 8225, 135, 8364, 136, 8240, 137, 1033, 138, 8249, 139, 1034, 140, 1036, 141, 1035, 142, 1039, 143, 1106, 144, 8216, 145, 8217, 146, 8220, 147, 8221, 148, 8226, 149, 8211, 150, 8212, 151, 8482, 153, 1113, 154, 8250, 155, 1114, 156, 1116, 157, 1115, 158, 1119, 159, 160, 160, 1038, 161, 1118, 162, 1032, 163, 164, 164, 1168, 165, 166, 166, 167, 167, 1025, 168, 169, 169, 1028, 170, 171, 171, 172, 172, 173, 173, 174, 174, 1031, 175, 176, 176, 177, 177, 1030, 178, 1110, 179, 1169, 180, 181, 181, 182, 182, 183, 183, 1105, 184, 8470, 185, 1108, 186, 187, 187, 1112, 188, 1029, 189, 1109, 190, 1111, 191, 1040, 192, 1041, 193, 1042, 194, 1043, 195, 1044, 196, 1045, 197, 1046, 198, 1047, 199, 1048, 200, 1049, 201, 1050, 202, 1051, 203, 1052, 204, 1053, 205, 1054, 206, 1055, 207, 1056, 208, 1057, 209, 1058, 210, 1059, 211, 1060, 212, 1061, 213, 1062, 214, 1063, 215, 1064, 216, 1065, 217, 1066, 218, 1067, 219, 1068, 220, 1069, 221, 1070, 222, 1071, 223, 1072, 224, 1073, 225, 1074, 226, 1075, 227, 1076, 228, 1077, 229, 1078, 230, 1079, 231, 1080, 232, 1081, 233, 1082, 234, 1083, 235, 1084, 236, 1085, 237, 1086, 238, 1087, 239, 1088, 240, 1089, 241, 1090, 242, 1091, 243, 1092, 244, 1093, 245, 1094, 246, 1095, 247, 1096, 248, 1097, 249, 1098, 250, 1099, 251, 1100, 252, 1101, 253, 1102, 254, 1103, 255};
    protected byte[] mSB = new byte[6];

    private static final String toHexString(byte[] buf, int offs, int len) {
        char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer tmp = new StringBuffer(len * 3);
        int i = 0;
        while (i < len) {
            tmp.append(hex[buf[offs + i] >> 4 & 0xF]);
            tmp.append(hex[buf[offs + i] & 0xF]);
            tmp.append(' ');
            ++i;
        }
        return tmp.toString();
    }

    private void write(byte[] buf, int offset, int length) throws IOException {
        this.mOut.write(buf, offset, length);
        System.out.println("W(" + length + "):" + FPBase.toHexString(buf, offset, length));
    }

    private void toAnsi(String str, byte[] data, int offset) {
        if (str != null) {
            int s = 0;
            while (s < str.length()) {
                char c = str.charAt(s);
                data[offset + s] = (byte)c;
                if (c >= '\u0080') {
                    if (this.mEncoding == 1251) {
                        int i = 0;
                        while (i < cp_1251.length) {
                            if (cp_1251[i] == c) {
                                data[offset + s] = (byte)cp_1251[i + 1];
                                break;
                            }
                            i += 2;
                        }
                    } else {
                        data[offset + s] = (byte)c;
                    }
                }
                ++s;
            }
        }
    }

    private String toUnicode(byte[] data, int offset, int length) {
        StringBuffer sb = new StringBuffer(length);
        int s = 0;
        while (s < length) {
            char c = (char)(data[offset + s] & 0xFF);
            if (c < '\u0080') {
                sb.append(c);
            } else if (this.mEncoding == 1251) {
                int i = 0;
                while (i < cp_1251.length) {
                    if (cp_1251[i + 1] == c) {
                        sb.append((char)cp_1251[i]);
                        break;
                    }
                    i += 2;
                }
            } else {
                sb.append(c);
            }
            ++s;
        }
        return sb.toString();
    }

    private void writePacket(int cmd, String data) throws IOException {
        int retry = 0;
        while (retry < 3) {
            byte[] buf = new byte[218];
            int offs = 0;
            int len = 0;
            int crc = 0;
            int n = len = data != null ? data.length() : 0;
            if (len > 218) {
                throw new IllegalArgumentException("Lenght of the packet exceeds the limits!");
            }
            buf[offs++] = 1;
            buf[offs++] = (byte)(36 + len);
            buf[offs++] = (byte)this.mPacketSeq;
            buf[offs++] = (byte)cmd;
            this.toAnsi(data, buf, offs);
            offs += len;
            buf[offs++] = 5;
            int i = 1;
            while (i < offs) {
                crc += buf[i] & 0xFF;
                ++i;
            }
            buf[offs++] = (byte)((crc >> 12 & 0xF) + 48);
            buf[offs++] = (byte)((crc >> 8 & 0xF) + 48);
            buf[offs++] = (byte)((crc >> 4 & 0xF) + 48);
            buf[offs++] = (byte)((crc >> 0 & 0xF) + 48);
            buf[offs++] = 3;
            this.write(buf, 0, offs);
            this.mOut.flush();
            do {
                this.read(buf, 0, 1);
            } while ((buf[0] & 0xFF) == 22);
            if (buf[0] != 21) {
                if (buf[0] != 1) {
                    throw new IOException("Invalid data received!");
                }
                return;
            }
            ++retry;
        }
        throw new IOException("Invalid packet checksum!");
    }

    private String readPacket() throws IOException {
        byte[] buf = new byte[218];
        int b = 0;
        int len = 0;
        int crc = 0;
        b = this.read();
        len = b - 43;
        crc = b;
        b = this.read();
        crc += b;
        b = this.read();
        crc += b;
        this.read(buf, 0, len);
        int i = 0;
        while (i < len) {
            crc += buf[i] & 0xFF;
            ++i;
        }
        b = this.read();
        if (b != 4) {
            throw new IOException("Invalid data received!");
        }
        crc += b;
        this.read(this.mSB, 0, this.mSB.length);
        i = 0;
        while (i < this.mSB.length) {
            crc += this.mSB[i] & 0xFF;
            ++i;
        }
        b = this.read();
        if (b != 5) {
            throw new IOException("Invalid data received!");
        }
        crc += b;
        b = this.read();
        crc -= b - 48 << 12;
        b = this.read();
        crc -= b - 48 << 8;
        b = this.read();
        crc -= b - 48 << 4;
        b = this.read();
        if ((crc -= b - 48) != 0) {
            throw new IOException("Invalid CRC!");
        }
        b = this.read();
        if (b != 3) {
            throw new IOException("Invalid data received!");
        }
        if (len <= 0) {
            return null;
        }
        System.out.println("Command returned: " + this.toUnicode(buf, 0, len));
        return this.toUnicode(buf, 0, len);
    }

    private int read(byte[] buf, int offset, int length) throws IOException {
        int rcv = 0;
        if (length > 0) {
            do {
                buf[offset + rcv] = (byte)this.read();
            } while (++rcv < length);
        }
        return rcv++;
    }

    private int read() throws IOException {
        long ms = System.currentTimeMillis() + 5000L;
        while (this.mRecvQueue.isEmpty()) {
            if (System.currentTimeMillis() > ms) {
                throw new IOException("Timeout receiving data");
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        int v = this.mRecvQueue.pull();
        return v;
    }

    protected String[] split(String inString, String[] delimiter) {
        String[] retAr = null;
        try {
            Vector<String> list = new Vector<String>();
            int indexA = 0;
            int indexB = -1;
            int dLen = 0;
            while (indexA < inString.length()) {
                indexB = -1;
                int d = 0;
                while (d < delimiter.length) {
                    int index = inString.indexOf(delimiter[d], indexA);
                    if (index != -1 && (indexB == -1 || index < indexB)) {
                        indexB = index;
                        dLen = delimiter[d].length();
                    }
                    ++d;
                }
                if (indexB == -1) {
                    indexB = inString.length();
                }
                if (indexA == indexB && indexA == inString.length() - 1) break;
                if (indexB == -1) continue;
                list.addElement(new String(inString.substring(indexA, indexB)));
                indexA = indexB + dLen;
            }
            retAr = new String[list.size()];
            int i = 0;
            while (i < list.size()) {
                retAr[i] = (String)list.elementAt(i);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return retAr;
    }

    protected abstract void CHECK_STATUS() throws FiscalPrinterException;

    protected abstract void INIT(boolean var1, boolean var2) throws IOException, FiscalPrinterException, IllegalArgumentException;

    public void setChkInputParams(boolean toValue) {
        this.chkInputParams = toValue;
    }

    public boolean getChkInputParams() {
        return this.chkInputParams;
    }

    public void setAutoCutInputParams(boolean toValue) {
        this.autoCutInputParams = toValue;
    }

    public boolean getAutoCutInputParams() {
        return this.autoCutInputParams;
    }

    public void setLanguageIndex(int toValue) {
        this.languageIndex = toValue;
    }

    public int getLanguageIndex() {
        return this.languageIndex;
    }

    public boolean notInt(String value) {
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return true;
        }
        return false;
    }

    public boolean notDbl(String value) {
        try {
            Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return true;
        }
        return false;
    }

    public int toInt(String value) {
        return Integer.parseInt(value);
    }

    public double toDouble(String value) {
        return Double.parseDouble(value);
    }

    public FPBase(InputStream in, OutputStream out, int encoding) {
        this.mIn = in;
        this.mOut = out;
        this.mEncoding = encoding;
        this.mPacketSeq = 32;
        this.mRecvQueue = new FifoBuffer(224);
        this.mActive = true;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (FPBase.this.mActive) {
                        int b = FPBase.this.mIn.read();
                        if (b == -1) {
                            throw new IOException("The end of the stream is reached");
                        }
                        FPBase.this.mRecvQueue.push(b);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        t.start();
    }

    public final synchronized void close() {
        this.mActive = false;
        try {
            this.mIn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.mOut.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String formatNumber(double n, int digits) {
        StringBuffer sb = new StringBuffer();
        if (digits > 0) {
            String nstr;
            sb.append((int)n);
            sb.append('.');
            n -= (double)((int)n);
            int i = 0;
            while (i < digits) {
                n *= 10.0;
                ++i;
            }
            if (n * 10.0 % 10.0 >= 5.0) {
                n += 1.0;
            }
            if ((nstr = Integer.toString((int)n)).length() < digits) {
                int i2 = 0;
                while (i2 < digits - nstr.length()) {
                    sb.append('0');
                    ++i2;
                }
            }
            sb.append(nstr);
        } else {
            if (n * 10.0 % 10.0 >= 5.0) {
                n += 1.0;
            }
            sb.append((int)n);
        }
        return sb.toString();
    }

    public byte[] getLastStatus() {
        return this.mSB;
    }

    public String customCommand(int cmd, String data) throws IOException, FiscalPrinterException {
        ++this.mPacketSeq;
        if (this.mPacketSeq > 127) {
            this.mPacketSeq = 32;
        }
        this.mRecvQueue.empty();
        this.writePacket(cmd, data);
        String r = this.readPacket();
        if (cmd != 74) {
            this.CHECK_STATUS();
        }
        return r;
    }

    public byte[] queryStatus() throws IOException, FiscalPrinterException {
        this.customCommand(74, null);
        return this.mSB;
    }

    public boolean getStatusBitBol(int byteIndex, int bitIndex) {
        boolean isFired = false;
        switch (bitIndex) {
            case 7: {
                if ((this.mSB[byteIndex] & 0x80) <= 0) break;
                isFired = true;
                break;
            }
            case 6: {
                if ((this.mSB[byteIndex] & 0x40) <= 0) break;
                isFired = true;
                break;
            }
            case 5: {
                if ((this.mSB[byteIndex] & 0x20) <= 0) break;
                isFired = true;
                break;
            }
            case 4: {
                if ((this.mSB[byteIndex] & 0x10) <= 0) break;
                isFired = true;
                break;
            }
            case 3: {
                if ((this.mSB[byteIndex] & 8) <= 0) break;
                isFired = true;
                break;
            }
            case 2: {
                if ((this.mSB[byteIndex] & 4) <= 0) break;
                isFired = true;
                break;
            }
            case 1: {
                if ((this.mSB[byteIndex] & 2) <= 0) break;
                isFired = true;
                break;
            }
            case 0: {
                if ((this.mSB[byteIndex] & 1) <= 0) break;
                isFired = true;
                break;
            }
            default: {
                isFired = false;
            }
        }
        return isFired;
    }

    protected String padRight(String str, int size, char padChar) {
        StringBuffer padded = new StringBuffer(str);
        while (padded.length() < size) {
            padded.append(padChar);
        }
        return padded.toString();
    }

    private class FifoBuffer {
        private byte[] mBuf;
        private int mHead;
        private int mSize;

        public FifoBuffer(int capacity) {
            if (capacity < 1) {
                throw new IllegalArgumentException("Invalid capacity");
            }
            this.mBuf = new byte[capacity];
            this.empty();
        }

        public synchronized void empty() {
            this.mHead = 0;
            this.mSize = 0;
        }

        public synchronized boolean isEmpty() {
            return this.mSize == 0;
        }

        public synchronized void push(int b) {
            if (this.mSize == this.mBuf.length) {
                this.pull();
            }
            this.mBuf[(this.mHead + this.mSize) % this.mBuf.length] = (byte)b;
            ++this.mSize;
        }

        public synchronized int pull() {
            if (this.isEmpty()) {
                return -1;
            }
            int b = this.mBuf[this.mHead] & 0xFF;
            this.mHead = (this.mHead + 1) % this.mBuf.length;
            --this.mSize;
            return b;
        }
    }
}

