package bg.datecs.drawerdemo.fragment;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ListFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.List;

import bg.datecs.drawerdemo.R;

import static android.app.Activity.RESULT_OK;

public class BluetoothFragment extends ListFragment implements AdapterView.OnItemClickListener {

    private static final int REQUEST_ENABLE_BT = 1;

    private List<BluetoothDevice> mBtDeviceList;

    private ClickListener mListener;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mBtDeviceList = new ArrayList<>();
    }

    @Override
    public View onCreateView(LayoutInflater inflater,
                            ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_bluetooth, container, false);
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        mListener = (ClickListener) getActivity();
        initDevices();
        getListView().setOnItemClickListener(this);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == REQUEST_ENABLE_BT) {
            if (resultCode == RESULT_OK) {
                initDevices();
            } else {
                getActivity().finish();
            }
            return;
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
        mListener.onClick(mBtDeviceList.get(position));
    }

    private void initDevices() {
        BluetoothAdapter btAdapter = BluetoothAdapter.getDefaultAdapter();
        if (!btAdapter.isEnabled()) {
            Intent enableBtIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
            startActivityForResult(enableBtIntent, REQUEST_ENABLE_BT);
            return;
        }

        mBtDeviceList.clear();
        for (BluetoothDevice device: btAdapter.getBondedDevices()) {
            mBtDeviceList.add(device);
        }

        ArrayAdapter adapter = new DeviceAdapter(getContext(), mBtDeviceList);
        setListAdapter(adapter);
    }

    private class DeviceAdapter extends ArrayAdapter<BluetoothDevice> {

        final List<BluetoothDevice> mDeviceList;

        DeviceAdapter(Context context, List<BluetoothDevice> deviceList) {
            super(context, android.R.layout.simple_list_item_2, android.R.id.text1, deviceList);
            mDeviceList = deviceList;
        }

        @NonNull
        @Override
        public View getView(int position, View convertView, @NonNull ViewGroup parent) {
            View view = super.getView(position, convertView, parent);
            TextView text1 = (TextView) view.findViewById(android.R.id.text1);
            TextView text2 = (TextView) view.findViewById(android.R.id.text2);

            BluetoothDevice device = mDeviceList.get(position);
            if (device != null) {
                text1.setText(device.getName());
                text2.setText(device.getAddress());
            }
            return view;
        }
    }

    public interface ClickListener {
        void onClick(BluetoothDevice device);
    }
}