/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.universalreader;

public final class TouchEvent {
    public static final int ACTION_DOWN = 0;
    public static final int ACTION_UP = 1;
    private int mX;
    private int mY;
    private int mPressure;
    private int mElapse;

    public static TouchEvent[] obtainArray(byte[] data) {
        if (data == null) {
            throw new NullPointerException("The data is null");
        }
        if (data.length % 4 != 0) {
            throw new IllegalArgumentException("The data.length % 4 is not a 0");
        }
        TouchEvent[] events = new TouchEvent[data.length / 4];
        for (int i = 0; i < events.length; ++i) {
            events[i] = new TouchEvent(data[i * 4] & 0xFF, data[i * 4 + 1] & 0xFF, data[i * 4 + 2] & 0xFF, (data[i * 4 + 3] & 0xFF) * 4);
        }
        return events;
    }

    public TouchEvent(int x, int y, int pressure, int elapse) {
        this.mX = x;
        this.mY = y;
        this.mPressure = pressure;
        this.mElapse = elapse;
    }

    public int getX() {
        return this.mX;
    }

    public int getY() {
        return this.mY;
    }

    public int getPressure() {
        return this.mPressure;
    }

    public int getElapse() {
        if (this.mElapse > 1000) {
            return -1;
        }
        return this.mElapse;
    }

    public int getAction() {
        if (this.mY < 255) {
            return 0;
        }
        return 1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Action=" + this.getAction());
        sb.append(",X=" + this.getX());
        sb.append(",Y=" + this.getY());
        sb.append(",Pressure=" + this.getPressure());
        sb.append(",Elapse=" + this.getElapse());
        return sb.toString();
    }
}

