/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.rfid;

import com.datecs.rfid.ContactlessCard;
import com.datecs.rfid.RC663;
import com.datecs.rfid.RFIDException;
import java.io.IOException;

public class STSRICard
extends ContactlessCard {
    public STSRICard(RC663 module) {
        super(module);
    }

    @Override
    protected boolean deinitialise() throws IOException {
        block4: while (true) {
            try {
                while (true) {
                    this.getUID();
                    try {
                        Thread.sleep(500L);
                        continue block4;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (RFIDException e) {
                return true;
            }
        }
    }

    @Override
    public boolean initialize() throws IOException {
        this.blockSize = 4;
        this.maxBlocks = 0;
        return true;
    }

    public void completion() throws IOException, RFIDException {
        byte[] cmd = new byte[32];
        int index = 0;
        cmd[index++] = 15;
        this.mModule.transmitCard(this.channel, cmd, index);
    }

    public void reset() throws IOException, RFIDException {
        byte[] cmd = new byte[32];
        int index = 0;
        cmd[index++] = 12;
        this.mModule.transmitCard(this.channel, cmd, index);
    }

    public byte[] readBlock(int address) throws IOException, RFIDException {
        byte[] cmd = new byte[32];
        int index = 0;
        cmd[index++] = 8;
        cmd[index++] = (byte)address;
        byte[] result = this.mModule.transmitCard(this.channel, cmd, index);
        if (result.length != 4) {
            throw new RFIDException(-6);
        }
        return result;
    }

    public void writeBlock(int address, byte[] data) throws IOException, RFIDException {
        byte[] cmd = new byte[32];
        int index = 0;
        cmd[index++] = 9;
        cmd[index++] = (byte)address;
        System.arraycopy(data, 0, cmd, index, 4);
        this.mModule.transmitCard(this.channel, cmd, index += 4);
    }

    public byte[] getUID() throws IOException, RFIDException {
        byte[] cmd = new byte[32];
        int index = 0;
        cmd[index++] = 11;
        byte[] result = this.mModule.transmitCard(this.channel, cmd, index);
        if (result.length != 8) {
            throw new RFIDException(-6);
        }
        return result;
    }
}

