/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.rfid;

import java.io.IOException;

public class RFIDException
extends IOException {
    private static final long serialVersionUID = 1L;
    public static final int ERROR_TIMEOUT = -6;
    public static final int ERROR_FAILED = -20;
    public static final int ERROR_MIFARE_EBASE = -10000;
    public static final int ERROR_MIFARE_ETIMEOUT = -10001;
    public static final int ERROR_MIFARE_ECOLLISION = -10002;
    public static final int ERROR_MIFARE_EPARITY = -10003;
    public static final int ERROR_MIFARE_EFRAME = -10004;
    public static final int ERROR_MIFARE_ECRC = -10005;
    public static final int ERROR_MIFARE_EFIFO = -10006;
    public static final int ERROR_MIFARE_EEEPROM = -10007;
    public static final int ERROR_MIFARE_EKEY = -10008;
    public static final int ERROR_MIFARE_EGENERIC = -10009;
    public static final int ERROR_MIFARE_EAUTHENTICATION = -10010;
    public static final int ERROR_MIFARE_ECODE = -10011;
    public static final int ERROR_MIFARE_EBIT = -10012;
    public static final int ERROR_MIFARE_EACCESS = -10013;
    public static final int ERROR_MIFARE_EVALUE = -10014;
    private int mErrorCode;

    public RFIDException(int errorCode) {
        super(RFIDException.getErrorAsString(errorCode));
        this.mErrorCode = errorCode;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    private static String getErrorAsString(int errorCode) {
        switch (errorCode) {
            case -6: {
                return "Timeout expired";
            }
            case -20: {
                return "Command failed";
            }
            case -10000: {
                return "Mifare operation successful";
            }
            case -10001: {
                return "Mifare timeout error";
            }
            case -10002: {
                return "Mifare collision error";
            }
            case -10003: {
                return "Mifare parity error";
            }
            case -10004: {
                return "Mifare frame error";
            }
            case -10005: {
                return "Mifare CRC error";
            }
            case -10006: {
                return "Mifare FIFO overflow";
            }
            case -10007: {
                return "Mifare EEPROM error";
            }
            case -10008: {
                return "Mifare invalid key";
            }
            case -10009: {
                return "Mifare generic error";
            }
            case -10010: {
                return "Mifare authentication error";
            }
            case -10011: {
                return "Mifare code error";
            }
            case -10012: {
                return "Mifare bit count error";
            }
            case -10013: {
                return "Mifare access error";
            }
            case -10014: {
                return "Mifare value error";
            }
        }
        return "Unspecified error code " + errorCode;
    }
}

