/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.rfid;

import com.datecs.rfid.ContactlessCard;
import com.datecs.rfid.RC663;
import com.datecs.rfid.RFIDException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class ISO14443Card
extends ContactlessCard {
    private static final int MAX_UID_LEN = 10;
    private static final int MF_SELECT = 147;
    private static final int MF_SETKEY = 1;
    private static final int MF_AUTHENTA = 96;
    private static final int MF_AUTHENTB = 97;
    private static final int MF_READ16 = 48;
    private static final int MF_WRITE16 = 160;
    private static final int MF_WRITE4 = 162;
    private static final int MF_HALT = 80;
    private byte[] mUUIDSelected = new byte[10];
    private boolean mSelectNeeded = true;
    private byte mBlockChain = 0;
    private boolean mProtocol;
    private byte[] mRats;
    private byte[] mAts;
    private int mStatus;

    public ISO14443Card(RC663 module) {
        super(module);
    }

    @Override
    protected boolean deinitialise() throws IOException {
        block4: while (true) {
            try {
                while (true) {
                    this.select(true);
                    try {
                        Thread.sleep(500L);
                        continue block4;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (RFIDException e) {
                return true;
            }
        }
    }

    @Override
    public boolean initialize() throws IOException {
        this.type = 0;
        this.capacity = 0;
        if ((this.sak == 36 || this.sak == 32) && this.atqa == 17411) {
            this.type = 9;
        } else if (this.sak == 0 && this.atqa == 17408) {
            this.type = 4;
        } else if (this.sak == 9 && (this.atqa & 0xF00) == 1024) {
            this.type = 1;
            this.capacity = 320;
        } else if (this.sak == 8 && (this.atqa & 0xF00) == 1024) {
            this.type = 2;
            this.capacity = 1024;
        } else if (this.sak == 24 && (this.atqa & 0xF00) == 512) {
            this.type = 3;
            this.capacity = 4096;
        } else if (this.sak == 24 && (this.atqa & 0xF00) == 512) {
            this.type = 3;
            this.capacity = 4096;
        } else if (!(this.sak != 32 && this.sak != 16 && this.sak != 17 && this.sak != 8 && this.sak != 24 || this.atqa != 17408 && this.atqa != 16896 && this.atqa != 1024 && this.atqa != 512)) {
            this.type = 7;
            this.capacity = 2048;
        } else if (!(this.sak != 32 && this.sak != 16 && this.sak != 17 && this.sak != 8 && this.sak != 24 || this.atqa != 17408 && this.atqa != 16896 && this.atqa != 1024 && this.atqa != 512)) {
            this.type = 7;
            this.capacity = 2048;
        } else if ((this.sak & 2) == 0 && (this.sak & 8) == 0 && (this.sak & 0x10) == 0 && (this.sak & 0x20) == 1) {
            this.type = 6;
        } else if (this.sak == 40 || this.sak == 32 && this.atqa == 1024 || this.sak == 32 && this.atqa == 18432 || this.sak == 40 && this.atqa == 1024 || this.sak == 32 && this.atqa == 2048) {
            this.capacity = 0;
            try {
                this.getATS();
                byte[] lds = new byte[]{-96, 0, 0, 2, 71, 16, 1};
                byte[] rapdu = this.executeAPDU(0, 164, 4, 12, lds, -1);
                if ((rapdu[rapdu.length - 2] & 0xFF) != 144 || rapdu[rapdu.length - 1] != 0) {
                    throw new RFIDException(-20);
                }
                this.type = 16;
                return true;
            }
            catch (RFIDException e) {
                e.printStackTrace();
                this.type = 13;
                return true;
            }
        }
        return true;
    }

    private void selectCard() throws IOException, RFIDException {
        this.select(this.mSelectNeeded);
    }

    private void select(boolean force) throws IOException, RFIDException {
        if (!force) {
            boolean match = true;
            for (int i = 0; i < this.uid.length && match; ++i) {
                match = this.uid[i] == this.mUUIDSelected[i];
            }
            if (match) {
                return;
            }
        }
        byte[] cmd = new byte[32];
        int index = 0;
        cmd[index++] = -109;
        System.arraycopy(this.uid, 0, cmd, index, this.uid.length);
        this.mModule.transmitCard(this.channel, cmd, index += this.uid.length);
        this.mSelectNeeded = false;
        System.arraycopy(this.uid, 0, this.mUUIDSelected, 0, this.uid.length);
    }

    public void loadKey(int keyIndex, char type, byte[] key) throws IOException, RFIDException {
        byte[] cmd = new byte[32];
        int index = 0;
        cmd[index++] = 1;
        cmd[index++] = (byte)keyIndex;
        cmd[index++] = (byte)type;
        System.arraycopy(key, 0, cmd, index, key.length);
        this.mModule.transmitCard(1, cmd, index += key.length);
    }

    public void authenticate(char type, int address, byte[] key) throws IOException, RFIDException {
        this.selectCard();
        byte[] cmd = new byte[32];
        int index = 0;
        cmd[index++] = (byte)(type == 'A' ? 96 : 97);
        cmd[index++] = (byte)address;
        System.arraycopy(this.uid, this.uid.length - 4, cmd, index, 4);
        System.arraycopy(key, 0, cmd, index += 4, key.length);
        index += key.length;
        try {
            this.mModule.transmitCard(this.channel, cmd, index);
        }
        catch (RFIDException e) {
            this.mSelectNeeded = true;
            throw e;
        }
    }

    public void authenticate(char type, int address, int keyIndex) throws IOException, RFIDException {
        this.selectCard();
        byte[] cmd = new byte[32];
        int index = 0;
        cmd[index++] = (byte)(type == 'A' ? 96 : 97);
        cmd[index++] = (byte)address;
        cmd[index++] = (byte)keyIndex;
        System.arraycopy(this.uid, 0, cmd, index, this.uid.length);
        index += this.uid.length;
        try {
            this.mModule.transmitCard(this.channel, cmd, index);
        }
        catch (RFIDException e) {
            this.mSelectNeeded = true;
            throw e;
        }
    }

    public byte[] read16(int address) throws IOException, RFIDException {
        this.selectCard();
        byte[] cmd = new byte[32];
        int index = 0;
        cmd[index++] = 48;
        cmd[index++] = (byte)address;
        try {
            byte[] result = this.mModule.transmitCard(this.channel, cmd, index);
            if (result.length < 16) {
                throw new RFIDException(-6);
            }
            if (result.length > 16) {
                byte[] tmp = new byte[16];
                System.arraycopy(result, 0, tmp, 0, tmp.length);
                result = tmp;
            }
            return result;
        }
        catch (RFIDException e) {
            this.mSelectNeeded = true;
            throw e;
        }
    }

    public void write16(int address, byte[] data) throws IOException, RFIDException {
        this.selectCard();
        byte[] cmd = new byte[32];
        int index = 0;
        cmd[index++] = -96;
        cmd[index++] = (byte)address;
        System.arraycopy(data, 0, cmd, index, data.length);
        index += data.length;
        try {
            this.mModule.transmitCard(this.channel, cmd, index);
        }
        catch (RFIDException e) {
            this.mSelectNeeded = true;
            throw e;
        }
    }

    public void write4(int address, byte[] data) throws IOException, RFIDException {
        this.selectCard();
        byte[] cmd = new byte[32];
        int index = 0;
        cmd[index++] = -94;
        cmd[index++] = (byte)address;
        System.arraycopy(data, 0, cmd, index, data.length);
        index += data.length;
        try {
            this.mModule.transmitCard(this.channel, cmd, index);
        }
        catch (RFIDException e) {
            this.mSelectNeeded = true;
            throw e;
        }
    }

    public void ulcSetKey(byte[] key) throws IOException, RFIDException {
        int i;
        this.selectCard();
        byte[] cmd = new byte[16];
        for (i = 0; i < 8; ++i) {
            cmd[i] = key[8 - i - 1];
            cmd[8 + i] = key[16 - i - 1];
        }
        for (i = 0; i < 4; ++i) {
            byte[] tmp = new byte[4];
            System.arraycopy(cmd, i * 4, tmp, 0, tmp.length);
            this.write4(44 + i, tmp);
        }
    }

    private void halt() throws IOException, RFIDException {
        byte[] cmd = new byte[]{80, 0};
        this.mSelectNeeded = true;
        this.mModule.transmitCard(this.channel, cmd, cmd.length);
    }

    private static void rol(byte[] data, int offset, int len) {
        byte first = data[offset];
        for (int i = 0; i < len - 1; ++i) {
            data[offset + i] = data[offset + i + 1];
        }
        data[offset + len - 1] = first;
    }

    private static byte[] decryptCBC3DES(byte[] key, byte[] iv, byte[] input, int offset, int length) {
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec newKey = new SecretKeySpec(key, "DESede");
            Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
            cipher.init(2, (Key)newKey, ivSpec);
            return cipher.doFinal(input, offset, length);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] encryptCBC3DES(byte[] key, byte[] iv, byte[] input, int offset, int length) {
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            SecretKeySpec newKey = new SecretKeySpec(key, "DESede");
            Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
            cipher.init(1, (Key)newKey, ivSpec);
            return cipher.doFinal(input, offset, length);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void ulcAuthenticate(byte[] key) throws IOException, RFIDException {
        byte[] iv = new byte[8];
        byte[] cmd = new byte[32];
        int index = 0;
        cmd[index++] = 26;
        cmd[index++] = 0;
        byte[] result = this.mModule.transmitCard(this.channel, cmd, index);
        Random generator = new Random(System.currentTimeMillis());
        byte[] random = new byte[8];
        generator.nextBytes(random);
        index = 0;
        cmd[index++] = -81;
        System.arraycopy(random, 0, cmd, index, random.length);
        byte[] dec = ISO14443Card.decryptCBC3DES(key, iv, result, 1, 8);
        System.arraycopy(dec, 0, cmd, index += random.length, dec.length);
        ISO14443Card.rol(cmd, index, 8);
        index += 8;
        for (int n = 0; n < iv.length; ++n) {
            iv[n] = 0;
        }
        byte[] enc = ISO14443Card.encryptCBC3DES(key, iv, cmd, 1, 16);
        System.arraycopy(enc, 0, cmd, 1, enc.length);
        this.mModule.transmitCard(this.channel, cmd, index);
    }

    public byte[] getATS() throws IOException, RFIDException {
        if (!this.mProtocol) {
            this.mBlockChain = 0;
            byte[] rats = new byte[]{-32, -128};
            byte[] result = null;
            try {
                result = this.mModule.transmitCard(this.channel, rats, rats.length);
            }
            catch (RFIDException e) {
                this.mSelectNeeded = true;
                throw e;
            }
            this.mProtocol = true;
            this.mRats = rats;
            this.mAts = rats;
            return result;
        }
        return this.mAts;
    }

    public byte[] getAttribB(int p1, int p2, int p3, int p4) throws IOException, RFIDException {
        byte[] cmd = new byte[256];
        int index = 0;
        cmd[index++] = 29;
        cmd[index++] = this.uid[0];
        cmd[index++] = this.uid[1];
        cmd[index++] = this.uid[2];
        cmd[index++] = this.uid[3];
        cmd[index++] = (byte)p1;
        cmd[index++] = (byte)p2;
        cmd[index++] = (byte)p3;
        cmd[index++] = (byte)p4;
        byte[] result = this.mModule.transmitCard(this.channel, cmd, index);
        return result;
    }

    public boolean isPresentB() throws IOException {
        byte[] cmd = new byte[256];
        int index = 0;
        cmd[index++] = 2;
        cmd[index++] = -1;
        cmd[index++] = -1;
        cmd[index++] = -1;
        cmd[index++] = -1;
        cmd[index++] = 0;
        try {
            this.mModule.transmitCard(this.channel, cmd, index);
        }
        catch (RFIDException e) {
            return false;
        }
        return true;
    }

    public byte[] transceiveA(byte[] data) throws IOException, RFIDException {
        byte[] result = this.mModule.transmitCard(this.channel, data, data.length);
        if (result.length < 1) {
            throw new RFIDException(-6);
        }
        byte[] tmp = new byte[result.length - 2];
        System.arraycopy(result, 0, tmp, 0, tmp.length);
        return tmp;
    }

    public byte[] transceiveB(byte[] data) throws IOException, RFIDException {
        byte[] cmd = new byte[280];
        int index = 0;
        cmd[index++] = (byte)(2 | this.mBlockChain & 1);
        for (int i = 0; i < data.length; ++i) {
            cmd[index++] = data[i];
        }
        byte[] result = this.mModule.transmitCard(this.channel, cmd, index);
        this.mBlockChain = (byte)(this.mBlockChain + 1);
        if (result.length < 4) {
            throw new RFIDException(-6);
        }
        byte[] tmp = new byte[result.length - 3];
        System.arraycopy(result, 1, tmp, 0, tmp.length);
        return tmp;
    }

    public byte[] transceive(byte[] data) throws IOException, RFIDException {
        byte[] cmd = new byte[280];
        int index = 0;
        if (this.mProtocol) {
            cmd[index++] = (byte)(2 | this.mBlockChain & 1);
            for (int i = 0; i < data.length; ++i) {
                cmd[index++] = data[i];
            }
            byte[] result = this.mModule.transmitCard(this.channel, cmd, index);
            this.mBlockChain = (byte)(this.mBlockChain + 1);
            if (result.length < 4) {
                throw new RFIDException(-6);
            }
            this.mStatus = result[0] & 0xFF;
            byte[] tmp = new byte[result.length - 3];
            System.arraycopy(result, 1, tmp, 0, tmp.length);
            return tmp;
        }
        for (int i = 0; i < data.length; ++i) {
            cmd[index++] = data[i];
        }
        byte[] result = this.mModule.transmitCard(this.channel, cmd, index);
        this.mBlockChain = (byte)(this.mBlockChain + 1);
        if (result.length < 4) {
            throw new RFIDException(-6);
        }
        this.mStatus = result[0] & 0xFF;
        byte[] tmp = new byte[result.length - 3];
        System.arraycopy(result, 1, tmp, 0, tmp.length);
        return tmp;
    }

    public byte[] executeAPDU(int cla, int ins, int p1, int p2, byte[] data) throws IOException, RFIDException {
        return this.executeAPDU(cla, ins, p1, p2, data, 0);
    }

    public byte[] executeAPDU(int cla, int ins, int p1, int p2, byte[] data, int le) throws IOException, RFIDException {
        byte[] cmd = new byte[256];
        int index = 0;
        cmd[index++] = (byte)cla;
        cmd[index++] = (byte)ins;
        cmd[index++] = (byte)p1;
        cmd[index++] = (byte)p2;
        if (data != null && data.length > 0) {
            cmd[index++] = (byte)data.length;
            for (int i = 0; i < data.length; ++i) {
                cmd[index++] = data[i];
            }
        }
        if (le >= 0) {
            cmd[index++] = (byte)le;
        }
        byte[] buffer = new byte[index];
        System.arraycopy(cmd, 0, buffer, 0, index);
        byte[] result = this.transceive(buffer);
        if (result.length < 2) {
            throw new RFIDException(-6);
        }
        byte[] tmp = new byte[result.length - 1];
        System.arraycopy(result, 1, tmp, 0, tmp.length);
        return result;
    }

    public DESFire DESFire() {
        return new DESFire();
    }

    public class DESFire {
        private int mStatus;

        public int getStatus() {
            return this.mStatus;
        }

        private void rol(byte[] data, int offset, int length) {
            byte first = data[offset];
            for (int i = 0; i < length - 1; ++i) {
                data[offset + i] = data[offset + i + 1];
            }
            data[offset + length - 1] = first;
        }

        private void ror(byte[] data, int offset, int length) {
            byte last = data[offset + length - 1];
            for (int i = length - 1; i >= 1; --i) {
                data[offset + i] = data[offset + i - 1];
            }
            data[offset] = last;
        }

        private byte[] transceive(byte[] data) throws IOException, RFIDException {
            byte[] src = ISO14443Card.this.transceiveB(data);
            byte[] dst = new byte[src.length - 1];
            System.arraycopy(src, 1, dst, 0, dst.length);
            this.mStatus = src[0] & 0xFF;
            return dst;
        }

        private byte[] transceive(byte[] data, int length) throws IOException, RFIDException {
            byte[] tmp = new byte[length];
            System.arraycopy(data, 0, tmp, 0, tmp.length);
            return this.transceive(tmp, length);
        }

        public byte[] authenticateAES(byte[] key, int keyIndex) throws IOException, RFIDException {
            SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
            byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            byte[] authRoundOneCmd = new byte[]{-86, (byte)keyIndex};
            byte[] result = this.transceive(authRoundOneCmd);
            if (this.getStatus() != -81) {
                throw new RFIDException(-20);
            }
            Cipher cipher = null;
            byte[] rndB = null;
            try {
                cipher = Cipher.getInstance("AES/CBC/NoPadding");
                cipher.init(2, (Key)keySpec, new IvParameterSpec(iv));
                rndB = cipher.doFinal(result);
                this.rol(rndB, 0, rndB.length);
            }
            catch (Exception e) {
                throw new RFIDException(-20);
            }
            byte[] rndA = new byte[]{35, 71, -63, 85, 127, -128, 112, 122, -67, -1, -122, -65, -99, -106, 92, -89};
            byte[] rndARndB = new byte[32];
            System.arraycopy(rndA, 0, rndARndB, 0, rndA.length);
            System.arraycopy(rndB, 0, rndARndB, 16, rndB.length);
            byte[] rndBoth = null;
            try {
                cipher.init(1, (Key)keySpec, new IvParameterSpec(iv));
                rndBoth = cipher.doFinal(rndARndB);
            }
            catch (Exception e) {
                throw new RFIDException(-20);
            }
            byte[] authCmd = new byte[33];
            authCmd[0] = -81;
            System.arraycopy(rndBoth, 0, authCmd, 1, rndBoth.length);
            result = this.transceive(authCmd);
            if (this.getStatus() != 0) {
                throw new RFIDException(-20);
            }
            byte[] rndAPrime = null;
            try {
                cipher.init(2, (Key)keySpec, new IvParameterSpec(iv));
                rndAPrime = cipher.doFinal(result);
            }
            catch (Exception e) {
                throw new RFIDException(-20);
            }
            byte[] rndACheck = new byte[16];
            System.arraycopy(rndAPrime, 0, rndACheck, 0, rndACheck.length);
            this.ror(rndACheck, 0, rndACheck.length);
            for (int i = 0; i < 16; ++i) {
                if (rndACheck[i] == rndA[i]) continue;
                throw new RFIDException(-20);
            }
            ByteArrayOutputStream session = new ByteArrayOutputStream();
            session.write(rndA, 0, 4);
            session.write(rndB, 0, 4);
            session.write(rndA, 12, 4);
            session.write(rndB, 12, 4);
            return session.toByteArray();
        }

        public void createFile(int fileID, int type, int permissions, int size, int isoID) throws IOException, RFIDException {
            byte[] cmd = new byte[256];
            int cmdLen = 0;
            cmd[cmdLen++] = -51;
            cmd[cmdLen++] = (byte)fileID;
            if (isoID != 0) {
                cmd[cmdLen++] = (byte)isoID;
                cmd[cmdLen++] = (byte)(isoID >> 8);
                cmd[cmdLen++] = (byte)(isoID >> 16);
                cmd[cmdLen++] = (byte)(isoID >> 24);
            }
            cmd[cmdLen++] = (byte)type;
            cmd[cmdLen++] = (byte)permissions;
            cmd[cmdLen++] = (byte)(permissions >> 8);
            cmd[cmdLen++] = (byte)size;
            cmd[cmdLen++] = (byte)(size >> 8);
            cmd[cmdLen++] = (byte)(size >> 16);
            this.transceive(cmd, cmd.length);
            if (this.getStatus() != 0) {
                throw new RFIDException(-20);
            }
        }

        public void writeFile(int fileID, byte[] data) throws IOException, RFIDException {
            int nbw;
            int DF_MAX_WRITE_LEN = 52;
            byte[] cmd = new byte[256];
            int cmdLen = 0;
            cmd[cmdLen++] = 61;
            cmd[cmdLen++] = (byte)fileID;
            cmd[cmdLen++] = 0;
            cmd[cmdLen++] = 0;
            cmd[cmdLen++] = 0;
            cmd[cmdLen++] = (byte)data.length;
            cmd[cmdLen++] = (byte)(data.length >> 8);
            cmd[cmdLen++] = (byte)(data.length >> 16);
            for (int offset = 0; offset < data.length; offset += nbw) {
                nbw = data.length - offset;
                if (nbw > 52) {
                    nbw = 52;
                }
                System.arraycopy(cmd, cmdLen, data, offset, nbw);
                this.transceive(cmd, cmdLen += nbw);
                if (this.getStatus() != 175 && this.getStatus() != 0) {
                    throw new RFIDException(-20);
                }
                cmdLen = 0;
                cmd[cmdLen++] = -81;
            }
        }

        public byte[] readFile(int fileID, int length) throws IOException, RFIDException {
            byte[] cmd = new byte[]{-67, (byte)fileID, 0, 0, 0, (byte)length, (byte)(length >> 8), (byte)(length >> 16)};
            int cmdLen = cmd.length;
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            while (true) {
                byte[] result = this.transceive(cmd, cmdLen);
                data.write(result);
                if (this.getStatus() == 0) {
                    return data.toByteArray();
                }
                if (this.getStatus() != 175) {
                    throw new RFIDException(-20);
                }
                cmd[0] = -81;
                cmdLen = 1;
            }
        }

        public void selectApplication(int app) throws IOException, RFIDException {
            byte[] cmd = new byte[]{90, (byte)app, (byte)(app >> 8), (byte)(app >> 16)};
            this.transceive(cmd);
            if (this.getStatus() != 0) {
                throw new RFIDException(-20);
            }
        }
    }
}

