/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.crypto;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class TripleDES {
    public static byte[] alignKey(byte[] key) {
        if (key.length == 16) {
            byte[] tmp = new byte[24];
            System.arraycopy(key, 0, tmp, 0, 16);
            System.arraycopy(key, 0, tmp, 16, 8);
            return tmp;
        }
        return key;
    }

    public static byte[] encryptECB(byte[] keyBytes, byte[] dataBytes) {
        byte[] key = TripleDES.alignKey(keyBytes);
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, "DESede");
            Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
            cipher.init(1, keySpec);
            return cipher.doFinal(dataBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decryptECB(byte[] keyBytes, byte[] dataBytes) {
        byte[] key = TripleDES.alignKey(keyBytes);
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, "DESede");
            Cipher cipher = Cipher.getInstance("DESede/ECB/NoPadding");
            cipher.init(2, keySpec);
            return cipher.doFinal(dataBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] encryptCBC(byte[] keyBytes, byte[] ivBytes, byte[] dataBytes) {
        byte[] key = TripleDES.alignKey(keyBytes);
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
            SecretKeySpec keySpec = new SecretKeySpec(key, "DESede");
            Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
            cipher.init(1, (Key)keySpec, ivSpec);
            return cipher.doFinal(dataBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] encryptCBC(byte[] keyBytes, byte[] dataBytes) {
        return TripleDES.encryptCBC(keyBytes, new byte[8], dataBytes);
    }

    public static byte[] decryptCBC(byte[] keyBytes, byte[] ivBytes, byte[] dataBytes) {
        byte[] key = TripleDES.alignKey(keyBytes);
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
            SecretKeySpec keySpec = new SecretKeySpec(key, "DESede");
            Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
            cipher.init(2, (Key)keySpec, ivSpec);
            return cipher.doFinal(dataBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decryptCBC(byte[] keyBytes, byte[] ivBytes, byte[] dataBytes, int offset, int length) {
        byte[] key = TripleDES.alignKey(keyBytes);
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
            SecretKeySpec keySpec = new SecretKeySpec(key, "DESede");
            Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
            cipher.init(2, (Key)keySpec, ivSpec);
            return cipher.doFinal(dataBytes, offset, length);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decryptCBC(byte[] keyBytes, byte[] dataBytes) {
        return TripleDES.decryptCBC(keyBytes, new byte[8], dataBytes);
    }

    public static byte[] decryptCBC(byte[] keyBytes, byte[] dataBytes, int offset, int length) {
        return TripleDES.decryptCBC(keyBytes, new byte[8], dataBytes, offset, length);
    }
}

