/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.card;

public final class FinancialCard {
    private String mNumber;
    private String mName;
    private int mExpMonth;
    private int mExpYear;
    private String mServiceCode;

    public FinancialCard(String data) {
        int fi = 0;
        int li = 0;
        if (data == null) {
            throw new NullPointerException("The data is null");
        }
        if (data.startsWith("%B")) {
            fi = data.indexOf(94);
            li = data.lastIndexOf(94);
            if (fi > 2) {
                this.mNumber = data.substring(2, fi);
            }
            if (fi < li) {
                this.mName = data.substring(fi + 1, li).trim();
            }
            if (li > 0 && li + 7 < data.length()) {
                this.mExpYear = (data.charAt(li + 1) & 0xF) * 10 + (data.charAt(li + 2) & 0xF);
                this.mExpMonth = (data.charAt(li + 3) & 0xF) * 10 + (data.charAt(li + 4) & 0xF);
                this.mServiceCode = data.substring(li + 5, li + 8);
            }
        } else if (data.startsWith(";") && (li = data.indexOf(61)) > 0 && li + 7 < data.length()) {
            this.mNumber = data.substring(1, li);
            this.mExpYear = (data.charAt(li + 1) & 0xF) * 10 + (data.charAt(li + 2) & 0xF);
            this.mExpMonth = (data.charAt(li + 3) & 0xF) * 10 + (data.charAt(li + 4) & 0xF);
            this.mServiceCode = data.substring(li + 5, li + 8);
        }
    }

    public String getNumber() {
        return this.mNumber;
    }

    public String getName() {
        return this.mName;
    }

    public int getExpiryMonth() {
        return this.mExpMonth;
    }

    public int getExpiryYear() {
        return this.mExpYear;
    }

    public String getServiceCode() {
        return this.mServiceCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Number=" + this.mNumber);
        sb.append(",Name=" + this.mName);
        sb.append(",ExpiryMonth=" + this.mExpMonth);
        sb.append(",ExpiryYear=" + this.mExpYear);
        sb.append(",ServiceCode=" + this.mServiceCode);
        return sb.toString();
    }
}

