/*
 * Decompiled with CFR 0.152.
 */
package com.datecs.rfid;

import com.datecs.rfid.ContactlessCard;
import com.datecs.rfid.RC663;
import com.datecs.rfid.RFIDException;
import java.io.IOException;

public class ISO15693Card
extends ContactlessCard {
    private static final int ISO15_FLAG_LOW_DATA_RATE = 2;
    private static final int ISO15_FLAG_CARD_ADDRESSED = 32;
    private static final int ISO15_FLAG_OPTIONS = 64;
    private static final int ISO15_HALT = 2;
    private static final int ISO15_READ_BLOCK = 32;
    private static final int ISO15_WRITE_BLOCK = 33;
    private static final int ISO15_LOCK_BLOCK = 34;
    private static final int ISO15_SELECT = 37;
    private static final int ISO15_RESET = 38;
    private static final int ISO15_WRITE_AFI = 39;
    private static final int ISO15_LOCK_AFI = 40;
    private static final int ISO15_WRITE_DSFID = 41;
    private static final int ISO15_LOCK_DSFID = 42;
    private static final int ISO15_GET_SYSTEM_INFO = 43;
    private static final int ISO15_GET_MULTIPLE_BLOCK_SECURITY_STATUS = 44;
    private static final int ISO15_MAX_BLOCKS = 1;

    public ISO15693Card(RC663 module) {
        super(module);
    }

    @Override
    protected boolean deinitialise() throws IOException {
        block4: while (true) {
            try {
                while (true) {
                    this.getSystemInformation();
                    try {
                        Thread.sleep(500L);
                        continue block4;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (RFIDException e) {
                return true;
            }
        }
    }

    @Override
    public boolean initialize() throws IOException {
        if (this.uid[this.uid.length - 2] == 22 && ((this.uid[this.uid.length - 3] & 0xFF) >> 2 & 0x1F) == 8) {
            this.afi = 0;
            this.dsfid = 0;
            this.maxBlocks = 0;
            this.blockSize = 0;
            return true;
        }
        try {
            this.getSystemInformation();
        }
        catch (RFIDException e) {
            return false;
        }
        return true;
    }

    public void lockBlock(int block) throws IOException, RFIDException {
        byte[] cmd = new byte[32];
        int index = 0;
        cmd[index++] = 34;
        cmd[index++] = 34;
        System.arraycopy(this.uid, 0, cmd, index, this.uid.length);
        index += this.uid.length;
        cmd[index++] = (byte)block;
        this.mModule.transmitCard(this.channel, cmd, index);
    }

    public byte[] read(int startBlock, int blocks) throws IOException, RFIDException {
        byte[] cmd = new byte[32];
        int index = 0;
        cmd[index++] = 34;
        cmd[index++] = 32;
        System.arraycopy(this.uid, 0, cmd, index, this.uid.length);
        index += this.uid.length;
        cmd[index++] = (byte)startBlock;
        byte[] result = this.mModule.transmitCard(this.channel, cmd, index);
        byte[] tmp = new byte[result.length - 1];
        System.arraycopy(result, 1, tmp, 0, tmp.length);
        return tmp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int write(int startBlock, byte[] data) throws IOException, RFIDException {
        int blocks = data.length / 4;
        byte[] cmd = new byte[32];
        int written = 0;
        int flags = 34;
        int dataIndex = 0;
        while (true) {
            int index = 0;
            int toWrite = blocks - written;
            if (toWrite > 1) {
                toWrite = 1;
            }
            if (this.hyatt64Card) {
                flags = (byte)(flags | 0x40);
            }
            cmd[index++] = flags;
            cmd[index++] = 33;
            System.arraycopy(this.uid, 0, cmd, index, this.uid.length);
            index += this.uid.length;
            cmd[index++] = (byte)startBlock;
            System.arraycopy(data, dataIndex, cmd, index, toWrite * this.blockSize);
            index += toWrite * this.blockSize;
            try {
                this.mModule.transmitCard(this.channel, cmd, index);
            }
            catch (RFIDException e) {
                if (!this.hyatt64Card) {
                    this.hyatt64Card = true;
                    continue;
                }
                if (e.getErrorCode() != -6 || !this.hyatt64Card) return written;
                int rblocks = 1;
                byte[] tmp = this.read(startBlock, rblocks);
                for (int i = 0; i < 4; ++i) {
                    if (tmp[i] == data[dataIndex + i]) continue;
                    throw new RFIDException(-20);
                }
                return written;
            }
            dataIndex += toWrite * this.blockSize;
            startBlock += toWrite;
            if ((written += toWrite) >= blocks) return written;
        }
    }

    private void select() throws IOException, RFIDException {
        byte[] cmd = new byte[32];
        int index = 0;
        cmd[index++] = 34;
        cmd[index++] = 37;
        System.arraycopy(this.uid, 0, cmd, index, this.uid.length);
        this.mModule.transmitCard(this.channel, cmd, index += this.uid.length);
    }

    private void resetToReady() throws IOException, RFIDException {
        byte[] cmd = new byte[128];
        int index = 0;
        cmd[index++] = 34;
        cmd[index++] = 38;
        System.arraycopy(this.uid, 0, cmd, index, this.uid.length);
        this.mModule.transmitCard(this.channel, cmd, index += this.uid.length);
    }

    private void halt() throws IOException, RFIDException {
        byte[] cmd = new byte[128];
        int index = 0;
        cmd[index++] = 34;
        cmd[index++] = 2;
        System.arraycopy(this.uid, 0, cmd, index, this.uid.length);
        this.mModule.transmitCard(this.channel, cmd, index += this.uid.length);
    }

    public void writeAFI(byte afi) throws IOException, RFIDException {
        byte[] cmd = new byte[256];
        int index = 0;
        cmd[index++] = 34;
        cmd[index++] = 39;
        System.arraycopy(this.uid, 0, cmd, index, this.uid.length);
        index += this.uid.length;
        cmd[index++] = afi;
        this.mModule.transmitCard(this.channel, cmd, index);
        this.afi = afi;
    }

    public void lockAFI() throws IOException, RFIDException {
        byte[] cmd = new byte[256];
        int index = 0;
        cmd[index++] = 34;
        cmd[index++] = 40;
        System.arraycopy(this.uid, 0, cmd, index, this.uid.length);
        this.mModule.transmitCard(this.channel, cmd, index += this.uid.length);
    }

    public void writeDSFID(byte dsfid) throws IOException, RFIDException {
        byte[] cmd = new byte[256];
        int index = 0;
        cmd[index++] = 34;
        cmd[index++] = 41;
        System.arraycopy(this.uid, 0, cmd, index, this.uid.length);
        index += this.uid.length;
        cmd[index++] = dsfid;
        this.mModule.transmitCard(this.channel, cmd, index);
        this.dsfid = dsfid;
    }

    public void lockDSFID() throws IOException, RFIDException {
        byte[] cmd = new byte[256];
        int index = 0;
        cmd[index++] = 34;
        cmd[index++] = 42;
        System.arraycopy(this.uid, 0, cmd, index, this.uid.length);
        this.mModule.transmitCard(this.channel, cmd, index += this.uid.length);
    }

    public byte[] getBlocksSecurityStatus(int startBlock, int blocks) throws IOException, RFIDException {
        byte[] cmd = new byte[128];
        int index = 0;
        cmd[index++] = 34;
        cmd[index++] = 44;
        System.arraycopy(this.uid, 0, cmd, index, this.uid.length);
        index += this.uid.length;
        cmd[index++] = (byte)startBlock;
        cmd[index++] = (byte)(blocks - 1);
        byte[] result = this.mModule.transmitCard(this.channel, cmd, index);
        byte[] tmp = new byte[result.length - 1];
        System.arraycopy(result, 1, tmp, 0, tmp.length);
        return tmp;
    }

    private void getSystemInformation() throws IOException, RFIDException {
        byte[] cmd = new byte[256];
        int index = 0;
        cmd[index++] = 34;
        cmd[index++] = 43;
        System.arraycopy(this.uid, 0, cmd, index, this.uid.length);
        byte[] result = this.mModule.transmitCard(this.channel, cmd, index += this.uid.length);
        index = 1;
        int sysflags = result[index++] & 0xFF;
        index += 8;
        this.dsfid = (sysflags & 1) != 0 ? result[index++] : (byte)0;
        this.afi = (sysflags & 2) != 0 ? result[index++] : (byte)0;
        if ((sysflags & 4) != 0) {
            this.maxBlocks = (result[index++] & 0xFF) + 1;
            this.blockSize = (result[index++] & 0x1F) + 1;
        } else {
            this.blockSize = 4;
            this.maxBlocks = 0;
        }
    }
}

